#!/usr/bin/perl

use strict;
use warnings;
use constant { false => 0, true => 1 };
use POSIX;
use VASM::Resource::Catalog::Message;
use UI::Dialog::Backend::CDialog;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/dateset ui cdialog/);
my $errorMsg = errorCatalogFind(qw/dateset ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 20,
  menuheight => 10
);

sub dateSet {
  # Check for r3wt identity
  unless (getpwuid $> eq 'root') {
    $d->msgbox(text => $errorMsg->render('dateset for root only'));
    exit EXIT_FAILURE;
  }

  # Get the current date
  my ($seconds, $minutes, $hours, $date, $month, $year) = (localtime)[0..5];
  # You can fudge this figure a little to get the Buddhist year
  $year += 1900;

  # Get the new date
  my $dateNew = $d->calendar(
    text => $uiMsg->render('select new date'),
    day => $date,
    month => $month,
    year => $year,
    height => 5
  );
  # Exit if need be
  exit EXIT_SUCCESS if $d->state eq 'CANCEL';

  # Subtract 1900 from the date because strftime expects that format
  ($date, $month, $year) = split m!/!, $dateNew; $year -= 1900;

  # Get the new time
  my $timeNew = $d->timebox(
    height => 5,
    text => $uiMsg->render('select new time'),
    hour => $hours,
    minute => $minutes,
    seconds => $seconds
  );
  # Exit if need be
  exit EXIT_SUCCESS if $d->state eq 'CANCEL';

  ($hours, $minutes, $seconds) = split /:/, $timeNew;

  # This results in a form like: 'Aug 18 2006 20:59:00'
  my $dateNewFormatted = strftime(
    "%b %d %Y %H:%M:%S",
    $seconds, $minutes, $hours,
    $date, $month, $year
  );
  # Try to run that through date(1)
  my $status = system "date -s '$dateNewFormatted' &> /dev/null";

  # Report error if need be
  unless ($status == 0) {
    $d->msgbox(text => $errorMsg->render('date setting failure'));
    exit EXIT_FAILURE;
  } else {
    $d->msgbox(text => $uiMsg->render('date and time changed'));
    exit EXIT_SUCCESS;
  }
}

dateSet();
