#!/usr/bin/perl

use strict;
use warnings;
use constant { false => 0, true => 1, pad => 2 };
use POSIX;
use VASM::Resource::Catalog::Message;
use VASM::Utility::FileSystem::InitTab;
use VASM::Utility::Gtk2::MessageDialog;
use Gtk2 '-init';

# Message files
my $uiMsg = messageCatalogFind(qw/bootset ui gtk2/);
my $errorMsg = errorCatalogFind(qw/bootset ui error/);

sub bootSetMenu {
  # Check for r3wt identity
  unless (getpwuid $> eq 'root') {
    errorMessage($errorMsg->render('bootset for root only'));
    exit EXIT_FAILURE;
  }

  my $dialog = Gtk2::Dialog->new_with_buttons(
    $uiMsg->render('title'), undef, [],
    'gtk-ok', 'ok', 'gtk-cancel' => 'cancel'
  );
  $dialog->set_resizable(false);
  $dialog->set_position('center');

  # Get the description of all available bootlevels
  my $bootLevelDirectory = bootLevelDirectory();

  # Generate radio buttons -- current boot level is the default
  my @bootLevels; my $bootLevelSelected = bootLevelGet();

  for my $bootLevel ($bootLevelDirectory->list) {
    # Generate button with group if appropriate
    my $radioButton = Gtk2::RadioButton->new_with_label(
      @bootLevels ? $bootLevels[0]->get_group : undef, 
      $bootLevelDirectory->render($bootLevel)
    );
    # Add it to the array of boot levels
    push @bootLevels, $radioButton;
    # On click, set $selected boot level scalar to corresponding boot level
    $radioButton->signal_connect(
      toggled => sub { $bootLevelSelected = $bootLevel }
    );
    # If $bootLevel is the same as the default, set this radio button to be
    # active
    $radioButton->set_active(true) if $bootLevel == $bootLevelSelected;
    # Add it to the dialog vbox
    $dialog->vbox->pack_start($radioButton, false, false, pad);
  }

  # Expander with detailed description
  my $descriptionShort = Gtk2::Expander->new(
    $uiMsg->render('bootset menu short description')
  );
  my $descriptionLong = Gtk2::Label->new(
    $uiMsg->render('bootset menu long description')
  );
  $descriptionLong->set_line_wrap(true);
  $descriptionShort->add($descriptionLong);
  $dialog->vbox->pack_start($descriptionShort, false, false, pad);

  $dialog->show_all;
  my $response = $dialog->run;

  if ($response eq 'ok') {
    bootLevelSet($bootLevelSelected);
    infoMessage($uiMsg->render('boot level changed'));
  }
  
  $dialog->destroy;
  exit EXIT_SUCCESS;
}

bootSetMenu();
