#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { false => 0, true => 1 };
use POSIX;
use VASM::Resource::Catalog::Message;
use VASM::Utility::FileSystem::InitTab;
use UI::Dialog::Backend::CDialog;

# Message files
my $commonMsg = messageCatalogFind(qw/common message/);
my $uiMsg = messageCatalogFind(qw/bootset ui cdialog/);
my $errorMsg = errorCatalogFind(qw/bootset ui error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $commonMsg->render('vasm backtitle'),
  title => $uiMsg->render('title'),
  'ok-label' => $commonMsg->render('ok'),
  'cancel-label' => $commonMsg->render('exit'),
  'yes-label' => $commonMsg->render('yes'),
  'no-label' => $commonMsg->render('no'),
  width => 75,
  height => 20,
  menuheight => 10
);

sub bootSetMenu {
  # Check for r3wt identity
  unless (getpwuid $> eq 'root') {
    $d->msgbox(text => $errorMsg->render('bootset for root only'));
    exit EXIT_FAILURE;
  }

  # Get the default bootlevel and description of all available bootlevels
  my $bootLevelDefault = bootLevelGet();
  my $bootLevelDirectory = bootLevelDirectory();

  # Generate radio buttons
  my $bootLevelChoices = [
    map {
      $bootLevelDirectory->_recodeString($_),
      [
        $bootLevelDirectory->render($_), 
        ($_ eq $bootLevelDefault) ? true : false
      ]
    } $bootLevelDirectory->list
  ];
  
  # Present a radio list of possible bootlevels with the current as default
  my $bootLevelNew = $d->radiolist(
    text => $uiMsg->render('main menu description'),
    list => $bootLevelChoices
  );

  # Set the new boot level if requested
  if ($d->state eq 'OK') {
    bootLevelSet($bootLevelNew);
    $d->msgbox(text => $uiMsg->render('boot level changed'));
  }

  exit EXIT_SUCCESS;
}

bootSetMenu();
