#!/usr/bin/perl

use strict;
use warnings;
use POSIX;
use VASM::Resource::Catalog::Action;
use VASM::Resource::Catalog::Message;

my $errorMsg = errorCatalogFind(qw/action ui error/);
local $\ = "\n";

# Make sure a filename was given
unless (defined $ARGV[0]) {
  print $errorMsg->render('no filename or URI given', $0);
  exit EXIT_FAILURE;
}

# Dig a catalog for the MIME or URI type
my $catalog = actionCatalogFindByMedium($ARGV[0]);

# Check if it found a catalog 
unless (defined $catalog) {
  print $errorMsg->render('no action catalog for file', $ARGV[0]);

  exit EXIT_FAILURE;
}

# Execute the preferred program
my $status = $catalog->exec($ARGV[0]);
print $errorMsg->render('no matching program') if $status == -1;
exit $status;
