# -*- project-name: VASM -*-
package VASM::Utility::Locale;

use strict;
use warnings;
use base qw/Exporter/;

our @EXPORT = qw/localeParse/;
our $VERSION = '1.0';

# Because most of the normal divisions of locale support (e.g., LC_COLLATE,
# LC_NUMERIC) do not apply here, we will only honor a certain subset of
# environment variables, in this order: LC_ALL, LC_MESSAGES, LANG. (I believe
# this is the correct protocol; please correct me if I'm wrong.) Because VASM
# strictly uses UTF-8 for all messages, any codeset portion of the variable is
# ignored altogether.
sub localeParse {
  # Loop through these variables in turn:
  for my $var (@ENV{qw/LC_ALL LC_MESSAGES LANG/}) {
    defined $var and return
      eval {
        # I buck the trend a little by using resource inheritance instead of
        # the default 'C' locale
        return if $var eq 'C';
        my $locale = ($var =~ m!([[:lower:]]{2}(?:_[[:upper:]]{2})?)!)[0];
        # Split language and country (ex: en_GB vs. en_US)
        split /_/, $locale;
      }
  }

  return;
}

1;

__END__
