# -*- project-name: VASM -*-
package VASM::Utility::FileSystem::Skeleton;

use strict;
use warnings;
use base qw/Exporter/;
use constant { false => 0, true => 1 };
use VASM::Resource::Catalog::Message;
use File::Spec::Functions;
use Carp;

our $VERSION = '1.01';
our @EXPORT = qw/skeletonDirectory skeletonInstall/;

# Silence 'use of undefined value' messages
$ENV{T_PX} = q() unless defined $ENV{T_PX};
$ENV{HOME} = q() unless defined $ENV{HOME};

my $skeletonDir = catdir($ENV{T_PX}, '/etc/skel');
my $homeDir = catdir($ENV{T_PX}, $ENV{HOME});
my $userName = getpwuid $>; # Not enough to justify 'use English'

sub skeletonDirectory {
  my $directory = messageCatalogFind(qw/skel directory/);

  # Weed out non-existent components of the skeleton
  for my $component ($directory->list) {
    # catfile will be used even for directories; it works fine and, more
    # importantly, is appropriate in this case
    $directory->delete($component) unless -r catfile($skeletonDir, $component);
  }

  return $directory;
}

sub skeletonInstall {
  my (@components) = @_;

  for my $component (@components) {
    croak "Skeleton component $component not readable"
      unless -r catfile($skeletonDir, $component);
    # All the portable third-party libraries I found to do this were
    # unsatisfactory, so I'm just going to call the programs themselves. Munch
    # on a bowl of my(@nuts)
    my $status = system qq(
      rm -rf ${homeDir}/${component} &> /dev/null &&
      cp -a ${skeletonDir}/${component} ${homeDir} &> /dev/null &&
      chown -R ${userName}:users ${homeDir}/${component} &> /dev/null
    );

    # Sufficient I guess
    croak 'Skeleton installation unsuccesful' unless $status == 0;
  }
  
  return;
}

1;

__END__
