# -*- project-name: VASM -*-
package VASM::Utility::FileSystem::InitTab;

use strict;
use warnings;
use base qw/Exporter/;
use VASM::Resource::Catalog::Message;
use File::Spec::Functions;
use Carp;

our $VERSION = '1.01';
our @EXPORT = qw/bootLevelGet bootLevelSet bootLevelDirectory/;

# Silence 'use of undefined value' messages
$ENV{T_PX} = q() unless defined $ENV{T_PX};

my $initTabFile = catfile($ENV{T_PX}, '/etc/inittab');

sub bootLevelGet {
  croak 'Cannot find inittab file...uh-oh...' 
    unless open my $initTabFH, '<', $initTabFile;

  # Find the initdefault line; there should be only one initdefault line... :?
  my $bootLevel = (grep { $_ =~ /^id:\d:initdefault:$/ } <$initTabFH>)[0];
  croak 'No initdefault in inittab' 
    unless defined $bootLevel; # No initdefault? <4 letter word>
  $bootLevel = ($bootLevel =~ /(\d)/)[0]; # Frob the number out of that line

  close $initTabFH; # Close the filehandle
 
  return $bootLevel;
}

sub bootLevelSet {
  my ($bootLevel) = @_; my $initTabFH;

  # Sanity checks: writability of inittab, definedness and validity of
  # $bootLevel argument
  croak 'No bootlevel given' unless defined $bootLevel;
  croak 'inittab not writable' unless -w $initTabFile;
  croak 'Boot level invalid' 
    unless $bootLevel =~ /^\d$/ and not $bootLevel =~ /^[06]$/;
  
  # Open inittab
  open $initTabFH, '<', $initTabFile;

  # Frob together the new inittab contents
  my @initTabNew = map { 
    s/\d/$bootLevel/ if /^id:\d:initdefault:$/; $_
  } <$initTabFH>;
  close $initTabFH; # Clean up $initTabFH

  # Print them out
  open $initTabFH, '>', $initTabFile; # Should still be there
  for my $line (@initTabNew) { print $initTabFH $line }
  close $initTabFH;

  return;
}

sub bootLevelDirectory {
  return messageCatalogFind(qw/bootset directory/);
}

1;

__END__
