# -*- project-name: VASM -*-
package VASM::Utility::FileSystem::Group;

use strict;
use warnings;
use constant { false => 0, true => 1 };
use base qw/Exporter/;
use VASM::Resource::Catalog::Message;

# groupDirectory - default message for non
# groupList - return hash with fields for each key
#   - user list (see passwd also)
#   - gid
# groupAdd(%) - name, gid, users
# groupDel($) - check passwd for primary group
# groupMod(%) - name, newName, gid

our $VERSION = '1.0';
our @EXPORT = qw/groupDirectory groupHash/;

sub groupDirectory {
  return messageCatalogFind(qw/group directory/);
}

sub groupHash {
  my %groupHash;
  
  while (my @groupEntry = getgrent) {
    $groupHash{$groupEntry[0]} = [ @groupEntry[3..$#groupEntry] ];
  }

  return %groupHash;
}

1;
