# -*- project-name: VASM -*-
package VASM::Utility::Expect::Super;

use strict;
use warnings;
use constant { true => 1 };
use base qw/Exporter/;
use Carp;
use Expect;

our $VERSION = '1.03';
our @EXPORT = qw/super/;

# Don't show the stdout of programs; it looks sloppy.
# $Expect::Log_Stdout = 0;
# OK, show it

sub super {
  my ($command, $password) = @_;

  my $expect = Expect->new;
  $expect->raw_pty(true); # Disable echoing and translation

  # If $DISPLAY is set, enable root connections to $DISPLAY (this should be
  # reasonably secure?)
  system 'xhost +si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};

  # Spawn su w/ arguments from CLI
  return unless $expect->spawn("su -c '$command'");
  
  # Five seconds seems to be a reasonable timeout -- the Expect pattern will
  # expect anything before a colon and a space, because a value of LANG like
  # 'de_DE' will produce 'Kennwort', etc.
  $expect->expect(5, [ qr/^.*?: /]) or croak 'Expect pattern match failed!';
  $expect->send("$password\n"); # Send the password
  $expect->expect; # Wait until process sends EOF
  $expect->soft_close; # Terminate the Expect instance

  # Remove root from the X access control list if need be
  system 'xhost -si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};

  return true;
}

1;
