# -*- project-name: VASM -*-
package VASM::Resource::Navigator;

use strict;
use warnings;
use base qw/Exporter/;
use constant +{
  false => 0, 
  true => 1,
  everyone => 0,
  rootOnly => 1,
  userOnly => 2
};
use VASM::Resource::Catalog::Message;
use VASM::Tree;

our $VERSION = '1.02';
our @EXPORT = qw/navigatorTree navigatorDirectory/;
my $userName = getpwuid $>;

my $navigatorTree = {
  hardware => {
    vmouseset => rootOnly
  },

  system => {
    vbootset => rootOnly,
    vsuper => everyone
  },

  user => {
    vaction => everyone,
    vmenu => everyone,
    vpasswd => everyone,
    vskel => everyone
  },
  
  x11 => {
    vfontset => rootOnly,
    vxwmset => everyone
  },

  # super vasm
};

sub navigatorTree {
  # Reduce the original hashref template according to environment then
  return _navigatorTree($navigatorTree);
}

sub _navigatorTree {
  my ($navigatorTree) = @_;

  return +{
    grep {
      defined $_
    } map {
      my $key = $_;

      if (ref $navigatorTree->{$key} eq 'HASH') {
        my $navigatorTree = _navigatorTree($navigatorTree->{$key});

        if (defined %$navigatorTree) {
          ($key => $navigatorTree)
        } else {
          undef
        }
      } else {
        if (navigatorTreeItemAvailable($navigatorTree->{$key})) {
          ($key => $navigatorTree->{$key})
        } else {
          undef
        }
      }
    } keys %{ $navigatorTree } # End of map statement
  } # End of hashref constructor
}

sub navigatorTreeItemAvailable {
  my ($permission) = @_;
  
  if ($permission == everyone) {
    return true;
  } elsif ($permission == rootOnly and $userName eq 'root') {
    return true;
  } elsif ($permission == userOnly and $userName ne 'root') {
    return true;
  }

  return false;
}

sub navigatorDirectory {
  return messageCatalogFind(qw/navigator directory/);
}

1;
