# -*- project-name: VASM -*-
package VASM::Resource::Catalog::XorgConfig;

use strict;
use warnings;
use base qw/Exporter/;
use VASM::Catalog::XorgConfig;
use VASM::Resource;
use Carp;

our @EXPORT = qw/xorgConfigCatalogFind xorgConfigCatalogWrite/;
our $VERSION = '1.02';

sub xorgConfigCatalogFind {
  my @locale = localeParse(); # Finagle locale from %ENV

  # Now, try to find the first matching config.xml in the hierarchy; the
  # search can go as far back as the base xorgconfig directory itself:
  my $fh;
  LOOP: {
    do {
      $fh = (configResourceFind(qw/xorgconfig/, @locale, 'config.xml'))[0];
      last LOOP if defined $fh;
    } while (pop @locale);
  }

  # Return unless a file handle was found
  return VASM::Catalog::XorgConfig->new unless $fh;
  # Otherwise, digest file and return the new catalog definition
  $fh->binmode(':utf8'); # Set the IO::File to UTF-8 for XML
  my $catalog = VASM::Catalog::XorgConfig->new($fh);
  $fh->close;

  return $catalog;
}

sub xorgConfigCatalogWrite {
  my ($instance) = @_;
  my @locale = localeParse(); # Finagle locale from %ENV

  # Generate a new IO::File for the catalog to be written. configResourceCreate
  # (actually, resourceCreate) will croak if unsuccessful, so no error checking
  # is really necessary
  my $configFH = (
    configResourceCreate(qw/xorgconfig/, @locale, 'config.xml')
  )[0];
  $instance->write($configFH); # Now let the instance do its thing
  $configFH->close; # ...close the filehandle and...done
  
  return;
}

1;

__END__

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 FUNCTIONS

=head1 AUTHORS

hanumizzle L<mailto:hanumizzle@gmail.com>: principal author
cintyram, YaP, vanger: design suggestions, technical assistance

=cut
