# -*- project-name: VASM -*-
package VASM::Catalog::XOrgConfig::Translation;

use strict;
use warnings;
use IO::File;
use Carp;

# How should this go?
# 
# Nested arrayrefs -- each level causes indent
# Each member either textual or a subref; its return values will be
# interpolated into the config

# Should I use Data::Dumper for this?

my @XorgConfigTemplate = [
  'Section "ServerLayout"',
  [
    'Identifier "X.org Configured"',
    'Screen 0 "Screen0" 0 0',
    'InputDevice "Mouse0" "CorePointer"',
    'InputDevice "Keyboard0" "CoreKeyboard"',
  ],
  "EndSection\n",

  'Section "Files"',
  [
    'RgbPath "/usr/X11R6/lib/X11/rgb"',
    'ModulePath "/usr/X11R6/lib/modules"',
    # User-defined font paths will be preferred before default system font paths
    \&mergeFontPaths,
    'FontPath "/usr/X11R6/lib/X11/fonts/misc/:unscaled',
    'FontPath "/usr/X11R6/lib/X11/fonts/TTF/',
    'FontPath "/usr/X11R6/lib/X11/fonts/Type1/',
    # Does anyone actually use these? I don't even know what they are
    'FontPath "/usr/X11R6/lib/X11/fonts/CID/',
    'FontPath "/usr/X11R6/lib/X11/fonts/75dpi/:unscaled"',
    'FontPath "/usr/X11R6/lib/X11/fonts/100dpi/:unscaled"'
  ],
  "EndSection\n",

  'Section "Module"',
  [
    # What modules should be standard? What modules should be included?
    'Load "record"',
    'Load "extmod"',
    'Load "dbe"',
    'Load "glx"',
    'Load "xtrap"',
    'Load "freetype"',
    'Load "type1"'
  ],
  "EndSection\n",

  'Section "InputDevice"',
  [
    'Identifier "Keyboard0"',
    'Driver "kbd"',
    \&mergeXkbOptions
    # \&mergeUserXkbModel,
    # \&mergeUserXkbLayout,
    # \&mergeUserXkbOptions,
    # \&mergeUserXkbVariant
  ],
  "EndSection\n",

  'Section "InputDevice"',
  [
    'Indentifier "Mouse0"',
    'Driver "mouse"',
    'Option "Device" "/dev/mouse"',
    \&mergeMouseOptions
    # \&mergeMouseProtocol,
    # \&mergeMouseEmulate3Buttons,
    # \&mergeMouseZAxisMapping
  ],
  "EndSection\n",
];

# How to probe for BusID, VendorName, etc.?

# sub Translate ($self, $handle, $indent)

1;

__END__
