#! /bin/sh
# rc.X   launch display manager if the system is going to level 5
#
# This script was originally created as rc.4 for Slackware 7.1
# written by Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
#
# Has been modified to suit Vector Linux by Kocil
# I kept the funny words :)

KDM_CMD=/opt/kde/bin/kdm
GDM_CMD=/opt/gnome2/bin/gdm
WDM_CMD=/usr/X11R6/bin/wdm
XDM_CMD=/usr/X11R6/bin/xdm

DISPLAY_MANAGER=WDM

# Tell the viewers what's going to happen...
# /etc/rc.d/rc.sysvinit
echoc "Starting up X11 session manager..." green

case $DISPLAY_MANAGER in
KDM)
  if [ -x $KDM_CMD ]; then
    exec $KDM_CMD -nodaemon
  fi
  ;;
GDM)
  if [ -x $GDM_CMD ]; then
    exec $GDM_CMD -nodaemon
  fi
  ;;
WDM)
  if [ -x $WDM_CMD ]; then
    exec $WDM_CMD -nodaemon
  fi 
  ;;
XDM)
  if [ -x $XDM_CMD ]; then
    exec $XDM_CMD -nodaemon
  fi  
  ;;
esac

echo WARNING: Could not find $DISPLAY_MANAGER. Trying the others ...

# KDE's kdm is the default session manager.  
# If you're got this, it's the one to use.
if [ -x $KDM_CMD ]; then
  exec $KDM_CMD -nodaemon
# GNOME's session manager is another choice:
elif [ -x $GDM_CMD ]; then
  exec $GDM_CMD -nodaemon
# WDM is the light DM with session menu
elif [ -x $WDM_CMD ]; then
  exec $WDM_CMD -nodaemon
# If all you have is XDM, I guess it will have to do:
elif [ -x $XDM_CMD ]; then
  exec $XDM_CMD -nodaemon
fi

# error
echo
echo "Hey, you don't have KDM, GDM, WDM, or XDM."
echo "Can't use runlevel 5 without one of those installed, mate."
sleep 30

# All done.
