#!/bin/sh
#
# /etc/rc.d/rc.S:  System initialization script.
#
# Mostly written by:  Patrick J. Volkerding, <volkerdi@ftp.cdrom.com>
# Adapted for BsV by Jonathan B. Araujo Neto jones@brfree.com.br
#
# Adapted for Vector Linux by Eko M. Budi
#

PATH=/sbin:/usr/sbin:/bin:/usr/bin
dmesg -n 1

#Set YES if you want a "rainbow-technicolor" initialization
export  RCINITCOLORS="YES" # {YES|NO}

echoc "==> rc.S  Setting up the base system configuration....." blue
#sleep 2

# Enable Swapping
# Normally ON
# You may want to turn it OFF if you have very BIG memory or User-Mode-Linux
if [ -x /etc/rc.d/rc.swap ]; then
  echoc "Setting up swap file" red
  . /etc/rc.d/rc.swap
fi

# Start update.
/sbin/update &
echoc "Setting up filesystems" red

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no
if echo -n >> "Testing filesystem status"; then
 rm -f "Testing filesystem status"
 READWRITE=yes
fi

# Check the integrity of all filesystems
if [ ! $READWRITE = yes ]; then

 # Check File System
 # Normally ON
 # You may turn it OFF for journaling file system or User-Mode-Linux
 if [ -x /etc/rc.d/rc.fsck ]; then
    . /etc/rc.d/rc.fsck
 fi

 # Remount the root filesystem in read-write mode
 echo "Remounting root device with read-write enabled."
 /bin/mount -w -v -n -o remount /
 if [ $? -gt 0 ] ; then
  echo
  echo "Attempt to remount root device as read-write failed!  This is going to"
  echo "cause serious problems...  "
  echo 
  echo "If you're using the UMSDOS filesystem, you **MUST** mount the root partition"
  echo "read-write!  You can make sure the root filesystem is getting mounted "
  echo "read-write with the 'rw' flag to Loadlin:"
  echo
  echo "loadlin vmlinuz root=/dev/hda1 rw   (replace /dev/hda1 with your root device)"
  echo
  echo "Normal bootdisks can be made to mount a system read-write with the rdev command:"
  echo
  echo "rdev -R /dev/fd0 0"
  echo
  echo "You can also get into your system by using a bootkernel disk with a command"
  echo "like this on the LILO prompt line:  (change the root partition name as needed)"
  echo 
  echo "LILO: mount root=/dev/hda1 rw"
  echo
  echo "Please press ENTER to continue, then reboot and use one of the above methods to"
  echo -n "get into your machine and start looking for the problem. " 
  read junk; 
 fi
else
 echo "Testing filesystem status: read-write filesystem"
 if cat /etc/fstab | grep ' / ' | grep umsdos 1> /dev/null 2> /dev/null ; then
  ROOTTYPE="umsdos"
 fi
 if [ ! "$ROOTTYPE" = "umsdos" ]; then # no warn for UMSDOS
  cat << EOF

*** ERROR: Root partition has already been mounted read-write. Cannot check!

For filesystem checking to work properly, your system must initially mount
the root partition as read only. Please modify your kernel with 'rdev' so that
it does this. If you're booting with LILO, add a line:

   read-only

to the Linux section in your /etc/lilo.conf and type 'lilo' to reinstall it.

If you boot from a kernel on a floppy disk, put it in the drive and type:
  rdev -R /dev/fd0 1

If you boot from a bootkernel disk, or with Loadlin, you can add the 'ro' flag.

This will fix the problem *AND* eliminate this annoying message. :^)

EOF
  echo -n "Press ENTER to continue. "
  read junk;
 fi
fi

# Force creation of a new mtab deleting old one
/bin/rm -f /etc/mtab* 

# mount file systems in fstab (and create an entry for /)
# but not NFS because TCP/IP is not yet configured
/bin/mount -a -v -t nonfs

if [ "$ROOTTYPE" = "umsdos" ]; then # we need to update any files added in DOS:
  echo "Synchronizing UMSDOS directory structure"
  echo "  umssync -r99 -v- / "
  umssync -r99 -v- /
fi

# Set the system time from the hardware clock using hwclock
# Normally ON. 
# You may want to turn it OFF for poor omputer or User Mode Linux
if [ -x /etc/rc.d/rc.rtclock ]; then
  echoc "Initialising system time" red
  . /etc/rc.d/rc.rtclock
fi

# Carry an entropy pool between reboots to improve randomness.
# Normally ON.
# You may want to turn it OFF for similar simulation each time the system reboot
if [ -x /etc/rc.d/rc.random ]; then
  echoc "Seeding random number generator" red
  . /etc/rc.d/rc.random
fi

echoc "Reseting the system ..." red

# Screen blanks after 15 minutes idle time.
/bin/setterm -blank 0

# If there's no /etc/HOSTNAME, fall back on this default:
if [ ! -r /etc/HOSTNAME ]; then
 echo "vector.myhome.net" > /etc/HOSTNAME
fi

# Set the hostname.  This might not work correctly if TCP/IP is not 
# compiled in the kernel.
echo "Setting hostname : `cat /etc/HOSTNAME`"
/bin/hostname `cat /etc/HOSTNAME | cut -f1 -d .`

# Setup the /etc/issue and /etc/motd to reflect the current kernel level:
# THESE WIPE ANY CHANGES YOU MAKE TO /ETC/ISSUE AND /ETC/MOTD WITH EACH
# BOOT. COMMENT THEM OUT IF YOU WANT TO MAKE CUSTOM VERSIONS.
#echo > /etc/issue
#echo Welcome to Linux `/bin/uname -a | /bin/cut -d\  -f3`. >> /etc/issue
#echo "Powered by VectorLinux and BsV" >> /etc/issue
#echo >> /etc/issue
echo "`/bin/uname -a | /bin/cut -d\  -f1,3`. Type vasm to enter setup menu." > /etc/motd
/sbin/linux_logo -c -t "Brought to you by Vector-Linux" > /etc/issue
/sbin/linux_logo -c > /etc/issue.net

# Remove undesired things
echo "Removing stale lock, temporary and junk files so the game can start "
# remove /etc/mtab* so that mount will create it with a root entry
/bin/rm -f  /etc/nologin /etc/shutdownpid /etc/dhcpc/*.pid 

# Clean up temporary files on the /var volume:
/bin/rm -f /var/run/utmp /var/run/*.pid /var/log/setup/tmp/*

# Remove stale locks and junk files (must be done after mount -a!)
/bin/rm -f /var/lock/* /var/spool/uucp/LCK..* /tmp/.X*lock /tmp/core /core 1> /dev/null 2> /dev/null

# Remove stale hunt sockets so the game can start.
if [ -r /tmp/hunt -o -r /tmp/hunt.stats ]; then
  /bin/rm -f /tmp/hunt*
fi

# Ensure basic filesystem permissions sanity.
echo "Ensuring basic filesystem permissions sanity" 
chmod 755 /
chmod 1777 /tmp /var/tmp

# Looks like we have to create this.
cat /dev/null > /var/run/utmp
mkdir -p /var/log/lastlog

# for X-Windows

# Update all the shared library links automatically
echo "Updating shared libraries links"
/sbin/ldconfig

# Fire up hardwares ...
# This section is mostly moved from rc.M of Vector Linux 4.0

# Configure ISA plug'n'pray
# Normally ON
# Turn it OFF if you don't believe it :)
if [ -x /etc/rc.d/rc.pnp ] ; then
  echoc "Initialising ISA Plug and Play" red
  . /etc/rc.d/rc.pnp
fi

# This loads any kernel modules that are needed.  These might be required to
# Normaly ON
# Turn it OFF if you are using monolitic kernel
if [ -x /etc/rc.d/rc.modules ]; then
  echoc "Loading kernel modules" red
  . /etc/rc.d/rc.modules
fi

# Initialize PCMCIA devices:
# Normaly OFF
# Turn it ON if this Linux is running on a laptop
if [ -x /etc/rc.d/rc.pcmcia ] ; then
  echoc "Setting up PCMCIA" red
  . /etc/rc.d/rc.pcmcia start
fi

# Initialize USB hotplugging:
# Normaly ON
# Turn it OFF if you will not use any hotplugable devices
if [ -x /etc/rc.d/rc.hotplug ]; then
  echoc "Starting USB hotplug service..." red
  . /etc/rc.d/rc.hotplug start
  sleep 2
fi	

# Detect new hardware
# Normaly OFF
# Turn it ON if you change your hardware frequently
if [ -x /etc/rc.d/rc.kudzu ]; then
  echoc "Starting Kudzu hardware detection ..." red
  sleep 2
  . /etc/rc.d/rc.kudzu start
fi

# Run serial port setup script:
# Normaly ON
# Turn it OFF if your serial ports do nothing
if [ -x /etc/rc.d/rc.serial ] ; then 
  echoc "Setting up serial devices" red
  . /etc/rc.d/rc.serial start
fi

# Initialize the NET subsystem.
# Normally ON
# Turn it OFF if ... I don't know. Up to you
if [ -x /etc/rc.d/rc.inet ]; then
  echoc "Setting up networking" red
  . /etc/rc.d/rc.inet 
fi

# Load a custom keymap and console font.
# Normaly ON
# Turn it OFF if you don't use any keyboard
if [ -x /etc/rc.d/rc.keymap ] ; then
  echoc "Setting up characters devices: keyboard" red
  . /etc/rc.d/rc.keymap
fi

# Start the local setup procedure.
# Always ON 
# You should edit rc.local for custom initilisation
# rather than editing ME, this file !!!
if [ -x /etc/rc.d/rc.local ] ; then
  echoc "Starting local setup" red
  . /etc/rc.d/rc.local
fi

# All done.

