#!/bin/sh
#
# rc.M		This file is executed by init(8) when the system is being
#		initialized for one of the "multi user" run levels (i.e.
#		levels 2 through 5).  It fires up services found at init.d
#
# This rc.M is completelly different than the one that exist 
# in Slackware or Vector Linux 4.0
# It is no more a hardware/network setting up (moved to rc.S)
# but initializing scripts in /etc/rc.d/init.d.
# The initialisation procedure is different than sys V !
#
# GNU GPL (c) Eko M. Budi, 2004
#         (c) Vector Linux, 2004
#

# Tell the viewers what's going to happen...

# Set onlcr to avoid staircase effect.
stty onlcr 0>&1

if [ "$PREVLEVEL" = "N" ]; then
   echoc "==> rc.M Entering multiuser mode...." blue
   PREVDIR=""
else
   echo
   echoc "Switching from run level $PREVLEVEL to $RUNLEVEL...." blue
   PREVDIR="/etc/rc.d/rc${PREVLEVEL}.d"
fi

RUNDIR="/etc/rc.d/rc${RUNLEVEL}.d"

# Collect script from previous level, reversed
if [ "$PREVDIR" ]; then
  ii=0
  for SLINK in `ls -1 -r $PREVDIR/S*`; do
    if [ -x $SLINK ]; then
      SNAME=`lnread $SLINK`
      if [ $SNAME ]; then
         SPREV[$ii]=`basename $SNAME`
         let ii=$ii+1
      fi
    fi
  done
fi

# Collect script from next level
ii=0
for SLINK in $RUNDIR/S* ; do
  if [ -x $SLINK ]; then
     SNAME=`lnread $SLINK`
     if [ $SNAME ]; then
       SNEXT[$ii]=`basename $SNAME`
       let ii=$ii+1
     fi
  fi
done

# Kill any script in prev level that does not exist in the next level
if [ "PREVDIR" ]; then
  echoc "==> Stopping services of runlevel $PREVLEVEL" red
  ii=0
  while [ ${SPREV[$ii]} ]; do
     SCRIPT=${SPREV[$ii]}
     jj=0
     while [ ${SNEXT[$jj]} ]; do
       if [ $SCRIPT = ${SNEXT[$jj]} ]; then
          SCRIPT=""
	  break
       fi
       let jj=$jj+1
     done
     if [ $SCRIPT ]; then
       /etc/rc.d/init.d/$SCRIPT stop
       sleep 1
     fi
     let ii=$ii+1
  done
fi
echo

# Start any script in the next level that does not exist in the prev level
echoc "==> Starting services of runlevel $RUNLEVEL" red
ii=0
while [ ${SNEXT[$ii]} ]; do
  SCRIPT=${SNEXT[$ii]}
  jj=0
  while [ ${SPREV[$jj]} ]; do
    if [ "$SCRIPT" = "${SPREV[$jj]}" ]; then
      SCRIPT=""
      break
    fi
    let jj=$jj+1
  done
  if [ $SCRIPT ]; then
    /etc/rc.d/init.d/$SCRIPT start
    sleep 1
  fi
  let ii=$ii+1
done
echo


# All done.
