<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>AlsaOut</name>
    <filename>classAlsaOut.html</filename>
    <base>MidiOut</base>
    <member kind="function">
      <type></type>
      <name>AlsaOut</name>
      <anchor>a0</anchor>
      <arglist>(int d, int client=64, int port=0, const char *cname=&quot;&quot;, const char *pname=&quot;&quot;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AlsaOut</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>openDev</name>
      <anchor>a2</anchor>
      <arglist>(int sqfd)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>closeDev</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initDev</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>deviceType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>deviceName</name>
      <anchor>a6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rate</name>
      <anchor>a7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOn</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOff</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressure</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPatchChange</name>
      <anchor>a11</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPressure</name>
      <anchor>a12</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPitchBender</name>
      <anchor>a13</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnController</name>
      <anchor>a14</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sysex</name>
      <anchor>a15</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>channelSilence</name>
      <anchor>a16</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>channelMute</name>
      <anchor>a17</anchor>
      <arglist>(uchar chn, int b)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setVolumePercentage</name>
      <anchor>a18</anchor>
      <arglist>(int volper)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ok</name>
      <anchor>a19</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>wait</name>
      <anchor>a20</anchor>
      <arglist>(double ticks)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tmrSetTempo</name>
      <anchor>a21</anchor>
      <arglist>(int v)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tmrStart</name>
      <anchor>a22</anchor>
      <arglist>(int tpcn)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tmrStart</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tmrStop</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tmrContinue</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sync</name>
      <anchor>a26</anchor>
      <arglist>(int i=0)</arglist>
    </member>
    <member kind="variable">
      <type>AlsaOutPrivate *</type>
      <name>di</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>seqbuf_dump</name>
      <anchor>b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>seqbuf_clean</name>
      <anchor>b1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>eventInit</name>
      <anchor>b2</anchor>
      <arglist>(snd_seq_event_t *ev)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>eventSend</name>
      <anchor>b3</anchor>
      <arglist>(snd_seq_event_t *ep)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>timerEventSend</name>
      <anchor>b4</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>ndevs</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>nmidiports</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>count</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>lastcount</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>lasttime</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>begintime</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_rate</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>convertrate</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>long int</type>
      <name>time</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DeviceManager</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DeviceManager</name>
    <filename>classDeviceManager.html</filename>
    <member kind="function">
      <type></type>
      <name>DeviceManager</name>
      <anchor>a0</anchor>
      <arglist>(int def=-1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DeviceManager</name>
      <anchor>a1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>initManager</name>
      <anchor>a2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>checkInit</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>MidiOut *</type>
      <name>chntodev</name>
      <anchor>a4</anchor>
      <arglist>(int chn)</arglist>
    </member>
    <member kind="function">
      <type>MidiOut *</type>
      <name>deviceForChannel</name>
      <anchor>a5</anchor>
      <arglist>(int chn)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>deviceNumberForChannel</name>
      <anchor>a6</anchor>
      <arglist>(int chn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDeviceNumberForChannel</name>
      <anchor>a7</anchor>
      <arglist>(int chn, int dev)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ok</name>
      <anchor>a8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>usingAlsa</name>
      <anchor>a9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>openDev</name>
      <anchor>a10</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeDev</name>
      <anchor>a11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initDev</name>
      <anchor>a12</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>noteOn</name>
      <anchor>a13</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>noteOff</name>
      <anchor>a14</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>keyPressure</name>
      <anchor>a15</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPatchChange</name>
      <anchor>a16</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPressure</name>
      <anchor>a17</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPitchBender</name>
      <anchor>a18</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnController</name>
      <anchor>a19</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sysEx</name>
      <anchor>a20</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>wait</name>
      <anchor>a21</anchor>
      <arglist>(double ms)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tmrSetTempo</name>
      <anchor>a22</anchor>
      <arglist>(int v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tmrStart</name>
      <anchor>a23</anchor>
      <arglist>(long int tpcn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tmrStop</name>
      <anchor>a24</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tmrContinue</name>
      <anchor>a25</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allNotesOff</name>
      <anchor>a26</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sync</name>
      <anchor>a27</anchor>
      <arglist>(bool f=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVolumePercentage</name>
      <anchor>a28</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>defaultDevice</name>
      <anchor>a29</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultDevice</name>
      <anchor>a30</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>setPatchesToUse</name>
      <anchor>a31</anchor>
      <arglist>(int *patchesused)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>midiMapFilename</name>
      <anchor>a32</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMidiMap</name>
      <anchor>a33</anchor>
      <arglist>(MidiMapper *map)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rate</name>
      <anchor>a34</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>midiPorts</name>
      <anchor>a35</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>synthDevices</name>
      <anchor>a36</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>name</name>
      <anchor>a37</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>type</name>
      <anchor>a38</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>seqbuf_dump</name>
      <anchor>b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>seqbuf_clean</name>
      <anchor>b1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>checkAlsa</name>
      <anchor>b2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MidiOut **</type>
      <name>device</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>midi_info *</type>
      <name>midiinfo</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>synth_info *</type>
      <name>synthinfo</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>chn2dev</name>
      <anchor>p3</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>n_synths</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>n_midi</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>n_total</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_rate</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>convertrate</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>timerstarted</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>lastwaittime</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MidiMapper *</type>
      <name>mapper_tmp</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>initialized</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>seqfd</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>default_dev</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>_ok</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>alsa</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FMOut</name>
    <filename>classFMOut.html</filename>
    <base>MidiOut</base>
    <member kind="function">
      <type></type>
      <name>FMOut</name>
      <anchor>a0</anchor>
      <arglist>(int d=0, int total=12)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FMOut</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>openDev</name>
      <anchor>a2</anchor>
      <arglist>(int sqfd)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>closeDev</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initDev</name>
      <anchor>a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOn</name>
      <anchor>a5</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOff</name>
      <anchor>a6</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressure</name>
      <anchor>a7</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPatchChange</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPressure</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPitchBender</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnController</name>
      <anchor>a11</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sysex</name>
      <anchor>a12</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setVolumePercentage</name>
      <anchor>a13</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>patch</name>
      <anchor>a14</anchor>
      <arglist>(int p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setFMPatchesDirectory</name>
      <anchor>e0</anchor>
      <arglist>(const char *dir)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>GUSOut</name>
    <filename>classGUSOut.html</filename>
    <base>MidiOut</base>
    <member kind="function">
      <type></type>
      <name>GUSOut</name>
      <anchor>a0</anchor>
      <arglist>(int d=0, int total=12)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~GUSOut</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>openDev</name>
      <anchor>a2</anchor>
      <arglist>(int sqfd)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>closeDev</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initDev</name>
      <anchor>a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOn</name>
      <anchor>a5</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOff</name>
      <anchor>a6</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressure</name>
      <anchor>a7</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPatchChange</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPressure</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPitchBender</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnController</name>
      <anchor>a11</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sysex</name>
      <anchor>a12</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPatchesToUse</name>
      <anchor>a13</anchor>
      <arglist>(int *patchesused)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>loadPatch</name>
      <anchor>a14</anchor>
      <arglist>(int pgm)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>patch</name>
      <anchor>a15</anchor>
      <arglist>(int p)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setGUSPatchesDirectory</name>
      <anchor>e0</anchor>
      <arglist>(const char *dir)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>MidiEvent</name>
    <filename>structMidiEvent.html</filename>
    <member kind="variable">
      <type>uchar</type>
      <name>command</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>chn</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>note</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>vel</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>patch</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>ctl</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d1</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d2</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d3</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d4</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d5</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>d6</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>length</name>
      <anchor>o12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar *</type>
      <name>data</name>
      <anchor>o13</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>MidiFileInfo</name>
    <filename>structMidiFileInfo.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>format</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ntracks</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ticksPerCuarterNote</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>ticksTotal</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>double</type>
      <name>millisecsTotal</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>ticksPlayed</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>patchesUsed</name>
      <anchor>o6</anchor>
      <arglist>[256]</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiMapper</name>
    <filename>classMidiMapper.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiMapper</name>
      <anchor>a0</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MidiMapper</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadFile</name>
      <anchor>a2</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ok</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>channel</name>
      <anchor>a4</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>patch</name>
      <anchor>a5</anchor>
      <arglist>(uchar chn, uchar pgm)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>key</name>
      <anchor>a6</anchor>
      <arglist>(uchar chn, uchar pgm, uchar note)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pitchBender</name>
      <anchor>a7</anchor>
      <arglist>(uchar chn, uchar &amp;lsb, uchar &amp;msb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>controller</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar &amp;ctl, uchar &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>filename</name>
      <anchor>a9</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiOut</name>
    <filename>classMidiOut.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiOut</name>
      <anchor>a0</anchor>
      <arglist>(int d=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MidiOut</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>openDev</name>
      <anchor>a2</anchor>
      <arglist>(int sqfd)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>closeDev</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initDev</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>deviceType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>deviceName</name>
      <anchor>a6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMidiMapper</name>
      <anchor>a7</anchor>
      <arglist>(MidiMapper *map)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOn</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>noteOff</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressure</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPatchChange</name>
      <anchor>a11</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPressure</name>
      <anchor>a12</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnPitchBender</name>
      <anchor>a13</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>chnController</name>
      <anchor>a14</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sysex</name>
      <anchor>a15</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allNotesOff</name>
      <anchor>a16</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>channelSilence</name>
      <anchor>a17</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>channelMute</name>
      <anchor>a18</anchor>
      <arglist>(uchar chn, int b)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setVolumePercentage</name>
      <anchor>a19</anchor>
      <arglist>(int volper)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ok</name>
      <anchor>a20</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>midiMapFilename</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sync</name>
      <anchor>a22</anchor>
      <arglist>(int i=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>seqbuf_dump</name>
      <anchor>b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>seqbuf_clean</name>
      <anchor>b1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>seqfd</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>device</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>devicetype</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>volumepercentage</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MidiMapper *</type>
      <name>map</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uchar</type>
      <name>chnpatch</name>
      <anchor>p5</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>chnbender</name>
      <anchor>p6</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uchar</type>
      <name>chnpressure</name>
      <anchor>p7</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uchar</type>
      <name>chncontroller</name>
      <anchor>p8</anchor>
      <arglist>[16][256]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>chnmute</name>
      <anchor>p9</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>_ok</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiPlayer</name>
    <filename>classMidiPlayer.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiPlayer</name>
      <anchor>a0</anchor>
      <arglist>(DeviceManager *midi_, PlayerController *pctl)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MidiPlayer</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>loadSong</name>
      <anchor>a2</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeSong</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>isSongLoaded</name>
      <anchor>a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SpecialEvent *</type>
      <name>specialEvents</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NoteArray *</type>
      <name>noteArray</name>
      <anchor>a6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>play</name>
      <anchor>a7</anchor>
      <arglist>(bool calloutput=false, void output(void)=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setParseSong</name>
      <anchor>a8</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGenerateBeats</name>
      <anchor>a9</anchor>
      <arglist>(bool b=false)</arglist>
    </member>
    <member kind="function">
      <type>MidiFileInfo *</type>
      <name>information</name>
      <anchor>a10</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPos</name>
      <anchor>a11</anchor>
      <arglist>(ulong gotomsec, class MidiStatus *midistat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTempoRatio</name>
      <anchor>a12</anchor>
      <arglist>(double ratio)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiStatus</name>
    <filename>classMidiStatus.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiStatus</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MidiStatus</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>keyPressure</name>
      <anchor>a2</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPatchChange</name>
      <anchor>a3</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>chnPatch</name>
      <anchor>a4</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPressure</name>
      <anchor>a5</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>chnPressure</name>
      <anchor>a6</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPitchBender</name>
      <anchor>a7</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>chnPitchBender</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnController</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>chnController</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar ctl)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sysex</name>
      <anchor>a11</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>tmrSetTempo</name>
      <anchor>a12</anchor>
      <arglist>(int v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sendData</name>
      <anchor>a13</anchor>
      <arglist>(class DeviceManager *midi, int gm=1)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MidiTrack</name>
    <filename>classMidiTrack.html</filename>
    <member kind="function">
      <type></type>
      <name>MidiTrack</name>
      <anchor>a0</anchor>
      <arglist>(FILE *file, int tpcn, int Id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~MidiTrack</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ticksPassed</name>
      <anchor>a2</anchor>
      <arglist>(ulong ticks)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>msPassed</name>
      <anchor>a3</anchor>
      <arglist>(ulong ms)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentMs</name>
      <anchor>a4</anchor>
      <arglist>(double ms)</arglist>
    </member>
    <member kind="function">
      <type>ulong</type>
      <name>waitTicks</name>
      <anchor>a5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>absMsOfNextEvent</name>
      <anchor>a6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeTempo</name>
      <anchor>a7</anchor>
      <arglist>(ulong t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readEvent</name>
      <anchor>a8</anchor>
      <arglist>(MidiEvent *ev)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a10</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMidSimpleAPI</name>
    <filename>classKMidSimpleAPI.html</filename>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidInit</name>
      <anchor>e0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidLoad</name>
      <anchor>e1</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidPlay</name>
      <anchor>e2</anchor>
      <arglist>(int loop=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidStop</name>
      <anchor>e3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>kMidDestruct</name>
      <anchor>e4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidIsPlaying</name>
      <anchor>e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kMidDevices</name>
      <anchor>e6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>kMidName</name>
      <anchor>e7</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>kMidType</name>
      <anchor>e8</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>kMidSetDevice</name>
      <anchor>e9</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>kMidSetMidiMapper</name>
      <anchor>e10</anchor>
      <arglist>(const char *mapfilename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>kMidVersion</name>
      <anchor>e11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>kMidCopyright</name>
      <anchor>e12</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>NoteArray</name>
    <filename>classNoteArray.html</filename>
    <member kind="function">
      <type></type>
      <name>NoteArray</name>
      <anchor>a0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NoteArray</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>at</name>
      <anchor>a2</anchor>
      <arglist>(ulong pos, ulong ms, int chn, int cmd, int note)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>at</name>
      <anchor>a3</anchor>
      <arglist>(ulong pos, noteCmd s)</arglist>
    </member>
    <member kind="function">
      <type>noteCmd</type>
      <name>at</name>
      <anchor>a4</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchor>a5</anchor>
      <arglist>(ulong ms, int chn, int cmd, int note)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>iteratorBegin</name>
      <anchor>a6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>noteCmd *</type>
      <name>get</name>
      <anchor>a7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next</name>
      <anchor>a8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>moveIteratorTo</name>
      <anchor>a9</anchor>
      <arglist>(ulong ms, int *pgm=NULL)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PlayerController</name>
    <filename>structPlayerController.html</filename>
    <member kind="variable">
      <type>volatile ulong</type>
      <name>ticksTotal</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile ulong</type>
      <name>ticksPlayed</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile double</type>
      <name>millisecsPlayed</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile ulong</type>
      <name>beginmillisec</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>tempo</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>num</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>den</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>SPEVprocessed</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>SPEVplayed</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>OK</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>playing</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>paused</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>moving</name>
      <anchor>o12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>finished</name>
      <anchor>o13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int message</type>
      <name>KDE_DEPRECATED</name>
      <anchor>o14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile ulong</type>
      <name>gotomsec</name>
      <anchor>o15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>error</name>
      <anchor>o16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>gm</name>
      <anchor>o17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>volumepercentage</name>
      <anchor>o18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile bool</type>
      <name>forcepgm</name>
      <anchor>o19</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable">
      <type>volatile int</type>
      <name>pgm</name>
      <anchor>o20</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable">
      <type>volatile double</type>
      <name>ratioTempo</name>
      <anchor>o21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile bool</type>
      <name>isSendingAllNotesOff</name>
      <anchor>o22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>volatile MidiEvent *</type>
      <name>ev</name>
      <anchor>o23</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>SpecialEvent</name>
    <filename>structSpecialEvent.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>id</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>diffmilliseconds</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>absmilliseconds</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ticks</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>type</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>text</name>
      <anchor>o5</anchor>
      <arglist>[1024]</arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>tempo</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>num</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>den</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SpecialEvent *</type>
      <name>next</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SynthOut</name>
    <filename>classSynthOut.html</filename>
    <base>MidiOut</base>
    <member kind="function">
      <type></type>
      <name>SynthOut</name>
      <anchor>a0</anchor>
      <arglist>(int d=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SynthOut</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>openDev</name>
      <anchor>a2</anchor>
      <arglist>(int sqfd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeDev</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initDev</name>
      <anchor>a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>noteOn</name>
      <anchor>a5</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>noteOff</name>
      <anchor>a6</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>keyPressure</name>
      <anchor>a7</anchor>
      <arglist>(uchar chn, uchar note, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPatchChange</name>
      <anchor>a8</anchor>
      <arglist>(uchar chn, uchar patch)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPressure</name>
      <anchor>a9</anchor>
      <arglist>(uchar chn, uchar vel)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnPitchBender</name>
      <anchor>a10</anchor>
      <arglist>(uchar chn, uchar lsb, uchar msb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>chnController</name>
      <anchor>a11</anchor>
      <arglist>(uchar chn, uchar ctl, uchar v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sysex</name>
      <anchor>a12</anchor>
      <arglist>(uchar *data, ulong size)</arglist>
    </member>
  </compound>
</tagfile>
