<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>KJS::Collector</name>
    <filename>classKJS_1_1Collector.html</filename>
    <member kind="function" static="yes">
      <type>void *</type>
      <name>allocate</name>
      <anchor>e0</anchor>
      <arglist>(size_t s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>collect</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>size</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>outOfMemory</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Completion</name>
    <filename>classKJS_1_1Completion.html</filename>
    <base>KJS::Value</base>
    <member kind="function">
      <type></type>
      <name>Completion</name>
      <anchor>a0</anchor>
      <arglist>(ComplType c=Normal, const Value &amp;v=Value(), const Identifier &amp;t=Identifier::null())</arglist>
    </member>
    <member kind="function">
      <type>ComplType</type>
      <name>complType</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>value</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Identifier</type>
      <name>target</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValueCompletion</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ContextImp</name>
    <filename>classKJS_1_1ContextImp.html</filename>
    <member kind="function">
      <type></type>
      <name>ContextImp</name>
      <anchor>a0</anchor>
      <arglist>(Object &amp;glob, InterpreterImp *interpreter, Object &amp;thisV, int _sourceId, CodeType type=GlobalCode, ContextImp *callingContext=0L, FunctionImp *func=0L, const List *args=0)</arglist>
    </member>
    <member kind="function">
      <type>const ScopeChain &amp;</type>
      <name>scopeChain</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>variableObject</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVariableObject</name>
      <anchor>a4</anchor>
      <arglist>(const Object &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>thisValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ContextImp *</type>
      <name>callingContext</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ObjectImp *</type>
      <name>activationObject</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FunctionImp *</type>
      <name>function</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const List *</type>
      <name>arguments</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushScope</name>
      <anchor>a10</anchor>
      <arglist>(const Object &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popScope</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LabelStack *</type>
      <name>seenLabels</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushTryCatch</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popTryCatch</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>inTryCatch</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLines</name>
      <anchor>a17</anchor>
      <arglist>(int l0, int l1)</arglist>
    </member>
    <member kind="function">
      <type>CodeType</type>
      <name>type</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Context</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>StatementNode</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::InternalFunctionImp</name>
    <filename>classKJS_1_1InternalFunctionImp.html</filename>
    <member kind="function">
      <type></type>
      <name>InternalFunctionImp</name>
      <anchor>a0</anchor>
      <arglist>(FunctionPrototypeImp *funcProto)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InternalFunctionImp</name>
      <anchor>a1</anchor>
      <arglist>(ExecState *exec)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>implementsHasInstance</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Boolean</type>
      <name>hasInstance</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec, const Value &amp;value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ClassInfo *</type>
      <name>classInfo</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Identifier</type>
      <name>name</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a6</anchor>
      <arglist>(Identifier _ident)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const ClassInfo</type>
      <name>info</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Identifier</type>
      <name>ident</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::FunctionPrototypeImp</name>
    <filename>classKJS_1_1FunctionPrototypeImp.html</filename>
    <base>KJS::InternalFunctionImp</base>
    <member kind="function">
      <type></type>
      <name>FunctionPrototypeImp</name>
      <anchor>a0</anchor>
      <arglist>(ExecState *exec)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>implementsCall</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>call</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec, Object &amp;thisObj, const List &amp;args)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::LabelStack</name>
    <filename>classKJS_1_1LabelStack.html</filename>
    <member kind="function">
      <type></type>
      <name>LabelStack</name>
      <anchor>a2</anchor>
      <arglist>(const LabelStack &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>LabelStack &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const LabelStack &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>push</name>
      <anchor>a4</anchor>
      <arglist>(const Identifier &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a5</anchor>
      <arglist>(const Identifier &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushIteration</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popIteration</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>inIteration</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushSwitch</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popSwitch</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>inSwitch</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::FunctionImp</name>
    <filename>classKJS_1_1FunctionImp.html</filename>
    <base>KJS::InternalFunctionImp</base>
    <member kind="function">
      <type></type>
      <name>FunctionImp</name>
      <anchor>a0</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;n=Identifier::null())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>get</name>
      <anchor>a2</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>put</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName, const Value &amp;value, int attr=None)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>hasProperty</name>
      <anchor>a4</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>deleteProperty</name>
      <anchor>a5</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>implementsCall</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>call</name>
      <anchor>a7</anchor>
      <arglist>(ExecState *exec, Object &amp;thisObj, const List &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addParameter</name>
      <anchor>a8</anchor>
      <arglist>(const Identifier &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>Identifier</type>
      <name>parameterProperty</name>
      <anchor>a9</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>parameterString</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual CodeType</type>
      <name>codeType</name>
      <anchor>a11</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Completion</type>
      <name>execute</name>
      <anchor>a12</anchor>
      <arglist>(ExecState *exec)=0</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>firstLine</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lastLine</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>sourceId</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ClassInfo *</type>
      <name>classInfo</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const ClassInfo</type>
      <name>info</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Parameter *</type>
      <name>param</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>line0</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>line1</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>sid</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Function</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>ActivationImp</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Context</name>
    <filename>classKJS_1_1Context.html</filename>
    <member kind="function">
      <type></type>
      <name>Context</name>
      <anchor>a0</anchor>
      <arglist>(ContextImp *i)</arglist>
    </member>
    <member kind="function">
      <type>ContextImp *</type>
      <name>imp</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ScopeChain &amp;</type>
      <name>scopeChain</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>variableObject</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>thisValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Context</type>
      <name>callingContext</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CodeType</type>
      <name>codeType</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>sourceId</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>curStmtFirstLine</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>curStmtLastLine</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>function</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Identifier</type>
      <name>functionName</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>List</type>
      <name>args</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Interpreter</name>
    <filename>classKJS_1_1Interpreter.html</filename>
    <member kind="function">
      <type></type>
      <name>Interpreter</name>
      <anchor>a0</anchor>
      <arglist>(const Object &amp;global)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Interpreter</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Object &amp;</type>
      <name>globalObject</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initGlobalObject</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ExecState *</type>
      <name>globalExec</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkSyntax</name>
      <anchor>a6</anchor>
      <arglist>(const UString &amp;code, int *errLine, UString *errMsg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkSyntax</name>
      <anchor>a7</anchor>
      <arglist>(const UString &amp;code)</arglist>
    </member>
    <member kind="function">
      <type>Completion</type>
      <name>evaluate</name>
      <anchor>a8</anchor>
      <arglist>(const UString &amp;code, const Value &amp;thisV=Value())</arglist>
    </member>
    <member kind="function">
      <type>InterpreterImp *</type>
      <name>imp</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinObject</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinFunction</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinArray</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinBoolean</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinString</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinNumber</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinDate</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinRegExp</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinError</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinObjectPrototype</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinFunctionPrototype</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinArrayPrototype</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinBooleanPrototype</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinStringPrototype</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinNumberPrototype</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinDatePrototype</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinRegExpPrototype</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinErrorPrototype</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinEvalError</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinRangeError</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinReferenceError</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinSyntaxError</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinTypeError</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinURIError</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinEvalErrorPrototype</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinRangeErrorPrototype</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinReferenceErrorPrototype</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinSyntaxErrorPrototype</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinTypeErrorPrototype</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>builtinURIErrorPrototype</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompatMode</name>
      <anchor>a40</anchor>
      <arglist>(CompatMode mode)</arglist>
    </member>
    <member kind="function">
      <type>CompatMode</type>
      <name>compatMode</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>mark</name>
      <anchor>a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>rtti</name>
      <anchor>a43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>lock</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>unlock</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>collect</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ExecState</name>
    <filename>classKJS_1_1ExecState.html</filename>
    <member kind="function">
      <type>Interpreter *</type>
      <name>interpreter</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Context</type>
      <name>context</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setException</name>
      <anchor>a2</anchor>
      <arglist>(const Value &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearException</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>exception</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hadException</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>requestTerminate</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>bool(*</type>
      <name>confirmTerminate</name>
      <anchor>s0</anchor>
      <arglist>)()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>InterpreterImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>FunctionImp</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>GlobalFuncImp</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TryNode</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>VarDeclNode</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>FuncDeclNode</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::List</name>
    <filename>classKJS_1_1List.html</filename>
    <member kind="function">
      <type></type>
      <name>List</name>
      <anchor>a1</anchor>
      <arglist>(bool needsMarking)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>List</name>
      <anchor>a3</anchor>
      <arglist>(const List &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>List &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const List &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchor>a5</anchor>
      <arglist>(const Value &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchor>a6</anchor>
      <arglist>(ValueImp *val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>List</type>
      <name>copy</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>List</type>
      <name>copyTail</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ListIterator</type>
      <name>begin</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ListIterator</type>
      <name>end</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>at</name>
      <anchor>a14</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator[]</name>
      <anchor>a15</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>ValueImp *</type>
      <name>impAt</name>
      <anchor>a16</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const List &amp;</type>
      <name>empty</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ListIterator</name>
    <filename>classKJS_1_1ListIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>ListIterator</name>
      <anchor>a0</anchor>
      <arglist>(const List &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ListIterator</name>
      <anchor>a1</anchor>
      <arglist>(const List &amp;l, int index)</arglist>
    </member>
    <member kind="function">
      <type>ValueImp *</type>
      <name>operator-&gt;</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator *</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator++</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator++</name>
      <anchor>a5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator--</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>operator--</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a8</anchor>
      <arglist>(const ListIterator &amp;it) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a9</anchor>
      <arglist>(const ListIterator &amp;it) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KJS::HashEntry</name>
    <filename>structKJS_1_1HashEntry.html</filename>
    <member kind="variable">
      <type>unsigned short</type>
      <name>soffset</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>short int</type>
      <name>value</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>attr</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char</type>
      <name>params</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>short</type>
      <name>next</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KJS::HashTable</name>
    <filename>structKJS_1_1HashTable.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>type</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>size</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const HashEntry *const </type>
      <name>entries</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>hashSize</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *const </type>
      <name>sbase</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Lookup</name>
    <filename>classKJS_1_1Lookup.html</filename>
    <member kind="function" static="yes">
      <type>int</type>
      <name>find</name>
      <anchor>e0</anchor>
      <arglist>(const struct HashTable *table, const Identifier &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>find</name>
      <anchor>e1</anchor>
      <arglist>(const struct HashTable *table, const UChar *c, unsigned int len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const HashEntry *</type>
      <name>findEntry</name>
      <anchor>e2</anchor>
      <arglist>(const struct HashTable *table, const Identifier &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const HashEntry *</type>
      <name>findEntry</name>
      <anchor>e3</anchor>
      <arglist>(const struct HashTable *table, const UChar *c, unsigned int len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>unsigned int</type>
      <name>hash</name>
      <anchor>e4</anchor>
      <arglist>(const Identifier &amp;key)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>unsigned int</type>
      <name>hash</name>
      <anchor>e5</anchor>
      <arglist>(const UChar *c, unsigned int len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>unsigned int</type>
      <name>hash</name>
      <anchor>e6</anchor>
      <arglist>(const char *s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::BinaryLogicalNode</name>
    <filename>classKJS_1_1BinaryLogicalNode.html</filename>
    <member kind="function">
      <type></type>
      <name>BinaryLogicalNode</name>
      <anchor>a0</anchor>
      <arglist>(Node *e1, Operator o, Node *e2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>ref</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>deref</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>evaluate</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>streamTo</name>
      <anchor>a4</anchor>
      <arglist>(SourceStream &amp;s) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ConditionalNode</name>
    <filename>classKJS_1_1ConditionalNode.html</filename>
    <member kind="function">
      <type></type>
      <name>ConditionalNode</name>
      <anchor>a0</anchor>
      <arglist>(Node *l, Node *e1, Node *e2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>ref</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>deref</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>evaluate</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>streamTo</name>
      <anchor>a4</anchor>
      <arglist>(SourceStream &amp;s) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KJS::ClassInfo</name>
    <filename>structKJS_1_1ClassInfo.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>className</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const ClassInfo *</type>
      <name>parentClass</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const HashTable *</type>
      <name>propHashTable</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>void *</type>
      <name>dummy</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Object</name>
    <filename>classKJS_1_1Object.html</filename>
    <base>KJS::Value</base>
    <member kind="function">
      <type></type>
      <name>Object</name>
      <anchor>a1</anchor>
      <arglist>(ObjectImp *v)</arglist>
    </member>
    <member kind="function">
      <type>ObjectImp *</type>
      <name>imp</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const ClassInfo *</type>
      <name>classInfo</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>inherits</name>
      <anchor>a4</anchor>
      <arglist>(const ClassInfo *cinfo) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>prototype</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>className</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>get</name>
      <anchor>a7</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>get</name>
      <anchor>a8</anchor>
      <arglist>(ExecState *exec, unsigned propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>put</name>
      <anchor>a9</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName, const Value &amp;value, int attr=None)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>put</name>
      <anchor>a10</anchor>
      <arglist>(ExecState *exec, unsigned propertyName, const Value &amp;value, int attr=None)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canPut</name>
      <anchor>a11</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasProperty</name>
      <anchor>a12</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasProperty</name>
      <anchor>a13</anchor>
      <arglist>(ExecState *exec, unsigned propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>deleteProperty</name>
      <anchor>a14</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>deleteProperty</name>
      <anchor>a15</anchor>
      <arglist>(ExecState *exec, unsigned propertyName)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>defaultValue</name>
      <anchor>a16</anchor>
      <arglist>(ExecState *exec, Type hint) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>implementsConstruct</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>construct</name>
      <anchor>a18</anchor>
      <arglist>(ExecState *exec, const List &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>implementsCall</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>call</name>
      <anchor>a20</anchor>
      <arglist>(ExecState *exec, Object &amp;thisObj, const List &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>implementsHasInstance</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Boolean</type>
      <name>hasInstance</name>
      <anchor>a22</anchor>
      <arglist>(ExecState *exec, const Value &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>const ScopeChain &amp;</type>
      <name>scope</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScope</name>
      <anchor>a24</anchor>
      <arglist>(const ScopeChain &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>ReferenceList</type>
      <name>propList</name>
      <anchor>a25</anchor>
      <arglist>(ExecState *exec, bool recursive=true)</arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>internalValue</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInternalValue</name>
      <anchor>a27</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Object</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Error</name>
    <filename>classKJS_1_1Error.html</filename>
    <member kind="function" static="yes">
      <type>Object</type>
      <name>create</name>
      <anchor>e0</anchor>
      <arglist>(ExecState *exec, ErrorType errtype=GeneralError, const char *message=0, int lineno=-1, int sourceId=-1)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const char *const *const </type>
      <name>errorNames</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KJS::UChar</name>
    <filename>structKJS_1_1UChar.html</filename>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a1</anchor>
      <arglist>(char u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a2</anchor>
      <arglist>(unsigned char u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a3</anchor>
      <arglist>(unsigned char h, unsigned char l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a4</anchor>
      <arglist>(unsigned short u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UChar</name>
      <anchor>a5</anchor>
      <arglist>(const UCharReference &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>unsigned char</type>
      <name>high</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned char</type>
      <name>low</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>unicode</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UChar</type>
      <name>toLower</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UChar</type>
      <name>toUpper</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>uc</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>UChar</type>
      <name>null</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::UCharReference</name>
    <filename>classKJS_1_1UCharReference.html</filename>
    <member kind="function">
      <type>UCharReference &amp;</type>
      <name>operator=</name>
      <anchor>a0</anchor>
      <arglist>(UChar c)</arglist>
    </member>
    <member kind="function">
      <type>UCharReference &amp;</type>
      <name>operator=</name>
      <anchor>a1</anchor>
      <arglist>(char c)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>unicode</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned char</type>
      <name>low</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned char</type>
      <name>high</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UChar</type>
      <name>toLower</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UChar</type>
      <name>toUpper</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>UString</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::CString</name>
    <filename>classKJS_1_1CString.html</filename>
    <member kind="function">
      <type></type>
      <name>CString</name>
      <anchor>a1</anchor>
      <arglist>(const char *c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CString</name>
      <anchor>a2</anchor>
      <arglist>(const char *c, int len)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CString</name>
      <anchor>a3</anchor>
      <arglist>(const CString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CString &amp;</type>
      <name>append</name>
      <anchor>a5</anchor>
      <arglist>(const CString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CString &amp;</type>
      <name>operator=</name>
      <anchor>a6</anchor>
      <arglist>(const char *c)</arglist>
    </member>
    <member kind="function">
      <type>CString &amp;</type>
      <name>operator=</name>
      <anchor>a7</anchor>
      <arglist>(const CString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CString &amp;</type>
      <name>operator+=</name>
      <anchor>a8</anchor>
      <arglist>(const CString &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>c_str</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::UString</name>
    <filename>classKJS_1_1UString.html</filename>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a1</anchor>
      <arglist>(char c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a2</anchor>
      <arglist>(const char *c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a3</anchor>
      <arglist>(const UChar *c, int length)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a4</anchor>
      <arglist>(UChar *c, int length, bool copy)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a5</anchor>
      <arglist>(const UString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a7</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UString</name>
      <anchor>a8</anchor>
      <arglist>(const UString &amp;, const UString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~UString</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>UString &amp;</type>
      <name>append</name>
      <anchor>a10</anchor>
      <arglist>(const UString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CString</type>
      <name>cstring</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>ascii</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>string</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>qstring</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QConstString</type>
      <name>qconststring</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UString &amp;</type>
      <name>operator=</name>
      <anchor>a16</anchor>
      <arglist>(const char *c)</arglist>
    </member>
    <member kind="function">
      <type>UString &amp;</type>
      <name>operator=</name>
      <anchor>a17</anchor>
      <arglist>(const UString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>UString &amp;</type>
      <name>operator+=</name>
      <anchor>a18</anchor>
      <arglist>(const UString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>const UChar *</type>
      <name>data</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is8Bit</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UChar</type>
      <name>operator[]</name>
      <anchor>a24</anchor>
      <arglist>(int pos) const </arglist>
    </member>
    <member kind="function">
      <type>UCharReference</type>
      <name>operator[]</name>
      <anchor>a25</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>toDouble</name>
      <anchor>a26</anchor>
      <arglist>(bool tolerateTrailingJunk, bool tolerateEmptyString) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>toDouble</name>
      <anchor>a27</anchor>
      <arglist>(bool tolerateTrailingJunk) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>toDouble</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>toULong</name>
      <anchor>a29</anchor>
      <arglist>(bool *ok, bool tolerateEmptyString) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>toULong</name>
      <anchor>a30</anchor>
      <arglist>(bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>toStrictUInt32</name>
      <anchor>a31</anchor>
      <arglist>(bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned</type>
      <name>toArrayIndex</name>
      <anchor>a32</anchor>
      <arglist>(bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>toLower</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>toUpper</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchor>a35</anchor>
      <arglist>(const UString &amp;f, int pos=0) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchor>a36</anchor>
      <arglist>(UChar, int pos=0) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rfind</name>
      <anchor>a37</anchor>
      <arglist>(const UString &amp;f, int pos) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>rfind</name>
      <anchor>a38</anchor>
      <arglist>(UChar, int pos) const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>substr</name>
      <anchor>a39</anchor>
      <arglist>(int pos=0, int len=-1) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>UString</type>
      <name>from</name>
      <anchor>e0</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>UString</type>
      <name>from</name>
      <anchor>e1</anchor>
      <arglist>(unsigned int u)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>UString</type>
      <name>from</name>
      <anchor>e2</anchor>
      <arglist>(long l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>UString</type>
      <name>from</name>
      <anchor>e3</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>UString</type>
      <name>null</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>UCharReference</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Identifier</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PropertyMap</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PropertyMapHashTableEntry</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend bool</type>
      <name>operator==</name>
      <anchor>n4</anchor>
      <arglist>(const UString &amp;, const UString &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ValueImp</name>
    <filename>classKJS_1_1ValueImp.html</filename>
    <member kind="function">
      <type>ValueImp *</type>
      <name>ref</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>deref</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>mark</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>marked</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new</name>
      <anchor>a6</anchor>
      <arglist>(size_t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete</name>
      <anchor>a7</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGcAllowed</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGcAllowedFast</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toInteger</name>
      <anchor>a10</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toInt32</name>
      <anchor>a11</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>toUInt32</name>
      <anchor>a12</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>toUInt16</name>
      <anchor>a13</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>dispatchType</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>dispatchToPrimitive</name>
      <anchor>a15</anchor>
      <arglist>(ExecState *exec, Type preferredType=UnspecifiedType) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dispatchToBoolean</name>
      <anchor>a16</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dispatchToNumber</name>
      <anchor>a17</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>dispatchToString</name>
      <anchor>a18</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dispatchToUInt32</name>
      <anchor>a19</anchor>
      <arglist>(unsigned &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>dispatchToObject</name>
      <anchor>a20</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDestroyed</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>unsigned short int</type>
      <name>refcount</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Collector</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Value</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>ContextImp</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Value</name>
    <filename>classKJS_1_1Value.html</filename>
    <member kind="function">
      <type></type>
      <name>Value</name>
      <anchor>a1</anchor>
      <arglist>(ValueImp *v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Value</name>
      <anchor>a2</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>Value &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ValueImp *</type>
      <name>imp</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>type</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isA</name>
      <anchor>a9</anchor>
      <arglist>(Type t) const </arglist>
    </member>
    <member kind="function">
      <type>Value</type>
      <name>toPrimitive</name>
      <anchor>a10</anchor>
      <arglist>(ExecState *exec, Type preferredType=UnspecifiedType) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>toBoolean</name>
      <anchor>a11</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>toNumber</name>
      <anchor>a12</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toInteger</name>
      <anchor>a13</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toInt32</name>
      <anchor>a14</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>toUInt32</name>
      <anchor>a15</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>toUInt16</name>
      <anchor>a16</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>toString</name>
      <anchor>a17</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>Object</type>
      <name>toObject</name>
      <anchor>a18</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>toUInt32</name>
      <anchor>a19</anchor>
      <arglist>(unsigned &amp;i) const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>ValueImp *</type>
      <name>rep</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Undefined</name>
    <filename>classKJS_1_1Undefined.html</filename>
    <base>KJS::Value</base>
    <member kind="function" static="yes">
      <type>Undefined</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>UndefinedImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Null</name>
    <filename>classKJS_1_1Null.html</filename>
    <base>KJS::Value</base>
    <member kind="function" static="yes">
      <type>Null</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NullImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Boolean</name>
    <filename>classKJS_1_1Boolean.html</filename>
    <base>KJS::Value</base>
    <member kind="function">
      <type></type>
      <name>Boolean</name>
      <anchor>a0</anchor>
      <arglist>(bool b=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>value</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>Boolean</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>BooleanImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::String</name>
    <filename>classKJS_1_1String.html</filename>
    <base>KJS::Value</base>
    <member kind="function">
      <type></type>
      <name>String</name>
      <anchor>a0</anchor>
      <arglist>(const UString &amp;s=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>UString</type>
      <name>value</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>String</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>StringImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::Number</name>
    <filename>classKJS_1_1Number.html</filename>
    <base>KJS::Value</base>
    <member kind="function">
      <type></type>
      <name>Number</name>
      <anchor>a0</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Number</name>
      <anchor>a1</anchor>
      <arglist>(unsigned int u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Number</name>
      <anchor>a2</anchor>
      <arglist>(double d=0.0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Number</name>
      <anchor>a3</anchor>
      <arglist>(long int l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Number</name>
      <anchor>a4</anchor>
      <arglist>(long unsigned int l)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>value</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>intValue</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNaN</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isInf</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>Number</type>
      <name>dynamicCast</name>
      <anchor>e0</anchor>
      <arglist>(const Value &amp;v)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>ValueImp</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NumberImp</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
</tagfile>
