<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>KDE HTML widget</title>
    <filename>index</filename>
  </compound>
  <compound kind="class">
    <name>KHTMLPageCache</name>
    <filename>classKHTMLPageCache.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type>long</type>
      <name>createCacheEntry</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addData</name>
      <anchor>a2</anchor>
      <arglist>(long id, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endData</name>
      <anchor>a3</anchor>
      <arglist>(long id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancelEntry</name>
      <anchor>a4</anchor>
      <arglist>(long id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a5</anchor>
      <arglist>(long id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isComplete</name>
      <anchor>a6</anchor>
      <arglist>(long id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fetchData</name>
      <anchor>a7</anchor>
      <arglist>(long id, QObject *recvObj, const char *recvSlot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancelFetch</name>
      <anchor>a8</anchor>
      <arglist>(QObject *recvObj)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveData</name>
      <anchor>a9</anchor>
      <arglist>(long id, QDataStream *str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KHTMLPageCache *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHTMLPart</name>
    <filename>classKHTMLPart.html</filename>
    <base>KParts::ReadOnlyPart</base>
    <member kind="enumeration">
      <name>CaretDisplayPolicy</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setActiveNode</name>
      <anchor>i0</anchor>
      <arglist>(const DOM::Node &amp;node)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>stopAnimations</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>QCString</type>
      <name>dcopObjectId</name>
      <anchor>i2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>QVariant</type>
      <name>executeScript</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;script)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCaretMode</name>
      <anchor>i4</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setEditable</name>
      <anchor>i5</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCaretVisible</name>
      <anchor>i6</anchor>
      <arglist>(bool show)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>submitFormProxy</name>
      <anchor>i7</anchor>
      <arglist>(const char *action, const QString &amp;url, const QByteArray &amp;formData, const QString &amp;target, const QString &amp;contentType=QString::null, const QString &amp;boundary=QString::null)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>onURL</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>popupMenu</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url, const QPoint &amp;point)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>selectionChanged</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>nodeActivated</name>
      <anchor>l3</anchor>
      <arglist>(const DOM::Node &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>docCreated</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>caretPositionChanged</name>
      <anchor>l5</anchor>
      <arglist>(const DOM::Node &amp;node, long offset)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>formSubmitNotification</name>
      <anchor>l6</anchor>
      <arglist>(const char *action, const QString &amp;url, const QByteArray &amp;formData, const QString &amp;target, const QString &amp;contentType, const QString &amp;boundary)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLPart</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parentWidget=0, const char *widgetname=0, QObject *parent=0, const char *name=0, GUIProfile prof=DefaultGUI)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLPart</name>
      <anchor>a1</anchor>
      <arglist>(KHTMLView *view, QObject *parent=0, const char *name=0, GUIProfile prof=DefaultGUI)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KHTMLPart</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>openURL</name>
      <anchor>a3</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>closeURL</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>showError</name>
      <anchor>a5</anchor>
      <arglist>(KIO::Job *job)</arglist>
    </member>
    <member kind="function">
      <type>DOM::HTMLDocument</type>
      <name>htmlDocument</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::Document</type>
      <name>document</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::Node</type>
      <name>activeNode</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KParts::BrowserExtension *</type>
      <name>browserExtension</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KParts::LiveConnectExtension *</type>
      <name>liveConnectExtension</name>
      <anchor>a10</anchor>
      <arglist>(const khtml::RenderPart *) const </arglist>
    </member>
    <member kind="function">
      <type>KHTMLView *</type>
      <name>view</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJScriptEnabled</name>
      <anchor>a12</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>jScriptEnabled</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KJS::Interpreter *</type>
      <name>jScriptInterpreter</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStatusMessagesEnabled</name>
      <anchor>a15</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>statusMessagesEnabled</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMetaRefreshEnabled</name>
      <anchor>a17</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>metaRefreshEnabled</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>executeScript</name>
      <anchor>a19</anchor>
      <arglist>(const DOM::Node &amp;n, const QString &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDNDEnabled</name>
      <anchor>a20</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dndEnabled</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJavaEnabled</name>
      <anchor>a22</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>javaEnabled</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KJavaAppletContext *</type>
      <name>javaContext</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KJavaAppletContext *</type>
      <name>createJavaContext</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPluginsEnabled</name>
      <anchor>a26</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>pluginsEnabled</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoloadImages</name>
      <anchor>a28</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoloadImages</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOnlyLocalReferences</name>
      <anchor>a30</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>onlyLocalReferences</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCaretMode</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEditable</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCaretPosition</name>
      <anchor>a34</anchor>
      <arglist>(DOM::Node node, long offset, bool extendSelection=false)</arglist>
    </member>
    <member kind="function">
      <type>CaretDisplayPolicy</type>
      <name>caretDisplayPolicyNonFocused</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCaretDisplayPolicyNonFocused</name>
      <anchor>a36</anchor>
      <arglist>(CaretDisplayPolicy policy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableJScript</name>
      <anchor>a37</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableJava</name>
      <anchor>a38</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enablePlugins</name>
      <anchor>a39</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>autoloadImages</name>
      <anchor>a40</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableMetaRefresh</name>
      <anchor>a41</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setCharset</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;, bool)</arglist>
    </member>
    <member kind="function">
      <type>KURL</type>
      <name>baseURL</name>
      <anchor>a43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>baseTarget</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KURL</type>
      <name>backgroundURL</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scheduleRedirection</name>
      <anchor>a46</anchor>
      <arglist>(int delay, const QString &amp;url, bool lockHistory=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>begin</name>
      <anchor>a47</anchor>
      <arglist>(const KURL &amp;url=KURL(), int xOffset=0, int yOffset=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchor>a48</anchor>
      <arglist>(const char *str, int len=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchor>a49</anchor>
      <arglist>(const QString &amp;str)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>end</name>
      <anchor>a50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paint</name>
      <anchor>a51</anchor>
      <arglist>(QPainter *, const QRect &amp;, int=0, bool *=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setEncoding</name>
      <anchor>a52</anchor>
      <arglist>(const QString &amp;name, bool override=false)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>encoding</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserStyleSheet</name>
      <anchor>a54</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserStyleSheet</name>
      <anchor>a55</anchor>
      <arglist>(const QString &amp;styleSheet)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStandardFont</name>
      <anchor>a56</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFixedFont</name>
      <anchor>a57</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>gotoAnchor</name>
      <anchor>a58</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nextAnchor</name>
      <anchor>a59</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>prevAnchor</name>
      <anchor>a60</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setURLCursor</name>
      <anchor>a61</anchor>
      <arglist>(const QCursor &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>QCursor</type>
      <name>urlCursor</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findTextBegin</name>
      <anchor>a63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findTextNext</name>
      <anchor>a64</anchor>
      <arglist>(const QString &amp;str, bool forward, bool caseSensitive, bool isRegExp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZoomFactor</name>
      <anchor>a65</anchor>
      <arglist>(int percent)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>zoomFactor</name>
      <anchor>a66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>selectedText</name>
      <anchor>a67</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::Range</type>
      <name>selection</name>
      <anchor>a68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>selection</name>
      <anchor>a69</anchor>
      <arglist>(DOM::Node &amp;startNode, long &amp;startOffset, DOM::Node &amp;endNode, long &amp;endOffset) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelection</name>
      <anchor>a70</anchor>
      <arglist>(const DOM::Range &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSelection</name>
      <anchor>a71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>selectAll</name>
      <anchor>a72</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchor>a73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide</name>
      <anchor>a74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KParts::PartManager *</type>
      <name>partManager</name>
      <anchor>a75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>saveState</name>
      <anchor>a76</anchor>
      <arglist>(QDataStream &amp;stream)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>restoreState</name>
      <anchor>a77</anchor>
      <arglist>(QDataStream &amp;stream)</arglist>
    </member>
    <member kind="function">
      <type>DOM::Node</type>
      <name>nodeUnderMouse</name>
      <anchor>a78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KHTMLSettings *</type>
      <name>settings</name>
      <anchor>a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KHTMLPart *</type>
      <name>parentPart</name>
      <anchor>a80</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>frameNames</name>
      <anchor>a81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; KParts::ReadOnlyPart &gt;</type>
      <name>frames</name>
      <anchor>a82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KHTMLPart *</type>
      <name>findFrame</name>
      <anchor>a83</anchor>
      <arglist>(const QString &amp;f)</arglist>
    </member>
    <member kind="function">
      <type>KParts::ReadOnlyPart *</type>
      <name>currentFrame</name>
      <anchor>a84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>frameExists</name>
      <anchor>a85</anchor>
      <arglist>(const QString &amp;frameName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJSStatusBarText</name>
      <anchor>a86</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJSDefaultStatusBarText</name>
      <anchor>a87</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>jsStatusBarText</name>
      <anchor>a88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>jsDefaultStatusBarText</name>
      <anchor>a89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>referrer</name>
      <anchor>a90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>pageReferrer</name>
      <anchor>a91</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>lastModified</name>
      <anchor>a92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preloadStyleSheet</name>
      <anchor>a93</anchor>
      <arglist>(const QString &amp;url, const QString &amp;stylesheet)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preloadScript</name>
      <anchor>a94</anchor>
      <arglist>(const QString &amp;url, const QString &amp;script)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>restored</name>
      <anchor>a95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFormNotification</name>
      <anchor>a96</anchor>
      <arglist>(FormNotification fn)</arglist>
    </member>
    <member kind="function">
      <type>FormNotification</type>
      <name>formNotification</name>
      <anchor>a97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KURL</type>
      <name>toplevelURL</name>
      <anchor>a98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>KURL</type>
      <name>completeURL</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>htmlError</name>
      <anchor>b1</anchor>
      <arglist>(int errorCode, const QString &amp;text, const KURL &amp;reqUrl)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>customEvent</name>
      <anchor>b2</anchor>
      <arglist>(QCustomEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>khtmlMousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(khtml::MousePressEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>khtmlMouseDoubleClickEvent</name>
      <anchor>b4</anchor>
      <arglist>(khtml::MouseDoubleClickEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>khtmlMouseMoveEvent</name>
      <anchor>b5</anchor>
      <arglist>(khtml::MouseMoveEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>khtmlMouseReleaseEvent</name>
      <anchor>b6</anchor>
      <arglist>(khtml::MouseReleaseEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>khtmlDrawContentsEvent</name>
      <anchor>b7</anchor>
      <arglist>(khtml::DrawContentsEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>guiActivateEvent</name>
      <anchor>b8</anchor>
      <arglist>(KParts::GUIActivateEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>openFile</name>
      <anchor>b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>urlSelected</name>
      <anchor>b10</anchor>
      <arglist>(const QString &amp;url, int button, int state, const QString &amp;_target, KParts::URLArgs args=KParts::URLArgs())</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KParts::ReadOnlyPart *</type>
      <name>createPart</name>
      <anchor>b11</anchor>
      <arglist>(QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const QString &amp;mimetype, QString &amp;serviceName, QStringList &amp;serviceTypes, const QStringList &amp;params)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>pluginPageQuestionAsked</name>
      <anchor>b12</anchor>
      <arglist>(const QString &amp;mimetype) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setPluginPageQuestionAsked</name>
      <anchor>b13</anchor>
      <arglist>(const QString &amp;mimetype)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setPageSecurity</name>
      <anchor>b14</anchor>
      <arglist>(PageSecurity sec)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>doOpenStream</name>
      <anchor>b15</anchor>
      <arglist>(const QString &amp;mimeType)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>doWriteStream</name>
      <anchor>b16</anchor>
      <arglist>(const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>doCloseStream</name>
      <anchor>b17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLTitleElementImpl</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLFrameElementImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLIFrameElementImpl</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLObjectElementImpl</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLAnchorElementImpl</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLMetaElementImpl</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::NodeImpl</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLRun</name>
      <anchor>n7</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLFormElementImpl</name>
      <anchor>n8</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderPartObject</name>
      <anchor>n9</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::Window</name>
      <anchor>n10</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::WindowFunc</name>
      <anchor>n11</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::ExternalFunc</name>
      <anchor>n12</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::JSEventListener</name>
      <anchor>n13</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::DOMDocument</name>
      <anchor>n14</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::SourceFile</name>
      <anchor>n15</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KJSProxy</name>
      <anchor>n16</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPartBrowserExtension</name>
      <anchor>n17</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::DocumentImpl</name>
      <anchor>n18</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLDocumentImpl</name>
      <anchor>n19</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPartBrowserHostExtension</name>
      <anchor>n20</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::HTMLTokenizer</name>
      <anchor>n21</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>XMLTokenizer</name>
      <anchor>n22</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderWidget</name>
      <anchor>n23</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::CSSStyleSelector</name>
      <anchor>n24</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPartIface</name>
      <anchor>n25</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPartFunction</name>
      <anchor>n26</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPartPrivate</name>
      <anchor>n27</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHTMLPartBrowserExtension</name>
    <filename>classKHTMLPartBrowserExtension.html</filename>
    <base>KParts::BrowserExtension</base>
    <member kind="slot">
      <type>void</type>
      <name>cut</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>copy</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>paste</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>reparseConfiguration</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>print</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateEditActions</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>editableWidgetFocused</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>editableWidgetBlurred</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLPartBrowserExtension</name>
      <anchor>a0</anchor>
      <arglist>(KHTMLPart *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>xOffset</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>yOffset</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>saveState</name>
      <anchor>a3</anchor>
      <arglist>(QDataStream &amp;stream)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>restoreState</name>
      <anchor>a4</anchor>
      <arglist>(QDataStream &amp;stream)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editableWidgetFocused</name>
      <anchor>a5</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editableWidgetBlurred</name>
      <anchor>a6</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setExtensionProxy</name>
      <anchor>a7</anchor>
      <arglist>(KParts::BrowserExtension *proxyExtension)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLView</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHTMLPartIface</name>
    <filename>classKHTMLPartIface.html</filename>
    <member kind="dcop">
      <type>KURL</type>
      <name>url</name>
      <anchor>z0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>closeURL</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setJScriptEnabled</name>
      <anchor>z2</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>jScriptEnabled</name>
      <anchor>z3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setMetaRefreshEnabled</name>
      <anchor>z4</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>metaRefreshEnabled</name>
      <anchor>z5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setDNDEnabled</name>
      <anchor>z6</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>dndEnabled</name>
      <anchor>z7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setJavaEnabled</name>
      <anchor>z8</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>javaEnabled</name>
      <anchor>z9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setPluginsEnabled</name>
      <anchor>z10</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>pluginsEnabled</name>
      <anchor>z11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setAutoloadImages</name>
      <anchor>z12</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>autoloadImages</name>
      <anchor>z13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setOnlyLocalReferences</name>
      <anchor>z14</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>onlyLocalReferences</name>
      <anchor>z15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>setEncoding</name>
      <anchor>z16</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>encoding</name>
      <anchor>z17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setUserStyleSheet</name>
      <anchor>z18</anchor>
      <arglist>(const QString &amp;styleSheet)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setFixedFont</name>
      <anchor>z19</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>gotoAnchor</name>
      <anchor>z20</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>nextAnchor</name>
      <anchor>z21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>prevAnchor</name>
      <anchor>z22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>activateNode</name>
      <anchor>z23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>selectedText</name>
      <anchor>z24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>selectAll</name>
      <anchor>z25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>lastModified</name>
      <anchor>z26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop">
      <type>ASYNC</type>
      <name>print</name>
      <anchor>z27</anchor>
      <arglist>(bool quick)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>debugRenderTree</name>
      <anchor>z28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>debugDOMTree</name>
      <anchor>z29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>viewDocumentSource</name>
      <anchor>z30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>viewFrameSource</name>
      <anchor>z31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>saveBackground</name>
      <anchor>z32</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>saveDocument</name>
      <anchor>z33</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>evalJS</name>
      <anchor>z34</anchor>
      <arglist>(const QString &amp;script)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>stopAnimations</name>
      <anchor>z35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLPartIface</name>
      <anchor>a0</anchor>
      <arglist>(KHTMLPart *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHTMLSettings</name>
    <filename>classKHTMLSettings.html</filename>
    <member kind="enumeration">
      <name>KJavaScriptAdvice</name>
      <anchor>w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KJSWindowOpenPolicy</name>
      <anchor>w20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KJSWindowStatusPolicy</name>
      <anchor>w21</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KJSWindowMovePolicy</name>
      <anchor>w22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KJSWindowResizePolicy</name>
      <anchor>w23</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KJSWindowFocusPolicy</name>
      <anchor>w24</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLSettings</name>
      <anchor>a1</anchor>
      <arglist>(const KHTMLSettings &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *config, bool reset=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KHTMLSettings</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>changeCursor</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>underlineLink</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hoverLink</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KAnimationAdvice</type>
      <name>showAnimations</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>stdFontName</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fixedFontName</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>serifFontName</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>sansSerifFontName</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>cursiveFontName</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fantasyFontName</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStdFontName</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFixedFontName</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minFontSize</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mediumFontSize</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>jsErrorsEnabled</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJSErrorsEnabled</name>
      <anchor>a20</anchor>
      <arglist>(bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>encoding</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>textColor</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>linkColor</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>vLinkColor</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoLoadImages</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isBackRightClickEnabled</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isJavaEnabled</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;hostname=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isJavaScriptEnabled</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;hostname=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isJavaScriptDebugEnabled</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;hostname=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isJavaScriptErrorReportingEnabled</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPluginsEnabled</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;hostname=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>KJSWindowOpenPolicy</type>
      <name>windowOpenPolicy</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>KJSWindowMovePolicy</type>
      <name>windowMovePolicy</name>
      <anchor>a33</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>KJSWindowResizePolicy</type>
      <name>windowResizePolicy</name>
      <anchor>a34</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>KJSWindowStatusPolicy</type>
      <name>windowStatusPolicy</name>
      <anchor>a35</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>KJSWindowFocusPolicy</type>
      <name>windowFocusPolicy</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;hostname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDomainSettings</name>
      <anchor>a37</anchor>
      <arglist>(KConfig *config, bool reset, bool global, KPerDomainSettings &amp;pd_settings)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>settingsToCSS</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>userStyleSheet</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFormCompletionEnabled</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxFormCompletionItems</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAutoDelayedActionsEnabled</name>
      <anchor>a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KJavaScriptAdvice</type>
      <name>strToAdvice</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;_str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>splitDomainAdvice</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;configStr, QString &amp;domain, KJavaScriptAdvice &amp;javaAdvice, KJavaScriptAdvice &amp;javaScriptAdvice)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>adviceToStr</name>
      <anchor>e2</anchor>
      <arglist>(KJavaScriptAdvice _advice)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QString &amp;</type>
      <name>availableFamilies</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLFactory</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHTMLView</name>
    <filename>classKHTMLView.html</filename>
    <base>QScrollView</base>
    <member kind="signal">
      <type>void</type>
      <name>cleared</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>zoomView</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHTMLView</name>
      <anchor>a0</anchor>
      <arglist>(KHTMLPart *part, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>KHTMLPart *</type>
      <name>part</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>frameWidth</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginWidth</name>
      <anchor>a4</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>marginWidth</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginHeight</name>
      <anchor>a6</anchor>
      <arglist>(int y)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>marginHeight</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setVScrollBarMode</name>
      <anchor>a8</anchor>
      <arglist>(ScrollBarMode mode)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setHScrollBarMode</name>
      <anchor>a9</anchor>
      <arglist>(ScrollBarMode mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchor>a11</anchor>
      <arglist>(bool quick)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>layout</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotPaletteChanged</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotScrollBarMoved</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>clear</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>showEvent</name>
      <anchor>b2</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b3</anchor>
      <arglist>(QHideEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>focusNextPrevChild</name>
      <anchor>b4</anchor>
      <arglist>(bool next)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b5</anchor>
      <arglist>(QPainter *p, int clipx, int clipy, int clipw, int cliph)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b6</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportMousePressEvent</name>
      <anchor>b7</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b8</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b9</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportMouseDoubleClickEvent</name>
      <anchor>b10</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportMouseMoveEvent</name>
      <anchor>b11</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportMouseReleaseEvent</name>
      <anchor>b12</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportResizeEvent</name>
      <anchor>b13</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportWheelEvent</name>
      <anchor>b14</anchor>
      <arglist>(QWheelEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragEnterEvent</name>
      <anchor>b15</anchor>
      <arglist>(QDragEnterEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b16</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeEvent</name>
      <anchor>b17</anchor>
      <arglist>(QCloseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b18</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyPressEvent</name>
      <anchor>b19</anchor>
      <arglist>(QKeyEvent *_ke)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyReleaseEvent</name>
      <anchor>b20</anchor>
      <arglist>(QKeyEvent *_ke)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>contentsContextMenuEvent</name>
      <anchor>b21</anchor>
      <arglist>(QContextMenuEvent *_ce)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>doAutoScroll</name>
      <anchor>b22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>timerEvent</name>
      <anchor>b23</anchor>
      <arglist>(QTimerEvent *)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLTitleElementImpl</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLGenericFormElementImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLFormElementImpl</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLAnchorElementImpl</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::HTMLInputElementImpl</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>DOM::DocumentImpl</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KHTMLPart</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderCanvas</name>
      <anchor>n7</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderObject</name>
      <anchor>n8</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderLineEdit</name>
      <anchor>n9</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderPartObject</name>
      <anchor>n10</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::RenderWidget</name>
      <anchor>n11</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::CSSStyleSelector</name>
      <anchor>n12</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>khtml::LineEditWidget</name>
      <anchor>n13</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::WindowFunc</name>
      <anchor>n14</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::ExternalFunc</name>
      <anchor>n15</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend void</type>
      <name>khtml::applyRule</name>
      <anchor>n16</anchor>
      <arglist>(DOM::CSSProperty *prop)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMultiPart</name>
    <filename>classKMultiPart.html</filename>
    <base>KParts::ReadOnlyPart</base>
    <member kind="function">
      <type></type>
      <name>KMultiPart</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name, const QStringList &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>openFile</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>openURL</name>
      <anchor>a3</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>closeURL</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KAboutData *</type>
      <name>createAboutData</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>guiActivateEvent</name>
      <anchor>b0</anchor>
      <arglist>(KParts::GUIActivateEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setPart</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;mimeType)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>startOfData</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>sendData</name>
      <anchor>b3</anchor>
      <arglist>(const QByteArray &amp;line)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>endOfData</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>rule</name>
    <title>is</title>
    <filename>rule</filename>
  </compound>
  <compound kind="namespace">
    <name>DOM</name>
    <filename>namespaceDOM.html</filename>
    <class kind="class">DOM::CSS2Azimuth</class>
    <class kind="class">DOM::CSS2BackgroundPosition</class>
    <class kind="class">DOM::CSS2BorderSpacing</class>
    <class kind="class">DOM::CSS2CounterIncrement</class>
    <class kind="class">DOM::CSS2CounterReset</class>
    <class kind="class">DOM::CSS2Cursor</class>
    <class kind="class">DOM::CSS2FontFaceSrc</class>
    <class kind="class">DOM::CSS2FontFaceWidths</class>
    <class kind="class">DOM::CSS2PageSize</class>
    <class kind="class">DOM::CSS2PlayDuring</class>
    <class kind="class">DOM::CSS2Properties</class>
    <class kind="class">DOM::CSS2TextShadow</class>
    <class kind="class">DOM::CSSRule</class>
    <class kind="class">DOM::CSSCharsetRule</class>
    <class kind="class">DOM::CSSFontFaceRule</class>
    <class kind="class">DOM::CSSImportRule</class>
    <class kind="class">DOM::CSSMediaRule</class>
    <class kind="class">DOM::CSSStyleRule</class>
    <class kind="class">DOM::CSSUnknownRule</class>
    <class kind="class">DOM::CSSRuleList</class>
    <class kind="class">DOM::StyleSheet</class>
    <class kind="class">DOM::CSSException</class>
    <class kind="class">DOM::CSSStyleSheet</class>
    <class kind="class">DOM::StyleSheetList</class>
    <class kind="class">DOM::MediaList</class>
    <class kind="class">DOM::CSSStyleDeclaration</class>
    <class kind="class">DOM::CSSValue</class>
    <class kind="class">DOM::CSSValueList</class>
    <class kind="class">DOM::CSSPrimitiveValue</class>
    <class kind="class">DOM::RGBColor</class>
    <class kind="class">DOM::Rect</class>
    <class kind="class">DOM::Counter</class>
    <class kind="class">DOM::EventListener</class>
    <class kind="class">DOM::Event</class>
    <class kind="class">DOM::EventException</class>
    <class kind="class">DOM::UIEvent</class>
    <class kind="class">DOM::MouseEvent</class>
    <class kind="class">DOM::TextEvent</class>
    <class kind="class">DOM::MutationEvent</class>
    <class kind="class">DOM::NodeIterator</class>
    <class kind="class">DOM::NodeFilter</class>
    <class kind="class">DOM::CustomNodeFilter</class>
    <class kind="class">DOM::TreeWalker</class>
    <class kind="class">DOM::AbstractView</class>
    <class kind="class">DOM::DOMImplementation</class>
    <class kind="class">DOM::Document</class>
    <class kind="class">DOM::DocumentFragment</class>
    <class kind="class">DOM::DocumentType</class>
    <class kind="class">DOM::Attr</class>
    <class kind="class">DOM::Element</class>
    <class kind="class">DOM::DOMException</class>
    <class kind="class">DOM::NamedNodeMap</class>
    <class kind="class">DOM::Node</class>
    <class kind="class">DOM::NodeList</class>
    <class kind="class">DOM::DOMString</class>
    <class kind="class">DOM::CharacterData</class>
    <class kind="class">DOM::Comment</class>
    <class kind="class">DOM::Text</class>
    <class kind="class">DOM::CDATASection</class>
    <class kind="class">DOM::Entity</class>
    <class kind="class">DOM::EntityReference</class>
    <class kind="class">DOM::Notation</class>
    <class kind="class">DOM::ProcessingInstruction</class>
    <class kind="class">DOM::HTMLBodyElement</class>
    <class kind="class">DOM::HTMLFrameElement</class>
    <class kind="class">DOM::HTMLFrameSetElement</class>
    <class kind="class">DOM::HTMLIFrameElement</class>
    <class kind="class">DOM::HTMLHeadElement</class>
    <class kind="class">DOM::HTMLHtmlElement</class>
    <class kind="class">DOM::HTMLBlockquoteElement</class>
    <class kind="class">DOM::HTMLDivElement</class>
    <class kind="class">DOM::HTMLHRElement</class>
    <class kind="class">DOM::HTMLHeadingElement</class>
    <class kind="class">DOM::HTMLParagraphElement</class>
    <class kind="class">DOM::HTMLPreElement</class>
    <class kind="class">DOM::HTMLDocument</class>
    <class kind="class">DOM::HTMLElement</class>
    <class kind="class">DOM::HTMLButtonElement</class>
    <class kind="class">DOM::HTMLFieldSetElement</class>
    <class kind="class">DOM::HTMLFormElement</class>
    <class kind="class">DOM::HTMLInputElement</class>
    <class kind="class">DOM::HTMLLabelElement</class>
    <class kind="class">DOM::HTMLLegendElement</class>
    <class kind="class">DOM::HTMLOptGroupElement</class>
    <class kind="class">DOM::HTMLSelectElement</class>
    <class kind="class">DOM::HTMLTextAreaElement</class>
    <class kind="class">DOM::HTMLOptionElement</class>
    <class kind="class">DOM::HTMLIsIndexElement</class>
    <class kind="class">DOM::HTMLBaseElement</class>
    <class kind="class">DOM::HTMLLinkElement</class>
    <class kind="class">DOM::HTMLMetaElement</class>
    <class kind="class">DOM::HTMLScriptElement</class>
    <class kind="class">DOM::HTMLStyleElement</class>
    <class kind="class">DOM::HTMLTitleElement</class>
    <class kind="class">DOM::HTMLAreaElement</class>
    <class kind="class">DOM::HTMLImageElement</class>
    <class kind="class">DOM::HTMLMapElement</class>
    <class kind="class">DOM::HTMLAnchorElement</class>
    <class kind="class">DOM::HTMLBRElement</class>
    <class kind="class">DOM::HTMLFontElement</class>
    <class kind="class">DOM::HTMLModElement</class>
    <class kind="class">DOM::HTMLQuoteElement</class>
    <class kind="class">DOM::HTMLDListElement</class>
    <class kind="class">DOM::HTMLDirectoryElement</class>
    <class kind="class">DOM::HTMLLIElement</class>
    <class kind="class">DOM::HTMLMenuElement</class>
    <class kind="class">DOM::HTMLOListElement</class>
    <class kind="class">DOM::HTMLUListElement</class>
    <class kind="class">DOM::HTMLBaseFontElement</class>
    <class kind="class">DOM::HTMLCollection</class>
    <class kind="class">DOM::HTMLAppletElement</class>
    <class kind="class">DOM::HTMLObjectElement</class>
    <class kind="class">DOM::HTMLParamElement</class>
    <class kind="class">DOM::HTMLTableCaptionElement</class>
    <class kind="class">DOM::HTMLTableCellElement</class>
    <class kind="class">DOM::HTMLTableColElement</class>
    <class kind="class">DOM::HTMLTableElement</class>
    <class kind="class">DOM::HTMLTableRowElement</class>
    <class kind="class">DOM::HTMLTableSectionElement</class>
    <member kind="typedef">
      <type>unsigned long long</type>
      <name>DOMTimeStamp</name>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>KDE_NO_EXPORT int</type>
      <name>getPropertyID</name>
      <anchor>a1</anchor>
      <arglist>(const char *tagStr, int len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>qString</name>
      <anchor>a2</anchor>
      <arglist>(const ParseString &amp;ps)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DOMString</type>
      <name>domString</name>
      <anchor>a3</anchor>
      <arglist>(const ParseString &amp;ps)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a4</anchor>
      <arglist>(kdbgstream &amp;stream, const DOMString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a5</anchor>
      <arglist>(const DOMString &amp;a, const DOMString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a6</anchor>
      <arglist>(const DOMString &amp;a, const QString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;a, const char *b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;a, const DOMString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;a, const QString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;a, const char *b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strcmp</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;a, const DOMString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strcasecmp</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;a, const DOMString &amp;b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strcasecmp</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;a, const char *b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2Azimuth</name>
    <filename>classDOM_1_1CSS2Azimuth.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2Azimuth</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2Azimuth &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2Azimuth</name>
      <anchor>a2</anchor>
      <arglist>(CSS2AzimuthImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2Azimuth &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2Azimuth &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>azimuthType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>identifier</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>behind</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAngleValue</name>
      <anchor>a8</anchor>
      <arglist>(const unsigned short unitType, const float floatValue)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAngleValue</name>
      <anchor>a9</anchor>
      <arglist>(const unsigned short unitType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIdentifier</name>
      <anchor>a10</anchor>
      <arglist>(const DOM::DOMString &amp;identifier, const bool behind)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2BackgroundPosition</name>
    <filename>classDOM_1_1CSS2BackgroundPosition.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2BackgroundPosition</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2BackgroundPosition &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2BackgroundPosition</name>
      <anchor>a2</anchor>
      <arglist>(CSS2BackgroundPositionImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2BackgroundPosition &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2BackgroundPosition &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>horizontalType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>verticalType</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>horizontalIdentifier</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>verticalIdentifier</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHorizontalPosition</name>
      <anchor>a9</anchor>
      <arglist>(const float horizontalType)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVerticalPosition</name>
      <anchor>a10</anchor>
      <arglist>(const float verticalType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHorizontalPosition</name>
      <anchor>a11</anchor>
      <arglist>(const unsigned short horizontalType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVerticalPosition</name>
      <anchor>a12</anchor>
      <arglist>(const unsigned short verticalType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositionIdentifier</name>
      <anchor>a13</anchor>
      <arglist>(const DOM::DOMString &amp;horizontalIdentifier, const DOM::DOMString &amp;verticalIdentifier)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2BorderSpacing</name>
    <filename>classDOM_1_1CSS2BorderSpacing.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2BorderSpacing</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2BorderSpacing &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2BorderSpacing</name>
      <anchor>a2</anchor>
      <arglist>(CSS2BorderSpacingImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2BorderSpacing &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2BorderSpacing &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>horizontalType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>verticalType</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHorizontalSpacing</name>
      <anchor>a7</anchor>
      <arglist>(const float horizontalType)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVerticalSpacing</name>
      <anchor>a8</anchor>
      <arglist>(const float verticalType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHorizontalSpacing</name>
      <anchor>a9</anchor>
      <arglist>(const unsigned short horizontalType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVerticalSpacing</name>
      <anchor>a10</anchor>
      <arglist>(const unsigned short verticalType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInherit</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2CounterIncrement</name>
    <filename>classDOM_1_1CSS2CounterIncrement.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2CounterIncrement</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2CounterIncrement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2CounterIncrement</name>
      <anchor>a2</anchor>
      <arglist>(CSS2CounterIncrementImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2CounterIncrement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2CounterIncrement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>identifier</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIdentifier</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>short</type>
      <name>increment</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIncrement</name>
      <anchor>a8</anchor>
      <arglist>(const short)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2CounterReset</name>
    <filename>classDOM_1_1CSS2CounterReset.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2CounterReset</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2CounterReset &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2CounterReset</name>
      <anchor>a2</anchor>
      <arglist>(CSS2CounterResetImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2CounterReset &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2CounterReset &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>identifier</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIdentifier</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>short</type>
      <name>reset</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReset</name>
      <anchor>a8</anchor>
      <arglist>(const short)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2Cursor</name>
    <filename>classDOM_1_1CSS2Cursor.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2Cursor</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2Cursor &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2Cursor</name>
      <anchor>a2</anchor>
      <arglist>(CSS2CursorImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2Cursor &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2Cursor &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>cursorType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCursorType</name>
      <anchor>a6</anchor>
      <arglist>(const unsigned short)</arglist>
    </member>
    <member kind="function">
      <type>CSSValueList</type>
      <name>uris</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>predefinedCursor</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPredefinedCursor</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2FontFaceSrc</name>
    <filename>classDOM_1_1CSS2FontFaceSrc.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2FontFaceSrc</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2FontFaceSrc &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2FontFaceSrc</name>
      <anchor>a2</anchor>
      <arglist>(CSS2FontFaceSrcImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2FontFaceSrc &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2FontFaceSrc &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>uri</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUri</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CSSValueList</type>
      <name>format</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontFaceName</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontFaceName</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2FontFaceWidths</name>
    <filename>classDOM_1_1CSS2FontFaceWidths.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2FontFaceWidths</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2FontFaceWidths &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2FontFaceWidths</name>
      <anchor>a2</anchor>
      <arglist>(CSS2FontFaceWidthsImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2FontFaceWidths &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2FontFaceWidths &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>urange</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUrange</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CSSValueList</type>
      <name>numbers</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2PageSize</name>
    <filename>classDOM_1_1CSS2PageSize.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2PageSize</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2PageSize &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2PageSize</name>
      <anchor>a2</anchor>
      <arglist>(CSS2PageSizeImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2PageSize &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2PageSize &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>widthType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>heightType</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>identifier</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getWidth</name>
      <anchor>a8</anchor>
      <arglist>(const float widthType)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHeightSize</name>
      <anchor>a9</anchor>
      <arglist>(const float heightType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidthSize</name>
      <anchor>a10</anchor>
      <arglist>(const unsigned short widthType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeightSize</name>
      <anchor>a11</anchor>
      <arglist>(const unsigned short heightType, const float value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIdentifier</name>
      <anchor>a12</anchor>
      <arglist>(const DOM::DOMString &amp;identifier)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2PlayDuring</name>
    <filename>classDOM_1_1CSS2PlayDuring.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSS2PlayDuring</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2PlayDuring &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2PlayDuring</name>
      <anchor>a2</anchor>
      <arglist>(CSS2PlayDuringImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2PlayDuring &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2PlayDuring &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>playDuringType</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>playDuringIdentifier</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlayDuringIdentifier</name>
      <anchor>a7</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>uri</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUri</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mix</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMix</name>
      <anchor>a11</anchor>
      <arglist>(const bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>repeat</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeat</name>
      <anchor>a13</anchor>
      <arglist>(const bool)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2Properties</name>
    <filename>classDOM_1_1CSS2Properties.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2Properties</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2Properties &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2Properties</name>
      <anchor>a2</anchor>
      <arglist>(CSS2PropertiesImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2Properties &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2Properties &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>azimuth</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAzimuth</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>background</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackground</name>
      <anchor>a8</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>backgroundAttachment</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundAttachment</name>
      <anchor>a10</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>backgroundColor</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundColor</name>
      <anchor>a12</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>backgroundImage</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundImage</name>
      <anchor>a14</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>backgroundPosition</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundPosition</name>
      <anchor>a16</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>backgroundRepeat</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundRepeat</name>
      <anchor>a18</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>border</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a20</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderCollapse</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderCollapse</name>
      <anchor>a22</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderColor</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderColor</name>
      <anchor>a24</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderSpacing</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderSpacing</name>
      <anchor>a26</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderStyle</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderStyle</name>
      <anchor>a28</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderTop</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderTop</name>
      <anchor>a30</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderRight</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderRight</name>
      <anchor>a32</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderBottom</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderBottom</name>
      <anchor>a34</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderLeft</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderLeft</name>
      <anchor>a36</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderTopColor</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderTopColor</name>
      <anchor>a38</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderRightColor</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderRightColor</name>
      <anchor>a40</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderBottomColor</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderBottomColor</name>
      <anchor>a42</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderLeftColor</name>
      <anchor>a43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderLeftColor</name>
      <anchor>a44</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderTopStyle</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderTopStyle</name>
      <anchor>a46</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderRightStyle</name>
      <anchor>a47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderRightStyle</name>
      <anchor>a48</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderBottomStyle</name>
      <anchor>a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderBottomStyle</name>
      <anchor>a50</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderLeftStyle</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderLeftStyle</name>
      <anchor>a52</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderTopWidth</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderTopWidth</name>
      <anchor>a54</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderRightWidth</name>
      <anchor>a55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderRightWidth</name>
      <anchor>a56</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderBottomWidth</name>
      <anchor>a57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderBottomWidth</name>
      <anchor>a58</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderLeftWidth</name>
      <anchor>a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderLeftWidth</name>
      <anchor>a60</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>borderWidth</name>
      <anchor>a61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorderWidth</name>
      <anchor>a62</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>bottom</name>
      <anchor>a63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBottom</name>
      <anchor>a64</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>captionSide</name>
      <anchor>a65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCaptionSide</name>
      <anchor>a66</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>clear</name>
      <anchor>a67</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClear</name>
      <anchor>a68</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>clip</name>
      <anchor>a69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClip</name>
      <anchor>a70</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>color</name>
      <anchor>a71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a72</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>content</name>
      <anchor>a73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContent</name>
      <anchor>a74</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>counterIncrement</name>
      <anchor>a75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCounterIncrement</name>
      <anchor>a76</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>counterReset</name>
      <anchor>a77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCounterReset</name>
      <anchor>a78</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cue</name>
      <anchor>a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCue</name>
      <anchor>a80</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cueAfter</name>
      <anchor>a81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCueAfter</name>
      <anchor>a82</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cueBefore</name>
      <anchor>a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCueBefore</name>
      <anchor>a84</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cursor</name>
      <anchor>a85</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCursor</name>
      <anchor>a86</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>direction</name>
      <anchor>a87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDirection</name>
      <anchor>a88</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>display</name>
      <anchor>a89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisplay</name>
      <anchor>a90</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>elevation</name>
      <anchor>a91</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setElevation</name>
      <anchor>a92</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>emptyCells</name>
      <anchor>a93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEmptyCells</name>
      <anchor>a94</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cssFloat</name>
      <anchor>a95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCssFloat</name>
      <anchor>a96</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>font</name>
      <anchor>a97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFont</name>
      <anchor>a98</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontFamily</name>
      <anchor>a99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontFamily</name>
      <anchor>a100</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontSize</name>
      <anchor>a101</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontSize</name>
      <anchor>a102</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontSizeAdjust</name>
      <anchor>a103</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontSizeAdjust</name>
      <anchor>a104</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontStretch</name>
      <anchor>a105</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontStretch</name>
      <anchor>a106</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontStyle</name>
      <anchor>a107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontStyle</name>
      <anchor>a108</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontVariant</name>
      <anchor>a109</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontVariant</name>
      <anchor>a110</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>fontWeight</name>
      <anchor>a111</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontWeight</name>
      <anchor>a112</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>height</name>
      <anchor>a113</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a114</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>left</name>
      <anchor>a115</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLeft</name>
      <anchor>a116</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>letterSpacing</name>
      <anchor>a117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLetterSpacing</name>
      <anchor>a118</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>lineHeight</name>
      <anchor>a119</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLineHeight</name>
      <anchor>a120</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>listStyle</name>
      <anchor>a121</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setListStyle</name>
      <anchor>a122</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>listStyleImage</name>
      <anchor>a123</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setListStyleImage</name>
      <anchor>a124</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>listStylePosition</name>
      <anchor>a125</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setListStylePosition</name>
      <anchor>a126</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>listStyleType</name>
      <anchor>a127</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setListStyleType</name>
      <anchor>a128</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>margin</name>
      <anchor>a129</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMargin</name>
      <anchor>a130</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>marginTop</name>
      <anchor>a131</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginTop</name>
      <anchor>a132</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>marginRight</name>
      <anchor>a133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginRight</name>
      <anchor>a134</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>marginBottom</name>
      <anchor>a135</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginBottom</name>
      <anchor>a136</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>marginLeft</name>
      <anchor>a137</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginLeft</name>
      <anchor>a138</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>markerOffset</name>
      <anchor>a139</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarkerOffset</name>
      <anchor>a140</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>marks</name>
      <anchor>a141</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarks</name>
      <anchor>a142</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>maxHeight</name>
      <anchor>a143</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxHeight</name>
      <anchor>a144</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>maxWidth</name>
      <anchor>a145</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxWidth</name>
      <anchor>a146</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>minHeight</name>
      <anchor>a147</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinHeight</name>
      <anchor>a148</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>minWidth</name>
      <anchor>a149</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinWidth</name>
      <anchor>a150</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>orphans</name>
      <anchor>a151</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrphans</name>
      <anchor>a152</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>outline</name>
      <anchor>a153</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutline</name>
      <anchor>a154</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>outlineColor</name>
      <anchor>a155</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutlineColor</name>
      <anchor>a156</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>outlineStyle</name>
      <anchor>a157</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutlineStyle</name>
      <anchor>a158</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>outlineWidth</name>
      <anchor>a159</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutlineWidth</name>
      <anchor>a160</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>overflow</name>
      <anchor>a161</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOverflow</name>
      <anchor>a162</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>padding</name>
      <anchor>a163</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPadding</name>
      <anchor>a164</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>paddingTop</name>
      <anchor>a165</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPaddingTop</name>
      <anchor>a166</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>paddingRight</name>
      <anchor>a167</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPaddingRight</name>
      <anchor>a168</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>paddingBottom</name>
      <anchor>a169</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPaddingBottom</name>
      <anchor>a170</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>paddingLeft</name>
      <anchor>a171</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPaddingLeft</name>
      <anchor>a172</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>page</name>
      <anchor>a173</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPage</name>
      <anchor>a174</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pageBreakAfter</name>
      <anchor>a175</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPageBreakAfter</name>
      <anchor>a176</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pageBreakBefore</name>
      <anchor>a177</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPageBreakBefore</name>
      <anchor>a178</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pageBreakInside</name>
      <anchor>a179</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPageBreakInside</name>
      <anchor>a180</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pause</name>
      <anchor>a181</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPause</name>
      <anchor>a182</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pauseAfter</name>
      <anchor>a183</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPauseAfter</name>
      <anchor>a184</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pauseBefore</name>
      <anchor>a185</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPauseBefore</name>
      <anchor>a186</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pitch</name>
      <anchor>a187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPitch</name>
      <anchor>a188</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>pitchRange</name>
      <anchor>a189</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPitchRange</name>
      <anchor>a190</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>playDuring</name>
      <anchor>a191</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlayDuring</name>
      <anchor>a192</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>position</name>
      <anchor>a193</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a194</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>quotes</name>
      <anchor>a195</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setQuotes</name>
      <anchor>a196</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>richness</name>
      <anchor>a197</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRichness</name>
      <anchor>a198</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>right</name>
      <anchor>a199</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRight</name>
      <anchor>a200</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>size</name>
      <anchor>a201</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a202</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>speak</name>
      <anchor>a203</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpeak</name>
      <anchor>a204</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>speakHeader</name>
      <anchor>a205</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpeakHeader</name>
      <anchor>a206</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>speakNumeral</name>
      <anchor>a207</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpeakNumeral</name>
      <anchor>a208</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>speakPunctuation</name>
      <anchor>a209</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpeakPunctuation</name>
      <anchor>a210</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>speechRate</name>
      <anchor>a211</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpeechRate</name>
      <anchor>a212</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>stress</name>
      <anchor>a213</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStress</name>
      <anchor>a214</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>tableLayout</name>
      <anchor>a215</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTableLayout</name>
      <anchor>a216</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>textAlign</name>
      <anchor>a217</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextAlign</name>
      <anchor>a218</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>textDecoration</name>
      <anchor>a219</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextDecoration</name>
      <anchor>a220</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>textIndent</name>
      <anchor>a221</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextIndent</name>
      <anchor>a222</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>textShadow</name>
      <anchor>a223</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextShadow</name>
      <anchor>a224</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>textTransform</name>
      <anchor>a225</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextTransform</name>
      <anchor>a226</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>top</name>
      <anchor>a227</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTop</name>
      <anchor>a228</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>unicodeBidi</name>
      <anchor>a229</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUnicodeBidi</name>
      <anchor>a230</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>verticalAlign</name>
      <anchor>a231</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVerticalAlign</name>
      <anchor>a232</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>visibility</name>
      <anchor>a233</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisibility</name>
      <anchor>a234</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>voiceFamily</name>
      <anchor>a235</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVoiceFamily</name>
      <anchor>a236</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>volume</name>
      <anchor>a237</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVolume</name>
      <anchor>a238</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>whiteSpace</name>
      <anchor>a239</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWhiteSpace</name>
      <anchor>a240</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>widows</name>
      <anchor>a241</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidows</name>
      <anchor>a242</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>width</name>
      <anchor>a243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a244</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>wordSpacing</name>
      <anchor>a245</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWordSpacing</name>
      <anchor>a246</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>zIndex</name>
      <anchor>a247</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setZIndex</name>
      <anchor>a248</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSS2TextShadow</name>
    <filename>classDOM_1_1CSS2TextShadow.html</filename>
    <member kind="function">
      <type></type>
      <name>CSS2TextShadow</name>
      <anchor>a1</anchor>
      <arglist>(const CSS2TextShadow &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSS2TextShadow</name>
      <anchor>a2</anchor>
      <arglist>(CSS2TextShadowImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSS2TextShadow &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSS2TextShadow &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>color</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>horizontal</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>vertical</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>blur</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSRule</name>
    <filename>classDOM_1_1CSSRule.html</filename>
    <member kind="enumeration">
      <name>RuleType</name>
      <anchor>w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSRule</name>
      <anchor>a2</anchor>
      <arglist>(CSSRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSRule &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>type</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cssText</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCssText</name>
      <anchor>a7</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleSheet</type>
      <name>parentStyleSheet</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRule</type>
      <name>parentRule</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRuleImpl *</type>
      <name>handle</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>assignOther</name>
      <anchor>b0</anchor>
      <arglist>(const CSSRule &amp;other, RuleType thisType)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSRuleImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSCharsetRule</name>
    <filename>classDOM_1_1CSSCharsetRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSCharsetRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSCharsetRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSCharsetRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSCharsetRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSCharsetRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSCharsetRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSCharsetRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSCharsetRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>encoding</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEncoding</name>
      <anchor>a8</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSFontFaceRule</name>
    <filename>classDOM_1_1CSSFontFaceRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSFontFaceRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSFontFaceRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSFontFaceRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSFontFaceRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSFontFaceRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSFontFaceRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSFontFaceRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSFontFaceRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration</type>
      <name>style</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSImportRule</name>
    <filename>classDOM_1_1CSSImportRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSImportRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSImportRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSImportRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSImportRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSImportRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSImportRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSImportRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSImportRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>href</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MediaList</type>
      <name>media</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSStyleSheet</type>
      <name>styleSheet</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSMediaRule</name>
    <filename>classDOM_1_1CSSMediaRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSMediaRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSMediaRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSMediaRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSMediaRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSMediaRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSMediaRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSMediaRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSMediaRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>MediaList</type>
      <name>media</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRuleList</type>
      <name>cssRules</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>insertRule</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;rule, unsigned long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteRule</name>
      <anchor>a10</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSStyleRule</name>
    <filename>classDOM_1_1CSSStyleRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSStyleRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSStyleRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSStyleRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSStyleRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>selectorText</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectorText</name>
      <anchor>a8</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration</type>
      <name>style</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSUnknownRule</name>
    <filename>classDOM_1_1CSSUnknownRule.html</filename>
    <base>DOM::CSSRule</base>
    <member kind="function">
      <type></type>
      <name>CSSUnknownRule</name>
      <anchor>a1</anchor>
      <arglist>(const CSSUnknownRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSUnknownRule</name>
      <anchor>a2</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSUnknownRule</name>
      <anchor>a3</anchor>
      <arglist>(CSSUnknownRuleImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSUnknownRule &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSUnknownRule &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSUnknownRule &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSRule &amp;other)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSRuleList</name>
    <filename>classDOM_1_1CSSRuleList.html</filename>
    <member kind="function">
      <type></type>
      <name>CSSRuleList</name>
      <anchor>a1</anchor>
      <arglist>(const CSSRuleList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSRuleList</name>
      <anchor>a2</anchor>
      <arglist>(CSSRuleListImpl *i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSRuleList</name>
      <anchor>a3</anchor>
      <arglist>(StyleListImpl *i)</arglist>
    </member>
    <member kind="function">
      <type>CSSRuleList &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSRuleList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRule</type>
      <name>item</name>
      <anchor>a7</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
    <member kind="function">
      <type>CSSRuleListImpl *</type>
      <name>handle</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSRuleListImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::StyleSheet</name>
    <filename>classDOM_1_1StyleSheet.html</filename>
    <member kind="function">
      <type></type>
      <name>StyleSheet</name>
      <anchor>a1</anchor>
      <arglist>(const StyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>StyleSheet</name>
      <anchor>a2</anchor>
      <arglist>(StyleSheetImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheet &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const StyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>type</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOM::Node</type>
      <name>ownerNode</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>StyleSheet</type>
      <name>parentStyleSheet</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>href</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>title</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>MediaList</type>
      <name>media</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCSSStyleSheet</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>StyleSheetImpl *</type>
      <name>handle</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>StyleSheetImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSException</name>
    <filename>classDOM_1_1CSSException.html</filename>
    <member kind="function">
      <type></type>
      <name>CSSException</name>
      <anchor>a0</anchor>
      <arglist>(unsigned short _code)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSException</name>
      <anchor>a1</anchor>
      <arglist>(const CSSException &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSException &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const CSSException &amp;other)</arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>code</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSStyleSheet</name>
    <filename>classDOM_1_1CSSStyleSheet.html</filename>
    <base>DOM::StyleSheet</base>
    <member kind="function">
      <type></type>
      <name>CSSStyleSheet</name>
      <anchor>a1</anchor>
      <arglist>(const CSSStyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleSheet</name>
      <anchor>a2</anchor>
      <arglist>(const StyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleSheet</name>
      <anchor>a3</anchor>
      <arglist>(CSSStyleSheetImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleSheet &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSStyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleSheet &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const StyleSheet &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSRule</type>
      <name>ownerRule</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRuleList</type>
      <name>cssRules</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>insertRule</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;rule, unsigned long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteRule</name>
      <anchor>a10</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::StyleSheetList</name>
    <filename>classDOM_1_1StyleSheetList.html</filename>
    <member kind="function">
      <type></type>
      <name>StyleSheetList</name>
      <anchor>a1</anchor>
      <arglist>(const StyleSheetList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>StyleSheetList</name>
      <anchor>a2</anchor>
      <arglist>(StyleSheetListImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheetList &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const StyleSheetList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>StyleSheet</type>
      <name>item</name>
      <anchor>a6</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheetListImpl *</type>
      <name>handle</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>StyleSheetListImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::MediaList</name>
    <filename>classDOM_1_1MediaList.html</filename>
    <member kind="function">
      <type></type>
      <name>MediaList</name>
      <anchor>a1</anchor>
      <arglist>(const MediaList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MediaList</name>
      <anchor>a2</anchor>
      <arglist>(MediaListImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>MediaList &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const MediaList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>mediaText</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMediaText</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>item</name>
      <anchor>a8</anchor>
      <arglist>(unsigned long index) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteMedium</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;oldMedium)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>appendMedium</name>
      <anchor>a10</anchor>
      <arglist>(const DOM::DOMString &amp;newMedium)</arglist>
    </member>
    <member kind="function">
      <type>MediaListImpl *</type>
      <name>handle</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MediaListImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSStyleDeclaration</name>
    <filename>classDOM_1_1CSSStyleDeclaration.html</filename>
    <member kind="function">
      <type></type>
      <name>CSSStyleDeclaration</name>
      <anchor>a1</anchor>
      <arglist>(const CSSStyleDeclaration &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleDeclaration</name>
      <anchor>a2</anchor>
      <arglist>(CSSStyleDeclarationImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSSStyleDeclaration &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cssText</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCssText</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSRule</type>
      <name>parentRule</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>getPropertyValue</name>
      <anchor>a9</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>getPropertyValue</name>
      <anchor>a10</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName)</arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>getPropertyCSSValue</name>
      <anchor>a11</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>getPropertyCSSValue</name>
      <anchor>a12</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>removeProperty</name>
      <anchor>a13</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>getPropertyPriority</name>
      <anchor>a14</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName) const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>getPropertyPriority</name>
      <anchor>a15</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a16</anchor>
      <arglist>(const DOM::DOMString &amp;propertyName, const DOM::DOMString &amp;value, const DOM::DOMString &amp;priority)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>item</name>
      <anchor>a17</anchor>
      <arglist>(unsigned long index) const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>item</name>
      <anchor>a18</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclarationImpl *</type>
      <name>handle</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleDeclarationImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSValue</name>
    <filename>classDOM_1_1CSSValue.html</filename>
    <member kind="enumeration">
      <name>UnitTypes</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSValue</name>
      <anchor>a1</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSValue</name>
      <anchor>a2</anchor>
      <arglist>(CSSValueImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSValue &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>cssText</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCssText</name>
      <anchor>a6</anchor>
      <arglist>(const DOM::DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>cssValueType</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCSSValueList</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCSSPrimitiveValue</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSValueImpl *</type>
      <name>handle</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSValueImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSValueList</name>
    <filename>classDOM_1_1CSSValueList.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="function">
      <type></type>
      <name>CSSValueList</name>
      <anchor>a1</anchor>
      <arglist>(const CSSValueList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSValueList</name>
      <anchor>a2</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSValueList</name>
      <anchor>a3</anchor>
      <arglist>(CSSValueListImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSValueList &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSValueList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSValueList &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSValue</type>
      <name>item</name>
      <anchor>a8</anchor>
      <arglist>(unsigned long index)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSValueListImpl *</type>
      <name>vimpl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CSSPrimitiveValue</name>
    <filename>classDOM_1_1CSSPrimitiveValue.html</filename>
    <base>DOM::CSSValue</base>
    <member kind="enumeration">
      <name>UnitTypes</name>
      <anchor>w27</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSPrimitiveValue</name>
      <anchor>a1</anchor>
      <arglist>(const CSSPrimitiveValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSPrimitiveValue</name>
      <anchor>a2</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSPrimitiveValue</name>
      <anchor>a3</anchor>
      <arglist>(CSSPrimitiveValueImpl *impl)</arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CSSPrimitiveValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const CSSValue &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>primitiveType</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFloatValue</name>
      <anchor>a8</anchor>
      <arglist>(unsigned short unitType, float floatValue)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getFloatValue</name>
      <anchor>a9</anchor>
      <arglist>(unsigned short unitType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStringValue</name>
      <anchor>a10</anchor>
      <arglist>(unsigned short stringType, const DOM::DOMString &amp;stringValue)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>getStringValue</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Counter</type>
      <name>getCounterValue</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Rect</type>
      <name>getRectValue</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RGBColor</type>
      <name>getRGBColorValue</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::RGBColor</name>
    <filename>classDOM_1_1RGBColor.html</filename>
    <member kind="function">
      <type></type>
      <name>RGBColor</name>
      <anchor>a1</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RGBColor</name>
      <anchor>a2</anchor>
      <arglist>(QRgb color)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>RGBColor</name>
      <anchor>a3</anchor>
      <arglist>(const RGBColor &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>RGBColor &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const RGBColor &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>red</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>green</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>blue</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRgb</type>
      <name>color</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRgb</type>
      <name>m_color</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Rect</name>
    <filename>classDOM_1_1Rect.html</filename>
    <member kind="function">
      <type></type>
      <name>Rect</name>
      <anchor>a1</anchor>
      <arglist>(const Rect &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Rect &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const Rect &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>top</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>right</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>bottom</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSPrimitiveValue</type>
      <name>left</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RectImpl *</type>
      <name>handle</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Rect</name>
      <anchor>b0</anchor>
      <arglist>(RectImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RectImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>CSSPrimitiveValue</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Counter</name>
    <filename>classDOM_1_1Counter.html</filename>
    <member kind="function">
      <type></type>
      <name>Counter</name>
      <anchor>a1</anchor>
      <arglist>(const Counter &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Counter &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const Counter &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>identifier</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>listStyle</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::DOMString</type>
      <name>separator</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CounterImpl *</type>
      <name>handle</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Counter</name>
      <anchor>b0</anchor>
      <arglist>(CounterImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CounterImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>CSSPrimitiveValue</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::EventListener</name>
    <filename>classDOM_1_1EventListener.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchor>a2</anchor>
      <arglist>(Event &amp;evt)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual DOMString</type>
      <name>eventListenerType</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>EventListenerImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Event</name>
    <filename>classDOM_1_1Event.html</filename>
    <member kind="enumeration">
      <name>PhaseType</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Event</name>
      <anchor>a1</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Event &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>target</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>currentTarget</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>eventPhase</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bubbles</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cancelable</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMTimeStamp</type>
      <name>timeStamp</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stopPropagation</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preventDefault</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initEvent</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;eventTypeArg, bool canBubbleArg, bool cancelableArg)</arglist>
    </member>
    <member kind="function">
      <type>EventImpl *</type>
      <name>handle</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>eventModuleName</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Event</name>
      <anchor>b0</anchor>
      <arglist>(EventImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>EventImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DocumentImpl</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::Image</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::EventException</name>
    <filename>classDOM_1_1EventException.html</filename>
    <member kind="enumeration">
      <name>EventExceptionCode</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EventException</name>
      <anchor>a0</anchor>
      <arglist>(unsigned short _code)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EventException</name>
      <anchor>a1</anchor>
      <arglist>(const EventException &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>EventException &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const EventException &amp;other)</arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>code</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::UIEvent</name>
    <filename>classDOM_1_1UIEvent.html</filename>
    <base>DOM::Event</base>
    <member kind="function">
      <type></type>
      <name>UIEvent</name>
      <anchor>a1</anchor>
      <arglist>(const UIEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UIEvent</name>
      <anchor>a2</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>UIEvent &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const UIEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>UIEvent &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>AbstractView</type>
      <name>view</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>detail</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCode</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>layerX</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>layerY</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>which</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initUIEvent</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;typeArg, bool canBubbleArg, bool cancelableArg, const AbstractView &amp;viewArg, long detailArg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>UIEvent</name>
      <anchor>b0</anchor>
      <arglist>(UIEventImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::MouseEvent</name>
    <filename>classDOM_1_1MouseEvent.html</filename>
    <base>DOM::UIEvent</base>
    <member kind="function">
      <type></type>
      <name>MouseEvent</name>
      <anchor>a1</anchor>
      <arglist>(const MouseEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MouseEvent</name>
      <anchor>a2</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>MouseEvent &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const MouseEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>MouseEvent &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>screenX</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>screenY</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>clientX</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>clientY</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ctrlKey</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>shiftKey</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>altKey</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>metaKey</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>button</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>relatedTarget</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initMouseEvent</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;typeArg, bool canBubbleArg, bool cancelableArg, const AbstractView &amp;viewArg, long detailArg, long screenXArg, long screenYArg, long clientXArg, long clientYArg, bool ctrlKeyArg, bool altKeyArg, bool shiftKeyArg, bool metaKeyArg, unsigned short buttonArg, const Node &amp;relatedTargetArg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>MouseEvent</name>
      <anchor>b0</anchor>
      <arglist>(MouseEventImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::TextEvent</name>
    <filename>classDOM_1_1TextEvent.html</filename>
    <base>DOM::UIEvent</base>
    <member kind="function">
      <type></type>
      <name>TextEvent</name>
      <anchor>a1</anchor>
      <arglist>(const TextEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TextEvent</name>
      <anchor>a2</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>TextEvent &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const TextEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>TextEvent &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initTextEvent</name>
      <anchor>a6</anchor>
      <arglist>(const DOMString &amp;typeArg, bool canBubbleArg, bool cancelableArg, const AbstractView &amp;viewArg, long detailArg, const DOMString &amp;outputStringArg, unsigned long keyValArg, unsigned long virtKeyValArg, bool inputGeneratedArg, bool numPadArg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initModifier</name>
      <anchor>a7</anchor>
      <arglist>(unsigned long modifierArg, bool valueArg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>inputGenerated</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>keyVal</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>numPad</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>outputString</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>virtKeyVal</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkModifier</name>
      <anchor>a13</anchor>
      <arglist>(unsigned long modiferArg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>TextEvent</name>
      <anchor>b0</anchor>
      <arglist>(TextEventImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::MutationEvent</name>
    <filename>classDOM_1_1MutationEvent.html</filename>
    <base>DOM::Event</base>
    <member kind="enumeration">
      <name>attrChangeType</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MutationEvent</name>
      <anchor>a1</anchor>
      <arglist>(const MutationEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MutationEvent</name>
      <anchor>a2</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>MutationEvent &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const MutationEvent &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>MutationEvent &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Event &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>relatedNode</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>prevValue</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>newValue</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>attrName</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>attrChange</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initMutationEvent</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;typeArg, bool canBubbleArg, bool cancelableArg, const Node &amp;relatedNodeArg, const DOMString &amp;prevValueArg, const DOMString &amp;newValueArg, const DOMString &amp;attrNameArg, unsigned short attrChangeArg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>MutationEvent</name>
      <anchor>b0</anchor>
      <arglist>(MutationEventImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::NodeIterator</name>
    <filename>classDOM_1_1NodeIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>NodeIterator</name>
      <anchor>a1</anchor>
      <arglist>(const NodeIterator &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>NodeIterator &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const NodeIterator &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>root</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>whatToShow</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeFilter</type>
      <name>filter</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>expandEntityReferences</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>previousNode</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>detach</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeIteratorImpl *</type>
      <name>handle</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>NodeIterator</name>
      <anchor>b0</anchor>
      <arglist>(NodeIteratorImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>NodeIteratorImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeIteratorImpl</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::NodeFilter</name>
    <filename>classDOM_1_1NodeFilter.html</filename>
    <member kind="enumeration">
      <name>AcceptCode</name>
      <anchor>w16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ShowCode</name>
      <anchor>w17</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>NodeFilter</name>
      <anchor>a1</anchor>
      <arglist>(const NodeFilter &amp;other)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual NodeFilter &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const NodeFilter &amp;other)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual short</type>
      <name>acceptNode</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;n)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual NodeFilterImpl *</type>
      <name>handle</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isNull</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomNodeFilter</name>
      <anchor>a7</anchor>
      <arglist>(CustomNodeFilter *custom)</arglist>
    </member>
    <member kind="function">
      <type>CustomNodeFilter *</type>
      <name>customNodeFilter</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>NodeFilter</type>
      <name>createCustom</name>
      <anchor>e0</anchor>
      <arglist>(CustomNodeFilter *custom)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>NodeFilter</name>
      <anchor>b0</anchor>
      <arglist>(NodeFilterImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>NodeFilterImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeIterator</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeIteratorImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TreeWalker</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TreeWalkerImpl</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeFilterImpl</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CustomNodeFilter</name>
    <filename>classDOM_1_1CustomNodeFilter.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual short</type>
      <name>acceptNode</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;n)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isNull</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual DOMString</type>
      <name>customNodeFilterType</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CustomNodeFilterImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::TreeWalker</name>
    <filename>classDOM_1_1TreeWalker.html</filename>
    <member kind="function">
      <type></type>
      <name>TreeWalker</name>
      <anchor>a1</anchor>
      <arglist>(const TreeWalker &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>TreeWalker &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const TreeWalker &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>root</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>whatToShow</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeFilter</type>
      <name>filter</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>expandEntityReferences</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>currentNode</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentNode</name>
      <anchor>a9</anchor>
      <arglist>(const Node _currentNode)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>parentNode</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>firstChild</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>lastChild</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>previousSibling</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextSibling</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>previousNode</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNode</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TreeWalkerImpl *</type>
      <name>handle</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>TreeWalker</name>
      <anchor>b0</anchor>
      <arglist>(TreeWalkerImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>TreeWalkerImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TreeWalkerImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::AbstractView</name>
    <filename>classDOM_1_1AbstractView.html</filename>
    <member kind="function">
      <type></type>
      <name>AbstractView</name>
      <anchor>a1</anchor>
      <arglist>(const AbstractView &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>AbstractView &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const AbstractView &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>document</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration</type>
      <name>getComputedStyle</name>
      <anchor>a5</anchor>
      <arglist>(const Element &amp;elt, const DOMString &amp;pseudoElt)</arglist>
    </member>
    <member kind="function">
      <type>AbstractViewImpl *</type>
      <name>handle</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>AbstractView</name>
      <anchor>b0</anchor>
      <arglist>(AbstractViewImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>AbstractViewImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Event</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>UIEvent</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>MouseEvent</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>MutationEvent</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::DOMImplementation</name>
    <filename>classDOM_1_1DOMImplementation.html</filename>
    <member kind="function">
      <type></type>
      <name>DOMImplementation</name>
      <anchor>a1</anchor>
      <arglist>(const DOMImplementation &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMImplementation &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const DOMImplementation &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasFeature</name>
      <anchor>a4</anchor>
      <arglist>(const DOMString &amp;feature, const DOMString &amp;version)</arglist>
    </member>
    <member kind="function">
      <type>DocumentType</type>
      <name>createDocumentType</name>
      <anchor>a5</anchor>
      <arglist>(const DOMString &amp;qualifiedName, const DOMString &amp;publicId, const DOMString &amp;systemId)</arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>createDocument</name>
      <anchor>a6</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;qualifiedName, const DocumentType &amp;doctype)</arglist>
    </member>
    <member kind="function">
      <type>DOMImplementation</type>
      <name>getInterface</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;feature) const </arglist>
    </member>
    <member kind="function">
      <type>CSSStyleSheet</type>
      <name>createCSSStyleSheet</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;title, const DOMString &amp;media)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDocument</type>
      <name>createHTMLDocument</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>DOMImplementationImpl *</type>
      <name>handle</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>DOMImplementation</name>
      <anchor>b0</anchor>
      <arglist>(DOMImplementationImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOMImplementationImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Document</name>
    <filename>classDOM_1_1Document.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchor>a1</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchor>a2</anchor>
      <arglist>(const Document &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Document &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Document &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const Document &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DocumentType</type>
      <name>doctype</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMImplementation</type>
      <name>implementation</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>documentElement</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>createElement</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;tagName)</arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>createElementNS</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;qualifiedName)</arglist>
    </member>
    <member kind="function">
      <type>DocumentFragment</type>
      <name>createDocumentFragment</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Text</type>
      <name>createTextNode</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Comment</type>
      <name>createComment</name>
      <anchor>a14</anchor>
      <arglist>(const DOMString &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>CDATASection</type>
      <name>createCDATASection</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>ProcessingInstruction</type>
      <name>createProcessingInstruction</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;target, const DOMString &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>createAttribute</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>createAttributeNS</name>
      <anchor>a18</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;qualifiedName)</arglist>
    </member>
    <member kind="function">
      <type>EntityReference</type>
      <name>createEntityReference</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>getElementById</name>
      <anchor>a20</anchor>
      <arglist>(const DOMString &amp;elementId) const </arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>getElementsByTagName</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;tagname)</arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>getElementsByTagNameNS</name>
      <anchor>a22</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>importNode</name>
      <anchor>a23</anchor>
      <arglist>(const Node &amp;importedNode, bool deep)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHTMLDocument</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Range</type>
      <name>createRange</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>NodeIterator</type>
      <name>createNodeIterator</name>
      <anchor>a26</anchor>
      <arglist>(Node root, unsigned long whatToShow, NodeFilter filter, bool entityReferenceExpansion)</arglist>
    </member>
    <member kind="function">
      <type>TreeWalker</type>
      <name>createTreeWalker</name>
      <anchor>a27</anchor>
      <arglist>(Node root, unsigned long whatToShow, NodeFilter filter, bool entityReferenceExpansion)</arglist>
    </member>
    <member kind="function">
      <type>Event</type>
      <name>createEvent</name>
      <anchor>a28</anchor>
      <arglist>(const DOMString &amp;eventType)</arglist>
    </member>
    <member kind="function">
      <type>AbstractView</type>
      <name>defaultView</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>StyleSheetList</type>
      <name>styleSheets</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>preferredStylesheetSet</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>selectedStylesheetSet</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectedStylesheetSet</name>
      <anchor>a33</anchor>
      <arglist>(const DOMString &amp;aString)</arglist>
    </member>
    <member kind="function">
      <type>KHTMLView *</type>
      <name>view</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration</type>
      <name>getOverrideStyle</name>
      <anchor>a35</anchor>
      <arglist>(const Element &amp;elt, const DOMString &amp;pseudoElt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>async</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAsync</name>
      <anchor>a37</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>abort</name>
      <anchor>a38</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load</name>
      <anchor>a39</anchor>
      <arglist>(const DOMString &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadXML</name>
      <anchor>a40</anchor>
      <arglist>(const DOMString &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>designMode</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDesignMode</name>
      <anchor>a42</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>completeURL</name>
      <anchor>a43</anchor>
      <arglist>(const DOMString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateRendering</name>
      <anchor>a44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Document</name>
      <anchor>b0</anchor>
      <arglist>(DocumentImpl *i)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>::KHTMLView</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>::KHTMLPart</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>AbstractView</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DOMImplementation</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLFrameElement</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLIFrameElement</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLObjectElement</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>Node</name>
      <anchor>n7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::DocumentFragment</name>
    <filename>classDOM_1_1DocumentFragment.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>DocumentFragment</name>
      <anchor>a1</anchor>
      <arglist>(const DocumentFragment &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocumentFragment</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DocumentFragment &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DocumentFragment &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const DocumentFragment &amp;other)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>DocumentFragment</name>
      <anchor>b0</anchor>
      <arglist>(DocumentFragmentImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLElementImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Range</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::DocumentType</name>
    <filename>classDOM_1_1DocumentType.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>DocumentType</name>
      <anchor>a1</anchor>
      <arglist>(const DocumentType &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocumentType</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DocumentType &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DocumentType &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const DocumentType &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NamedNodeMap</type>
      <name>entities</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NamedNodeMap</type>
      <name>notations</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>publicId</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>systemId</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>internalSubset</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>DocumentType</name>
      <anchor>b0</anchor>
      <arglist>(DocumentTypeImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DOMImplementation</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Attr</name>
    <filename>classDOM_1_1Attr.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>Attr</name>
      <anchor>a1</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Attr</name>
      <anchor>a2</anchor>
      <arglist>(const Attr &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Attr &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Attr &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Attr &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>specified</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>ownerElement</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Attr</name>
      <anchor>b0</anchor>
      <arglist>(AttrImpl *_impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Element</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DocumentImpl</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLDocument</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>ElementImpl</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NamedAttrMapImpl</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>AttrImpl</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Element</name>
    <filename>classDOM_1_1Element.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>Element</name>
      <anchor>a1</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Element</name>
      <anchor>a2</anchor>
      <arglist>(const Element &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Element &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Element &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Element &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>tagName</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>getAttribute</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttribute</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;name, const DOMString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAttribute</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>getAttributeNode</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>setAttributeNode</name>
      <anchor>a11</anchor>
      <arglist>(const Attr &amp;newAttr)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>removeAttributeNode</name>
      <anchor>a12</anchor>
      <arglist>(const Attr &amp;oldAttr)</arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>getElementsByTagName</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>getElementsByTagNameNS</name>
      <anchor>a14</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>getAttributeNS</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttributeNS</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;qualifiedName, const DOMString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAttributeNS</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>getAttributeNodeNS</name>
      <anchor>a18</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>Attr</type>
      <name>setAttributeNodeNS</name>
      <anchor>a19</anchor>
      <arglist>(const Attr &amp;newAttr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasAttribute</name>
      <anchor>a20</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasAttributeNS</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>CSSStyleDeclaration</type>
      <name>style</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contentEditable</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContentEditable</name>
      <anchor>a24</anchor>
      <arglist>(bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHTMLElement</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Element</type>
      <name>form</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>khtmlValidAttrName</name>
      <anchor>e0</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>khtmlValidPrefix</name>
      <anchor>e1</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>khtmlValidQualifiedName</name>
      <anchor>e2</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>khtmlMalformedQualifiedName</name>
      <anchor>e3</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>khtmlMalformedPrefix</name>
      <anchor>e4</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Element</name>
      <anchor>b0</anchor>
      <arglist>(ElementImpl *_impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLDocument</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Attr</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::DOMException</name>
    <filename>classDOM_1_1DOMException.html</filename>
    <member kind="enumeration">
      <name>ExceptionCode</name>
      <anchor>w15</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMException</name>
      <anchor>a0</anchor>
      <arglist>(unsigned short _code)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMException</name>
      <anchor>a1</anchor>
      <arglist>(const DOMException &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMException &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const DOMException &amp;other)</arglist>
    </member>
    <member kind="variable">
      <type>unsigned short</type>
      <name>code</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::NamedNodeMap</name>
    <filename>classDOM_1_1NamedNodeMap.html</filename>
    <member kind="function">
      <type></type>
      <name>NamedNodeMap</name>
      <anchor>a1</anchor>
      <arglist>(const NamedNodeMap &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>NamedNodeMap &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const NamedNodeMap &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>getNamedItem</name>
      <anchor>a5</anchor>
      <arglist>(const DOMString &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>setNamedItem</name>
      <anchor>a6</anchor>
      <arglist>(const Node &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>removeNamedItem</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>item</name>
      <anchor>a8</anchor>
      <arglist>(unsigned long index) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>getNamedItemNS</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>setNamedItemNS</name>
      <anchor>a10</anchor>
      <arglist>(const Node &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>removeNamedItemNS</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;namespaceURI, const DOMString &amp;localName)</arglist>
    </member>
    <member kind="function">
      <type>NamedNodeMapImpl *</type>
      <name>handle</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>NamedNodeMap</name>
      <anchor>b0</anchor>
      <arglist>(NamedNodeMapImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>NamedNodeMapImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>Node</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>DocumentType</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>NodeImpl</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Node</name>
    <filename>classDOM_1_1Node.html</filename>
    <member kind="enumeration">
      <name>NodeType</name>
      <anchor>w12</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Node</name>
      <anchor>a1</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Node</name>
      <anchor>a2</anchor>
      <arglist>(NodeImpl *_impl)</arglist>
    </member>
    <member kind="function">
      <type>Node &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a5</anchor>
      <arglist>(const Node &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>nodeName</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>nodeValue</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeValue</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>nodeType</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>parentNode</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>childNodes</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>firstChild</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>lastChild</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>previousSibling</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextSibling</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NamedNodeMap</type>
      <name>attributes</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>ownerDocument</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>insertBefore</name>
      <anchor>a19</anchor>
      <arglist>(const Node &amp;newChild, const Node &amp;refChild)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>replaceChild</name>
      <anchor>a20</anchor>
      <arglist>(const Node &amp;newChild, const Node &amp;oldChild)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>removeChild</name>
      <anchor>a21</anchor>
      <arglist>(const Node &amp;oldChild)</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>appendChild</name>
      <anchor>a22</anchor>
      <arglist>(const Node &amp;newChild)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasChildNodes</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>cloneNode</name>
      <anchor>a24</anchor>
      <arglist>(bool deep)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>normalize</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSupported</name>
      <anchor>a26</anchor>
      <arglist>(const DOMString &amp;feature, const DOMString &amp;version) const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>namespaceURI</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>prefix</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrefix</name>
      <anchor>a29</anchor>
      <arglist>(const DOMString &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>localName</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasAttributes</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addEventListener</name>
      <anchor>a32</anchor>
      <arglist>(const DOMString &amp;type, EventListener *listener, const bool useCapture)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeEventListener</name>
      <anchor>a33</anchor>
      <arglist>(const DOMString &amp;type, EventListener *listener, bool useCapture)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dispatchEvent</name>
      <anchor>a34</anchor>
      <arglist>(const Event &amp;evt)</arglist>
    </member>
    <member kind="function">
      <type>Q_UINT32</type>
      <name>elementId</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NodeImpl *</type>
      <name>handle</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>index</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toHTML</name>
      <anchor>a39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyChanges</name>
      <anchor>a40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getCursor</name>
      <anchor>a41</anchor>
      <arglist>(int offset, int &amp;_x, int &amp;_y, int &amp;height) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>getRect</name>
      <anchor>a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>NodeImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NamedNodeMap</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>NodeList</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLCollection</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>StyleSheet</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::NodeList</name>
    <filename>classDOM_1_1NodeList.html</filename>
    <member kind="function">
      <type></type>
      <name>NodeList</name>
      <anchor>a1</anchor>
      <arglist>(const NodeList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>NodeList &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const NodeList &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>item</name>
      <anchor>a5</anchor>
      <arglist>(unsigned long index) const </arglist>
    </member>
    <member kind="function">
      <type>NodeListImpl *</type>
      <name>handle</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>NodeList</name>
      <anchor>b0</anchor>
      <arglist>(const NodeListImpl *i)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>NodeListImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Element</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Node</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLDocument</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KJS::HTMLDocument</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::DOMString</name>
    <filename>classDOM_1_1DOMString.html</filename>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a1</anchor>
      <arglist>(const QChar *str, uint len)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a3</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a4</anchor>
      <arglist>(DOMStringImpl *i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DOMString</name>
      <anchor>a6</anchor>
      <arglist>(const DOMString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>DOMString &amp;</type>
      <name>operator=</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>DOMString &amp;</type>
      <name>operator+=</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>operator+</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchor>a10</anchor>
      <arglist>(DOMString str, uint pos)</arglist>
    </member>
    <member kind="function">
      <type>const QChar &amp;</type>
      <name>operator[]</name>
      <anchor>a11</anchor>
      <arglist>(unsigned int i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchor>a12</anchor>
      <arglist>(const QChar c, int start=0) const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>length</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchor>a14</anchor>
      <arglist>(unsigned int len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a15</anchor>
      <arglist>(unsigned int pos, int len=1)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>split</name>
      <anchor>a16</anchor>
      <arglist>(unsigned int pos)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>lower</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>upper</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QChar *</type>
      <name>unicode</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>string</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>toInt</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>percentage</name>
      <anchor>a22</anchor>
      <arglist>(int &amp;_percentage) const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>copy</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMStringImpl *</type>
      <name>implementation</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOMStringImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>CharacterDataImpl</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend bool</type>
      <name>operator==</name>
      <anchor>n1</anchor>
      <arglist>(const DOMString &amp;a, const char *b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CharacterData</name>
    <filename>classDOM_1_1CharacterData.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>CharacterData</name>
      <anchor>a1</anchor>
      <arglist>(const CharacterData &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CharacterData</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CharacterData &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CharacterData &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CharacterData &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>data</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>substringData</name>
      <anchor>a9</anchor>
      <arglist>(const unsigned long offset, const unsigned long count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>appendData</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertData</name>
      <anchor>a11</anchor>
      <arglist>(const unsigned long offset, const DOMString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteData</name>
      <anchor>a12</anchor>
      <arglist>(const unsigned long offset, const unsigned long count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replaceData</name>
      <anchor>a13</anchor>
      <arglist>(const unsigned long offset, const unsigned long count, const DOMString &amp;arg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>CharacterData</name>
      <anchor>b0</anchor>
      <arglist>(CharacterDataImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>CharacterDataImpl</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Comment</name>
    <filename>classDOM_1_1Comment.html</filename>
    <base>DOM::CharacterData</base>
    <member kind="function">
      <type></type>
      <name>Comment</name>
      <anchor>a1</anchor>
      <arglist>(const Comment &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Comment</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Comment &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Comment &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Comment &amp;other)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Comment</name>
      <anchor>b0</anchor>
      <arglist>(CommentImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TextImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Text</name>
    <filename>classDOM_1_1Text.html</filename>
    <base>DOM::CharacterData</base>
    <member kind="function">
      <type></type>
      <name>Text</name>
      <anchor>a1</anchor>
      <arglist>(const Text &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Text</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Text &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Text &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Text &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Text</type>
      <name>splitText</name>
      <anchor>a6</anchor>
      <arglist>(const unsigned long offset)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Text</name>
      <anchor>b0</anchor>
      <arglist>(TextImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>TextImpl</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::CDATASection</name>
    <filename>classDOM_1_1CDATASection.html</filename>
    <base>DOM::Text</base>
    <member kind="function">
      <type></type>
      <name>CDATASection</name>
      <anchor>a1</anchor>
      <arglist>(const CDATASection &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CDATASection</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CDATASection &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>CDATASection &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const CDATASection &amp;other)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>CDATASection</name>
      <anchor>b0</anchor>
      <arglist>(CDATASectionImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Entity</name>
    <filename>classDOM_1_1Entity.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>Entity</name>
      <anchor>a1</anchor>
      <arglist>(const Entity &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Entity</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Entity &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Entity &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Entity &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>publicId</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>systemId</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>notationName</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Entity</name>
      <anchor>b0</anchor>
      <arglist>(EntityImpl *i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::EntityReference</name>
    <filename>classDOM_1_1EntityReference.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>EntityReference</name>
      <anchor>a1</anchor>
      <arglist>(const EntityReference &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EntityReference</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>EntityReference &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>EntityReference &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const EntityReference &amp;other)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>EntityReference</name>
      <anchor>b0</anchor>
      <arglist>(EntityReferenceImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::Notation</name>
    <filename>classDOM_1_1Notation.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>Notation</name>
      <anchor>a1</anchor>
      <arglist>(const Notation &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Notation</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Notation &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>Notation &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Notation &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>publicId</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>systemId</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>Notation</name>
      <anchor>b0</anchor>
      <arglist>(NotationImpl *i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::ProcessingInstruction</name>
    <filename>classDOM_1_1ProcessingInstruction.html</filename>
    <base>DOM::Node</base>
    <member kind="function">
      <type></type>
      <name>ProcessingInstruction</name>
      <anchor>a1</anchor>
      <arglist>(const ProcessingInstruction &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ProcessingInstruction</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>ProcessingInstruction &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>ProcessingInstruction &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const ProcessingInstruction &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>data</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheet</type>
      <name>sheet</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>ProcessingInstruction</name>
      <anchor>b0</anchor>
      <arglist>(ProcessingInstructionImpl *i)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Document</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLBodyElement</name>
    <filename>classDOM_1_1HTMLBodyElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLBodyElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLBodyElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLBodyElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBodyElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLBodyElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBodyElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>aLink</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setALink</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>background</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackground</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>bgColor</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBgColor</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>link</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLink</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>text</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vLink</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVLink</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLBodyElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLBodyElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLFrameElement</name>
    <filename>classDOM_1_1HTMLFrameElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLFrameElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLFrameElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLFrameElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFrameElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLFrameElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFrameElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>frameBorder</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrameBorder</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>longDesc</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLongDesc</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>marginHeight</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginHeight</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>marginWidth</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginWidth</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>noResize</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoResize</name>
      <anchor>a17</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>scrolling</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScrolling</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>src</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSrc</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>contentDocument</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLFrameElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLFrameElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLFrameSetElement</name>
    <filename>classDOM_1_1HTMLFrameSetElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLFrameSetElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLFrameSetElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLFrameSetElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFrameSetElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLFrameSetElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFrameSetElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cols</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCols</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rows</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRows</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLFrameSetElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLFrameSetElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLIFrameElement</name>
    <filename>classDOM_1_1HTMLIFrameElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLIFrameElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLIFrameElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLIFrameElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLIFrameElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLIFrameElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLIFrameElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>frameBorder</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrameBorder</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>height</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>longDesc</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLongDesc</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>marginHeight</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginHeight</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>marginWidth</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMarginWidth</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>scrolling</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScrolling</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>src</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSrc</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>contentDocument</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLIFrameElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLIFrameElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLHeadElement</name>
    <filename>classDOM_1_1HTMLHeadElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLHeadElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLHeadElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLHeadElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHeadElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLHeadElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHeadElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>profile</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProfile</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLHeadElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLHeadElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLHtmlElement</name>
    <filename>classDOM_1_1HTMLHtmlElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLHtmlElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLHtmlElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLHtmlElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHtmlElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLHtmlElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHtmlElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>version</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLHtmlElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLHtmlElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLBlockquoteElement</name>
    <filename>classDOM_1_1HTMLBlockquoteElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLBlockquoteElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLBlockquoteElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLBlockquoteElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBlockquoteElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLBlockquoteElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBlockquoteElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cite</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCite</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLBlockquoteElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLDivElement</name>
    <filename>classDOM_1_1HTMLDivElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLDivElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLDivElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLDivElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDivElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLDivElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDivElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLDivElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLDivElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLHRElement</name>
    <filename>classDOM_1_1HTMLHRElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLHRElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLHRElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLHRElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHRElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLHRElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHRElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>noShade</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoShade</name>
      <anchor>a9</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>size</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLHRElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLHRElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLHeadingElement</name>
    <filename>classDOM_1_1HTMLHeadingElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLHeadingElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLHeadingElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLHeadingElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHeadingElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLHeadingElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLHeadingElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLHeadingElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLParagraphElement</name>
    <filename>classDOM_1_1HTMLParagraphElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLParagraphElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLParagraphElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLParagraphElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLParagraphElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLParagraphElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLParagraphElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLParagraphElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLPreElement</name>
    <filename>classDOM_1_1HTMLPreElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLPreElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLPreElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLPreElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLPreElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLPreElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLPreElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>width</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLPreElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLPreElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLDocument</name>
    <filename>classDOM_1_1HTMLDocument.html</filename>
    <base>DOM::Document</base>
    <member kind="function">
      <type></type>
      <name>HTMLDocument</name>
      <anchor>a1</anchor>
      <arglist>(KHTMLView *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLDocument</name>
      <anchor>a2</anchor>
      <arglist>(const HTMLDocument &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLDocument</name>
      <anchor>a3</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDocument &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const HTMLDocument &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDocument &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>title</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>referrer</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>domain</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>URL</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>body</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBody</name>
      <anchor>a13</anchor>
      <arglist>(const HTMLElement &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>images</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>applets</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>links</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>forms</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>anchors</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cookie</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCookie</name>
      <anchor>a20</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeln</name>
      <anchor>a24</anchor>
      <arglist>(const DOMString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>NodeList</type>
      <name>getElementsByName</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;elementName)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>completeURL</name>
      <anchor>a26</anchor>
      <arglist>(const DOMString &amp;url) const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>lastModified</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>all</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLDocument</name>
      <anchor>b0</anchor>
      <arglist>(HTMLDocumentImpl *impl)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>::KHTMLView</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>::KHTMLPart</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DOMImplementation</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLElement</name>
    <filename>classDOM_1_1HTMLElement.html</filename>
    <base>DOM::Element</base>
    <member kind="function">
      <type></type>
      <name>HTMLElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>id</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setId</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>title</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>lang</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLang</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>dir</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDir</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>className</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClassName</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>innerHTML</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInnerHTML</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;html)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>innerText</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInnerText</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>children</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>all</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeCSSProperty</name>
      <anchor>a22</anchor>
      <arglist>(const DOMString &amp;property)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCSSProperty</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;property, const DOMString &amp;value)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLElementImpl *impl)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>assignOther</name>
      <anchor>b1</anchor>
      <arglist>(const Node &amp;other, int elementId)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLDocument</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>::KHTMLView</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableRowElement</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableSectionElement</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLButtonElement</name>
    <filename>classDOM_1_1HTMLButtonElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLButtonElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLButtonElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLButtonElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLButtonElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLButtonElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLButtonElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a10</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a14</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLButtonElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLButtonElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLFieldSetElement</name>
    <filename>classDOM_1_1HTMLFieldSetElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLFieldSetElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLFieldSetElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLFieldSetElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFieldSetElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLFieldSetElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFieldSetElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLFieldSetElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLFieldSetElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLFormElement</name>
    <filename>classDOM_1_1HTMLFormElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLFormElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLFormElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLFormElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLFormElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>elements</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>acceptCharset</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAcceptCharset</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>action</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAction</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>enctype</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnctype</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>method</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMethod</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTarget</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>submit</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLFormElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLFormElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLButtonElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLFieldSetElement</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLInputElement</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLLabelElement</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLLegendElement</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLSelectElement</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTextAreaElement</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLOptionElement</name>
      <anchor>n7</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLIsIndexElement</name>
      <anchor>n8</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLObjectElement</name>
      <anchor>n9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLInputElement</name>
    <filename>classDOM_1_1HTMLInputElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLInputElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLInputElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLInputElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLInputElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLInputElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLInputElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>defaultValue</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultValue</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>defaultChecked</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultChecked</name>
      <anchor>a9</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accept</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccept</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a14</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>alt</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlt</name>
      <anchor>a18</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checked</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChecked</name>
      <anchor>a20</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a22</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>maxLength</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxLength</name>
      <anchor>a24</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a26</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readOnly</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReadOnly</name>
      <anchor>a28</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>size</name>
      <anchor>a29</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a30</anchor>
      <arglist>(const DOMString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSize</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a32</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>src</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSrc</name>
      <anchor>a34</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a36</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a38</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>useMap</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseMap</name>
      <anchor>a40</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a42</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>blur</name>
      <anchor>a43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>focus</name>
      <anchor>a44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>select</name>
      <anchor>a45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>click</name>
      <anchor>a46</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLInputElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLInputElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLLabelElement</name>
    <filename>classDOM_1_1HTMLLabelElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLLabelElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLLabelElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLLabelElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLabelElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLLabelElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLabelElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>htmlFor</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHtmlFor</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLLabelElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLLabelElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLLegendElement</name>
    <filename>classDOM_1_1HTMLLegendElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLLegendElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLLegendElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLLegendElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLegendElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLLegendElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLegendElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLLegendElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLLegendElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLOptGroupElement</name>
    <filename>classDOM_1_1HTMLOptGroupElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLOptGroupElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLOptGroupElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLOptGroupElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOptGroupElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLOptGroupElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOptGroupElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>label</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLOptGroupElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLOptGroupElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLSelectElement</name>
    <filename>classDOM_1_1HTMLSelectElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLSelectElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLSelectElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLSelectElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLSelectElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLSelectElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLSelectElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>selectedIndex</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectedIndex</name>
      <anchor>a8</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>length</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>options</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a15</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>multiple</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMultiple</name>
      <anchor>a17</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>size</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a21</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a23</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchor>a24</anchor>
      <arglist>(const HTMLElement &amp;element, const HTMLElement &amp;before)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a25</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>blur</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>focus</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLSelectElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLSelectElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTextAreaElement</name>
    <filename>classDOM_1_1HTMLTextAreaElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTextAreaElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTextAreaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTextAreaElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTextAreaElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTextAreaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTextAreaElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>defaultValue</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultValue</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>cols</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCols</name>
      <anchor>a12</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a14</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readOnly</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReadOnly</name>
      <anchor>a18</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>rows</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRows</name>
      <anchor>a20</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a22</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>blur</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>focus</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>select</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTextAreaElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTextAreaElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLOptionElement</name>
    <filename>classDOM_1_1HTMLOptionElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLOptionElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLOptionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLOptionElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOptionElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLOptionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOptionElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>defaultSelected</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultSelected</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>text</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>index</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIndex</name>
      <anchor>a11</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a13</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>label</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>selected</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelected</name>
      <anchor>a17</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLOptionElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLOptionElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLIsIndexElement</name>
    <filename>classDOM_1_1HTMLIsIndexElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLIsIndexElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLIsIndexElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLIsIndexElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLIsIndexElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLIsIndexElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLIsIndexElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>prompt</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrompt</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLIsIndexElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLIsIndexElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLBaseElement</name>
    <filename>classDOM_1_1HTMLBaseElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLBaseElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLBaseElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLBaseElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBaseElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLBaseElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBaseElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>href</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHref</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTarget</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLBaseElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLBaseElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLLinkElement</name>
    <filename>classDOM_1_1HTMLLinkElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLLinkElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLLinkElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLLinkElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLinkElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLLinkElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLinkElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>charset</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCharset</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>href</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHref</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>hreflang</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHreflang</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>media</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMedia</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rel</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRel</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rev</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRev</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTarget</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheet</type>
      <name>sheet</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLLinkElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLLinkElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLMetaElement</name>
    <filename>classDOM_1_1HTMLMetaElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLMetaElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLMetaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLMetaElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMetaElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLMetaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMetaElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>content</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContent</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>httpEquiv</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHttpEquiv</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>scheme</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScheme</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLMetaElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLMetaElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLScriptElement</name>
    <filename>classDOM_1_1HTMLScriptElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLScriptElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLScriptElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLScriptElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLScriptElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLScriptElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLScriptElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>text</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>htmlFor</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHtmlFor</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>event</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEvent</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>charset</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCharset</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>defer</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefer</name>
      <anchor>a15</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>src</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSrc</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLScriptElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLScriptElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLStyleElement</name>
    <filename>classDOM_1_1HTMLStyleElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLStyleElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLStyleElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLStyleElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLStyleElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLStyleElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLStyleElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabled</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>media</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMedia</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>StyleSheet</type>
      <name>sheet</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLStyleElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLStyleElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTitleElement</name>
    <filename>classDOM_1_1HTMLTitleElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTitleElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTitleElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTitleElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTitleElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTitleElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTitleElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>text</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTitleElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTitleElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLAreaElement</name>
    <filename>classDOM_1_1HTMLAreaElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLAreaElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLAreaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLAreaElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAreaElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLAreaElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAreaElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>alt</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlt</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>coords</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCoords</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>href</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHref</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>noHref</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoHref</name>
      <anchor>a15</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>shape</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShape</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a19</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTarget</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLAreaElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLAreaElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLImageElement</name>
    <filename>classDOM_1_1HTMLImageElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLImageElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLImageElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLImageElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLImageElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLImageElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLImageElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>alt</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlt</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>getBorder</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>border</name>
      <anchor>a14</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a15</anchor>
      <arglist>(long) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>height</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a17</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>hspace</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHspace</name>
      <anchor>a19</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMap</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIsMap</name>
      <anchor>a21</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>longDesc</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLongDesc</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>src</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSrc</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>useMap</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseMap</name>
      <anchor>a27</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>vspace</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVspace</name>
      <anchor>a29</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>width</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a31</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>x</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>y</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLImageElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLImageElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLMapElement</name>
    <filename>classDOM_1_1HTMLMapElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLMapElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLMapElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLMapElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMapElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLMapElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMapElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>areas</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLMapElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLMapElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLAnchorElement</name>
    <filename>classDOM_1_1HTMLAnchorElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLAnchorElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLAnchorElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLAnchorElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAnchorElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLAnchorElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAnchorElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>accessKey</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccessKey</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>charset</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCharset</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>coords</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCoords</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>href</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHref</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>hreflang</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHreflang</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rel</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRel</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rev</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRev</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>shape</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShape</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a25</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>target</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTarget</name>
      <anchor>a27</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a29</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>blur</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>focus</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLAnchorElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLAnchorElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLBRElement</name>
    <filename>classDOM_1_1HTMLBRElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLBRElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLBRElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLBRElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBRElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLBRElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBRElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>clear</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClear</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLBRElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLBRElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLFontElement</name>
    <filename>classDOM_1_1HTMLFontElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLFontElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLFontElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLFontElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFontElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLFontElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFontElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>color</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>face</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFace</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>size</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLFontElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLFontElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLModElement</name>
    <filename>classDOM_1_1HTMLModElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLModElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLModElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLModElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLModElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLModElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLModElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cite</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCite</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>dateTime</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDateTime</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLModElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLQuoteElement</name>
    <filename>classDOM_1_1HTMLQuoteElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLQuoteElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLQuoteElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLQuoteElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLQuoteElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLQuoteElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLQuoteElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cite</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCite</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLQuoteElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLGenericElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLDListElement</name>
    <filename>classDOM_1_1HTMLDListElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLDListElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLDListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLDListElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDListElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLDListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDListElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compact</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompact</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLDListElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLDListElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLDirectoryElement</name>
    <filename>classDOM_1_1HTMLDirectoryElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLDirectoryElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLDirectoryElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLDirectoryElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDirectoryElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLDirectoryElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLDirectoryElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compact</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompact</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLDirectoryElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLDirectoryElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLLIElement</name>
    <filename>classDOM_1_1HTMLLIElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLLIElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLLIElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLLIElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLIElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLLIElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLLIElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>value</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a9</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLLIElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLLIElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLMenuElement</name>
    <filename>classDOM_1_1HTMLMenuElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLMenuElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLMenuElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLMenuElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMenuElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLMenuElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLMenuElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compact</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompact</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLMenuElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLMenuElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLOListElement</name>
    <filename>classDOM_1_1HTMLOListElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLOListElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLOListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLOListElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOListElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLOListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLOListElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compact</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompact</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>start</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStart</name>
      <anchor>a9</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLOListElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLOListElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLUListElement</name>
    <filename>classDOM_1_1HTMLUListElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLUListElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLUListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLUListElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLUListElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLUListElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLUListElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compact</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompact</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLUListElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLUListElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLBaseFontElement</name>
    <filename>classDOM_1_1HTMLBaseFontElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLBaseFontElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLBaseFontElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLBaseFontElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBaseFontElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLBaseFontElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLBaseFontElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>color</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>face</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFace</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getSize</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a11</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>size</name>
      <anchor>a12</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLBaseFontElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLBaseFontElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLCollection</name>
    <filename>classDOM_1_1HTMLCollection.html</filename>
    <member kind="function">
      <type></type>
      <name>HTMLCollection</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLCollection &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const HTMLCollection &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>length</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>item</name>
      <anchor>a5</anchor>
      <arglist>(unsigned long index) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>namedItem</name>
      <anchor>a6</anchor>
      <arglist>(const DOMString &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>base</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollectionImpl *</type>
      <name>handle</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>firstItem</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextItem</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node</type>
      <name>nextNamedItem</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;name) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLCollection</name>
      <anchor>b0</anchor>
      <arglist>(NodeImpl *base, int type)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>HTMLCollectionImpl *</type>
      <name>impl</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLDocument</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLSelectElement</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLImageElement</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLMapElement</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableRowElement</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableSectionElement</name>
      <anchor>n6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLElement</name>
      <anchor>n7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLAppletElement</name>
    <filename>classDOM_1_1HTMLAppletElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLAppletElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLAppletElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLAppletElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAppletElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLAppletElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLAppletElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>alt</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlt</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>archive</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setArchive</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>code</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCode</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>codeBase</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCodeBase</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>height</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getHspace</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHspace</name>
      <anchor>a19</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>hspace</name>
      <anchor>a20</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHspace</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;value) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>object</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setObject</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getVspace</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVspace</name>
      <anchor>a27</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vspace</name>
      <anchor>a28</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVspace</name>
      <anchor>a29</anchor>
      <arglist>(const DOMString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a31</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLAppletElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLAppletElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLObjectElement</name>
    <filename>classDOM_1_1HTMLObjectElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLObjectElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLObjectElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLObjectElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLObjectElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLObjectElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLObjectElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLFormElement</type>
      <name>form</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>code</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCode</name>
      <anchor>a8</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a10</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>archive</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setArchive</name>
      <anchor>a12</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>border</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a14</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>codeBase</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCodeBase</name>
      <anchor>a16</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>codeType</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCodeType</name>
      <anchor>a18</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>data</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchor>a20</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>declare</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDeclare</name>
      <anchor>a22</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>height</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a24</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getHspace</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHspace</name>
      <anchor>a26</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>hspace</name>
      <anchor>a27</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHspace</name>
      <anchor>a28</anchor>
      <arglist>(const DOMString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a30</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>standby</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStandby</name>
      <anchor>a32</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>tabIndex</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabIndex</name>
      <anchor>a34</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a36</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>useMap</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseMap</name>
      <anchor>a38</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>getVspace</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVspace</name>
      <anchor>a40</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vspace</name>
      <anchor>a41</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVspace</name>
      <anchor>a42</anchor>
      <arglist>(const DOMString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a44</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Document</type>
      <name>contentDocument</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLObjectElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLObjectElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLParamElement</name>
    <filename>classDOM_1_1HTMLParamElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLParamElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLParamElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLParamElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLParamElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLParamElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLParamElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>name</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>type</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>value</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>valueType</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValueType</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLParamElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLParamElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableCaptionElement</name>
    <filename>classDOM_1_1HTMLTableCaptionElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableCaptionElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableCaptionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableCaptionElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableCaptionElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableCaptionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableCaptionElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableCaptionElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableCaptionElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableCellElement</name>
    <filename>classDOM_1_1HTMLTableCellElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableCellElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableCellElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableCellElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableCellElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableCellElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableCellElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>cellIndex</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCellIndex</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>abbr</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAbbr</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>axis</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAxis</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>bgColor</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBgColor</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>ch</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCh</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>chOff</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChOff</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>colSpan</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColSpan</name>
      <anchor>a21</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>headers</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeaders</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>height</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeight</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>noWrap</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoWrap</name>
      <anchor>a27</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>rowSpan</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRowSpan</name>
      <anchor>a29</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>scope</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScope</name>
      <anchor>a31</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vAlign</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVAlign</name>
      <anchor>a33</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a35</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableCellElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableCellElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableColElement</name>
    <filename>classDOM_1_1HTMLTableColElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableColElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableColElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableColElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableColElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableColElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableColElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>ch</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCh</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>chOff</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChOff</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>span</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpan</name>
      <anchor>a13</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vAlign</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVAlign</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableColElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableColElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableElement</name>
    <filename>classDOM_1_1HTMLTableElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableCaptionElement</type>
      <name>caption</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCaption</name>
      <anchor>a7</anchor>
      <arglist>(const HTMLTableCaptionElement &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableSectionElement</type>
      <name>tHead</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTHead</name>
      <anchor>a9</anchor>
      <arglist>(const HTMLTableSectionElement &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableSectionElement</type>
      <name>tFoot</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTFoot</name>
      <anchor>a11</anchor>
      <arglist>(const HTMLTableSectionElement &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>rows</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>tBodies</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>bgColor</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBgColor</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>border</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cellPadding</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCellPadding</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>cellSpacing</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCellSpacing</name>
      <anchor>a23</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>frame</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrame</name>
      <anchor>a25</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>rules</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRules</name>
      <anchor>a27</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>summary</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSummary</name>
      <anchor>a29</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>width</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidth</name>
      <anchor>a31</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>createTHead</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteTHead</name>
      <anchor>a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>createTFoot</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteTFoot</name>
      <anchor>a35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>createCaption</name>
      <anchor>a36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteCaption</name>
      <anchor>a37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>insertRow</name>
      <anchor>a38</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteRow</name>
      <anchor>a39</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableElementImpl *impl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableRowElement</name>
    <filename>classDOM_1_1HTMLTableRowElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableRowElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableRowElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableRowElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableRowElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableRowElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableRowElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>rowIndex</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRowIndex</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>sectionRowIndex</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSectionRowIndex</name>
      <anchor>a9</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>cells</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCells</name>
      <anchor>a11</anchor>
      <arglist>(const HTMLCollection &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>bgColor</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBgColor</name>
      <anchor>a15</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>ch</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCh</name>
      <anchor>a17</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>chOff</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChOff</name>
      <anchor>a19</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vAlign</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVAlign</name>
      <anchor>a21</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>insertCell</name>
      <anchor>a22</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteCell</name>
      <anchor>a23</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableRowElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableRowElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DOM::HTMLTableSectionElement</name>
    <filename>classDOM_1_1HTMLTableSectionElement.html</filename>
    <base>DOM::HTMLElement</base>
    <member kind="function">
      <type></type>
      <name>HTMLTableSectionElement</name>
      <anchor>a1</anchor>
      <arglist>(const HTMLTableSectionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>HTMLTableSectionElement</name>
      <anchor>a2</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableSectionElement &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const HTMLTableSectionElement &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>HTMLTableSectionElement &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const Node &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>align</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlign</name>
      <anchor>a7</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>ch</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCh</name>
      <anchor>a9</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>chOff</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChOff</name>
      <anchor>a11</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>DOMString</type>
      <name>vAlign</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVAlign</name>
      <anchor>a13</anchor>
      <arglist>(const DOMString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>HTMLCollection</type>
      <name>rows</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>HTMLElement</type>
      <name>insertRow</name>
      <anchor>a15</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteRow</name>
      <anchor>a16</anchor>
      <arglist>(long index)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>HTMLTableSectionElement</name>
      <anchor>b0</anchor>
      <arglist>(HTMLTableSectionElementImpl *impl)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>HTMLTableElement</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::StyleSelector</name>
    <filename>classkhtml_1_1StyleSelector.html</filename>
  </compound>
  <compound kind="class">
    <name>khtml::CSSStyleSelector</name>
    <filename>classkhtml_1_1CSSStyleSelector.html</filename>
    <base>khtml::StyleSelector</base>
    <member kind="function">
      <type></type>
      <name>CSSStyleSelector</name>
      <anchor>a0</anchor>
      <arglist>(DOM::DocumentImpl *doc, QString userStyleSheet, DOM::StyleSheetListImpl *styleSheets, const KURL &amp;url, bool _strictParsing)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CSSStyleSelector</name>
      <anchor>a1</anchor>
      <arglist>(DOM::CSSStyleSheetImpl *sheet)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addSheet</name>
      <anchor>a3</anchor>
      <arglist>(DOM::CSSStyleSheetImpl *sheet)</arglist>
    </member>
    <member kind="function">
      <type>RenderStyle *</type>
      <name>styleForElement</name>
      <anchor>a4</anchor>
      <arglist>(DOM::ElementImpl *e)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>fontSizes</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>fixedFontSizes</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeFontSizes</name>
      <anchor>a7</anchor>
      <arglist>(QPaintDeviceMetrics *paintDeviceMetrics, int zoomFactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>computeFontSizesFor</name>
      <anchor>a8</anchor>
      <arglist>(QPaintDeviceMetrics *paintDeviceMetrics, int zoomFactor, QValueList&lt; int &gt; &amp;fontSizes, bool isFixed)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>clear</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>reparseConfiguration</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>loadDefaultStyle</name>
      <anchor>e2</anchor>
      <arglist>(const KHTMLSettings *s=0)</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>strictParsing</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>khtml::CSSStyleSelector::Encodedurl</type>
      <name>encodedurl</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>checkSelector</name>
      <anchor>b0</anchor>
      <arglist>(int selector, DOM::ElementImpl *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>checkOneSelector</name>
      <anchor>b1</anchor>
      <arglist>(DOM::CSSSelector *selector, DOM::ElementImpl *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>buildLists</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>clearLists</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>adjustRenderStyle</name>
      <anchor>b4</anchor>
      <arglist>(RenderStyle *style, DOM::ElementImpl *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>unsigned int</type>
      <name>addInlineDeclarations</name>
      <anchor>b5</anchor>
      <arglist>(DOM::ElementImpl *e, DOM::CSSStyleDeclarationImpl *decl, unsigned int numProps)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>applyRule</name>
      <anchor>b6</anchor>
      <arglist>(int id, DOM::CSSValueImpl *value)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleSelectorList *</type>
      <name>defaultStyle</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleSelectorList *</type>
      <name>defaultQuirksStyle</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleSelectorList *</type>
      <name>defaultPrintStyle</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleSelectorList *</type>
      <name>authorStyle</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSStyleSelectorList *</type>
      <name>userStyle</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::CSSStyleSheetImpl *</type>
      <name>userSheet</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>selectors_size</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::CSSSelector **</type>
      <name>selectors</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>SelectorCache *</type>
      <name>selectorCache</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>properties_size</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSOrderedProperty **</type>
      <name>properties</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMemArray&lt; CSSOrderedProperty &gt;</type>
      <name>inlineProps</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>m_medium</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSOrderedProperty **</type>
      <name>propsToApply</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>CSSOrderedProperty **</type>
      <name>pseudoProps</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>propsToApplySize</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>pseudoPropsSize</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderStyle::PseudoId</type>
      <name>dynamicPseudo</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderStyle *</type>
      <name>style</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderStyle *</type>
      <name>parentStyle</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::ElementImpl *</type>
      <name>element</name>
      <anchor>p20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::NodeImpl *</type>
      <name>parentNode</name>
      <anchor>p21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KHTMLView *</type>
      <name>view</name>
      <anchor>p22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KHTMLPart *</type>
      <name>part</name>
      <anchor>p23</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>const KHTMLSettings *</type>
      <name>settings</name>
      <anchor>p24</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPaintDeviceMetrics *</type>
      <name>paintDeviceMetrics</name>
      <anchor>p25</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QValueList&lt; int &gt;</type>
      <name>m_fontSizes</name>
      <anchor>p26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QValueList&lt; int &gt;</type>
      <name>m_fixedFontSizes</name>
      <anchor>p27</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>fontDirty</name>
      <anchor>p28</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>DOM::CSSStyleSheetImpl *</type>
      <name>s_defaultSheet</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>DOM::CSSStyleSheetImpl *</type>
      <name>s_quirksSheet</name>
      <anchor>t1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>CSSStyleSelectorList *</type>
      <name>s_defaultStyle</name>
      <anchor>t2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>CSSStyleSelectorList *</type>
      <name>s_defaultQuirksStyle</name>
      <anchor>t3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>CSSStyleSelectorList *</type>
      <name>s_defaultPrintStyle</name>
      <anchor>t4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>RenderStyle *</type>
      <name>styleNotYetAvailable</name>
      <anchor>t5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>khtml::CaretViewContext</name>
    <filename>structkhtml_1_1CaretViewContext.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>freqTimerId</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>x</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>y</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>width</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>height</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>visible</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>displayed</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>caretMoved</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>KHTMLPart::CaretDisplayPolicy</type>
      <name>displayNonFocused</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>origX</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>keyReleasePending</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>khtml::EditorContext</name>
    <filename>structkhtml_1_1EditorContext.html</filename>
    <member kind="variable">
      <type>bool</type>
      <name>override</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::LineIterator</name>
    <filename>classkhtml_1_1LineIterator.html</filename>
    <member kind="function">
      <type>InlineFlowBox *</type>
      <name>operator *</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>LineIterator &amp;</type>
      <name>operator++</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LineIterator</type>
      <name>operator++</name>
      <anchor>a2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>LineIterator &amp;</type>
      <name>operator--</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>LineIterator</type>
      <name>operator--</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>LineIterator</type>
      <name>operator+</name>
      <anchor>a5</anchor>
      <arglist>(int summand) const </arglist>
    </member>
    <member kind="function">
      <type>LineIterator</type>
      <name>operator-</name>
      <anchor>a6</anchor>
      <arglist>(int summand) const </arglist>
    </member>
    <member kind="function">
      <type>LineIterator &amp;</type>
      <name>operator+=</name>
      <anchor>a7</anchor>
      <arglist>(int summand)</arglist>
    </member>
    <member kind="function">
      <type>LineIterator &amp;</type>
      <name>operator-=</name>
      <anchor>a8</anchor>
      <arglist>(int summand)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a9</anchor>
      <arglist>(const LineIterator &amp;it) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a10</anchor>
      <arglist>(const LineIterator &amp;it) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>InlineBox *</type>
      <name>currentInlineBox</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>LineIterator</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>LineIterator</name>
      <anchor>b1</anchor>
      <arglist>(LinearDocument *l, DOM::NodeImpl *node, long offset)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>nextBlock</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>prevBlock</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>LinearDocument *</type>
      <name>lines</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderFlow *</type>
      <name>cb</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>InlineFlowBox *</type>
      <name>flowBox</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>InlineBox *</type>
      <name>currentBox</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>InlineBoxIterator</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>EditableInlineBoxIterator</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>LinearDocument</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::LinearDocument</name>
    <filename>classkhtml_1_1LinearDocument.html</filename>
    <member kind="typedef">
      <type>LineIterator</type>
      <name>Iterator</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LinearDocument</name>
      <anchor>a0</anchor>
      <arglist>(KHTMLPart *part, DOM::NodeImpl *node, long offset)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>current</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Iterator &amp;</type>
      <name>end</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>preEnd</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>begin</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Iterator &amp;</type>
      <name>preBegin</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initPreBeginIterator</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initEndIterator</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderArena *</type>
      <name>arena</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::NodeImpl *</type>
      <name>node</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>long</type>
      <name>offset</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Iterator</type>
      <name>_preBegin</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Iterator</type>
      <name>_end</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KHTMLPart *</type>
      <name>m_part</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>LineIterator</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>EditableLineIterator</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>ErgonomicEditableLineIterator</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>InlineBoxIterator</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>EditableInlineBoxIterator</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>EditableCharacterIterator</name>
      <anchor>n5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::InlineBoxIterator</name>
    <filename>classkhtml_1_1InlineBoxIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>InlineBoxIterator</name>
      <anchor>a0</anchor>
      <arglist>(RenderArena *arena, InlineFlowBox *flowBox, bool fromEnd=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InlineBoxIterator</name>
      <anchor>a1</anchor>
      <arglist>(LineIterator &amp;lit, bool fromEnd=false, InlineBox *initBox=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InlineBoxIterator</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>InlineBox *</type>
      <name>operator *</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>InlineBoxIterator &amp;</type>
      <name>operator++</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>InlineBoxIterator &amp;</type>
      <name>operator--</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RenderArena *</type>
      <name>arena</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>InlineBox *</type>
      <name>box</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::EditableInlineBoxIterator</name>
    <filename>classkhtml_1_1EditableInlineBoxIterator.html</filename>
    <base>khtml::InlineBoxIterator</base>
    <member kind="function">
      <type></type>
      <name>EditableInlineBoxIterator</name>
      <anchor>a0</anchor>
      <arglist>(KHTMLPart *part, RenderArena *arena, InlineFlowBox *flowBox, bool fromEnd=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EditableInlineBoxIterator</name>
      <anchor>a1</anchor>
      <arglist>(LineIterator &amp;lit, bool fromEnd=false, InlineBox *initBox=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EditableInlineBoxIterator</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAdjacent</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EditableInlineBoxIterator &amp;</type>
      <name>operator++</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EditableInlineBoxIterator &amp;</type>
      <name>operator--</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isEditable</name>
      <anchor>b0</anchor>
      <arglist>(InlineBox *b)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KHTMLPart *</type>
      <name>m_part</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>adjacent</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::EditableLineIterator</name>
    <filename>classkhtml_1_1EditableLineIterator.html</filename>
    <base>khtml::LineIterator</base>
    <member kind="function">
      <type></type>
      <name>EditableLineIterator</name>
      <anchor>a0</anchor>
      <arglist>(const LineIterator &amp;it, bool fromEnd=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EditableLineIterator</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EditableLineIterator &amp;</type>
      <name>operator++</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EditableLineIterator &amp;</type>
      <name>operator--</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isEditable</name>
      <anchor>b0</anchor>
      <arglist>(LineIterator &amp;it)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::TableRowIterator</name>
    <filename>classkhtml_1_1TableRowIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>TableRowIterator</name>
      <anchor>a0</anchor>
      <arglist>(RenderTable *table, bool fromEnd=false, RenderTableSection::RowStruct *row=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TableRowIterator</name>
      <anchor>a1</anchor>
      <arglist>(RenderTableSection *section, int index)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TableRowIterator</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>RenderTableSection::RowStruct *</type>
      <name>operator *</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TableRowIterator &amp;</type>
      <name>operator++</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>TableRowIterator &amp;</type>
      <name>operator--</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>TableSectionIterator</type>
      <name>sec</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>index</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::ErgonomicEditableLineIterator</name>
    <filename>classkhtml_1_1ErgonomicEditableLineIterator.html</filename>
    <base>khtml::EditableLineIterator</base>
    <member kind="function">
      <type></type>
      <name>ErgonomicEditableLineIterator</name>
      <anchor>a0</anchor>
      <arglist>(const LineIterator &amp;it, int x)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ErgonomicEditableLineIterator</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ErgonomicEditableLineIterator &amp;</type>
      <name>operator++</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ErgonomicEditableLineIterator &amp;</type>
      <name>operator--</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>determineTopologicalElement</name>
      <anchor>b0</anchor>
      <arglist>(RenderTableCell *oldCell, RenderObject *newObject, bool toBegin)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>calcAndStoreNewLine</name>
      <anchor>b1</anchor>
      <arglist>(RenderFlow *newBlock, bool toBegin)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>xCoor</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>khtml::EditableCharacterIterator</name>
    <filename>classkhtml_1_1EditableCharacterIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>EditableCharacterIterator</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EditableCharacterIterator</name>
      <anchor>a1</anchor>
      <arglist>(LinearDocument *ld)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>chr</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>operator *</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>offset</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DOM::NodeImpl *</type>
      <name>node</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>InlineBox *</type>
      <name>box</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EditableCharacterIterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EditableCharacterIterator &amp;</type>
      <name>operator--</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initFirstChar</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>peekNext</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>peekPrev</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>LinearDocument *</type>
      <name>ld</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>EditableLineIterator</type>
      <name>_it</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>EditableInlineBoxIterator</type>
      <name>ebit</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DOM::NodeImpl *</type>
      <name>_node</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>long</type>
      <name>_offset</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>_char</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::DOMObject</name>
    <filename>classKJS_1_1DOMObject.html</filename>
    <member kind="function">
      <type></type>
      <name>DOMObject</name>
      <anchor>a0</anchor>
      <arglist>(const Object &amp;proto)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>get</name>
      <anchor>a1</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>tryGet</name>
      <anchor>a2</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>put</name>
      <anchor>a3</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName, const Value &amp;value, int attr=None)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>tryPut</name>
      <anchor>a4</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName, const Value &amp;value, int attr=None)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual UString</type>
      <name>toString</name>
      <anchor>a5</anchor>
      <arglist>(ExecState *exec) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::DOMFunction</name>
    <filename>classKJS_1_1DOMFunction.html</filename>
    <member kind="function">
      <type></type>
      <name>DOMFunction</name>
      <anchor>a0</anchor>
      <arglist>(ExecState *exec)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>get</name>
      <anchor>a1</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>tryGet</name>
      <anchor>a2</anchor>
      <arglist>(ExecState *exec, const Identifier &amp;propertyName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>implementsCall</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>call</name>
      <anchor>a4</anchor>
      <arglist>(ExecState *exec, Object &amp;thisObj, const List &amp;args)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Value</type>
      <name>tryCall</name>
      <anchor>a5</anchor>
      <arglist>(ExecState *exec, Object &amp;thisObj, const List &amp;args)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>toBoolean</name>
      <anchor>a6</anchor>
      <arglist>(ExecState *) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ScriptInterpreter</name>
    <filename>classKJS_1_1ScriptInterpreter.html</filename>
    <member kind="function">
      <type></type>
      <name>ScriptInterpreter</name>
      <anchor>a0</anchor>
      <arglist>(const Object &amp;global, KHTMLPart *part)</arglist>
    </member>
    <member kind="function">
      <type>DOMObject *</type>
      <name>getDOMObject</name>
      <anchor>a2</anchor>
      <arglist>(void *objectHandle) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>putDOMObject</name>
      <anchor>a3</anchor>
      <arglist>(void *objectHandle, DOMObject *obj)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>deleteDOMObject</name>
      <anchor>a4</anchor>
      <arglist>(void *objectHandle)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>mark</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KHTMLPart *</type>
      <name>part</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>rtti</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentEvent</name>
      <anchor>a9</anchor>
      <arglist>(DOM::Event *evt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInlineCode</name>
      <anchor>a10</anchor>
      <arglist>(bool inlineCode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProcessingTimerCallback</name>
      <anchor>a11</anchor>
      <arglist>(bool timerCallback)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isWindowOpenAllowed</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>forgetDOMObject</name>
      <anchor>e0</anchor>
      <arglist>(void *objectHandle)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJS::ScheduledAction</name>
    <filename>classKJS_1_1ScheduledAction.html</filename>
    <member kind="function">
      <type></type>
      <name>ScheduledAction</name>
      <anchor>a0</anchor>
      <arglist>(Object _func, List _args, QTime _nextTime, int _interval, bool _singleShot, int _timerId)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScheduledAction</name>
      <anchor>a1</anchor>
      <arglist>(QString _code, QTime _nextTime, int _interval, bool _singleShot, int _timerId)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>execute</name>
      <anchor>a3</anchor>
      <arglist>(Window *window)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mark</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>ObjectImp *</type>
      <name>func</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>List</type>
      <name>args</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>code</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>isFunction</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>singleShot</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QTime</type>
      <name>nextTime</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>interval</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>executing</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>timerId</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
  </compound>
</tagfile>
