<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>The KDE User Interface library</title>
    <filename>index</filename>
  </compound>
  <compound kind="class">
    <name>KAboutApplication</name>
    <filename>classKAboutApplication.html</filename>
    <base>KAboutDialog</base>
    <member kind="function">
      <type></type>
      <name>KAboutApplication</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutApplication</name>
      <anchor>a1</anchor>
      <arglist>(const KAboutData *aboutData, QWidget *parent=0, const char *name=0, bool modal=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>buildDialog</name>
      <anchor>b0</anchor>
      <arglist>(const KAboutData *aboutData)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutContainer</name>
    <filename>classKAboutContainer.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>urlClick</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mailClick</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;name, const QString &amp;address)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutContainer</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, int margin=0, int spacing=0, int childAlignment=AlignCenter, int innerAlignment=AlignCenter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addWidget</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPerson</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;task, bool showHeader=false, bool showframe=false, bool showBold=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addTitle</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;title, int alignment=AlignLeft, bool showframe=false, bool showBold=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addImage</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;fileName, int alignment=AlignLeft)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>childEvent</name>
      <anchor>b0</anchor>
      <arglist>(QChildEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutContainerBase</name>
    <filename>classKAboutContainerBase.html</filename>
    <base>QWidget</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotMouseTrack</name>
      <anchor>i0</anchor>
      <arglist>(int mode, const QMouseEvent *e)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotUrlClick</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotMailClick</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;name, const QString &amp;address)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseTrack</name>
      <anchor>l0</anchor>
      <arglist>(int mode, const QMouseEvent *e)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>urlClick</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mailClick</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;name, const QString &amp;address)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutContainerBase</name>
      <anchor>a0</anchor>
      <arglist>(int layoutType, QWidget *parent=0, char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImage</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImageBackgroundColor</name>
      <anchor>a5</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImageFrame</name>
      <anchor>a6</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProduct</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;appName, const QString &amp;version, const QString &amp;author, const QString &amp;year)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addTextPage</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;title, const QString &amp;text, bool richText=false, int numLines=10)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addLicensePage</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;title, const QString &amp;text, int numLines=10)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addContainerPage</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;title, int childAlignment=AlignCenter, int innerAlignment=AlignCenter)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addScrolledContainerPage</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;title, int childAlignment=AlignCenter, int innerAlignment=AlignCenter)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addEmptyPage</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addContainer</name>
      <anchor>a13</anchor>
      <arglist>(int childAlignment, int innerAlignment)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fontChange</name>
      <anchor>b0</anchor>
      <arglist>(const QFont &amp;oldFont)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutContributor</name>
    <filename>classKAboutContributor.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>sendEmail</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>openURL</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutContributor</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, const QString &amp;username=QString::null, const QString &amp;email=QString::null, const QString &amp;url=QString::null, const QString &amp;work=QString::null, bool showHeader=false, bool showFrame=true, bool showBold=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const QString &amp;header=QString::null, bool update=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEmail</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QString &amp;header=QString::null, bool update=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setURL</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;header=QString::null, bool update=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWork</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QString &amp;header=QString::null, bool update=true)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getName</name>
      <anchor>a5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getEmail</name>
      <anchor>a6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getURL</name>
      <anchor>a7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getWork</name>
      <anchor>a8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>urlClickedSlot</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>emailClickedSlot</name>
      <anchor>j1</anchor>
      <arglist>(const QString &amp;emailaddress)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fontChange</name>
      <anchor>b0</anchor>
      <arglist>(const QFont &amp;oldFont)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutDialog</name>
    <filename>classKAboutDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="enumeration">
      <name>LayoutType</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>sendEmail</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>openURL</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutDialog</name>
      <anchor>a1</anchor>
      <arglist>(int dialogLayout, const QString &amp;caption, int buttonMask, ButtonCode defaultButton, QWidget *parent=0, const char *name=0, bool modal=false, bool separator=false, const QString &amp;user1=QString::null, const QString &amp;user2=QString::null, const QString &amp;user3=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>adjust</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *centerParent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImage</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImageBackgroundColor</name>
      <anchor>a7</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setImageFrame</name>
      <anchor>a8</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProduct</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;appName, const QString &amp;version, const QString &amp;author, const QString &amp;year)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addTextPage</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;title, const QString &amp;text, bool richText=false, int numLines=10)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addLicensePage</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;title, const QString &amp;text, int numLines=10)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addContainerPage</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;title, int childAlignment=AlignCenter, int innerAlignment=AlignCenter)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addScrolledContainerPage</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;title, int childAlignment=AlignCenter, int innerAlignment=AlignCenter)</arglist>
    </member>
    <member kind="function">
      <type>KAboutContainer *</type>
      <name>addContainer</name>
      <anchor>a14</anchor>
      <arglist>(int childAlignment, int innerAlignment)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addPage</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLogo</name>
      <anchor>a16</anchor>
      <arglist>(const QPixmap &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAuthor</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaintainer</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addContributor</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>imageURL</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *parent, const QString &amp;caption, const QString &amp;path, const QColor &amp;imageColor, const QString &amp;url)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sendEmailSlot</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>openURLSlot</name>
      <anchor>j1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseTrackSlot</name>
      <anchor>j2</anchor>
      <arglist>(int mode, const QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KAboutWidget *</type>
      <name>about</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KAboutContainerBase *</type>
      <name>mContainerBase</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutKDE</name>
    <filename>classKAboutKDE.html</filename>
    <base>KAboutDialog</base>
    <member kind="function">
      <type></type>
      <name>KAboutKDE</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutWidget</name>
    <filename>classKAboutWidget.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>sendEmail</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>openURL</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>adjust</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLogo</name>
      <anchor>a2</anchor>
      <arglist>(const QPixmap &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAuthor</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaintainer</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addContributor</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email, const QString &amp;url, const QString &amp;work)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVersion</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sendEmailSlot</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;email)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>openURLSlot</name>
      <anchor>j1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>version</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>cont</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>logo</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KAboutContributor *</type>
      <name>author</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KAboutContributor *</type>
      <name>maintainer</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>showMaintainer</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; KAboutContributor &gt;</type>
      <name>contributors</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAction</name>
    <filename>classKAction.html</filename>
    <base>QObject</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setText</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual bool</type>
      <name>setShortcut</name>
      <anchor>i1</anchor>
      <arglist>(const KShortcut &amp;)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setGroup</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setWhatsThis</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setToolTip</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setIconSet</name>
      <anchor>i5</anchor>
      <arglist>(const QIconSet &amp;iconSet)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setIcon</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;icon)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setEnabled</name>
      <anchor>i7</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setShortcutConfigurable</name>
      <anchor>i8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>activate</name>
      <anchor>i9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>enabled</name>
      <anchor>l1</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a3</anchor>
      <arglist>(const KGuiItem &amp;item, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAction</name>
      <anchor>a10</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KAction</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a12</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>plugAccel</name>
      <anchor>a13</anchor>
      <arglist>(KAccel *accel, bool configurable=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unplug</name>
      <anchor>a14</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unplugAccel</name>
      <anchor>a15</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isPlugged</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPlugged</name>
      <anchor>a17</anchor>
      <arglist>(const QWidget *container) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isPlugged</name>
      <anchor>a18</anchor>
      <arglist>(const QWidget *container, int id) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isPlugged</name>
      <anchor>a19</anchor>
      <arglist>(const QWidget *container, const QWidget *_representative) const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>container</name>
      <anchor>a20</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>itemId</name>
      <anchor>a21</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>representative</name>
      <anchor>a22</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>containerCount</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>kaccelCount</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>hasIcon</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasIconSet</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>plainText</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>text</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcutDefault</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>shortcutText</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShortcutText</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isEnabled</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isShortcutConfigurable</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>group</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>whatsThis</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>toolTip</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QIconSet</type>
      <name>iconSet</name>
      <anchor>a38</anchor>
      <arglist>(KIcon::Group group, int size=0) const </arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>iconSet</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>icon</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KActionCollection *</type>
      <name>parentCollection</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unplugAll</name>
      <anchor>a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>accel</name>
      <anchor>a43</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>statusText</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccel</name>
      <anchor>a45</anchor>
      <arglist>(int key) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStatusText</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>menuId</name>
      <anchor>a47</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getToolButtonID</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotDestroyed</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotKeycodeChanged</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>KToolBar *</type>
      <name>toolBar</name>
      <anchor>b0</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>QPopupMenu *</type>
      <name>popupMenu</name>
      <anchor>b1</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>removeContainer</name>
      <anchor>b2</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>findContainer</name>
      <anchor>b3</anchor>
      <arglist>(const QWidget *widget) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>plugMainWindowAccel</name>
      <anchor>b4</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addContainer</name>
      <anchor>b5</anchor>
      <arglist>(QWidget *parent, int id)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addContainer</name>
      <anchor>b6</anchor>
      <arglist>(QWidget *parent, QWidget *representative)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateShortcut</name>
      <anchor>b7</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateShortcut</name>
      <anchor>b8</anchor>
      <arglist>(QPopupMenu *menu, int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateGroup</name>
      <anchor>b9</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateText</name>
      <anchor>b10</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateEnabled</name>
      <anchor>b11</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateIconSet</name>
      <anchor>b12</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateIcon</name>
      <anchor>b13</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateToolTip</name>
      <anchor>b14</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateWhatsThis</name>
      <anchor>b15</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>whatsThisWithIcon</name>
      <anchor>b16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b17</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KActionCollection *</type>
      <name>m_parentCollection</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KActionCollection</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KActionCollection</name>
    <filename>classKActionCollection.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>clear</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>inserted</name>
      <anchor>l0</anchor>
      <arglist>(KAction *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>removed</name>
      <anchor>l1</anchor>
      <arglist>(KAction *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>actionHighlighted</name>
      <anchor>l2</anchor>
      <arglist>(KAction *action)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>actionHighlighted</name>
      <anchor>l3</anchor>
      <arglist>(KAction *action, bool highlight)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>actionStatusText</name>
      <anchor>l4</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clearStatusText</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionCollection</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0, KInstance *instance=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionCollection</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *watch, QObject *parent, const char *name=0, KInstance *instance=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionCollection</name>
      <anchor>a2</anchor>
      <arglist>(const KActionCollection &amp;copy)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWidget</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoConnectShortcuts</name>
      <anchor>a5</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAutoConnectShortcuts</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addDocCollection</name>
      <anchor>a7</anchor>
      <arglist>(KActionCollection *pDoc)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KAccel *</type>
      <name>accel</name>
      <anchor>a8</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KAccel *</type>
      <name>accel</name>
      <anchor>a9</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>KAccel *</type>
      <name>kaccel</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KAccel *</type>
      <name>kaccel</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KAccel *</type>
      <name>builderKAccel</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual uint</type>
      <name>count</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KAction *</type>
      <name>action</name>
      <anchor>a15</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KAction *</type>
      <name>action</name>
      <anchor>a16</anchor>
      <arglist>(const char *name, const char *classname=0) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>groups</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KActionPtrList</type>
      <name>actions</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;group) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KActionPtrList</type>
      <name>actions</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readShortcutSettings</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;sConfigGroup=QString::null, KConfigBase *pConfig=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeShortcutSettings</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;sConfigGroup=QString::null, KConfigBase *pConfig=0) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInstance</name>
      <anchor>a22</anchor>
      <arglist>(KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>KInstance *</type>
      <name>instance</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXMLFile</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>xmlFile</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHighlightingEnabled</name>
      <anchor>a26</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>highlightingEnabled</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connectHighlight</name>
      <anchor>a28</anchor>
      <arglist>(QWidget *container, KAction *action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnectHighlight</name>
      <anchor>a29</anchor>
      <arglist>(QWidget *container, KAction *action)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionCollection</name>
      <anchor>a30</anchor>
      <arglist>(QObject *parent, const char *name=0, KInstance *instance=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchor>a31</anchor>
      <arglist>(KAction *action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a32</anchor>
      <arglist>(KAction *action)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>take</name>
      <anchor>a33</anchor>
      <arglist>(KAction *action)</arglist>
    </member>
    <member kind="function">
      <type>KActionCollection</type>
      <name>operator+</name>
      <anchor>a34</anchor>
      <arglist>(const KActionCollection &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>KActionCollection &amp;</type>
      <name>operator=</name>
      <anchor>a35</anchor>
      <arglist>(const KActionCollection &amp;)</arglist>
    </member>
    <member kind="function">
      <type>KActionCollection &amp;</type>
      <name>operator+=</name>
      <anchor>a36</anchor>
      <arglist>(const KActionCollection &amp;)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KAction</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KXMLGUIClient</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KActionMenu</name>
    <filename>classKActionMenu.html</filename>
    <base>KAction</base>
    <member kind="function">
      <type></type>
      <name>KActionMenu</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionMenu</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;icon, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionMenu</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QString &amp;icon, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActionMenu</name>
      <anchor>a3</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>insert</name>
      <anchor>a5</anchor>
      <arglist>(KAction *, int index=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove</name>
      <anchor>a6</anchor>
      <arglist>(KAction *)</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>popupMenu</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popup</name>
      <anchor>a8</anchor>
      <arglist>(const QPoint &amp;global)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>delayed</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDelayed</name>
      <anchor>a10</anchor>
      <arglist>(bool _delayed)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stickyMenu</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStickyMenu</name>
      <anchor>a12</anchor>
      <arglist>(bool sticky)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a13</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KActiveLabel</name>
    <filename>classKActiveLabel.html</filename>
    <base>QTextBrowser</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>openLink</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;link)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActiveLabel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KActiveLabel</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b1</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b2</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAnimWidget</name>
    <filename>classKAnimWidget.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAnimWidget</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;icons, int size=0, QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KAnimWidget</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a4</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIcons</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;icons)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotTimerUpdate</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>updateIcons</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b1</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>enterEvent</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b3</anchor>
      <arglist>(QHideEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>showEvent</name>
      <anchor>b4</anchor>
      <arglist>(QShowEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b5</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b6</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KArrowButton</name>
    <filename>classKArrowButton.html</filename>
    <base>QPushButton</base>
    <member kind="slot">
      <type>void</type>
      <name>setArrowType</name>
      <anchor>i0</anchor>
      <arglist>(Qt::ArrowType a)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KArrowButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, Qt::ArrowType arrow=Qt::UpArrow, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KArrowButton</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawButton</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAuthIcon</name>
    <filename>classKAuthIcon.html</filename>
    <base>QWidget</base>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>updateStatus</name>
      <anchor>i0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>authChanged</name>
      <anchor>l0</anchor>
      <arglist>(bool authorized)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAuthIcon</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>status</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QHBoxLayout *</type>
      <name>layout</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>lockBox</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>lockLabel</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPixmap</type>
      <name>lockPM</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPixmap</type>
      <name>openLockPM</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>lockText</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>openLockText</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KBugReport</name>
    <filename>classKBugReport.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>KBugReport</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, bool modal=true, const KAboutData *aboutData=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KBugReport</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotConfigureEmail</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotSetFrom</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotUrlClicked</name>
      <anchor>j2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotOk</name>
      <anchor>j3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotCancel</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>appChanged</name>
      <anchor>j5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>updateURL</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>text</name>
      <anchor>b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>sendBugReport</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KProcess *</type>
      <name>m_process</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>const KAboutData *</type>
      <name>m_aboutData</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMultiLineEdit *</type>
      <name>m_lineedit</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLineEdit *</type>
      <name>m_subject</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>m_from</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>m_version</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>m_strVersion</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QHButtonGroup *</type>
      <name>m_bgSeverity</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPushButton *</type>
      <name>m_configureEmail</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KButtonBox</name>
    <filename>classKButtonBox.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>KButtonBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, Orientation _orientation=Horizontal, int border=0, int _autoborder=6)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KButtonBox</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSizePolicy</type>
      <name>sizePolicy</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>a4</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>addButton</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, bool noexpand=false)</arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>addButton</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;text, QObject *receiver, const char *slot, bool noexpand=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addStretch</name>
      <anchor>a7</anchor>
      <arglist>(int scale=1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>layout</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSize</type>
      <name>bestButtonSize</name>
      <anchor>b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>placeButtons</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSize</type>
      <name>buttonSizeHint</name>
      <anchor>b2</anchor>
      <arglist>(QPushButton *) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCharSelect</name>
    <filename>classKCharSelect.html</filename>
    <base>QVBox</base>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l0</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l2</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fontChanged</name>
      <anchor>l4</anchor>
      <arglist>(const QString &amp;_font)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>focusItemChanged</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>focusItemChanged</name>
      <anchor>l6</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCharSelect</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, const QString &amp;font=QString::null, const QChar &amp;chr= &apos; &apos;, int tableNum=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;font)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setChar</name>
      <anchor>a3</anchor>
      <arglist>(const QChar &amp;chr)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTableNum</name>
      <anchor>a4</anchor>
      <arglist>(int tableNum)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QChar</type>
      <name>chr</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>font</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>tableNum</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>enableFontCombo</name>
      <anchor>a8</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>enableTableSpinBox</name>
      <anchor>a9</anchor>
      <arglist>(bool e)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isFontComboEnabled</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isTableSpinBoxEnabled</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>fontSelected</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;_font)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>tableChanged</name>
      <anchor>j1</anchor>
      <arglist>(int _value)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charHighlighted</name>
      <anchor>j2</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charHighlighted</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charActivated</name>
      <anchor>j4</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charActivated</name>
      <anchor>j5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charFocusItemChanged</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charFocusItemChanged</name>
      <anchor>j7</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charTableUp</name>
      <anchor>j8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>charTableDown</name>
      <anchor>j9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDoubleClicked</name>
      <anchor>j10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fillFontCombo</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="function" protection="public" static="yes">
      <type>void</type>
      <name>cleanupFontDatabase</name>
      <anchor>f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QComboBox *</type>
      <name>fontCombo</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSpinBox *</type>
      <name>tableSpinBox</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KCharSelectTable *</type>
      <name>charTable</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>fontList</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>QFontDatabase *</type>
      <name>fontDataBase</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCharSelectTable</name>
    <filename>classKCharSelectTable.html</filename>
    <base>QGridView</base>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l0</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l2</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>focusItemChanged</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>focusItemChanged</name>
      <anchor>l5</anchor>
      <arglist>(const QChar &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tableUp</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tableDown</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCharSelectTable</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, const QString &amp;_font, const QChar &amp;_chr, int _tableNum)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>a2</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;_font)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setChar</name>
      <anchor>a4</anchor>
      <arglist>(const QChar &amp;_chr)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTableNum</name>
      <anchor>a5</anchor>
      <arglist>(int _tableNum)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QChar</type>
      <name>chr</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintCell</name>
      <anchor>b0</anchor>
      <arglist>(class QPainter *p, int row, int col)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b5</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>gotoLeft</name>
      <anchor>b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>gotoRight</name>
      <anchor>b7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>gotoUp</name>
      <anchor>b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>gotoDown</name>
      <anchor>b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b10</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>vFont</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QChar</type>
      <name>vChr</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>vTableNum</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPoint</type>
      <name>vPos</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QChar</type>
      <name>focusItem</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPoint</type>
      <name>focusPos</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>temp</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCModule</name>
    <filename>classKCModule.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>Button</name>
      <anchor>w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>changed</name>
      <anchor>l0</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>quickHelpChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCModule</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, const QStringList &amp;args=QStringList())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCModule</name>
      <anchor>a1</anchor>
      <arglist>(KInstance *instance, QWidget *parent=0, const QStringList &amp;args=QStringList())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>load</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>defaults</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sysdefaults</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>quickHelp</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KAboutData *</type>
      <name>aboutData</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>buttons</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>rootOnlyMsg</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>useRootOnlyMsg</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KInstance *</type>
      <name>instance</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setButtons</name>
      <anchor>b0</anchor>
      <arglist>(int btn)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setRootOnlyMsg</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setUseRootOnlyMsg</name>
      <anchor>b2</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColor</name>
    <filename>classKColor.html</filename>
    <base>QColor</base>
    <member kind="function">
      <type></type>
      <name>KColor</name>
      <anchor>a1</anchor>
      <arglist>(const KColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColor</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>KColor &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const KColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a4</anchor>
      <arglist>(const KColor &amp;col) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHsv</name>
      <anchor>a5</anchor>
      <arglist>(int _h, int _s, int _v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRgb</name>
      <anchor>a6</anchor>
      <arglist>(int _r, int _g, int _b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rgb</name>
      <anchor>a7</anchor>
      <arglist>(int *_r, int *_g, int *_b) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hsv</name>
      <anchor>a8</anchor>
      <arglist>(int *_h, int *_s, int *_v) const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>h</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>s</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>v</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>r</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>g</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>b</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorButton</name>
    <filename>classKColorButton.html</filename>
    <base>QPushButton</base>
    <member kind="signal">
      <type>void</type>
      <name>changed</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;newColor)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorButton</name>
      <anchor>a1</anchor>
      <arglist>(const QColor &amp;c, QWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorButton</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;c, const QColor &amp;defaultColor, QWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KColorButton</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a5</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>chooseColor</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawButtonLabel</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragEnterEvent</name>
      <anchor>b1</anchor>
      <arglist>(QDragEnterEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b2</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b5</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorCells</name>
    <filename>classKColorCells.html</filename>
    <base>QGridView</base>
    <member kind="signal">
      <type>void</type>
      <name>colorSelected</name>
      <anchor>l0</anchor>
      <arglist>(int col)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>colorDoubleClicked</name>
      <anchor>l1</anchor>
      <arglist>(int col)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorCells</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int rows, int cols)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a2</anchor>
      <arglist>(int colNum, const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a3</anchor>
      <arglist>(int indx) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numCells</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShading</name>
      <anchor>a5</anchor>
      <arglist>(bool _shade)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAcceptDrags</name>
      <anchor>a6</anchor>
      <arglist>(bool _acceptDrags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getSelected</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintCell</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *painter, int row, int col)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragEnterEvent</name>
      <anchor>b5</anchor>
      <arglist>(QDragEnterEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b6</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b7</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>posToCell</name>
      <anchor>b8</anchor>
      <arglist>(const QPoint &amp;pos, bool ignoreBorders=false)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b9</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QColor *</type>
      <name>colors</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>inMouse</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPoint</type>
      <name>mPos</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>selected</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>shade</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>acceptDrags</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorCombo</name>
    <filename>classKColorCombo.html</filename>
    <base>QComboBox</base>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l1</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorCombo</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showEmptyList</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *re)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorDialog</name>
    <filename>classKColorDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="slot">
      <type>void</type>
      <name>setColor</name>
      <anchor>i0</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>colorSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L, bool modal=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KColorDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultColor</name>
      <anchor>a3</anchor>
      <arglist>(const QColor &amp;defaultCol)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>defaultColor</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getColor</name>
      <anchor>e0</anchor>
      <arglist>(QColor &amp;theColor, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getColor</name>
      <anchor>e1</anchor>
      <arglist>(QColor &amp;theColor, const QColor &amp;defaultColor, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>grabColor</name>
      <anchor>e2</anchor>
      <arglist>(const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b2</anchor>
      <arglist>(QObject *obj, QEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorDrag</name>
    <filename>classKColorDrag.html</filename>
    <base>QStoredDrag</base>
    <member kind="function">
      <type></type>
      <name>KColorDrag</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *dragsource=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorDrag</name>
      <anchor>a1</anchor>
      <arglist>(const QColor &amp;col, QWidget *dragsource=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const char *</type>
      <name>format</name>
      <anchor>a3</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QByteArray</type>
      <name>encodedData</name>
      <anchor>a4</anchor>
      <arglist>(const char *m) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a5</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>canDecode</name>
      <anchor>e0</anchor>
      <arglist>(QMimeSource *e)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>decode</name>
      <anchor>e1</anchor>
      <arglist>(QMimeSource *e, QColor &amp;col)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KColorDrag *</type>
      <name>makeDrag</name>
      <anchor>e2</anchor>
      <arglist>(const QColor &amp;, QWidget *dragsource) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KColorPatch</name>
    <filename>classKColorPatch.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>colorChanged</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KColorPatch</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *painter)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragEnterEvent</name>
      <anchor>b2</anchor>
      <arglist>(QDragEnterEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b3</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KComboBox</name>
    <filename>classKComboBox.html</filename>
    <base>QComboBox</base>
    <base>KCompletionBase</base>
    <member kind="slot">
      <type>void</type>
      <name>rotateText</name>
      <anchor>i0</anchor>
      <arglist>(KCompletionBase::KeyBindingType type)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletedText</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCompletedItems</name>
      <anchor>i2</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCurrentItem</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;item, bool insert=false, int index=-1)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCurrentItem</name>
      <anchor>i4</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>returnPressed</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>returnPressed</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>completion</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>substringCompletion</name>
      <anchor>l3</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>textRotation</name>
      <anchor>l4</anchor>
      <arglist>(KCompletionBase::KeyBindingType)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>completionModeChanged</name>
      <anchor>l5</anchor>
      <arglist>(KGlobalSettings::Completion)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowContextMenu</name>
      <anchor>l6</anchor>
      <arglist>(QPopupMenu *p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KComboBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KComboBox</name>
      <anchor>a1</anchor>
      <arglist>(bool rw, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KComboBox</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEditURL</name>
      <anchor>a3</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertURL</name>
      <anchor>a4</anchor>
      <arglist>(const KURL &amp;url, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertURL</name>
      <anchor>a5</anchor>
      <arglist>(const QPixmap &amp;pixmap, const KURL &amp;url, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeURL</name>
      <anchor>a6</anchor>
      <arglist>(const KURL &amp;url, int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeURL</name>
      <anchor>a7</anchor>
      <arglist>(const QPixmap &amp;pixmap, const KURL &amp;url, int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cursorPosition</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setAutoCompletion</name>
      <anchor>a9</anchor>
      <arglist>(bool autocomplete)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoCompletion</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setContextMenuEnabled</name>
      <anchor>a11</anchor>
      <arglist>(bool showMenu)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isContextMenuEnabled</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setURLDropsEnabled</name>
      <anchor>a13</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isURLDropsEnabled</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;text) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTrapReturnKey</name>
      <anchor>a16</anchor>
      <arglist>(bool trap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trapReturnKey</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a18</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function">
      <type>KCompletionBox *</type>
      <name>completionBox</name>
      <anchor>a19</anchor>
      <arglist>(bool create=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLineEdit</name>
      <anchor>a20</anchor>
      <arglist>(QLineEdit *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>itemSelected</name>
      <anchor>j0</anchor>
      <arglist>(QListBoxItem *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>makeCompletion</name>
      <anchor>j1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletedText</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;, bool)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>create</name>
      <anchor>b1</anchor>
      <arglist>(WId=0, bool initializeWindow=true, bool destroyOldWindow=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>wheelEvent</name>
      <anchor>b2</anchor>
      <arglist>(QWheelEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCommand</name>
    <filename>classKCommand.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>execute</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>unexecute</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KCommand</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCommandHistory</name>
    <filename>classKCommandHistory.html</filename>
    <base>QObject</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>undo</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>redo</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>documentSaved</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>commandExecuted</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>documentRestored</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCommandHistory</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCommandHistory</name>
      <anchor>a1</anchor>
      <arglist>(KActionCollection *actionCollection, bool withMenus=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCommandHistory</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCommand</name>
      <anchor>a4</anchor>
      <arglist>(KCommand *command, bool execute=true)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>undoLimit</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUndoLimit</name>
      <anchor>a6</anchor>
      <arglist>(int limit)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>redoLimit</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRedoLimit</name>
      <anchor>a8</anchor>
      <arglist>(int limit)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateActions</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotUndoAboutToShow</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotUndoActivated</name>
      <anchor>j1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotRedoAboutToShow</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotRedoActivated</name>
      <anchor>j3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCompletionBox</name>
    <filename>classKCompletionBox.html</filename>
    <base>KListBox</base>
    <member kind="slot">
      <type>QStringList</type>
      <name>items</name>
      <anchor>i0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>insertItems</name>
      <anchor>i1</anchor>
      <arglist>(const QStringList &amp;items, int index=-1)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setItems</name>
      <anchor>i2</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>popup</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTabHandling</name>
      <anchor>i4</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>isTabHandling</name>
      <anchor>i5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCancelledText</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;txt)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>cancelledText</name>
      <anchor>i7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>down</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>up</name>
      <anchor>i9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>pageDown</name>
      <anchor>i10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>pageUp</name>
      <anchor>i11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>home</name>
      <anchor>i12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>end</name>
      <anchor>i13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>i14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>hide</name>
      <anchor>i15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>userCancelled</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCompletionBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KCompletionBox</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j0</anchor>
      <arglist>(QListBoxItem *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QRect</type>
      <name>calculateGeometry</name>
      <anchor>b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>sizeAndPosition</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b2</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigDialog</name>
    <filename>classKConfigDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="signal">
      <type>void</type>
      <name>widgetModified</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>settingsChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>settingsChanged</name>
      <anchor>l2</anchor>
      <arglist>(const char *dialogName)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, KConfigSkeleton *config, KDialogBase::DialogType dialogType=KDialogBase::IconList, int dialogButtons=KDialogBase::Default|KDialogBase::Ok|KDialogBase::Apply|KDialogBase::Cancel|KDialogBase::Help, KDialogBase::ButtonCode defaultButton=Ok, bool modal=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KConfigDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPage</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *page, const QString &amp;itemName, const QString &amp;pixmapName, const QString &amp;header=QString::null, bool manage=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KConfigDialog *</type>
      <name>exists</name>
      <anchor>e0</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>showDialog</name>
      <anchor>e1</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateSettings</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateWidgets</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateWidgetsDefault</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>updateButtons</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>settingsChangedSlot</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>hasChanged</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>isDefault</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KContextMenuManager</name>
    <filename>classKContextMenuManager.html</filename>
    <base>QObject</base>
    <member kind="function" static="yes">
      <type>void</type>
      <name>insert</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *widget, QPopupMenu *popup)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>showOnButtonPress</name>
      <anchor>e1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>I_really_like_this_class</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCursor</name>
    <filename>classKCursor.html</filename>
    <base>Qt</base>
    <member kind="function">
      <type></type>
      <name>KCursor</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>handCursor</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>workingCursor</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>arrowCursor</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>upArrowCursor</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>crossCursor</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>waitCursor</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>ibeamCursor</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>sizeVerCursor</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>sizeHorCursor</name>
      <anchor>e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>sizeBDiagCursor</name>
      <anchor>e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>sizeFDiagCursor</name>
      <anchor>e10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>sizeAllCursor</name>
      <anchor>e11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>blankCursor</name>
      <anchor>e12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCursor</type>
      <name>whatsThisCursor</name>
      <anchor>e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setAutoHideCursor</name>
      <anchor>e14</anchor>
      <arglist>(QWidget *w, bool enable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setAutoHideCursor</name>
      <anchor>e15</anchor>
      <arglist>(QWidget *w, bool enable, bool customEventFilter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setHideCursorDelay</name>
      <anchor>e16</anchor>
      <arglist>(int ms)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>hideCursorDelay</name>
      <anchor>e17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>autoHideEventFilter</name>
      <anchor>e18</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCursorPrivateAutoHideEventFilter</name>
    <filename>classKCursorPrivateAutoHideEventFilter.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>KCursorPrivateAutoHideEventFilter</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a2</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetWidget</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateInternalMonthPicker</name>
    <filename>classKDateInternalMonthPicker.html</filename>
    <base>QGridView</base>
    <member kind="signal">
      <type>void</type>
      <name>closeMe</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateInternalMonthPicker</name>
      <anchor>a0</anchor>
      <arglist>(const QDate &amp;date, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KDateInternalMonthPicker</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getResult</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setupPainter</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportResizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintCell</name>
      <anchor>b2</anchor>
      <arglist>(QPainter *painter, int row, int col)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>b5</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>result</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>short int</type>
      <name>activeCol</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>short int</type>
      <name>activeRow</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRect</type>
      <name>max</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateInternalWeekSelector</name>
    <filename>classKDateInternalWeekSelector.html</filename>
    <base>QLineEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>weekEnteredSlot</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMaxWeek</name>
      <anchor>i1</anchor>
      <arglist>(int max)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeMe</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateInternalWeekSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getWeek</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWeek</name>
      <anchor>a2</anchor>
      <arglist>(int week)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QIntValidator *</type>
      <name>val</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>result</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateInternalYearSelector</name>
    <filename>classKDateInternalYearSelector.html</filename>
    <base>QLineEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>yearEnteredSlot</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeMe</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateInternalYearSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getYear</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setYear</name>
      <anchor>a2</anchor>
      <arglist>(int year)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QIntValidator *</type>
      <name>val</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>result</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDatePicker</name>
    <filename>classKDatePicker.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>dateChanged</name>
      <anchor>l0</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dateSelected</name>
      <anchor>l1</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dateEntered</name>
      <anchor>l2</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tableClicked</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDatePicker</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, QDate=QDate::currentDate(), const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDatePicker</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent, QDate, const char *name, WFlags f)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDatePicker</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDatePicker</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setDate</name>
      <anchor>a5</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const QDate &amp;</type>
      <name>getDate</name>
      <anchor>a6</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>const QDate &amp;</type>
      <name>date</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnabled</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>KDateTable *</type>
      <name>dateTable</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontSize</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fontSize</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCloseButton</name>
      <anchor>a12</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasCloseButton</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>dateChangedSlot</name>
      <anchor>j0</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>tableClickedSlot</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>monthForwardClicked</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>monthBackwardClicked</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>yearForwardClicked</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>yearBackwardClicked</name>
      <anchor>j5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>selectWeekClicked</name>
      <anchor>j6</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>selectMonthClicked</name>
      <anchor>j7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>selectYearClicked</name>
      <anchor>j8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>lineEnterPressed</name>
      <anchor>j9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>todayButtonClicked</name>
      <anchor>j10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>weekSelected</name>
      <anchor>j11</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>yearForward</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>yearBackward</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>monthForward</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>monthBackward</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>selectMonth</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QToolButton *</type>
      <name>selectYear</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLineEdit *</type>
      <name>line</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDateValidator *</type>
      <name>val</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDateTable *</type>
      <name>table</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSize</type>
      <name>maxMonthRect</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateTable</name>
    <filename>classKDateTable.html</filename>
    <base>QGridView</base>
    <member kind="signal">
      <type>void</type>
      <name>dateChanged</name>
      <anchor>l0</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dateChanged</name>
      <anchor>l1</anchor>
      <arglist>(const QDate &amp;cur, const QDate &amp;old)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tableClicked</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowContextMenu</name>
      <anchor>l3</anchor>
      <arglist>(KPopupMenu *menu, const QDate &amp;date)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateTable</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, QDate date=QDate::currentDate(), const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KDateTable</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFontSize</name>
      <anchor>a3</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setDate</name>
      <anchor>a4</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const QDate &amp;</type>
      <name>getDate</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPopupMenuEnabled</name>
      <anchor>a6</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>popupMenuEnabled</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomDatePainting</name>
      <anchor>a8</anchor>
      <arglist>(const QDate &amp;date, const QColor &amp;fgColor, BackgroundMode bgMode=NoBgMode, const QColor &amp;bgColor=QColor())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetCustomDatePainting</name>
      <anchor>a9</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>posFromDate</name>
      <anchor>b0</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QDate</type>
      <name>dateFromPos</name>
      <anchor>b1</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintCell</name>
      <anchor>b2</anchor>
      <arglist>(QPainter *, int, int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportResizeEvent</name>
      <anchor>b3</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>wheelEvent</name>
      <anchor>b5</anchor>
      <arglist>(QWheelEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b6</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b7</anchor>
      <arglist>(QFocusEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b8</anchor>
      <arglist>(QFocusEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b9</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>fontsize</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QDate</type>
      <name>date</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>firstday</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>numdays</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>numDaysPrevMonth</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>unused_hasSelection</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRect</type>
      <name>maxCell</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateTimeWidget</name>
    <filename>classKDateTimeWidget.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setDateTime</name>
      <anchor>i0</anchor>
      <arglist>(const QDateTime &amp;datetime)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(const QDateTime &amp;datetime)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateTimeWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateTimeWidget</name>
      <anchor>a1</anchor>
      <arglist>(const QDateTime &amp;datetime, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDateTimeWidget</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>dateTime</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateValidator</name>
    <filename>classKDateValidator.html</filename>
    <base>QValidator</base>
    <member kind="function">
      <type></type>
      <name>KDateValidator</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual State</type>
      <name>validate</name>
      <anchor>a1</anchor>
      <arglist>(QString &amp;, int &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>fixup</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;input) const </arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>date</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;, QDate &amp;) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDateWidget</name>
    <filename>classKDateWidget.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>changed</name>
      <anchor>l0</anchor>
      <arglist>(QDate)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDateWidget</name>
      <anchor>a1</anchor>
      <arglist>(QDate date, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDateWidget</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>date</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDate</name>
      <anchor>a4</anchor>
      <arglist>(QDate date)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDateChanged</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b1</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDCOPActionProxy</name>
    <filename>classKDCOPActionProxy.html</filename>
    <base>DCOPObjectProxy</base>
    <member kind="function">
      <type></type>
      <name>KDCOPActionProxy</name>
      <anchor>a0</anchor>
      <arglist>(KActionCollection *actionCollection, DCOPObject *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDCOPActionProxy</name>
      <anchor>a1</anchor>
      <arglist>(DCOPObject *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KDCOPActionProxy</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QValueList&lt; KAction * &gt;</type>
      <name>actions</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KAction *</type>
      <name>action</name>
      <anchor>a4</anchor>
      <arglist>(const char *name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QCString</type>
      <name>actionObjectId</name>
      <anchor>a5</anchor>
      <arglist>(const QCString &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QMap&lt; QCString, DCOPRef &gt;</type>
      <name>actionMap</name>
      <anchor>a6</anchor>
      <arglist>(const QCString &amp;appId=QCString()) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>process</name>
      <anchor>a7</anchor>
      <arglist>(const QCString &amp;obj, const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>processAction</name>
      <anchor>a8</anchor>
      <arglist>(const QCString &amp;obj, const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData, KAction *action)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDialog</name>
    <filename>classKDialog.html</filename>
    <base>QDialog</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>polish</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCaption</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;caption)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setPlainCaption</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;caption)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>layoutHintChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=false, WFlags f=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>marginHint</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>spacingHint</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>resizeLayout</name>
      <anchor>e2</anchor>
      <arglist>(QWidget *widget, int margin, int spacing)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>resizeLayout</name>
      <anchor>e3</anchor>
      <arglist>(QLayoutItem *lay, int margin, int spacing)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>centerOnScreen</name>
      <anchor>e4</anchor>
      <arglist>(QWidget *widget, int screen=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>avoidArea</name>
      <anchor>e5</anchor>
      <arglist>(QWidget *widget, const QRect &amp;area, int screen=-1)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDialogBase</name>
    <filename>classKDialogBase.html</filename>
    <base>KDialog</base>
    <member kind="enumeration">
      <name>ButtonCode</name>
      <anchor>w26</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DialogType</name>
      <anchor>w28</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableButton</name>
      <anchor>i0</anchor>
      <arglist>(ButtonCode id, bool state)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableButtonOK</name>
      <anchor>i1</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableButtonApply</name>
      <anchor>i2</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableButtonCancel</name>
      <anchor>i3</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableLinkedHelp</name>
      <anchor>i4</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>delayedDestruct</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHelpLinkText</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHelp</name>
      <anchor>i7</anchor>
      <arglist>(const QString &amp;anchor, const QString &amp;appname=QString::null)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>helpClickedSlot</name>
      <anchor>i8</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setDetails</name>
      <anchor>i9</anchor>
      <arglist>(bool showDetails)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setDetailsWidget</name>
      <anchor>i10</anchor>
      <arglist>(QWidget *detailsWidget)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateBackground</name>
      <anchor>i11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>cancel</name>
      <anchor>i12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>helpClicked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>defaultClicked</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>user3Clicked</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>user2Clicked</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>user1Clicked</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>applyClicked</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tryClicked</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>okClicked</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>yesClicked</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>noClicked</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>cancelClicked</name>
      <anchor>l10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeClicked</name>
      <anchor>l11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>apply</name>
      <anchor>l12</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>backgroundChanged</name>
      <anchor>l13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>hidden</name>
      <anchor>l14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>finished</name>
      <anchor>l15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowDetails</name>
      <anchor>l16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowPage</name>
      <anchor>l17</anchor>
      <arglist>(QWidget *page)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialogBase</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=true, const QString &amp;caption=QString::null, int buttonMask=Ok|Apply|Cancel, ButtonCode defaultButton=Ok, bool separator=false, const KGuiItem &amp;user1=KGuiItem(), const KGuiItem &amp;user2=KGuiItem(), const KGuiItem &amp;user3=KGuiItem())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialogBase</name>
      <anchor>a1</anchor>
      <arglist>(int dialogFace, const QString &amp;caption, int buttonMask, ButtonCode defaultButton, QWidget *parent=0, const char *name=0, bool modal=true, bool separator=false, const KGuiItem &amp;user1=KGuiItem(), const KGuiItem &amp;user2=KGuiItem(), const KGuiItem &amp;user3=KGuiItem())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialogBase</name>
      <anchor>a2</anchor>
      <arglist>(KDialogBase::DialogType dialogFace, WFlags f, QWidget *parent=0, const char *name=0, bool modal=true, const QString &amp;caption=QString::null, int buttonMask=Ok|Apply|Cancel, ButtonCode defaultButton=Ok, bool separator=false, const KGuiItem &amp;user1=KGuiItem(), const KGuiItem &amp;user2=KGuiItem(), const KGuiItem &amp;user3=KGuiItem())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialogBase</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;caption, int buttonMask=Yes|No|Cancel, ButtonCode defaultButton=Yes, ButtonCode escapeButton=Cancel, QWidget *parent=0, const char *name=0, bool modal=true, bool separator=false, const KGuiItem &amp;yes=KStdGuiItem::yes(), const KGuiItem &amp;no=KStdGuiItem::no(), const KGuiItem &amp;cancel=KStdGuiItem::cancel())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KDialogBase</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonBoxOrientation</name>
      <anchor>a5</anchor>
      <arglist>(int orientation)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEscapeButton</name>
      <anchor>a6</anchor>
      <arglist>(ButtonCode id)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>adjustSize</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>plainPage</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addPage</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>addPage</name>
      <anchor>a12</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QVBox *</type>
      <name>addVBoxPage</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QVBox *</type>
      <name>addVBoxPage</name>
      <anchor>a14</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QHBox *</type>
      <name>addHBoxPage</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QHBox *</type>
      <name>addHBoxPage</name>
      <anchor>a16</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QGrid *</type>
      <name>addGridPage</name>
      <anchor>a17</anchor>
      <arglist>(int n, Orientation dir, const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>QGrid *</type>
      <name>addGridPage</name>
      <anchor>a18</anchor>
      <arglist>(int n, Orientation dir, const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFolderIcon</name>
      <anchor>a19</anchor>
      <arglist>(const QStringList &amp;path, const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function">
      <type>QFrame *</type>
      <name>makeMainWidget</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QVBox *</type>
      <name>makeVBoxMainWidget</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QHBox *</type>
      <name>makeHBoxMainWidget</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QGrid *</type>
      <name>makeGridMainWidget</name>
      <anchor>a23</anchor>
      <arglist>(int n, Orientation dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableButtonSeparator</name>
      <anchor>a24</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showButton</name>
      <anchor>a25</anchor>
      <arglist>(ButtonCode id, bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showButtonOK</name>
      <anchor>a26</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showButtonApply</name>
      <anchor>a27</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showButtonCancel</name>
      <anchor>a28</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showPage</name>
      <anchor>a29</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>activePageIndex</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>pageIndex</name>
      <anchor>a31</anchor>
      <arglist>(QWidget *widget) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMainWidget</name>
      <anchor>a32</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>mainWidget</name>
      <anchor>a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disableResize</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInitialSize</name>
      <anchor>a35</anchor>
      <arglist>(const QSize &amp;s, bool noResize=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>incInitialSize</name>
      <anchor>a36</anchor>
      <arglist>(const QSize &amp;s, bool noResize=false)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>configDialogSize</name>
      <anchor>a37</anchor>
      <arglist>(const QString &amp;groupName) const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>configDialogSize</name>
      <anchor>a38</anchor>
      <arglist>(KConfig &amp;config, const QString &amp;groupName) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveDialogSize</name>
      <anchor>a39</anchor>
      <arglist>(const QString &amp;groupName, bool global=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveDialogSize</name>
      <anchor>a40</anchor>
      <arglist>(KConfig &amp;config, const QString &amp;groupName, bool global=false) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonOK</name>
      <anchor>a41</anchor>
      <arglist>(const KGuiItem &amp;item=KStdGuiItem::ok())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonOKText</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;text=QString::null, const QString &amp;tooltip=QString::null, const QString &amp;quickhelp=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonApply</name>
      <anchor>a43</anchor>
      <arglist>(const KGuiItem &amp;item=KStdGuiItem::apply())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonApplyText</name>
      <anchor>a44</anchor>
      <arglist>(const QString &amp;text=QString::null, const QString &amp;tooltip=QString::null, const QString &amp;quickhelp=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonCancel</name>
      <anchor>a45</anchor>
      <arglist>(const KGuiItem &amp;item=KStdGuiItem::cancel())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonCancelText</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;text=QString::null, const QString &amp;tooltip=QString::null, const QString &amp;quickhelp=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonText</name>
      <anchor>a47</anchor>
      <arglist>(ButtonCode id, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonTip</name>
      <anchor>a48</anchor>
      <arglist>(ButtonCode id, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonWhatsThis</name>
      <anchor>a49</anchor>
      <arglist>(ButtonCode id, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTreeListAutoResize</name>
      <anchor>a50</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowIconsInTreeList</name>
      <anchor>a51</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRootIsDecorated</name>
      <anchor>a52</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unfoldTreeList</name>
      <anchor>a53</anchor>
      <arglist>(bool persist=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addWidgetBelowList</name>
      <anchor>a54</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButtonBelowList</name>
      <anchor>a55</anchor>
      <arglist>(const QString &amp;text, QObject *recv, const char *slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButtonBelowList</name>
      <anchor>a56</anchor>
      <arglist>(const KGuiItem &amp;guiitem, QObject *recv, const char *slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconListAllVisible</name>
      <anchor>a57</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showTile</name>
      <anchor>a58</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBorderWidths</name>
      <anchor>a59</anchor>
      <arglist>(int &amp;ulx, int &amp;uly, int &amp;lrx, int &amp;lry) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>getContentsRect</name>
      <anchor>a60</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>calculateSize</name>
      <anchor>a61</anchor>
      <arglist>(int w, int h) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>helpLinkText</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>actionButton</name>
      <anchor>a63</anchor>
      <arglist>(ButtonCode id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>haveBackgroundTile</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QPixmap *</type>
      <name>backgroundTile</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QPixmap *</type>
      <name>getBackgroundTile</name>
      <anchor>e2</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setBackgroundTile</name>
      <anchor>e3</anchor>
      <arglist>(const QPixmap *pix)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotHelp</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotDefault</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotDetails</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotUser3</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotUser2</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotUser1</name>
      <anchor>j5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotOk</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotApply</name>
      <anchor>j7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotTry</name>
      <anchor>j8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotYes</name>
      <anchor>j9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotNo</name>
      <anchor>j10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotCancel</name>
      <anchor>j11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotClose</name>
      <anchor>j12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>applyPressed</name>
      <anchor>j13</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>updateGeometry</name>
      <anchor>j14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDelayedDestruct</name>
      <anchor>j15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b1</anchor>
      <arglist>(QHideEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeEvent</name>
      <anchor>b2</anchor>
      <arglist>(QCloseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDialogBaseButton</name>
    <filename>classKDialogBaseButton.html</filename>
    <base>KPushButton</base>
    <member kind="function">
      <type></type>
      <name>KDialogBaseButton</name>
      <anchor>a0</anchor>
      <arglist>(const KGuiItem &amp;text, int key, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDialogBaseTile</name>
    <filename>classKDialogBaseTile.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>cleanup</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>pixmapChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDialogBaseTile</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchor>a2</anchor>
      <arglist>(const QPixmap *pix)</arglist>
    </member>
    <member kind="function">
      <type>const QPixmap *</type>
      <name>get</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockButton_Private</name>
    <filename>classKDockButton__Private.html</filename>
    <base>QPushButton</base>
    <member kind="function">
      <type></type>
      <name>KDockButton_Private</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawButton</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>enterEvent</name>
      <anchor>b1</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockMainWindow</name>
    <filename>classKDockMainWindow.html</filename>
    <base>KMainWindow</base>
    <member kind="signal">
      <type>void</type>
      <name>dockWidgetHasUndocked</name>
      <anchor>l0</anchor>
      <arglist>(KDockWidget *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDockMainWindow</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L, WFlags f=WType_TopLevel|WDestructiveClose)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockMainWindow</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KDockManager *</type>
      <name>manager</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMainDockWidget</name>
      <anchor>a3</anchor>
      <arglist>(KDockWidget *dockwidget)</arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>getMainDockWidget</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>createDockWidget</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;name, const QPixmap &amp;pixmap, QWidget *parent=0L, const QString &amp;strCaption=QString::null, const QString &amp;strTabPageLabel=QString::fromLatin1(&quot;&quot;))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDockConfig</name>
      <anchor>a6</anchor>
      <arglist>(QDomElement &amp;base)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDockConfig</name>
      <anchor>a7</anchor>
      <arglist>(QDomElement &amp;base)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeDockConfig</name>
      <anchor>a8</anchor>
      <arglist>(KConfig *c=0L, QString group=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readDockConfig</name>
      <anchor>a9</anchor>
      <arglist>(KConfig *c=0L, QString group=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activateDock</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>dockHideShowMenu</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeDockVisible</name>
      <anchor>a12</anchor>
      <arglist>(KDockWidget *dock)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeDockInvisible</name>
      <anchor>a13</anchor>
      <arglist>(KDockWidget *dock)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeWidgetDockVisible</name>
      <anchor>a14</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setView</name>
      <anchor>a15</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDockWidgetUndocked</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockWidget *</type>
      <name>mainDockWidget</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockManager *</type>
      <name>dockManager</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockManager</name>
    <filename>classKDockManager.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>change</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>replaceDock</name>
      <anchor>l1</anchor>
      <arglist>(KDockWidget *oldDock, KDockWidget *newDock)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>setDockDefaultPos</name>
      <anchor>l2</anchor>
      <arglist>(KDockWidget *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDockManager</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *mainWindow, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockManager</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dumpDockWidgets</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeConfig</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *c=0L, QString group=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a4</anchor>
      <arglist>(KConfig *c=0L, QString group=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMainDockWidget2</name>
      <anchor>a5</anchor>
      <arglist>(KDockWidget *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeConfig</name>
      <anchor>a6</anchor>
      <arglist>(QDomElement &amp;base)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a7</anchor>
      <arglist>(QDomElement &amp;base)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a9</anchor>
      <arglist>(QObject *object, QEvent *event)</arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>findWidgetParentDock</name>
      <anchor>a10</anchor>
      <arglist>(QWidget *w) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeWidgetDockVisible</name>
      <anchor>a11</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>dockHideShowMenu</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>getDockWidgetFromName</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;dockName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSplitterOpaqueResize</name>
      <anchor>a14</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>splitterOpaqueResize</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSplitterKeepSize</name>
      <anchor>a16</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>splitterKeepSize</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSplitterHighResolution</name>
      <anchor>a18</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>splitterHighResolution</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialLeftDockContainer</name>
      <anchor>a20</anchor>
      <arglist>(KDockWidget *container)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialTopDockContainer</name>
      <anchor>a21</anchor>
      <arglist>(KDockWidget *container)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialRightDockContainer</name>
      <anchor>a22</anchor>
      <arglist>(KDockWidget *container)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialBottomDockContainer</name>
      <anchor>a23</anchor>
      <arglist>(KDockWidget *container)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFromAutoCreateList</name>
      <anchor>a24</anchor>
      <arglist>(KDockWidget *pDockWidget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>finishReadDockConfig</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReadDockConfigMode</name>
      <anchor>a26</anchor>
      <arglist>(int mode)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KDockMainWindow</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockSplitter</name>
    <filename>classKDockSplitter.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>KDockSplitter</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, Orientation orient=Vertical, int pos=50, bool highResolution=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *c0, QWidget *c1=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deactivate</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>separatorPos</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSeparatorPos</name>
      <anchor>a5</anchor>
      <arglist>(int pos, bool do_resize=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a6</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>a7</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>getFirst</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>getLast</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>getAnother</name>
      <anchor>a10</anchor>
      <arglist>(QWidget *) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateName</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOpaqueResize</name>
      <anchor>a12</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>opaqueResize</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeepSize</name>
      <anchor>a14</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keepSize</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHighResolution</name>
      <anchor>a16</anchor>
      <arglist>(bool b=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>highResolution</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForcedFixedWidth</name>
      <anchor>a18</anchor>
      <arglist>(KDockWidget *dw, int w)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForcedFixedHeight</name>
      <anchor>a19</anchor>
      <arglist>(KDockWidget *dw, int h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restoreFromForcedFixedSize</name>
      <anchor>a20</anchor>
      <arglist>(KDockWidget *dw)</arglist>
    </member>
    <member kind="function">
      <type>Orientation</type>
      <name>orientation</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>checkValue</name>
      <anchor>b0</anchor>
      <arglist>(int) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>checkValueOverlapped</name>
      <anchor>b1</anchor>
      <arglist>(int,QWidget *) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b2</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>KDockContainer</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockTabGroup</name>
    <filename>classKDockTabGroup.html</filename>
    <base>QTabWidget</base>
    <member kind="function">
      <type></type>
      <name>KDockTabGroup</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockTabGroup</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>transientTo</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidget</name>
    <filename>classKDockWidget.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>DockPosition</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DockToSpecialSites</name>
      <anchor>w11w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setForcedFixedWidth</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setForcedFixedHeight</name>
      <anchor>i1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>restoreFromForcedFixedSize</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>int</type>
      <name>forcedFixedWidth</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>int</type>
      <name>forcedFixedHeight</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>dockBack</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>changeHideShowState</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>undock</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>toDesktop</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>widgetSet</name>
      <anchor>l0</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>docking</name>
      <anchor>l1</anchor>
      <arglist>(KDockWidget *dw, KDockWidget::DockPosition dp)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>setDockDefaultPos</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>headerCloseButtonClicked</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>headerDockbackButtonClicked</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>iMBeingClosed</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>hasUndocked</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDockWidget</name>
      <anchor>a0</anchor>
      <arglist>(KDockManager *dockManager, const char *name, const QPixmap &amp;pixmap, QWidget *parent=0L, const QString &amp;strCaption=QString::null, const QString &amp;strTabPageLabel=QString::fromLatin1(&quot;&quot;), WFlags f=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockWidget</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>manualDock</name>
      <anchor>a2</anchor>
      <arglist>(KDockWidget *target, DockPosition dockPos, int spliPos=50, QPoint pos=QPoint(0, 0), bool check=false, int tabIndex=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnableDocking</name>
      <anchor>a3</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>enableDocking</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDockSite</name>
      <anchor>a5</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dockSite</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidget</name>
      <anchor>a7</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>getWidget</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeader</name>
      <anchor>a9</anchor>
      <arglist>(KDockWidgetAbstractHeader *ah)</arglist>
    </member>
    <member kind="function">
      <type>KDockWidgetAbstractHeader *</type>
      <name>getHeader</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeDockVisible</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mayBeHide</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mayBeShow</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDockManager *</type>
      <name>dockManager</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToolTipString</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;ttStr)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>toolTipString</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDockBackPossible</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabPageLabel</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>tabPageLabel</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>a20</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KDockTabGroup *</type>
      <name>parentDockTabGroup</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>parentDockContainer</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDockWindowType</name>
      <anchor>a24</anchor>
      <arglist>(NET::WindowType windowType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDockWindowTransient</name>
      <anchor>a25</anchor>
      <arglist>(QWidget *parent, bool transientEnabled)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>transientTo</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>findNearestDockWidget</name>
      <anchor>a27</anchor>
      <arglist>(DockPosition pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixmap</name>
      <anchor>a28</anchor>
      <arglist>(const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>const QPixmap &amp;</type>
      <name>pixmap</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>loseFormerBrotherDockWidget</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>j1</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>j2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>j3</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>j4</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>j5</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>updateHeader</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setLatestKDockContainer</name>
      <anchor>b1</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QWidget *</type>
      <name>latestKDockContainer</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockWidget *</type>
      <name>formerBrotherDockWidget</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DockPosition</type>
      <name>currentDockPos</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>DockPosition</type>
      <name>formerDockPos</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>toolTipStr</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>tabPageTitle</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KDockSplitter</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KDockMainWindow</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KDockArea</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>KMdiMainFrm</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>KDockWidgetHeader</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidgetAbstractHeader</name>
    <filename>classKDockWidgetAbstractHeader.html</filename>
    <base>QFrame</base>
    <member kind="function">
      <type></type>
      <name>KDockWidgetAbstractHeader</name>
      <anchor>a0</anchor>
      <arglist>(KDockWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockWidgetAbstractHeader</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTopLevel</name>
      <anchor>a2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>saveConfig</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>loadConfig</name>
      <anchor>a4</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidgetAbstractHeaderDrag</name>
    <filename>classKDockWidgetAbstractHeaderDrag.html</filename>
    <base>QFrame</base>
    <member kind="function">
      <type></type>
      <name>KDockWidgetAbstractHeaderDrag</name>
      <anchor>a0</anchor>
      <arglist>(KDockWidgetAbstractHeader *parent, KDockWidget *dock, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockWidgetAbstractHeaderDrag</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KDockWidget *</type>
      <name>dockWidget</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidgetHeader</name>
    <filename>classKDockWidgetHeader.html</filename>
    <base>KDockWidgetAbstractHeader</base>
    <member kind="function">
      <type></type>
      <name>KDockWidgetHeader</name>
      <anchor>a0</anchor>
      <arglist>(KDockWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockWidgetHeader</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTopLevel</name>
      <anchor>a2</anchor>
      <arglist>(bool t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDragPanel</name>
      <anchor>a3</anchor>
      <arglist>(KDockWidgetHeaderDrag *nd)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dragEnabled</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDragEnabled</name>
      <anchor>a5</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showUndockButton</name>
      <anchor>a6</anchor>
      <arglist>(bool show)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forceCloseButtonHidden</name>
      <anchor>a7</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>saveConfig</name>
      <anchor>a8</anchor>
      <arglist>(KConfig *c)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>loadConfig</name>
      <anchor>a9</anchor>
      <arglist>(KConfig *c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButton</name>
      <anchor>a10</anchor>
      <arglist>(KDockButton_Private *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeButton</name>
      <anchor>a11</anchor>
      <arglist>(KDockButton_Private *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotStayClicked</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QHBoxLayout *</type>
      <name>layout</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockButton_Private *</type>
      <name>closeButton</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockButton_Private *</type>
      <name>stayButton</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockButton_Private *</type>
      <name>dockbackButton</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDockWidgetHeaderDrag *</type>
      <name>drag</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidgetHeaderDrag</name>
    <filename>classKDockWidgetHeaderDrag.html</filename>
    <base>KDockWidgetAbstractHeaderDrag</base>
    <member kind="function">
      <type></type>
      <name>KDockWidgetHeaderDrag</name>
      <anchor>a0</anchor>
      <arglist>(KDockWidgetAbstractHeader *parent, KDockWidget *dock, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDockWidgetHeaderDrag</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>b0</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWidgetPrivate</name>
    <filename>classKDockWidgetPrivate.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>slotFocusEmbeddedWidget</name>
      <anchor>i0</anchor>
      <arglist>(QWidget *w=0L)</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>index</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>splitPosInPercent</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>pendingFocusInEvent</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>blockHasUndockedSignal</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>pendingDtor</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>forcedWidth</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>forcedHeight</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>isContainer</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NET::WindowType</type>
      <name>windowType</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QWidget *</type>
      <name>_parent</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>transient</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QGuardedPtr&lt; QWidget &gt;</type>
      <name>container</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QPoint</type>
      <name>resizePos</name>
      <anchor>o12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>resizing</name>
      <anchor>o13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>KDockWidgetResize</type>
      <name>resizeMode</name>
      <anchor>o14</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDockWindow</name>
    <filename>classKDockWindow.html</filename>
    <base>KSystemTray</base>
    <member kind="function">
      <type></type>
      <name>KDockWindow</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDoubleNumInput</name>
    <filename>classKDoubleNumInput.html</filename>
    <base>KNumInput</base>
    <member kind="slot">
      <type>void</type>
      <name>setValue</name>
      <anchor>i0</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRelativeValue</name>
      <anchor>i1</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setReferencePoint</name>
      <anchor>i2</anchor>
      <arglist>(double ref)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSuffix</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;suffix)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPrefix</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;prefix)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>relativeValueChanged</name>
      <anchor>l1</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleNumInput</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleNumInput</name>
      <anchor>a1</anchor>
      <arglist>(double value, QWidget *parent=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleNumInput</name>
      <anchor>a2</anchor>
      <arglist>(double lower, double upper, double value, double step=0.01, int precision=2, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDoubleNumInput</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleNumInput</name>
      <anchor>a4</anchor>
      <arglist>(KNumInput *below, double value, QWidget *parent=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleNumInput</name>
      <anchor>a5</anchor>
      <arglist>(KNumInput *below, double lower, double upper, double value, double step=0.02, int precision=2, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>value</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>suffix</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prefix</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>precision</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>specialValueText</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a11</anchor>
      <arglist>(double min, double max, double step=1, bool slider=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a12</anchor>
      <arglist>(double min)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>minValue</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a14</anchor>
      <arglist>(double max)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>maxValue</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecision</name>
      <anchor>a16</anchor>
      <arglist>(int precision)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>referencePoint</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>relativeValue</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialValueText</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLabel</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;label, int a=AlignLeft|AlignTop)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a22</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>doLayout</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resetEditBox</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KDoubleLine *</type>
      <name>edit</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_range</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>m_lower</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>m_upper</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>double</type>
      <name>m_step</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSize</type>
      <name>m_sizeEdit</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>KDoubleLine</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDoubleSpinBox</name>
    <filename>classKDoubleSpinBox.html</filename>
    <base>QSpinBox</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setValue</name>
      <anchor>i0</anchor>
      <arglist>(double value)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(double value)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleSpinBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleSpinBox</name>
      <anchor>a1</anchor>
      <arglist>(double lower, double upper, double step, double value, int precision=2, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acceptLocalizedNumbers</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setAcceptLocalizedNumbers</name>
      <anchor>a4</anchor>
      <arglist>(bool accept)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a5</anchor>
      <arglist>(double lower, double upper, double step=0.01, int precision=2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>precision</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrecision</name>
      <anchor>a7</anchor>
      <arglist>(int precision)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPrecision</name>
      <anchor>a8</anchor>
      <arglist>(int precision, bool force)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>value</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>minValue</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a11</anchor>
      <arglist>(double value)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>maxValue</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a13</anchor>
      <arglist>(double value)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>lineStep</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLineStep</name>
      <anchor>a15</anchor>
      <arglist>(double step)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValidator</name>
      <anchor>a16</anchor>
      <arglist>(const QValidator *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotValueChanged</name>
      <anchor>j0</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QString</type>
      <name>mapValueToText</name>
      <anchor>b0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>mapTextToValue</name>
      <anchor>b1</anchor>
      <arglist>(bool *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDoubleValidator</name>
    <filename>classKDoubleValidator.html</filename>
    <base>QDoubleValidator</base>
    <member kind="function">
      <type></type>
      <name>KDoubleValidator</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDoubleValidator</name>
      <anchor>a1</anchor>
      <arglist>(double bottom, double top, int decimals, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDoubleValidator</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QValidator::State</type>
      <name>validate</name>
      <anchor>a3</anchor>
      <arglist>(QString &amp;input, int &amp;pos) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acceptLocalizedNumbers</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAcceptLocalizedNumbers</name>
      <anchor>a5</anchor>
      <arglist>(bool accept)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDualColorButton</name>
    <filename>classKDualColorButton.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setForeground</name>
      <anchor>i0</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBackground</name>
      <anchor>i1</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCurrent</name>
      <anchor>i2</anchor>
      <arglist>(DualColor s)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCurrentColor</name>
      <anchor>i3</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fgChanged</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>bgChanged</name>
      <anchor>l1</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>currentChanged</name>
      <anchor>l2</anchor>
      <arglist>(KDualColorButton::DualColor s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDualColorButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, QWidget *dialogParent=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KDualColorButton</name>
      <anchor>a1</anchor>
      <arglist>(const QColor &amp;fgColor, const QColor &amp;bgColor, QWidget *parent=0, const char *name=0, QWidget *dialogParent=0)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>foreground</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>background</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DualColor</type>
      <name>current</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>currentColor</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>metrics</name>
      <anchor>b0</anchor>
      <arglist>(QRect &amp;fgRect, QRect &amp;bgRect)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>b1</anchor>
      <arglist>(QPaintEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragEnterEvent</name>
      <anchor>b5</anchor>
      <arglist>(QDragEnterEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b6</anchor>
      <arglist>(QDropEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KEdit</name>
    <filename>classKEdit.html</filename>
    <base>QMultiLineEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>corrected</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;originalword, const QString &amp;newword, unsigned int pos)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>misspelling</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;word, const QStringList &amp;, unsigned int pos)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>gotUrlDrop</name>
      <anchor>l0</anchor>
      <arglist>(QDropEvent *e)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>CursorPositionChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toggle_overwrite_signal</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEdit</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *_parent=NULL, const char *name=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertText</name>
      <anchor>a2</anchor>
      <arglist>(QTextStream *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveText</name>
      <anchor>a3</anchor>
      <arglist>(QTextStream *, bool softWrap)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveText</name>
      <anchor>a4</anchor>
      <arglist>(QTextStream *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>selectFont</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>search</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>repeatSearch</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>doGotoLine</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cleanWhiteSpace</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>installRBPopup</name>
      <anchor>a11</anchor>
      <arglist>(QPopupMenu *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentLine</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentColumn</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spellcheck_start</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spellcheck_stop</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOverwriteEnabled</name>
      <anchor>a16</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>selectWordUnderCursor</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>computePosition</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>doSearch</name>
      <anchor>b1</anchor>
      <arglist>(QString s_pattern, bool case_sensitive, bool regex, bool forward, int line, int col)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>doReplace</name>
      <anchor>b2</anchor>
      <arglist>(QString s_pattern, bool case_sensitive, bool regex, bool forward, int line, int col, bool replace)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>posToRowCol</name>
      <anchor>b3</anchor>
      <arglist>(unsigned int pos, unsigned int &amp;line, unsigned int &amp;col)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>create</name>
      <anchor>b4</anchor>
      <arglist>(WId=0, bool initializeWindow=true, bool destroyOldWindow=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyPressEvent</name>
      <anchor>b5</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>dragMoveEvent</name>
      <anchor>b6</anchor>
      <arglist>(QDragMoveEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>dragEnterEvent</name>
      <anchor>b7</anchor>
      <arglist>(QDragEnterEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>dropEvent</name>
      <anchor>b8</anchor>
      <arglist>(QDropEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>contentsDragMoveEvent</name>
      <anchor>b9</anchor>
      <arglist>(QDragMoveEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>contentsDragEnterEvent</name>
      <anchor>b10</anchor>
      <arglist>(QDragEnterEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>contentsDropEvent</name>
      <anchor>b11</anchor>
      <arglist>(QDropEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b12</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KEditListBox</name>
    <filename>classKEditListBox.html</filename>
    <base>QGroupBox</base>
    <member kind="enumeration">
      <name>Button</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>changed</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>added</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>removed</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditListBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool checkAtEntering=false, int buttons=All)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditListBox</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;title, QWidget *parent=0, const char *name=0, bool checkAtEntering=false, int buttons=All)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditListBox</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;title, const CustomEditor &amp;customEditor, QWidget *parent=0, const char *name=0, bool checkAtEntering=false, int buttons=All)</arglist>
    </member>
    <member kind="function">
      <type>QListBox *</type>
      <name>listBox</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KLineEdit *</type>
      <name>lineEdit</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>addButton</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>removeButton</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>upButton</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>downButton</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertStringList</name>
      <anchor>a11</anchor>
      <arglist>(const QStringList &amp;list, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertStrList</name>
      <anchor>a12</anchor>
      <arglist>(const QStrList *list, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertStrList</name>
      <anchor>a13</anchor>
      <arglist>(const QStrList &amp;list, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertStrList</name>
      <anchor>a14</anchor>
      <arglist>(const char **list, int numStrings=-1, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertItem</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;text, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>text</name>
      <anchor>a17</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentItem</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currentText</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>items</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>moveItemUp</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>moveItemDown</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>addItem</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>removeItem</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>enableMoveButtons</name>
      <anchor>j4</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>typedSomething</name>
      <anchor>j5</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KEditListBox::CustomEditor</name>
    <filename>classKEditListBox_1_1CustomEditor.html</filename>
    <member kind="function">
      <type></type>
      <name>CustomEditor</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *repWidget, KLineEdit *edit)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CustomEditor</name>
      <anchor>a2</anchor>
      <arglist>(KComboBox *combo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepresentationWidget</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *repWidget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLineEdit</name>
      <anchor>a4</anchor>
      <arglist>(KLineEdit *edit)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QWidget *</type>
      <name>representationWidget</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KLineEdit *</type>
      <name>lineEdit</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QWidget *</type>
      <name>m_representationWidget</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KLineEdit *</type>
      <name>m_lineEdit</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KEditToolbar</name>
    <filename>classKEditToolbar.html</filename>
    <base>KDialogBase</base>
    <member kind="signal">
      <type>void</type>
      <name>newToolbarConfig</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbar</name>
      <anchor>a0</anchor>
      <arglist>(KActionCollection *collection, const QString &amp;xmlfile=QString::null, bool global=true, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbar</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;defaultToolbar, KActionCollection *collection, const QString &amp;xmlfile=QString::null, bool global=true, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbar</name>
      <anchor>a2</anchor>
      <arglist>(KXMLGUIFactory *factory, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbar</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;defaultToolbar, KXMLGUIFactory *factory, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KEditToolbar</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotOk</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotApply</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>acceptOK</name>
      <anchor>j2</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KEditToolbarWidget</name>
    <filename>classKEditToolbarWidget.html</filename>
    <base>QWidget</base>
    <base virtualness="virtual">KXMLGUIClient</base>
    <member kind="signal">
      <type>void</type>
      <name>enableOk</name>
      <anchor>l0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbarWidget</name>
      <anchor>a0</anchor>
      <arglist>(KActionCollection *collection, const QString &amp;xmlfile=QString::null, bool global=true, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbarWidget</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;defaultToolbar, KActionCollection *collection, const QString &amp;file=QString::null, bool global=true, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbarWidget</name>
      <anchor>a2</anchor>
      <arglist>(KXMLGUIFactory *factory, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KEditToolbarWidget</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;defaultToolbar, KXMLGUIFactory *factory, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KEditToolbarWidget</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KActionCollection *</type>
      <name>actionCollection</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotToolbarSelected</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotInactiveSelected</name>
      <anchor>j1</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotActiveSelected</name>
      <anchor>j2</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotInsertButton</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotRemoveButton</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotUpButton</name>
      <anchor>j5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDownButton</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setupLayout</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initNonKPart</name>
      <anchor>b1</anchor>
      <arglist>(KActionCollection *collection, const QString &amp;file, bool global)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initKPart</name>
      <anchor>b2</anchor>
      <arglist>(KXMLGUIFactory *factory)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>loadToolbarCombo</name>
      <anchor>b3</anchor>
      <arglist>(const QString &amp;defaultToolbar=QString::null)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>loadActionList</name>
      <anchor>b4</anchor>
      <arglist>(QDomElement &amp;elem)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>updateLocal</name>
      <anchor>b5</anchor>
      <arglist>(QDomElement &amp;elem)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KFloatValidator</name>
    <filename>classKFloatValidator.html</filename>
    <base>QValidator</base>
    <member kind="function">
      <type></type>
      <name>KFloatValidator</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFloatValidator</name>
      <anchor>a1</anchor>
      <arglist>(double bottom, double top, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFloatValidator</name>
      <anchor>a2</anchor>
      <arglist>(double bottom, double top, bool localeAware, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KFloatValidator</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual State</type>
      <name>validate</name>
      <anchor>a4</anchor>
      <arglist>(QString &amp;, int &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>fixup</name>
      <anchor>a5</anchor>
      <arglist>(QString &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setRange</name>
      <anchor>a6</anchor>
      <arglist>(double bottom, double top)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual double</type>
      <name>bottom</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual double</type>
      <name>top</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAcceptLocalizedNumbers</name>
      <anchor>a9</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acceptLocalizedNumbers</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KFontChooser</name>
    <filename>classKFontChooser.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>FontColumn</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontDiff</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FontListCriteria</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fontSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QFont &amp;font)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFontChooser</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L, bool onlyFixed=false, const QStringList &amp;fontList=QStringList(), bool makeFrame=true, int visibleListSize=8, bool diff=false, QButton::ToggleState *sizeIsRelativeState=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KFontChooser</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableColumn</name>
      <anchor>a2</anchor>
      <arglist>(int column, bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFont</name>
      <anchor>a3</anchor>
      <arglist>(const QFont &amp;font, bool onlyFixed=false)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fontDiffFlags</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>font</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a6</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundColor</name>
      <anchor>a8</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>backgroundColor</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSizeIsRelative</name>
      <anchor>a10</anchor>
      <arglist>(QButton::ToggleState relative)</arglist>
    </member>
    <member kind="function">
      <type>QButton::ToggleState</type>
      <name>sizeIsRelative</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>sampleText</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSampleText</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a14</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getXLFD</name>
      <anchor>e0</anchor>
      <arglist>(const QFont &amp;theFont)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>getFontList</name>
      <anchor>e1</anchor>
      <arglist>(QStringList &amp;list, uint fontListCriteria)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KFontCombo</name>
    <filename>classKFontCombo.html</filename>
    <base>KComboBox</base>
    <member kind="function">
      <type></type>
      <name>KFontCombo</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFontCombo</name>
      <anchor>a1</anchor>
      <arglist>(const QStringList &amp;fonts, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KFontCombo</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFonts</name>
      <anchor>a3</anchor>
      <arglist>(const QStringList &amp;fonts)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentFont</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;family)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currentFont</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBold</name>
      <anchor>a6</anchor>
      <arglist>(bool bold)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bold</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItalic</name>
      <anchor>a8</anchor>
      <arglist>(bool italic)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>italic</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUnderline</name>
      <anchor>a10</anchor>
      <arglist>(bool underline)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>underline</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStrikeOut</name>
      <anchor>a12</anchor>
      <arglist>(bool strikeOut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strikeOut</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a14</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCurrentItem</name>
      <anchor>a16</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>displayFonts</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>updateFonts</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KFontListItem</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KFontDialog</name>
    <filename>classKFontDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="signal">
      <type>void</type>
      <name>fontSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QFont &amp;font)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFontDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0, bool onlyFixed=false, bool modal=false, const QStringList &amp;fontlist=QStringList(), bool makeFrame=true, bool diff=false, QButton::ToggleState *sizeIsRelativeState=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFont</name>
      <anchor>a1</anchor>
      <arglist>(const QFont &amp;font, bool onlyFixed=false)</arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>font</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSizeIsRelative</name>
      <anchor>a3</anchor>
      <arglist>(QButton::ToggleState relative)</arglist>
    </member>
    <member kind="function">
      <type>QButton::ToggleState</type>
      <name>sizeIsRelative</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getFont</name>
      <anchor>e0</anchor>
      <arglist>(QFont &amp;theFont, bool onlyFixed=false, QWidget *parent=0L, bool makeFrame=true, QButton::ToggleState *sizeIsRelativeState=0L)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getFontDiff</name>
      <anchor>e1</anchor>
      <arglist>(QFont &amp;theFont, int &amp;diffFlags, bool onlyFixed=false, QWidget *parent=0L, bool makeFrame=true, QButton::ToggleState *sizeIsRelativeState=0L)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getFontAndText</name>
      <anchor>e2</anchor>
      <arglist>(QFont &amp;theFont, QString &amp;theString, bool onlyFixed=false, QWidget *parent=0L, bool makeFrame=true, QButton::ToggleState *sizeIsRelativeState=0L)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KFontChooser *</type>
      <name>chooser</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KFontRequester</name>
    <filename>classKFontRequester.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>fontSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QFont &amp;font)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFontRequester</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L, bool onlyFixed=false)</arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>font</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFixedOnly</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>sampleText</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>title</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QLabel *</type>
      <name>label</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPushButton *</type>
      <name>button</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>a7</anchor>
      <arglist>(const QFont &amp;font, bool onlyFixed=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSampleText</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTitle</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>buttonClicked</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>displaySampleText</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setToolTip</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_onlyFixed</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>m_sampleText</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>m_title</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>m_sampleLabel</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPushButton *</type>
      <name>m_button</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QFont</type>
      <name>m_selFont</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGradientSelector</name>
    <filename>classKGradientSelector.html</filename>
    <base>KSelector</base>
    <member kind="function">
      <type></type>
      <name>KGradientSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KGradientSelector</name>
      <anchor>a1</anchor>
      <arglist>(Orientation o, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KGradientSelector</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColors</name>
      <anchor>a3</anchor>
      <arglist>(const QColor &amp;col1, const QColor &amp;col2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;t1, const QString &amp;t2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstColor</name>
      <anchor>a5</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSecondColor</name>
      <anchor>a6</anchor>
      <arglist>(const QColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstText</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSecondText</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>const QColor</type>
      <name>firstColor</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QColor</type>
      <name>secondColor</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>firstText</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>secondText</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSize</name>
      <anchor>b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHelpMenu</name>
    <filename>classKHelpMenu.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>appHelpActivated</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>contextHelpActivated</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>aboutApplication</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>aboutKDE</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>reportBug</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>showAboutApplication</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHelpMenu</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const QString &amp;aboutAppText=QString::null, bool showWhatsThis=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHelpMenu</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent, const KAboutData *aboutData, bool showWhatsThis=true, KActionCollection *actions=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KHelpMenu</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>menu</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHistoryCombo</name>
    <filename>classKHistoryCombo.html</filename>
    <base>KComboBox</base>
    <member kind="slot">
      <type>void</type>
      <name>addToHistory</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;item)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>clearHistory</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>cleared</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHistoryCombo</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KHistoryCombo</name>
      <anchor>a1</anchor>
      <arglist>(bool useCompletion, QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KHistoryCombo</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHistoryItems</name>
      <anchor>a3</anchor>
      <arglist>(QStringList items)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHistoryItems</name>
      <anchor>a4</anchor>
      <arglist>(QStringList items, bool setCompletionList)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>historyItems</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeFromHistory</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixmapProvider</name>
      <anchor>a7</anchor>
      <arglist>(KPixmapProvider *prov)</arglist>
    </member>
    <member kind="function">
      <type>KPixmapProvider *</type>
      <name>pixmapProvider</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>wheelEvent</name>
      <anchor>b1</anchor>
      <arglist>(QWheelEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>insertItems</name>
      <anchor>b2</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>useCompletion</name>
      <anchor>b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHSSelector</name>
    <filename>classKHSSelector.html</filename>
    <base>KXYSelector</base>
    <member kind="function">
      <type></type>
      <name>KHSSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawPalette</name>
      <anchor>b0</anchor>
      <arglist>(QPixmap *pixmap)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b2</anchor>
      <arglist>(QPainter *painter)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIconView</name>
    <filename>classKIconView.html</filename>
    <base>QIconView</base>
    <member kind="enumeration">
      <name>Mode</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l0</anchor>
      <arglist>(QIconViewItem *item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l1</anchor>
      <arglist>(QIconViewItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l2</anchor>
      <arglist>(QIconViewItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMode</name>
      <anchor>a2</anchor>
      <arglist>(Mode m)</arglist>
    </member>
    <member kind="function">
      <type>Mode</type>
      <name>mode</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>a4</anchor>
      <arglist>(const QFont &amp;)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnItem</name>
      <anchor>j0</anchor>
      <arglist>(QIconViewItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnViewport</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSettingsChanged</name>
      <anchor>j2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAutoSelect</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>emitExecute</name>
      <anchor>b0</anchor>
      <arglist>(QIconViewItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b1</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseDoubleClickEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>b5</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KIconViewItem</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIconViewItem</name>
    <filename>classKIconViewItem.html</filename>
    <base>QIconViewItem</base>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a0</anchor>
      <arglist>(QIconView *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a1</anchor>
      <arglist>(QIconView *parent, QIconViewItem *after)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a2</anchor>
      <arglist>(QIconView *parent, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a3</anchor>
      <arglist>(QIconView *parent, QIconViewItem *after, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a4</anchor>
      <arglist>(QIconView *parent, const QString &amp;text, const QPixmap &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a5</anchor>
      <arglist>(QIconView *parent, QIconViewItem *after, const QString &amp;text, const QPixmap &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a6</anchor>
      <arglist>(QIconView *parent, const QString &amp;text, const QPicture &amp;picture)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconViewItem</name>
      <anchor>a7</anchor>
      <arglist>(QIconView *parent, QIconViewItem *after, const QString &amp;text, const QPicture &amp;picture)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>calcRect</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;text_=QString::null)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintItem</name>
      <anchor>b2</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;c)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>KWordWrap *</type>
      <name>wordWrap</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintPixmap</name>
      <anchor>b4</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;c)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintText</name>
      <anchor>b5</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;c)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KImageTrackLabel</name>
    <filename>classKImageTrackLabel.html</filename>
    <base>QLabel</base>
    <member kind="signal">
      <type>void</type>
      <name>mouseTrack</name>
      <anchor>l0</anchor>
      <arglist>(int mode, const QMouseEvent *e)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KImageTrackLabel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KInputDialog</name>
    <filename>classKInputDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getText</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, const QString &amp;value=QString::null, bool *ok=0, QWidget *parent=0, const char *name=0, QValidator *validator=0, const QString &amp;mask=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getInteger</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, int value=0, int minValue=-2147483647, int maxValue=2147483647, int step=1, int base=10, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getInteger</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, int value=0, int minValue=-2147483647, int maxValue=2147483647, int step=1, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>double</type>
      <name>getDouble</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, double value=0, double minValue=-2147483647, double maxValue=2147483647, double step=0.1, int decimals=1, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>double</type>
      <name>getDouble</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, double value=0, double minValue=-2147483647, double maxValue=2147483647, int decimals=1, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getItem</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, const QStringList &amp;list, int current=0, bool editable=false, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>getItemList</name>
      <anchor>e6</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;label, const QStringList &amp;list=QStringList(), const QStringList &amp;select=QStringList(), bool multiple=false, bool *ok=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KInputDialogPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIntNumInput</name>
    <filename>classKIntNumInput.html</filename>
    <base>KNumInput</base>
    <member kind="slot">
      <type>void</type>
      <name>setValue</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRelativeValue</name>
      <anchor>i1</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setReferencePoint</name>
      <anchor>i2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSuffix</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;suffix)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPrefix</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;prefix)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setEditFocus</name>
      <anchor>i5</anchor>
      <arglist>(bool mark=true)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>relativeValueChanged</name>
      <anchor>l1</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIntNumInput</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIntNumInput</name>
      <anchor>a1</anchor>
      <arglist>(int value, QWidget *parent=0, int base=10, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIntNumInput</name>
      <anchor>a2</anchor>
      <arglist>(KNumInput *below, int value, QWidget *parent=0, int base=10, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KIntNumInput</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>value</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>relativeValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>referencePoint</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>suffix</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prefix</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>specialValueText</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a10</anchor>
      <arglist>(int min, int max, int step=1, bool slider=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a11</anchor>
      <arglist>(int min)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minValue</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a13</anchor>
      <arglist>(int max)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxValue</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpecialValueText</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLabel</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;label, int a=AlignLeft|AlignTop)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>doLayout</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KIntSpinBox *</type>
      <name>m_spin</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSize</type>
      <name>m_sizeSpin</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIntSpinBox</name>
    <filename>classKIntSpinBox.html</filename>
    <base>QSpinBox</base>
    <member kind="function">
      <type></type>
      <name>KIntSpinBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIntSpinBox</name>
      <anchor>a1</anchor>
      <arglist>(int lower, int upper, int step, int value, int base=10, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KIntSpinBox</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBase</name>
      <anchor>a3</anchor>
      <arglist>(int base)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>base</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEditFocus</name>
      <anchor>a5</anchor>
      <arglist>(bool mark)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QString</type>
      <name>mapValueToText</name>
      <anchor>b0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>mapTextToValue</name>
      <anchor>b1</anchor>
      <arglist>(bool *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIntValidator</name>
    <filename>classKIntValidator.html</filename>
    <base>QValidator</base>
    <member kind="function">
      <type></type>
      <name>KIntValidator</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int base=10, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIntValidator</name>
      <anchor>a1</anchor>
      <arglist>(int bottom, int top, QWidget *parent, int base=10, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KIntValidator</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual State</type>
      <name>validate</name>
      <anchor>a3</anchor>
      <arglist>(QString &amp;, int &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>fixup</name>
      <anchor>a4</anchor>
      <arglist>(QString &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setRange</name>
      <anchor>a5</anchor>
      <arglist>(int bottom, int top)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setBase</name>
      <anchor>a6</anchor>
      <arglist>(int base)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>bottom</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>top</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>base</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KJanusWidget</name>
    <filename>classKJanusWidget.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>Face</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TreeList</name>
      <anchor>w5w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Tabbed</name>
      <anchor>w5w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Plain</name>
      <anchor>w5w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Swallow</name>
      <anchor>w5w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IconList</name>
      <anchor>w5w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setFocus</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowPage</name>
      <anchor>l0</anchor>
      <arglist>(QWidget *page)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KJanusWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, int face=Plain)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KJanusWidget</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>showPage</name>
      <anchor>a2</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>activePageIndex</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isValid</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>face</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QFrame *</type>
      <name>plainPage</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QFrame *</type>
      <name>addPage</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;item, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QFrame *</type>
      <name>addPage</name>
      <anchor>a10</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVBox *</type>
      <name>addVBoxPage</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;item, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVBox *</type>
      <name>addVBoxPage</name>
      <anchor>a12</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QHBox *</type>
      <name>addHBoxPage</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QHBox *</type>
      <name>addHBoxPage</name>
      <anchor>a14</anchor>
      <arglist>(const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QGrid *</type>
      <name>addGridPage</name>
      <anchor>a15</anchor>
      <arglist>(int n, Orientation dir, const QString &amp;itemName, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QGrid *</type>
      <name>addGridPage</name>
      <anchor>a16</anchor>
      <arglist>(int n, Orientation dir, const QStringList &amp;items, const QString &amp;header=QString::null, const QPixmap &amp;pixmap=QPixmap())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePage</name>
      <anchor>a17</anchor>
      <arglist>(QWidget *page)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>pageIndex</name>
      <anchor>a18</anchor>
      <arglist>(QWidget *widget) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setSwallowedWidget</name>
      <anchor>a19</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTreeListAutoResize</name>
      <anchor>a20</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setShowIconsInTreeList</name>
      <anchor>a21</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setRootIsDecorated</name>
      <anchor>a22</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unfoldTreeList</name>
      <anchor>a23</anchor>
      <arglist>(bool persist=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addWidgetBelowList</name>
      <anchor>a24</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButtonBelowList</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;text, QObject *recv, const char *slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButtonBelowList</name>
      <anchor>a26</anchor>
      <arglist>(const KGuiItem &amp;guiitem, QObject *recv, const char *slot)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIconListAllVisible</name>
      <anchor>a27</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFolderIcon</name>
      <anchor>a28</anchor>
      <arglist>(const QStringList &amp;path, const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>pageTitle</name>
      <anchor>a29</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>pageWidget</name>
      <anchor>a30</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>showEvent</name>
      <anchor>b0</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b1</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>showPage</name>
      <anchor>b2</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addPageWidget</name>
      <anchor>b3</anchor>
      <arglist>(QFrame *page, const QStringList &amp;items, const QString &amp;header, const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>InsertTreeListItem</name>
      <anchor>b4</anchor>
      <arglist>(const QStringList &amp;items, const QPixmap &amp;pixmap, QFrame *page)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QWidget *</type>
      <name>FindParent</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKeyButton</name>
    <filename>classKKeyButton.html</filename>
    <base>QPushButton</base>
    <member kind="slot">
      <type>void</type>
      <name>captureShortcut</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>capturedShortcut</name>
      <anchor>l0</anchor>
      <arglist>(const KShortcut &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KKeyButton</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShortcut</name>
      <anchor>a2</anchor>
      <arglist>(const KShortcut &amp;cut) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShortcut</name>
      <anchor>a3</anchor>
      <arglist>(const KShortcut &amp;cut, bool bQtShortcut)</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>drawButton</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *_painter)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KShortcut</type>
      <name>m_cut</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bEditing</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKeyChooser</name>
    <filename>classKKeyChooser.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>allDefault</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPreferFourModifierKeys</name>
      <anchor>i1</anchor>
      <arglist>(bool preferFourModifierKeys)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>listSync</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>keyChange</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, ActionType type=Application, bool bAllowLetterShortcuts=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a1</anchor>
      <arglist>(KActionCollection *coll, QWidget *parent, bool bAllowLetterShortcuts=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a2</anchor>
      <arglist>(KAccel *actions, QWidget *parent, bool bAllowLetterShortcuts=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a3</anchor>
      <arglist>(KGlobalAccel *actions, QWidget *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a4</anchor>
      <arglist>(KShortcutList *, QWidget *parent, ActionType type=Application, bool bAllowLetterShortcuts=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insert</name>
      <anchor>a6</anchor>
      <arglist>(KActionCollection *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insert</name>
      <anchor>a7</anchor>
      <arglist>(KActionCollection *, const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>syncToConfig</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;sConfigGroup, KConfigBase *pConfig, bool bClearUnset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>commitChanges</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a11</anchor>
      <arglist>(KAccel *actions, QWidget *parent, bool bCheckAgainstStdKeys, bool bAllowLetterShortcuts, bool bAllowWinKey=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyChooser</name>
      <anchor>a12</anchor>
      <arglist>(KGlobalAccel *actions, QWidget *parent, bool bCheckAgainstStdKeys, bool bAllowLetterShortcuts, bool bAllowWinKey=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>checkGlobalShortcutsConflict</name>
      <anchor>e0</anchor>
      <arglist>(const KShortcut &amp;cut, bool warnUser, QWidget *parent)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>checkStandardShortcutsConflict</name>
      <anchor>e1</anchor>
      <arglist>(const KShortcut &amp;cut, bool warnUser, QWidget *parent)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotNoKey</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDefaultKey</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotCustomKey</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotListItemSelected</name>
      <anchor>j3</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>capturedShortcut</name>
      <anchor>j4</anchor>
      <arglist>(const KShortcut &amp;cut)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSettingsChanged</name>
      <anchor>j5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotListItemDoubleClicked</name>
      <anchor>j6</anchor>
      <arglist>(QListViewItem *ipoQListViewItem, const QPoint &amp;ipoQPoint, int c)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initGUI</name>
      <anchor>b0</anchor>
      <arglist>(ActionType type, bool bAllowLetterShortcuts)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>insert</name>
      <anchor>b1</anchor>
      <arglist>(KAccel *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>insert</name>
      <anchor>b2</anchor>
      <arglist>(KGlobalAccel *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>insert</name>
      <anchor>b3</anchor>
      <arglist>(KShortcutList *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>buildListView</name>
      <anchor>b4</anchor>
      <arglist>(uint iList, const QString &amp;title=QString::null)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>readGlobalKeys</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>updateButtons</name>
      <anchor>b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>fontChange</name>
      <anchor>b7</anchor>
      <arglist>(const QFont &amp;_font)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setShortcut</name>
      <anchor>b8</anchor>
      <arglist>(const KShortcut &amp;cut)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isKeyPresent</name>
      <anchor>b9</anchor>
      <arglist>(const KShortcut &amp;cut, bool warnuser=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isKeyPresentLocally</name>
      <anchor>b10</anchor>
      <arglist>(const KShortcut &amp;cut, KKeyChooserItem *ignoreItem, const QString &amp;warnText)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>_warning</name>
      <anchor>b11</anchor>
      <arglist>(const KKeySequence &amp;seq, QString sAction, QString sTitle)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b12</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>ActionType</type>
      <name>m_type</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bAllowLetterShortcuts</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bAllowWinKey</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bPreferFourModifierKeys</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRadioButton *</type>
      <name>m_prbNone</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRadioButton *</type>
      <name>m_prbDef</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QRadioButton *</type>
      <name>m_prbCustom</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KKeyDialog</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKeyDialog</name>
    <filename>classKKeyDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>KKeyDialog</name>
      <anchor>a0</anchor>
      <arglist>(bool bAllowLetterShortcuts=true, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KKeyDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insert</name>
      <anchor>a2</anchor>
      <arglist>(KActionCollection *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insert</name>
      <anchor>a3</anchor>
      <arglist>(KActionCollection *, const QString &amp;title)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>configure</name>
      <anchor>a4</anchor>
      <arglist>(bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>commitChanges</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e0</anchor>
      <arglist>(KActionCollection *coll, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e1</anchor>
      <arglist>(KAccel *keys, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e2</anchor>
      <arglist>(KGlobalAccel *keys, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e3</anchor>
      <arglist>(KActionCollection *coll, bool bAllowLetterShortcuts, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e4</anchor>
      <arglist>(KAccel *keys, bool bAllowLetterShortcuts, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>configure</name>
      <anchor>e5</anchor>
      <arglist>(KGlobalAccel *keys, bool bAllowLetterShortcuts, QWidget *parent=0, bool bSaveSettings=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KDE_DEPRECATED int</type>
      <name>configureKeys</name>
      <anchor>e6</anchor>
      <arglist>(KAccel *keys, bool save_settings=true, QWidget *parent=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KDE_DEPRECATED int</type>
      <name>configureKeys</name>
      <anchor>e7</anchor>
      <arglist>(KGlobalAccel *keys, bool save_settings=true, QWidget *parent=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KDE_DEPRECATED int</type>
      <name>configureKeys</name>
      <anchor>e8</anchor>
      <arglist>(KActionCollection *coll, const QString &amp;, bool save_settings=true, QWidget *parent=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLed</name>
    <filename>classKLed.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>State</name>
      <anchor>w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Shape</name>
      <anchor>w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Look</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>toggle</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>on</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>off</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLed</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLed</name>
      <anchor>a1</anchor>
      <arglist>(const QColor &amp;col, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLed</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;col, KLed::State state, KLed::Look look, KLed::Shape shape, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KLed</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>state</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Shape</type>
      <name>shape</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Look</type>
      <name>look</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>darkFactor</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setState</name>
      <anchor>a9</anchor>
      <arglist>(State state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShape</name>
      <anchor>a10</anchor>
      <arglist>(Shape s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>toggleState</name>
      <anchor>a11</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchor>a12</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDarkFactor</name>
      <anchor>a13</anchor>
      <arglist>(int darkfactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLook</name>
      <anchor>a14</anchor>
      <arglist>(Look look)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintFlat</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintRound</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintSunken</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintRect</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintRectFrame</name>
      <anchor>b4</anchor>
      <arglist>(bool raised)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>b5</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLineEdit</name>
    <filename>classKLineEdit.html</filename>
    <base>QLineEdit</base>
    <base>KCompletionBase</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setReadOnly</name>
      <anchor>i0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>rotateText</name>
      <anchor>i1</anchor>
      <arglist>(KCompletionBase::KeyBindingType type)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletedText</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCompletedItems</name>
      <anchor>i3</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSqueezedText</name>
      <anchor>i5</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setText</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>completionBoxActivated</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>returnPressed</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>completion</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>substringCompletion</name>
      <anchor>l3</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>textRotation</name>
      <anchor>l4</anchor>
      <arglist>(KCompletionBase::KeyBindingType)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>completionModeChanged</name>
      <anchor>l5</anchor>
      <arglist>(KGlobalSettings::Completion)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowContextMenu</name>
      <anchor>l6</anchor>
      <arglist>(QPopupMenu *p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLineEdit</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;string, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLineEdit</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KLineEdit</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setURL</name>
      <anchor>a3</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cursorAtEnd</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletionMode</name>
      <anchor>a5</anchor>
      <arglist>(KGlobalSettings::Completion mode)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setContextMenuEnabled</name>
      <anchor>a6</anchor>
      <arglist>(bool showMenu)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isContextMenuEnabled</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setURLDropsEnabled</name>
      <anchor>a8</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isURLDropsEnabled</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTrapReturnKey</name>
      <anchor>a10</anchor>
      <arglist>(bool trap)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trapReturnKey</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>a12</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function">
      <type>KCompletionBox *</type>
      <name>completionBox</name>
      <anchor>a13</anchor>
      <arglist>(bool create=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletionObject</name>
      <anchor>a14</anchor>
      <arglist>(KCompletion *, bool hsig=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>copy</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnableSqueezedText</name>
      <anchor>a16</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSqueezedTextEnabled</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>originalText</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>makeCompletion</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAboutToShow</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotCancelled</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>userCancelled</name>
      <anchor>j3</anchor>
      <arglist>(const QString &amp;cancelText)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QPopupMenu *</type>
      <name>createPopupMenu</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b5</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletedText</name>
      <anchor>b6</anchor>
      <arglist>(const QString &amp;, bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setUserSelection</name>
      <anchor>b7</anchor>
      <arglist>(bool userSelection)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>create</name>
      <anchor>b8</anchor>
      <arglist>(WId=0, bool initializeWindow=true, bool destroyOldWindow=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b9</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KComboBox</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLineEditDlg</name>
    <filename>classKLineEditDlg.html</filename>
    <base>KDialogBase</base>
    <member kind="slot">
      <type>void</type>
      <name>slotClear</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLineEditDlg</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;_text, const QString &amp;_value, QWidget *parent) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>text</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KLineEdit *</type>
      <name>lineEdit</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getText</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;text, const QString &amp;value, bool *ok, QWidget *parent, QValidator *validator=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getText</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, const QString &amp;value=QString::null, bool *ok=0, QWidget *parent=0, QValidator *validator=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotTextChanged</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KLineEdit *</type>
      <name>edit</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KListAction</name>
    <filename>classKListAction.html</filename>
    <base>KSelectAction</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCurrentItem</name>
      <anchor>i0</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListAction</name>
      <anchor>a6</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KListAction</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>currentText</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>currentItem</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KListBox</name>
    <filename>classKListBox.html</filename>
    <base>QListBox</base>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l0</anchor>
      <arglist>(QListBoxItem *item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l1</anchor>
      <arglist>(QListBoxItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l2</anchor>
      <arglist>(QListBoxItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListBox</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnItem</name>
      <anchor>j0</anchor>
      <arglist>(QListBoxItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnViewport</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSettingsChanged</name>
      <anchor>j2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAutoSelect</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>emitExecute</name>
      <anchor>b0</anchor>
      <arglist>(QListBoxItem *item, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b2</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b3</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseDoubleClickEvent</name>
      <anchor>b5</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bUseSingle</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bChangeCursorOverItem</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QListBoxItem *</type>
      <name>m_pCurrentItem</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QTimer *</type>
      <name>m_pAutoSelect</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_autoSelectDelay</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KListView</name>
    <filename>classKListView.html</filename>
    <base>QListView</base>
    <member kind="enumeration">
      <name>SelectionModeExt</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>rename</name>
      <anchor>i0</anchor>
      <arglist>(QListViewItem *item, int c)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRenameable</name>
      <anchor>i1</anchor>
      <arglist>(int column, bool yesno=true)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setItemsMovable</name>
      <anchor>i2</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setItemsRenameable</name>
      <anchor>i3</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setDragEnabled</name>
      <anchor>i4</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setAutoOpen</name>
      <anchor>i5</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setDropVisualizer</name>
      <anchor>i6</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setDropVisualizerWidth</name>
      <anchor>i7</anchor>
      <arglist>(int w)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setTooltipColumn</name>
      <anchor>i8</anchor>
      <arglist>(int column)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setDropHighlighter</name>
      <anchor>i9</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCreateChildren</name>
      <anchor>i10</anchor>
      <arglist>(bool b) KDE_DEPRECATED</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSelectionModeExt</name>
      <anchor>i11</anchor>
      <arglist>(SelectionModeExt mode)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTabOrderedRenaming</name>
      <anchor>i12</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>tabOrderedRenaming</name>
      <anchor>i13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l0</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>executed</name>
      <anchor>l1</anchor>
      <arglist>(QListViewItem *item, const QPoint &amp;pos, int c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l2</anchor>
      <arglist>(QListViewItem *item, const QPoint &amp;pos, int c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dropped</name>
      <anchor>l3</anchor>
      <arglist>(QDropEvent *e, QListViewItem *after)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dropped</name>
      <anchor>l4</anchor>
      <arglist>(KListView *list, QDropEvent *e, QListViewItem *after)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dropped</name>
      <anchor>l5</anchor>
      <arglist>(KListView *list, QDropEvent *e, QListViewItem *parent, QListViewItem *after)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dropped</name>
      <anchor>l6</anchor>
      <arglist>(QDropEvent *e, QListViewItem *parent, QListViewItem *after)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>moved</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>aboutToMove</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>moved</name>
      <anchor>l9</anchor>
      <arglist>(QListViewItem *item, QListViewItem *afterFirst, QListViewItem *afterNow)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>moved</name>
      <anchor>l10</anchor>
      <arglist>(QPtrList&lt; QListViewItem &gt; &amp;items, QPtrList&lt; QListViewItem &gt; &amp;afterFirst, QPtrList&lt; QListViewItem &gt; &amp;afterNow)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>itemRenamed</name>
      <anchor>l11</anchor>
      <arglist>(QListViewItem *item, const QString &amp;str, int col)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>itemRenamed</name>
      <anchor>l12</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>menuShortCutPressed</name>
      <anchor>l13</anchor>
      <arglist>(KListView *list, QListViewItem *item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>contextMenu</name>
      <anchor>l14</anchor>
      <arglist>(KListView *l, QListViewItem *i, const QPoint &amp;p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KListView</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setAcceptDrops</name>
      <anchor>a2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isExecuteArea</name>
      <anchor>a3</anchor>
      <arglist>(const QPoint &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isExecuteArea</name>
      <anchor>a4</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; QListViewItem &gt;</type>
      <name>selectedItems</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>moveItem</name>
      <anchor>a6</anchor>
      <arglist>(QListViewItem *item, QListViewItem *parent, QListViewItem *after) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QListViewItem *</type>
      <name>lastItem</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QListViewItem *</type>
      <name>lastChild</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KLineEdit *</type>
      <name>renameLineEdit</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>itemsMovable</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>itemsRenameable</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dragEnabled</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoOpen</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRenameable</name>
      <anchor>a14</anchor>
      <arglist>(int column) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dropVisualizer</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>tooltipColumn</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>createChildren</name>
      <anchor>a17</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dropHighlighter</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dropVisualizerWidth</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SelectionModeExt</type>
      <name>selectionModeExt</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>itemIndex</name>
      <anchor>a21</anchor>
      <arglist>(const QListViewItem *item) const </arglist>
    </member>
    <member kind="function">
      <type>QListViewItem *</type>
      <name>itemAtIndex</name>
      <anchor>a22</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFullWidth</name>
      <anchor>a23</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFullWidth</name>
      <anchor>a24</anchor>
      <arglist>(bool fullWidth)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>fullWidth</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>addColumn</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;label, int width=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>addColumn</name>
      <anchor>a27</anchor>
      <arglist>(const QIconSet &amp;iconset, const QString &amp;label, int width=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeColumn</name>
      <anchor>a28</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlternateBackground</name>
      <anchor>a29</anchor>
      <arglist>(const QColor &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>alternateBackground</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveLayout</name>
      <anchor>a31</anchor>
      <arglist>(KConfig *config, const QString &amp;group) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restoreLayout</name>
      <anchor>a32</anchor>
      <arglist>(KConfig *config, const QString &amp;group)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSorting</name>
      <anchor>a33</anchor>
      <arglist>(int column, bool ascending=true)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>columnSorted</name>
      <anchor>a34</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ascendingSort</name>
      <anchor>a35</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>takeItem</name>
      <anchor>a36</anchor>
      <arglist>(QListViewItem *i)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSettingsChanged</name>
      <anchor>j0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotMouseButtonClicked</name>
      <anchor>j1</anchor>
      <arglist>(int btn, QListViewItem *item, const QPoint &amp;pos, int c)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>doneEditing</name>
      <anchor>j2</anchor>
      <arglist>(QListViewItem *item, int row)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>cleanDropVisualizer</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>cleanItemHighlighter</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>emitContextMenu</name>
      <anchor>j5</anchor>
      <arglist>(QListViewItem *, const QPoint &amp;, int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>emitContextMenu</name>
      <anchor>j6</anchor>
      <arglist>(KListView *, QListViewItem *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnItem</name>
      <anchor>j7</anchor>
      <arglist>(QListViewItem *item)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOnViewport</name>
      <anchor>j8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAutoSelect</name>
      <anchor>j9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDragExpand</name>
      <anchor>j10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotHeaderChanged</name>
      <anchor>j11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>below</name>
      <anchor>b0</anchor>
      <arglist>(const QRect &amp;rect, const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>below</name>
      <anchor>b1</anchor>
      <arglist>(QListViewItem *i, const QPoint &amp;p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>emitExecute</name>
      <anchor>b3</anchor>
      <arglist>(QListViewItem *item, const QPoint &amp;pos, int c)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b4</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b5</anchor>
      <arglist>(QFocusEvent *fe)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b6</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QString</type>
      <name>tooltip</name>
      <anchor>b7</anchor>
      <arglist>(QListViewItem *item, int column) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>showTooltip</name>
      <anchor>b8</anchor>
      <arglist>(QListViewItem *item, const QPoint &amp;pos, int column) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsDragMoveEvent</name>
      <anchor>b9</anchor>
      <arglist>(QDragMoveEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMousePressEvent</name>
      <anchor>b10</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseMoveEvent</name>
      <anchor>b11</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseDoubleClickEvent</name>
      <anchor>b12</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsDragLeaveEvent</name>
      <anchor>b13</anchor>
      <arglist>(QDragLeaveEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsMouseReleaseEvent</name>
      <anchor>b14</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsDropEvent</name>
      <anchor>b15</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsDragEnterEvent</name>
      <anchor>b16</anchor>
      <arglist>(QDragEnterEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QDragObject *</type>
      <name>dragObject</name>
      <anchor>b17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>acceptDrag</name>
      <anchor>b18</anchor>
      <arglist>(QDropEvent *event) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QRect</type>
      <name>drawDropVisualizer</name>
      <anchor>b19</anchor>
      <arglist>(QPainter *p, QListViewItem *parent, QListViewItem *after)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QRect</type>
      <name>drawItemHighlighter</name>
      <anchor>b20</anchor>
      <arglist>(QPainter *painter, QListViewItem *item)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>startDrag</name>
      <anchor>b21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b22</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportPaintEvent</name>
      <anchor>b23</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>activateAutomaticSelection</name>
      <anchor>b24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>deactivateAutomaticSelection</name>
      <anchor>b25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>automaticSelection</name>
      <anchor>b26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportResizeEvent</name>
      <anchor>b27</anchor>
      <arglist>(QResizeEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>disableAutoSelection</name>
      <anchor>b28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resetAutoSelection</name>
      <anchor>b29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>movableDropEvent</name>
      <anchor>b30</anchor>
      <arglist>(QListViewItem *parent, QListViewItem *afterme)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>findDrop</name>
      <anchor>b31</anchor>
      <arglist>(const QPoint &amp;pos, QListViewItem *&amp;parent, QListViewItem *&amp;after)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>fileManagerKeyPressEvent</name>
      <anchor>b32</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>depthToPixels</name>
      <anchor>b33</anchor>
      <arglist>(int depth)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b34</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KListViewItem</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KListViewItem</name>
    <filename>classKListViewItem.html</filename>
    <base>QListViewItem</base>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a0</anchor>
      <arglist>(QListView *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a1</anchor>
      <arglist>(QListViewItem *parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a2</anchor>
      <arglist>(QListView *parent, QListViewItem *after)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a3</anchor>
      <arglist>(QListViewItem *parent, QListViewItem *after)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a4</anchor>
      <arglist>(QListView *parent, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a5</anchor>
      <arglist>(QListViewItem *parent, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a6</anchor>
      <arglist>(QListView *parent, QListViewItem *after, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewItem</name>
      <anchor>a7</anchor>
      <arglist>(QListViewItem *parent, QListViewItem *after, QString, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null, QString=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAlternate</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>backgroundColor</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>paintCell</name>
      <anchor>a11</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;cg, int column, int width, int alignment)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KListViewLineEdit</name>
    <filename>classKListViewLineEdit.html</filename>
    <base>KLineEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>terminate</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>load</name>
      <anchor>i1</anchor>
      <arglist>(QListViewItem *i, int c)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>done</name>
      <anchor>l0</anchor>
      <arglist>(QListViewItem *, int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KListViewLineEdit</name>
      <anchor>a0</anchor>
      <arglist>(KListView *parent)</arglist>
    </member>
    <member kind="function">
      <type>QListViewItem *</type>
      <name>currentItem</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSelectionChanged</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusOutEvent</name>
      <anchor>b0</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>b2</anchor>
      <arglist>(QPaintEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>b3</anchor>
      <arglist>(QEvent *pe)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>selectNextCell</name>
      <anchor>b4</anchor>
      <arglist>(QListViewItem *pi, int column, bool forward)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>terminate</name>
      <anchor>b5</anchor>
      <arglist>(bool commit)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QListViewItem *</type>
      <name>item</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>col</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KListView *</type>
      <name>p</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMacroCommand</name>
    <filename>classKMacroCommand.html</filename>
    <base>KNamedCommand</base>
    <member kind="function">
      <type></type>
      <name>KMacroCommand</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCommand</name>
      <anchor>a2</anchor>
      <arglist>(KCommand *command)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>execute</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unexecute</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; KCommand &gt;</type>
      <name>m_commands</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMainWindow</name>
    <filename>classKMainWindow.html</filename>
    <base>QMainWindow</base>
    <base>KXMLGUIBuilder</base>
    <base virtualness="virtual">KXMLGUIClient</base>
    <member kind="enumeration">
      <name>CreationFlags</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCaption</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;caption)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCaption</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;caption, bool modified)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setPlainCaption</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;caption)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>appHelpActivated</name>
      <anchor>i3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotStateChanged</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;newstate)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotStateChanged</name>
      <anchor>i5</anchor>
      <arglist>(const QString &amp;newstate, KXMLGUIClient::ReverseStateChange)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSettingsDirty</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMainWindow</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=WType_TopLevel|WDestructiveClose)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMainWindow</name>
      <anchor>a1</anchor>
      <arglist>(int cflags, QWidget *parent=0, const char *name=0, WFlags f=WType_TopLevel|WDestructiveClose)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KMainWindow</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>helpMenu</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;aboutAppText=QString::null, bool showWhatsThis=true)</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>customHelpMenu</name>
      <anchor>a4</anchor>
      <arglist>(bool showWhatsThis=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>hide</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>restore</name>
      <anchor>a7</anchor>
      <arglist>(int number, bool show=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KXMLGUIFactory *</type>
      <name>guiFactory</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>createGUI</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;xmlfile=QString::null, bool _conserveMemory=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHelpMenuEnabled</name>
      <anchor>a10</anchor>
      <arglist>(bool showHelpMenu=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHelpMenuEnabled</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasMenuBar</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KMenuBar *</type>
      <name>menuBar</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KStatusBar *</type>
      <name>statusBar</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KToolBar *</type>
      <name>toolBar</name>
      <anchor>a15</anchor>
      <arglist>(const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QPtrListIterator&lt; KToolBar &gt;</type>
      <name>toolBarIterator</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KAccel *</type>
      <name>accel</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrameBorderWidth</name>
      <anchor>a18</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoSaveSettings</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;groupName=QString::fromLatin1(&quot;MainWindow&quot;), bool saveWindowSize=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetAutoSaveSettings</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoSaveSettings</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>autoSaveGroup</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyMainWindowSettings</name>
      <anchor>a23</anchor>
      <arglist>(KConfig *config, const QString &amp;groupName=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveMainWindowSettings</name>
      <anchor>a24</anchor>
      <arglist>(KConfig *config, const QString &amp;groupName=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStandardToolBarMenuEnabled</name>
      <anchor>a25</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isStandardToolBarMenuEnabled</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>createStandardStatusBarAction</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>toolBarMenuAction</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>finalizeGUI</name>
      <anchor>a29</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>finalizeGUI</name>
      <anchor>a30</anchor>
      <arglist>(bool force)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialGeometrySet</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ignoreInitialGeometry</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeForCentralWidgetSize</name>
      <anchor>a33</anchor>
      <arglist>(QSize size) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>canBeRestored</name>
      <anchor>e0</anchor>
      <arglist>(int number)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QString</type>
      <name>classNameOfToplevel</name>
      <anchor>e1</anchor>
      <arglist>(int number)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>QPtrList&lt; KMainWindow &gt; *</type>
      <name>memberList</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>showAboutApplication</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>saveAutoSaveSettings</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>b0</anchor>
      <arglist>(QPaintEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>childEvent</name>
      <anchor>b1</anchor>
      <arglist>(QChildEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b2</anchor>
      <arglist>(QResizeEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeEvent</name>
      <anchor>b3</anchor>
      <arglist>(QCloseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>queryExit</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>queryClose</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>saveProperties</name>
      <anchor>b6</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>readProperties</name>
      <anchor>b7</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>saveGlobalProperties</name>
      <anchor>b8</anchor>
      <arglist>(KConfig *sessionConfig)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>readGlobalProperties</name>
      <anchor>b9</anchor>
      <arglist>(KConfig *sessionConfig)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>savePropertiesInternal</name>
      <anchor>b10</anchor>
      <arglist>(KConfig *, int)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>readPropertiesInternal</name>
      <anchor>b11</anchor>
      <arglist>(KConfig *, int)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>settingsDirty</name>
      <anchor>b12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>settingsGroup</name>
      <anchor>b13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>saveWindowSize</name>
      <anchor>b14</anchor>
      <arglist>(KConfig *config) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>restoreWindowSize</name>
      <anchor>b15</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseGeometry</name>
      <anchor>b16</anchor>
      <arglist>(bool parsewidth)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b17</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KMWSessionManaged</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMainWindowInterface</name>
    <filename>classKMainWindowInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>QCStringList</type>
      <name>actions</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>activateAction</name>
      <anchor>z1</anchor>
      <arglist>(QCString action)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>disableAction</name>
      <anchor>z2</anchor>
      <arglist>(QCString action)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>enableAction</name>
      <anchor>z3</anchor>
      <arglist>(QCString action)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>actionIsEnabled</name>
      <anchor>z4</anchor>
      <arglist>(QCString action)</arglist>
    </member>
    <member kind="dcop">
      <type>QCString</type>
      <name>actionToolTip</name>
      <anchor>z5</anchor>
      <arglist>(QCString action)</arglist>
    </member>
    <member kind="dcop">
      <type>DCOPRef</type>
      <name>action</name>
      <anchor>z6</anchor>
      <arglist>(const QCString &amp;name)</arglist>
    </member>
    <member kind="dcop">
      <type>QMap&lt; QCString, DCOPRef &gt;</type>
      <name>actionMap</name>
      <anchor>z7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>int</type>
      <name>getWinID</name>
      <anchor>z8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>grabWindowToClipBoard</name>
      <anchor>z9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>hide</name>
      <anchor>z10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>maximize</name>
      <anchor>z11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>minimize</name>
      <anchor>z12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>resize</name>
      <anchor>z13</anchor>
      <arglist>(int newWidth, int newHeight)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>move</name>
      <anchor>z14</anchor>
      <arglist>(int newX, int newY)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setGeometry</name>
      <anchor>z15</anchor>
      <arglist>(int newX, int newY, int newWidth, int newHeight)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>raise</name>
      <anchor>z16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>lower</name>
      <anchor>z17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>restore</name>
      <anchor>z18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>show</name>
      <anchor>z19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMainWindowInterface</name>
      <anchor>a0</anchor>
      <arglist>(KMainWindow *mainWindow)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KMainWindowInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>functionsDynamic</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processDynamic</name>
      <anchor>a3</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMenuBar</name>
    <filename>classKMenuBar.html</filename>
    <base>QMenuBar</base>
    <member kind="function">
      <type></type>
      <name>KMenuBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTopLevelMenu</name>
      <anchor>a2</anchor>
      <arglist>(bool top_level=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTopLevelMenu</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setGeometry</name>
      <anchor>a4</anchor>
      <arglist>(const QRect &amp;r)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setGeometry</name>
      <anchor>a5</anchor>
      <arglist>(int x, int y, int w, int h)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>resize</name>
      <anchor>a6</anchor>
      <arglist>(int w, int h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resize</name>
      <anchor>a7</anchor>
      <arglist>(const QSize &amp;s)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFrameStyle</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLineWidth</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setMargin</name>
      <anchor>a11</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotReadConfig</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>showEvent</name>
      <anchor>b0</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b2</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>x11Event</name>
      <anchor>b3</anchor>
      <arglist>(XEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMessageBox</name>
    <filename>classKMessageBox.html</filename>
    <member kind="enumeration">
      <name>ButtonCode</name>
      <anchor>w16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OptionsType</name>
      <anchor>w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNo</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNoWId</name>
      <anchor>e1</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNoCancel</name>
      <anchor>e2</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNoCancelWId</name>
      <anchor>e3</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNoList</name>
      <anchor>e4</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>questionYesNoListWId</name>
      <anchor>e5</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNo</name>
      <anchor>e6</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify|Dangerous)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoWId</name>
      <anchor>e7</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify|Dangerous)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoList</name>
      <anchor>e8</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify|Dangerous)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoListWId</name>
      <anchor>e9</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify|Dangerous)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningContinueCancel</name>
      <anchor>e10</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonContinue=KStdGuiItem::cont(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningContinueCancelWId</name>
      <anchor>e11</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonContinue=KStdGuiItem::cont(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningContinueCancelList</name>
      <anchor>e12</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonContinue=KStdGuiItem::cont(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningContinueCancelListWId</name>
      <anchor>e13</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonContinue=KStdGuiItem::cont(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoCancel</name>
      <anchor>e14</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoCancelWId</name>
      <anchor>e15</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoCancelList</name>
      <anchor>e16</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>warningYesNoCancelListWId</name>
      <anchor>e17</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>error</name>
      <anchor>e18</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>errorWId</name>
      <anchor>e19</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>detailedError</name>
      <anchor>e20</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>detailedErrorWId</name>
      <anchor>e21</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedDetailedError</name>
      <anchor>e22</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedDetailedErrorWId</name>
      <anchor>e23</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>sorry</name>
      <anchor>e24</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>sorryWId</name>
      <anchor>e25</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>detailedSorry</name>
      <anchor>e26</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>detailedSorryWId</name>
      <anchor>e27</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;details, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>information</name>
      <anchor>e28</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, const QString &amp;dontShowAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>informationWId</name>
      <anchor>e29</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QString &amp;caption=QString::null, const QString &amp;dontShowAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>informationList</name>
      <anchor>e30</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const QString &amp;dontShowAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>informationListWId</name>
      <anchor>e31</anchor>
      <arglist>(WId parent_id, const QString &amp;text, const QStringList &amp;strlist, const QString &amp;caption=QString::null, const QString &amp;dontShowAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>enableAllMessages</name>
      <anchor>e32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>enableMessage</name>
      <anchor>e33</anchor>
      <arglist>(const QString &amp;dontShowAgainName)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>about</name>
      <anchor>e34</anchor>
      <arglist>(QWidget *parent, const QString &amp;text, const QString &amp;caption=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>messageBox</name>
      <anchor>e35</anchor>
      <arglist>(QWidget *parent, DialogType type, const QString &amp;text, const QString &amp;caption, const KGuiItem &amp;buttonYes, const KGuiItem &amp;buttonNo, const QString &amp;dontShowAskAgainName, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>messageBox</name>
      <anchor>e36</anchor>
      <arglist>(QWidget *parent, DialogType type, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>messageBoxWId</name>
      <anchor>e37</anchor>
      <arglist>(WId parent_id, DialogType type, const QString &amp;text, const QString &amp;caption=QString::null, const KGuiItem &amp;buttonYes=KStdGuiItem::yes(), const KGuiItem &amp;buttonNo=KStdGuiItem::no(), const QString &amp;dontShowAskAgainName=QString::null, int options=Notify)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedMessageBox</name>
      <anchor>e38</anchor>
      <arglist>(QWidget *parent, DialogType type, const QString &amp;text, const QString &amp;caption, int options)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedMessageBoxWId</name>
      <anchor>e39</anchor>
      <arglist>(WId parent_id, DialogType type, const QString &amp;text, const QString &amp;caption, int options)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedMessageBox</name>
      <anchor>e40</anchor>
      <arglist>(QWidget *parent, DialogType type, const QString &amp;text, const QString &amp;caption=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>queuedMessageBoxWId</name>
      <anchor>e41</anchor>
      <arglist>(WId parent_id, DialogType type, const QString &amp;text, const QString &amp;caption=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>shouldBeShownYesNo</name>
      <anchor>e42</anchor>
      <arglist>(const QString &amp;dontShowAgainName, ButtonCode &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>shouldBeShownContinue</name>
      <anchor>e43</anchor>
      <arglist>(const QString &amp;dontShowAgainName)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>saveDontShowAgainYesNo</name>
      <anchor>e44</anchor>
      <arglist>(const QString &amp;dontShowAgainName, ButtonCode result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>saveDontShowAgainContinue</name>
      <anchor>e45</anchor>
      <arglist>(const QString &amp;dontShowAgainName)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setDontShowAskAgainConfig</name>
      <anchor>e46</anchor>
      <arglist>(KConfig *cfg)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMimeTypeValidator</name>
    <filename>classKMimeTypeValidator.html</filename>
    <base>QValidator</base>
    <member kind="function">
      <type></type>
      <name>KMimeTypeValidator</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual State</type>
      <name>validate</name>
      <anchor>a1</anchor>
      <arglist>(QString &amp;input, int &amp;pos) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>fixup</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;input) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KNamedCommand</name>
    <filename>classKNamedCommand.html</filename>
    <base>KCommand</base>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KNamedCommand</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KNumInput</name>
    <filename>classKNumInput.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>KNumInput</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KNumInput</name>
      <anchor>a1</anchor>
      <arglist>(KNumInput *below, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLabel</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;label, int a=AlignLeft|AlignTop)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showSlider</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSteps</name>
      <anchor>a6</anchor>
      <arglist>(int minor, int major)</arglist>
    </member>
    <member kind="function">
      <type>QSizePolicy</type>
      <name>sizePolicy</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>layout</name>
      <anchor>b0</anchor>
      <arglist>(bool deep)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>doLayout</name>
      <anchor>b1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KNumInput *</type>
      <name>m_prev</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KNumInput *</type>
      <name>m_next</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_colw1</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_colw2</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>m_label</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSlider *</type>
      <name>m_slider</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSize</type>
      <name>m_sizeSlider</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSize</type>
      <name>m_sizeLabel</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_alignment</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPaletteTable</name>
    <filename>classKPaletteTable.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setPalette</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;paletteName)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>colorSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>colorDoubleClicked</name>
      <anchor>l1</anchor>
      <arglist>(const QColor &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPaletteTable</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int minWidth=210, int cols=16)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addToCustomColors</name>
      <anchor>a2</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addToRecentColors</name>
      <anchor>a3</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>palette</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotColorCellSelected</name>
      <anchor>j0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotColorCellDoubleClicked</name>
      <anchor>j1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotColorTextSelected</name>
      <anchor>j2</anchor>
      <arglist>(const QString &amp;colorText)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSetPalette</name>
      <anchor>j3</anchor>
      <arglist>(const QString &amp;_paletteName)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotShowNamedColorReadError</name>
      <anchor>j4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>readNamedColor</name>
      <anchor>b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>i18n_customColors</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>i18n_recentColors</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>i18n_namedColors</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QComboBox *</type>
      <name>combo</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KColorCells *</type>
      <name>cells</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QScrollView *</type>
      <name>sv</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KListBox *</type>
      <name>mNamedColorList</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KPalette *</type>
      <name>mPalette</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>mMinWidth</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>mCols</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPanelApplet</name>
    <filename>classKPanelApplet.html</filename>
    <base>QFrame</base>
    <member kind="enumeration">
      <name>Type</name>
      <anchor>w17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Action</name>
      <anchor>w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>updateLayout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>requestFocus</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelApplet</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;configFile, Type t=Normal, int actions=0, QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPanelApplet</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>widthForHeight</name>
      <anchor>a2</anchor>
      <arglist>(int height) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>heightForWidth</name>
      <anchor>a3</anchor>
      <arglist>(int width) const </arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KSharedConfig::Ptr</type>
      <name>sharedConfig</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>type</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>actions</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>action</name>
      <anchor>a8</anchor>
      <arglist>(Action a)</arglist>
    </member>
    <member kind="function">
      <type>const QPopupMenu *</type>
      <name>customMenu</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a10</anchor>
      <arglist>(Position p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlignment</name>
      <anchor>a11</anchor>
      <arglist>(Alignment a)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>about</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>help</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>preferences</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>reportBug</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Orientation</type>
      <name>orientation</name>
      <anchor>b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>Position</type>
      <name>position</name>
      <anchor>b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>Alignment</type>
      <name>alignment</name>
      <anchor>b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>positionChange</name>
      <anchor>b7</anchor>
      <arglist>(Position p)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>alignmentChange</name>
      <anchor>b8</anchor>
      <arglist>(Alignment)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setCustomMenu</name>
      <anchor>b9</anchor>
      <arglist>(const QPopupMenu *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KDE_DEPRECATED void</type>
      <name>orientationChange</name>
      <anchor>b10</anchor>
      <arglist>(Orientation)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Direction</type>
      <name>popupDirection</name>
      <anchor>b11</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KDE_DEPRECATED void</type>
      <name>popupDirectionChange</name>
      <anchor>b12</anchor>
      <arglist>(Direction)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b13</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KPanelAppletPrivate *</type>
      <name>d</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPanelAppMenu</name>
    <filename>classKPanelAppMenu.html</filename>
    <base>QObject</base>
    <base>DCOPObject</base>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelAppMenu</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;title, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelAppMenu</name>
      <anchor>a1</anchor>
      <arglist>(const QPixmap &amp;icon, const QString &amp;title, QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelAppMenu</name>
      <anchor>a2</anchor>
      <arglist>(QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPanelAppMenu</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertItem</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, int id=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertItem</name>
      <anchor>a5</anchor>
      <arglist>(const QPixmap &amp;icon, const QString &amp;text, int id=-1)</arglist>
    </member>
    <member kind="function">
      <type>KPanelAppMenu *</type>
      <name>insertMenu</name>
      <anchor>a6</anchor>
      <arglist>(const QPixmap &amp;icon, const QString &amp;text, int id=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>process</name>
      <anchor>a8</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;reply)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>(const QPixmap &amp;icon, const QString &amp;title)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPanelExtension</name>
    <filename>classKPanelExtension.html</filename>
    <base>QFrame</base>
    <member kind="enumeration">
      <name>Type</name>
      <anchor>w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Size</name>
      <anchor>w22</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>updateLayout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelExtension</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;configFile, Type t=Normal, int actions=0, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPanelExtension</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a2</anchor>
      <arglist>(Position, QSize maxsize) const </arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>type</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>actions</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>action</name>
      <anchor>a6</anchor>
      <arglist>(Action a)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Position</type>
      <name>preferedPosition</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchor>a8</anchor>
      <arglist>(Position p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlignment</name>
      <anchor>a9</anchor>
      <arglist>(Alignment a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSize</name>
      <anchor>a10</anchor>
      <arglist>(Size size, int customSize)</arglist>
    </member>
    <member kind="function">
      <type>Size</type>
      <name>sizeSetting</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>customSize</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>about</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>help</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>preferences</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>reportBug</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Position</type>
      <name>position</name>
      <anchor>b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>Alignment</type>
      <name>alignment</name>
      <anchor>b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>Orientation</type>
      <name>orientation</name>
      <anchor>b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>sizeInPixels</name>
      <anchor>b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>positionChange</name>
      <anchor>b8</anchor>
      <arglist>(Position)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>alignmentChange</name>
      <anchor>b9</anchor>
      <arglist>(Alignment)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b10</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPanelMenu</name>
    <filename>classKPanelMenu.html</filename>
    <base>KPopupMenu</base>
    <member kind="slot">
      <type>void</type>
      <name>reinitialize</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>deinitialize</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelMenu</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPanelMenu</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;startDir, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KPanelMenu</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>path</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPath</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initialized</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setInitialized</name>
      <anchor>a6</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disableAutoClear</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotAboutToShow</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>slotExec</name>
      <anchor>j1</anchor>
      <arglist>(int id)=0</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>initialize</name>
      <anchor>j2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotClear</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b0</anchor>
      <arglist>(QHideEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;path=QString::null)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPassivePopup</name>
    <filename>classKPassivePopup.html</filename>
    <base>QFrame</base>
    <member kind="slot">
      <type>void</type>
      <name>setTimeout</name>
      <anchor>i0</anchor>
      <arglist>(int delay)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>show</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l1</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPassivePopup</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPassivePopup</name>
      <anchor>a1</anchor>
      <arglist>(WId parent, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KPassivePopup</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setView</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setView</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text=QString::null)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setView</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, const QPixmap &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>QVBox *</type>
      <name>standardView</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, const QPixmap &amp;icon, QWidget *parent=0L)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>view</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>timeout</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setAutoDelete</name>
      <anchor>a9</anchor>
      <arglist>(bool autoDelete)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoDelete</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPassivePopup *</type>
      <name>message</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPassivePopup *</type>
      <name>message</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPassivePopup *</type>
      <name>message</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, const QPixmap &amp;icon, QWidget *parent, const char *name=0, int timeout=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPassivePopup *</type>
      <name>message</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;caption, const QString &amp;text, const QPixmap &amp;icon, WId parent, const char *name=0, int timeout=-1)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>positionSelf</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b1</anchor>
      <arglist>(QHideEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>moveNear</name>
      <anchor>b2</anchor>
      <arglist>(QRect target)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QRect</type>
      <name>defaultArea</name>
      <anchor>b4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPasswordDialog</name>
    <filename>classKPasswordDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="enumeration">
      <name>Types</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Password</name>
      <anchor>w2w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NewPassword</name>
      <anchor>w2w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordDialog</name>
      <anchor>a0</anchor>
      <arglist>(Types type, bool enableKeep, int extraBttn, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordDialog</name>
      <anchor>a1</anchor>
      <arglist>(int type, QString prompt, bool enableKeep=false, int extraBttn=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KPasswordDialog</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrompt</name>
      <anchor>a3</anchor>
      <arglist>(QString prompt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prompt</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addLine</name>
      <anchor>a5</anchor>
      <arglist>(QString key, QString value)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>password</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keep</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getPassword</name>
      <anchor>e0</anchor>
      <arglist>(QCString &amp;password, QString prompt, int *keep=0L)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>getNewPassword</name>
      <anchor>e1</anchor>
      <arglist>(QCString &amp;password, QString prompt)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>disableCoreDumps</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotOk</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotCancel</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotKeep</name>
      <anchor>j2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>checkPassword</name>
      <anchor>b0</anchor>
      <arglist>(const char *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPasswordEdit</name>
    <filename>classKPasswordEdit.html</filename>
    <base>QLineEdit</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>insert</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordEdit</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordEdit</name>
      <anchor>a1</anchor>
      <arglist>(EchoMode echoMode, QWidget *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordEdit</name>
      <anchor>a2</anchor>
      <arglist>(EchoModes echoMode, QWidget *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPasswordEdit</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *parent, const char *name, int echoMode) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPasswordEdit</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>password</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>erase</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>PassLen</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b1</anchor>
      <arglist>(QFocusEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPasteTextAction</name>
    <filename>classKPasteTextAction.html</filename>
    <base>KAction</base>
    <member kind="function">
      <type></type>
      <name>KPasteTextAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const QString &amp;icon, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMixedMode</name>
      <anchor>a2</anchor>
      <arglist>(bool mode)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>menuAboutToShow</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>menuItemActivated</name>
      <anchor>j1</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPixmapIO</name>
    <filename>classKPixmapIO.html</filename>
    <member kind="enumeration">
      <name>ShmPolicies</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>convertToPixmap</name>
      <anchor>a2</anchor>
      <arglist>(const QImage &amp;image)</arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>convertToImage</name>
      <anchor>a3</anchor>
      <arglist>(const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>putImage</name>
      <anchor>a4</anchor>
      <arglist>(QPixmap *dst, int dx, int dy, const QImage *src)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>putImage</name>
      <anchor>a5</anchor>
      <arglist>(QPixmap *dst, const QPoint &amp;offset, const QImage *src)</arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>getImage</name>
      <anchor>a6</anchor>
      <arglist>(const QPixmap *src, int sx, int sy, int sw, int sh)</arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>getImage</name>
      <anchor>a7</anchor>
      <arglist>(const QPixmap *src, const QRect &amp;rect)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShmPolicy</name>
      <anchor>a8</anchor>
      <arglist>(int policy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preAllocShm</name>
      <anchor>a9</anchor>
      <arglist>(int size)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPopupFrame</name>
    <filename>classKPopupFrame.html</filename>
    <base>QFrame</base>
    <member kind="slot">
      <type>void</type>
      <name>close</name>
      <anchor>i0</anchor>
      <arglist>(int r)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupFrame</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMainWidget</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *m)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>a2</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popup</name>
      <anchor>a3</anchor>
      <arglist>(const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a4</anchor>
      <arglist>(QPoint p)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a5</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>result</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QWidget *</type>
      <name>main</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPopupMenu</name>
    <filename>classKPopupMenu.html</filename>
    <base>QPopupMenu</base>
    <member kind="signal">
      <type>void</type>
      <name>aboutToShowContextMenu</name>
      <anchor>l0</anchor>
      <arglist>(KPopupMenu *menu, int menuItem, QPopupMenu *ctxMenu)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupMenu</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPopupMenu</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertTitle</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, int id=-1, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertTitle</name>
      <anchor>a3</anchor>
      <arglist>(const QPixmap &amp;icon, const QString &amp;text, int id=-1, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeTitle</name>
      <anchor>a4</anchor>
      <arglist>(int id, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeTitle</name>
      <anchor>a5</anchor>
      <arglist>(int id, const QPixmap &amp;icon, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>title</name>
      <anchor>a6</anchor>
      <arglist>(int id=-1) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>titlePixmap</name>
      <anchor>a7</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeyboardShortcutsEnabled</name>
      <anchor>a8</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeyboardShortcutsExecute</name>
      <anchor>a9</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupMenu</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;title, QWidget *parent=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;title) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>contextMenu</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QPopupMenu *</type>
      <name>contextMenu</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hideContextMenu</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPopupMenu *</type>
      <name>contextMenuFocus</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>contextMenuFocusItem</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>QString</type>
      <name>underlineText</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;text, uint length)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>resetKeyboardVars</name>
      <anchor>j1</anchor>
      <arglist>(bool noMatches=false)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>itemHighlighted</name>
      <anchor>j2</anchor>
      <arglist>(int whichItem)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>showCtxMenu</name>
      <anchor>j3</anchor>
      <arglist>(QPoint pos)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>ctxMenuHiding</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>ctxMenuHideShowingMenu</name>
      <anchor>j5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QCloseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>focusNextPrevChild</name>
      <anchor>b3</anchor>
      <arglist>(bool next)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contextMenuEvent</name>
      <anchor>b4</anchor>
      <arglist>(QContextMenuEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>hideEvent</name>
      <anchor>b5</anchor>
      <arglist>(QHideEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPopupTitle</name>
    <filename>classKPopupTitle.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setText</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setIcon</name>
      <anchor>i1</anchor>
      <arglist>(const QPixmap &amp;pix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupTitle</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupTitle</name>
      <anchor>a1</anchor>
      <arglist>(KPixmapEffect::GradientType gradient, const QColor &amp;color, const QColor &amp;textColor, QWidget *parent=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPopupTitle</name>
      <anchor>a2</anchor>
      <arglist>(const KPixmap &amp;background, const QColor &amp;color, const QColor &amp;textColor, QWidget *parent=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QPixmap *icon=NULL)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>title</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>icon</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>calcSize</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>b1</anchor>
      <arglist>(QPaintEvent *ev)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KPixmapEffect::GradientType</type>
      <name>grType</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>titleStr</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KPixmap</type>
      <name>fill</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPixmap</type>
      <name>miniicon</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QColor</type>
      <name>fgColor</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QColor</type>
      <name>bgColor</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QColor</type>
      <name>grHigh</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QColor</type>
      <name>grLow</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>useGradient</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProgress</name>
    <filename>classKProgress.html</filename>
    <base>QProgressBar</base>
    <member kind="slot">
      <type>void</type>
      <name>setFormat</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;format)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTotalSteps</name>
      <anchor>i1</anchor>
      <arglist>(int totalSteps)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setProgress</name>
      <anchor>i2</anchor>
      <arglist>(int progress)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setValue</name>
      <anchor>i3</anchor>
      <arglist>(int progress)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>advance</name>
      <anchor>i4</anchor>
      <arglist>(int offset)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>percentageChanged</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KProgress</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KProgress</name>
      <anchor>a1</anchor>
      <arglist>(int totalSteps, QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KProgress</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextEnabled</name>
      <anchor>a3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>value</name>
      <anchor>a4</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>textEnabled</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>format</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a7</anchor>
      <arglist>(int min, int max) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxValue</name>
      <anchor>a8</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>setIndicator</name>
      <anchor>b0</anchor>
      <arglist>(QString &amp;indicator, int progress, int totalSteps)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProgressDialog</name>
    <filename>classKProgressDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>KProgressDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, const QString &amp;caption=QString::null, const QString &amp;text=QString::null, bool modal=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KProgressDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KProgress *</type>
      <name>progressBar</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KProgress *</type>
      <name>progressBar</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>labelText</name>
      <anchor>a5</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>labelText</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAllowCancel</name>
      <anchor>a7</anchor>
      <arglist>(bool allowCancel)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>allowCancel</name>
      <anchor>a8</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>allowCancel</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showCancelButton</name>
      <anchor>a10</anchor>
      <arglist>(bool show)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoClose</name>
      <anchor>a11</anchor>
      <arglist>(bool close)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoClose</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoClose</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoReset</name>
      <anchor>a14</anchor>
      <arglist>(bool autoReset)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoReset</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoReset</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>wasCancelled</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>wasCancelled</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonText</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>buttonText</name>
      <anchor>a20</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>buttonText</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinimumDuration</name>
      <anchor>a22</anchor>
      <arglist>(int ms)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minimumDuration</name>
      <anchor>a23</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minimumDuration</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAutoShow</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotAutoActions</name>
      <anchor>j1</anchor>
      <arglist>(int percentage)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotCancel</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPushButton</name>
    <filename>classKPushButton.html</filename>
    <base>QPushButton</base>
    <member kind="function">
      <type></type>
      <name>KPushButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPushButton</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPushButton</name>
      <anchor>a2</anchor>
      <arglist>(const QIconSet &amp;icon, const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPushButton</name>
      <anchor>a3</anchor>
      <arglist>(const KGuiItem &amp;item, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPushButton</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDragEnabled</name>
      <anchor>a5</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDragEnabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGuiItem</name>
      <anchor>a7</anchor>
      <arglist>(const KGuiItem &amp;item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconSet</name>
      <anchor>a8</anchor>
      <arglist>(const QIconSet &amp;iconSet)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QDragObject *</type>
      <name>dragObject</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>startDrag</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QXEmbed</name>
    <filename>classQXEmbed.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>embeddedWindowDestroyed</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QXEmbed</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QXEmbed</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProtocol</name>
      <anchor>a2</anchor>
      <arglist>(Protocol proto)</arglist>
    </member>
    <member kind="function">
      <type>Protocol</type>
      <name>protocol</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>embed</name>
      <anchor>a4</anchor>
      <arglist>(WId w)</arglist>
    </member>
    <member kind="function">
      <type>WId</type>
      <name>embeddedWinId</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sendDelete</name>
      <anchor>a6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDelete</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoDelete</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSizePolicy</type>
      <name>sizePolicy</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>a12</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>customWhatsThis</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enterWhatsThisMode</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reparent</name>
      <anchor>a15</anchor>
      <arglist>(QWidget *parent, WFlags f, const QPoint &amp;p, bool showIt=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>initialize</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>embedClientIntoWindow</name>
      <anchor>e1</anchor>
      <arglist>(QWidget *client, WId window)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>processClientCmdline</name>
      <anchor>e2</anchor>
      <arglist>(QWidget *client, int &amp;argc, char **argv)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>event</name>
      <anchor>b0</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyReleaseEvent</name>
      <anchor>b2</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>focusInEvent</name>
      <anchor>b3</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>focusOutEvent</name>
      <anchor>b4</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b5</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>showEvent</name>
      <anchor>b6</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>x11Event</name>
      <anchor>b7</anchor>
      <arglist>(XEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>windowChanged</name>
      <anchor>b8</anchor>
      <arglist>(WId w)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>focusNextPrevChild</name>
      <anchor>b9</anchor>
      <arglist>(bool next)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRadioAction</name>
    <filename>classKRadioAction.html</filename>
    <base>KToggleAction</base>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRadioAction</name>
      <anchor>a6</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRecentFilesAction</name>
    <filename>classKRecentFilesAction.html</filename>
    <base>KListAction</base>
    <member kind="slot">
      <type>void</type>
      <name>setMaxItems</name>
      <anchor>i0</anchor>
      <arglist>(uint maxItems)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>loadEntries</name>
      <anchor>i1</anchor>
      <arglist>(KConfig *config, QString groupname=QString::null)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>saveEntries</name>
      <anchor>i2</anchor>
      <arglist>(KConfig *config, QString groupname=QString::null)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>addURL</name>
      <anchor>i3</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeURL</name>
      <anchor>i4</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>clearURLList</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>urlSelected</name>
      <anchor>l0</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRecentFilesAction</name>
      <anchor>a6</anchor>
      <arglist>(QObject *parent=0, const char *name=0, uint maxItems=10)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KRecentFilesAction</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a8</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>maxItems</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>itemSelected</name>
      <anchor>j0</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>menuAboutToShow</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>menuItemActivated</name>
      <anchor>j2</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotClicked</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j5</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRestrictedLine</name>
    <filename>classKRestrictedLine.html</filename>
    <base>KLineEdit</base>
    <member kind="signal">
      <type>void</type>
      <name>invalidChar</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRestrictedLine</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, const QString &amp;valid=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KRestrictedLine</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValidChars</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;valid)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>validChars</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRootPermsIcon</name>
    <filename>classKRootPermsIcon.html</filename>
    <base>KAuthIcon</base>
    <member kind="slot">
      <type>void</type>
      <name>updateStatus</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRootPermsIcon</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>root</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRootPixmap</name>
    <filename>classKRootPixmap.html</filename>
    <base>QObject</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>start</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>stop</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setFadeEffect</name>
      <anchor>i2</anchor>
      <arglist>(double opacity, const QColor &amp;color)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>repaint</name>
      <anchor>i3</anchor>
      <arglist>(bool force)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>repaint</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setCustomPainting</name>
      <anchor>i5</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableExports</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" static="yes">
      <type>QString</type>
      <name>pixmapName</name>
      <anchor>i7</anchor>
      <arglist>(int desk)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>backgroundUpdated</name>
      <anchor>l0</anchor>
      <arglist>(const QPixmap &amp;pm)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRootPixmap</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *target, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRootPixmap</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *target, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KRootPixmap</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAvailable</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isActive</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentDesktop</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>customPainting</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED bool</type>
      <name>checkAvailable</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>color</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>opacity</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateBackground</name>
      <anchor>b1</anchor>
      <arglist>(KSharedPixmap *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRuler</name>
    <filename>classKRuler.html</filename>
    <base>QFrame</base>
    <member kind="enumeration">
      <name>MetricStyle</name>
      <anchor>w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotNewValue</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotNewOffset</name>
      <anchor>i1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotEndOffset</name>
      <anchor>i2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRuler</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRuler</name>
      <anchor>a1</anchor>
      <arglist>(Orientation orient, QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRuler</name>
      <anchor>a2</anchor>
      <arglist>(Orientation orient, int widgetWidth, QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KRuler</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxValue</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a8</anchor>
      <arglist>(int min, int max)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>value</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTinyMarkDistance</name>
      <anchor>a11</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>tinyMarkDistance</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLittleMarkDistance</name>
      <anchor>a13</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>littleMarkDistance</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMediumMarkDistance</name>
      <anchor>a15</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mediumMarkDistance</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBigMarkDistance</name>
      <anchor>a17</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>bigMarkDistance</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowTinyMarks</name>
      <anchor>a19</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showTinyMarks</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowLittleMarks</name>
      <anchor>a21</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showLittleMarks</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowMediumMarks</name>
      <anchor>a23</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showMediumMarks</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowBigMarks</name>
      <anchor>a25</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showBigMarks</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowEndMarks</name>
      <anchor>a27</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showEndMarks</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowPointer</name>
      <anchor>a29</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showPointer</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePerLittleMark</name>
      <anchor>a31</anchor>
      <arglist>(int) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePerMediumMark</name>
      <anchor>a32</anchor>
      <arglist>(int) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePerBigMark</name>
      <anchor>a33</anchor>
      <arglist>(int) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowEndLabel</name>
      <anchor>a34</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showEndLabel</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndLabel</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>endLabel</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRulerMetricStyle</name>
      <anchor>a38</anchor>
      <arglist>(KRuler::MetricStyle)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixelPerMark</name>
      <anchor>a39</anchor>
      <arglist>(double rate)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>pixelPerMark</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLength</name>
      <anchor>a41</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>length</name>
      <anchor>a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLengthFixed</name>
      <anchor>a43</anchor>
      <arglist>(bool fix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lengthFixed</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>slideUp</name>
      <anchor>a45</anchor>
      <arglist>(int count=1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>slideDown</name>
      <anchor>a46</anchor>
      <arglist>(int count=1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOffset</name>
      <anchor>a47</anchor>
      <arglist>(int offset)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>offset</name>
      <anchor>a48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>endOffset</name>
      <anchor>a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSelectAction</name>
    <filename>classKSelectAction.html</filename>
    <base>KAction</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setCurrentItem</name>
      <anchor>i0</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setItems</name>
      <anchor>i1</anchor>
      <arglist>(const QStringList &amp;lst)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setEditable</name>
      <anchor>i3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setComboWidth</name>
      <anchor>i4</anchor>
      <arglist>(int width)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l0</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activated</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelectAction</name>
      <anchor>a6</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSelectAction</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a8</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isEditable</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>items</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>changeItem</name>
      <anchor>a11</anchor>
      <arglist>(int index, const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>currentText</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>currentItem</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>comboWidth</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>popupMenu</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRemoveAmpersandsInCombo</name>
      <anchor>a16</anchor>
      <arglist>(bool b) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeAmpersandsInCombo</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMenuAccelsEnabled</name>
      <anchor>a18</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>menuAccelsEnabled</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j1</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>changeItem</name>
      <anchor>b0</anchor>
      <arglist>(int id, int index, const QString &amp;text)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QStringList</type>
      <name>comboItems</name>
      <anchor>b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateCurrentItem</name>
      <anchor>b2</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateComboWidth</name>
      <anchor>b3</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateItems</name>
      <anchor>b4</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateClear</name>
      <anchor>b5</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b6</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSelector</name>
    <filename>classKSelector.html</filename>
    <base>QWidget</base>
    <base>QRangeControl</base>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSelector</name>
      <anchor>a1</anchor>
      <arglist>(Orientation o, QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>Orientation</type>
      <name>orientation</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>contentsRect</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIndent</name>
      <anchor>a5</anchor>
      <arglist>(bool i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>indent</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a7</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>value</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a9</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>minValue</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a11</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxValue</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawArrow</name>
      <anchor>b1</anchor>
      <arglist>(QPainter *painter, bool show, const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>valueChange</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>b3</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b5</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>wheelEvent</name>
      <anchor>b6</anchor>
      <arglist>(QWheelEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSeparator</name>
    <filename>classKSeparator.html</filename>
    <base>QFrame</base>
    <member kind="function">
      <type></type>
      <name>KSeparator</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSeparator</name>
      <anchor>a1</anchor>
      <arglist>(int orientation, QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>orientation</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientation</name>
      <anchor>a3</anchor>
      <arglist>(int orient)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawFrame</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSpell</name>
    <filename>classKSpell.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>spellStatus</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpellerType</name>
      <anchor>w12</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>misspelling</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;originalword, const QStringList &amp;suggestions, unsigned int pos)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>corrected</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;originalword, const QString &amp;newword, unsigned int pos)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ignoreall</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;originalword)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ignoreword</name>
      <anchor>l3</anchor>
      <arglist>(const QString &amp;originalword)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addword</name>
      <anchor>l4</anchor>
      <arglist>(const QString &amp;originalword)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>replaceall</name>
      <anchor>l5</anchor>
      <arglist>(const QString &amp;origword, const QString &amp;replacement)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ready</name>
      <anchor>l6</anchor>
      <arglist>(KSpell *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>progress</name>
      <anchor>l7</anchor>
      <arglist>(unsigned int i)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>done</name>
      <anchor>l8</anchor>
      <arglist>(const QString &amp;buffer)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>done</name>
      <anchor>l9</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>death</name>
      <anchor>l10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dialog3</name>
      <anchor>l11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSpell</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const QString &amp;caption, QObject *receiver, const char *slot, KSpellConfig *kcs=0, bool progressbar=true, bool modal=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSpell</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent, const QString &amp;caption, QObject *receiver, const char *slot, KSpellConfig *kcs, bool progressbar, bool modal, SpellerType type)</arglist>
    </member>
    <member kind="function">
      <type>spellStatus</type>
      <name>status</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>cleanUp</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDelete</name>
      <anchor>a4</anchor>
      <arglist>(bool _autoDelete)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>check</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;_buffer, bool usedialog=true)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lastPosition</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>checkList</name>
      <anchor>a7</anchor>
      <arglist>(QStringList *_wordlist, bool usedialog=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>checkWord</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;_buffer, bool usedialog=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkWord</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;buffer, bool _usedialog, bool suggest)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>suggestions</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>dlgResult</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>moveDlg</name>
      <anchor>a13</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>heightDlg</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>widthDlg</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>intermediateBuffer</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>ignore</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;word)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>addPersonal</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;word)</arglist>
    </member>
    <member kind="function">
      <type>KSpellConfig</type>
      <name>ksConfig</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProgressResolution</name>
      <anchor>a20</anchor>
      <arglist>(unsigned int res)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSpell</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIgnoreUpperWords</name>
      <anchor>a22</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIgnoreTitleCase</name>
      <anchor>a23</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>modalCheck</name>
      <anchor>e0</anchor>
      <arglist>(QString &amp;text) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>modalCheck</name>
      <anchor>e1</anchor>
      <arglist>(QString &amp;text, KSpellConfig *kcs)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>KSpell2</name>
      <anchor>j0</anchor>
      <arglist>(KProcIO *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkWord2</name>
      <anchor>j1</anchor>
      <arglist>(KProcIO *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkWord3</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>check2</name>
      <anchor>j3</anchor>
      <arglist>(KProcIO *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkList2</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkList3a</name>
      <anchor>j5</anchor>
      <arglist>(KProcIO *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkListReplaceCurrent</name>
      <anchor>j6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkList4</name>
      <anchor>j7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>dialog2</name>
      <anchor>j8</anchor>
      <arglist>(int dlgresult)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>check3</name>
      <anchor>j9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>suggestWord</name>
      <anchor>j10</anchor>
      <arglist>(KProcIO *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotStopCancel</name>
      <anchor>j11</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>ispellExit</name>
      <anchor>j12</anchor>
      <arglist>(KProcess *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>emitDeath</name>
      <anchor>j13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>ispellErrors</name>
      <anchor>j14</anchor>
      <arglist>(KProcess *, char *, int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>checkNext</name>
      <anchor>j15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>parseOneResponse</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;_buffer, QString &amp;word, QStringList &amp;sugg)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>funnyWord</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;word)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>dialog</name>
      <anchor>b2</anchor>
      <arglist>(const QString &amp;word, QStringList &amp;sugg, const char *_slot)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>replacement</name>
      <anchor>b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setUpDialog</name>
      <anchor>b4</anchor>
      <arglist>(bool reallyusedialogbox=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>emitProgress</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>cleanFputs</name>
      <anchor>b6</anchor>
      <arglist>(const QString &amp;s, bool appendCR=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>cleanFputsWord</name>
      <anchor>b7</anchor>
      <arglist>(const QString &amp;s, bool appendCR=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>startIspell</name>
      <anchor>b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>writePersonalDictionary</name>
      <anchor>b9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initialize</name>
      <anchor>b10</anchor>
      <arglist>(QWidget *_parent, const QString &amp;_caption, QObject *obj, const char *slot, KSpellConfig *_ksc, bool _progressbar, bool _modal, SpellerType type)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KProcIO *</type>
      <name>proc</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QWidget *</type>
      <name>parent</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KSpellConfig *</type>
      <name>ksconfig</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KSpellDlg *</type>
      <name>ksdlg</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList *</type>
      <name>wordlist</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList::Iterator</type>
      <name>wlIt</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>ignorelist</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>replacelist</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>sugg</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QTextCodec *</type>
      <name>codec</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>spellStatus</type>
      <name>m_status</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>usedialog</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>texmode</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>dlgon</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>personaldict</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>dialogwillprocess</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>progressbar</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>dialogsetup</name>
      <anchor>p17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>autoDelete</name>
      <anchor>p18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>caption</name>
      <anchor>p19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>orig</name>
      <anchor>p20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>origbuffer</name>
      <anchor>p21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>newbuffer</name>
      <anchor>p22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>cwword</name>
      <anchor>p23</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>dlgorigword</name>
      <anchor>p24</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>dlgreplacement</name>
      <anchor>p25</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>dialog3slot</name>
      <anchor>p26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>dlgresult</name>
      <anchor>p27</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>trystart</name>
      <anchor>p28</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>maxtrystart</name>
      <anchor>p29</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>lastpos</name>
      <anchor>p30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>totalpos</name>
      <anchor>p31</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>lastline</name>
      <anchor>p32</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>posinline</name>
      <anchor>p33</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>lastlastline</name>
      <anchor>p34</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>offset</name>
      <anchor>p35</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>progres</name>
      <anchor>p36</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>curprog</name>
      <anchor>p37</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>modaldlg</name>
      <anchor>p38</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>QString</type>
      <name>modaltext</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>int</type>
      <name>modalreturn</name>
      <anchor>t1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>QWidget *</type>
      <name>modalWidgetHack</name>
      <anchor>t2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSpellConfig</name>
    <filename>classKSpellConfig.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>activateHelp</name>
      <anchor>i0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>configChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSpellConfig</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, KSpellConfig *spellConfig=0, bool addHelpButton=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSpellConfig</name>
      <anchor>a1</anchor>
      <arglist>(const KSpellConfig &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSpellConfig</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const KSpellConfig &amp;ksc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fillDicts</name>
      <anchor>a4</anchor>
      <arglist>(QComboBox *box, QStringList *dictionaries=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIgnoreList</name>
      <anchor>a5</anchor>
      <arglist>(QStringList _ignorelist)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReplaceAllList</name>
      <anchor>a6</anchor>
      <arglist>(QStringList _replaceAllList)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoRootAffix</name>
      <anchor>a7</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRunTogether</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDictionary</name>
      <anchor>a9</anchor>
      <arglist>(const QString qs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDictFromList</name>
      <anchor>a10</anchor>
      <arglist>(bool dfl)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEncoding</name>
      <anchor>a11</anchor>
      <arglist>(int enctype)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClient</name>
      <anchor>a12</anchor>
      <arglist>(int client)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>noRootAffix</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runTogether</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString</type>
      <name>dictionary</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dictFromList</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>encoding</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>ignoreList</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>replaceAllList</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>client</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeGlobalSettings</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readGlobalSettings</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sHelp</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sNoAff</name>
      <anchor>j1</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sRunTogether</name>
      <anchor>j2</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sDictionary</name>
      <anchor>j3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sPathDictionary</name>
      <anchor>j4</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sSetDictionary</name>
      <anchor>j5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sChangeEncoding</name>
      <anchor>j6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sChangeClient</name>
      <anchor>j7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>fillInDialog</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>interpret</name>
      <anchor>b1</anchor>
      <arglist>(QString &amp;fname, QString &amp;lname, QString &amp;hname)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>enc</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bnorootaffix</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bruntogether</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>dictfromlist</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>nodialog</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>qsdict</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>qspdict</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>ignorelist</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfig *</type>
      <name>kc</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>iclient</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCheckBox *</type>
      <name>cb1</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCheckBox *</type>
      <name>cb2</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QLabel *</type>
      <name>dictlist</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QComboBox *</type>
      <name>dictcombo</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QComboBox *</type>
      <name>encodingcombo</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QComboBox *</type>
      <name>clientcombo</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>langfnames</name>
      <anchor>p16</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSplashScreen</name>
    <filename>classKSplashScreen.html</filename>
    <base>QSplashScreen</base>
    <member kind="function">
      <type></type>
      <name>KSplashScreen</name>
      <anchor>a0</anchor>
      <arglist>(const QPixmap &amp;pixmap, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KSplashScreen</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSqueezedTextLabel</name>
    <filename>classKSqueezedTextLabel.html</filename>
    <base>QLabel</base>
    <member kind="slot">
      <type>void</type>
      <name>setText</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSqueezedTextLabel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSqueezedTextLabel</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>squeezeTextToLabel</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>fullText</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStatusBar</name>
    <filename>classKStatusBar.html</filename>
    <base>QStatusBar</base>
    <member kind="enumeration">
      <name>BarStatus</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>pressed</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>released</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStatusBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KStatusBar</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertItem</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, int id, int stretch=0, bool permanent=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertFixedItem</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, int id, bool permanent=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchor>a4</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasItem</name>
      <anchor>a5</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeItem</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;text, int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemAlignment</name>
      <anchor>a7</anchor>
      <arglist>(int id, int align)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemFixed</name>
      <anchor>a8</anchor>
      <arglist>(int id, int width=-1)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStatusBarLabel</name>
    <filename>classKStatusBarLabel.html</filename>
    <base>QLabel</base>
    <member kind="signal">
      <type>void</type>
      <name>itemPressed</name>
      <anchor>l0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>itemReleased</name>
      <anchor>l1</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStatusBarLabel</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, int _id, KStatusBar *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *_event)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *_event)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStringListValidator</name>
    <filename>classKStringListValidator.html</filename>
    <base>QValidator</base>
    <member kind="function">
      <type></type>
      <name>KStringListValidator</name>
      <anchor>a0</anchor>
      <arglist>(const QStringList &amp;list=QStringList(), bool rejecting=true, bool fixupEnabled=false, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual State</type>
      <name>validate</name>
      <anchor>a1</anchor>
      <arglist>(QString &amp;input, int &amp;pos) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>fixup</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;input) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRejecting</name>
      <anchor>a3</anchor>
      <arglist>(bool rejecting)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRejecting</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFixupEnabled</name>
      <anchor>a5</anchor>
      <arglist>(bool fixupEnabled)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFixupEnabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStringList</name>
      <anchor>a7</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>stringList</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>mStringList</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>mRejecting</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>mFixupEnabled</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSystemTray</name>
    <filename>classKSystemTray.html</filename>
    <base>QLabel</base>
    <member kind="signal">
      <type>void</type>
      <name>quitSelected</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSystemTray</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>contextMenu</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KActionCollection *</type>
      <name>actionCollection</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPixmap</type>
      <name>loadIcon</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;icon, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contextMenuAboutToShow</name>
      <anchor>b2</anchor>
      <arglist>(KPopupMenu *menu)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>showEvent</name>
      <anchor>b3</anchor>
      <arglist>(QShowEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>enterEvent</name>
      <anchor>b4</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b5</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTabBar</name>
    <filename>classKTabBar.html</filename>
    <base>QTabBar</base>
    <member kind="signal">
      <type>void</type>
      <name>contextMenu</name>
      <anchor>l0</anchor>
      <arglist>(int, const QPoint &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseDoubleClick</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseMiddleClick</name>
      <anchor>l2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>initiateDrag</name>
      <anchor>l3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>testCanDecode</name>
      <anchor>l4</anchor>
      <arglist>(const QDragMoveEvent *e, bool &amp;accept)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedDropEvent</name>
      <anchor>l5</anchor>
      <arglist>(int, QDropEvent *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>moveTab</name>
      <anchor>l6</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeRequest</name>
      <anchor>l7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTabBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setTabEnabled</name>
      <anchor>a2</anchor>
      <arglist>(int, bool)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>tabColor</name>
      <anchor>a3</anchor>
      <arglist>(int) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabColor</name>
      <anchor>a4</anchor>
      <arglist>(int, const QColor &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeTab</name>
      <anchor>a5</anchor>
      <arglist>(QTab *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabReorderingEnabled</name>
      <anchor>a6</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTabReorderingEnabled</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHoverCloseButton</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hoverCloseButton</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHoverCloseButtonDelayed</name>
      <anchor>a10</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hoverCloseButtonDelayed</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeButtonClicked</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>onLayoutChange</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>enableCloseButton</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>activateDragSwitchTab</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClickEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QDragMoveEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b5</anchor>
      <arglist>(QDropEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintLabel</name>
      <anchor>b6</anchor>
      <arglist>(QPainter *, const QRect &amp;, QTab *, bool) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTabCtl</name>
    <filename>classKTabCtl.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>tabSelected</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTabCtl</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFont</name>
      <anchor>a3</anchor>
      <arglist>(const QFont &amp;font)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabFont</name>
      <anchor>a4</anchor>
      <arglist>(const QFont &amp;font)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addTab</name>
      <anchor>a5</anchor>
      <arglist>(QWidget *, const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTabEnabled</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabEnabled</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;, bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBorder</name>
      <anchor>a8</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShape</name>
      <anchor>a9</anchor>
      <arglist>(QTabBar::Shape shape)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QSize</type>
      <name>sizeHint</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>showTab</name>
      <anchor>j0</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>b0</anchor>
      <arglist>(QPaintEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSizes</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QRect</type>
      <name>getChildRect</name>
      <anchor>b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QTabBar *</type>
      <name>tabs</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMemArray&lt; QWidget * &gt;</type>
      <name>pages</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>bh</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>blBorder</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTabWidget</name>
    <filename>classKTabWidget.html</filename>
    <base>QTabWidget</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>moveTab</name>
      <anchor>i0</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTabReorderingEnabled</name>
      <anchor>i1</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHoverCloseButton</name>
      <anchor>i2</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHoverCloseButtonDelayed</name>
      <anchor>i3</anchor>
      <arglist>(bool delayed)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>testCanDecode</name>
      <anchor>l0</anchor>
      <arglist>(const QDragMoveEvent *e, bool &amp;accept)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedDropEvent</name>
      <anchor>l1</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedDropEvent</name>
      <anchor>l2</anchor>
      <arglist>(QWidget *, QDropEvent *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>initiateDrag</name>
      <anchor>l3</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>contextMenu</name>
      <anchor>l4</anchor>
      <arglist>(const QPoint &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>contextMenu</name>
      <anchor>l5</anchor>
      <arglist>(QWidget *, const QPoint &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>movedTab</name>
      <anchor>l6</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseDoubleClick</name>
      <anchor>l7</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseMiddleClick</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>mouseMiddleClick</name>
      <anchor>l9</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeRequest</name>
      <anchor>l10</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTabWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags f=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KTabWidget</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabColor</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *, const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>tabColor</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTabReorderingEnabled</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hoverCloseButton</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hoverCloseButtonDelayed</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>receivedDropEvent</name>
      <anchor>j0</anchor>
      <arglist>(int, QDropEvent *)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>initiateDrag</name>
      <anchor>j1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contextMenu</name>
      <anchor>j2</anchor>
      <arglist>(int, const QPoint &amp;)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseDoubleClick</name>
      <anchor>j3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMiddleClick</name>
      <anchor>j4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>closeRequest</name>
      <anchor>j5</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dragMoveEvent</name>
      <anchor>b1</anchor>
      <arglist>(QDragMoveEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b2</anchor>
      <arglist>(QDropEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextBrowser</name>
    <filename>classKTextBrowser.html</filename>
    <base>QTextBrowser</base>
    <member kind="signal">
      <type>void</type>
      <name>mailClick</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;address)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>urlClick</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTextBrowser</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool notifyClick=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KTextBrowser</name>
      <anchor>a1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNotifyClick</name>
      <anchor>a2</anchor>
      <arglist>(bool notifyClick)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNotifyClick</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSource</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b1</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>viewportMouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsWheelEvent</name>
      <anchor>b3</anchor>
      <arglist>(QWheelEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEdit</name>
    <filename>classKTextEdit.html</filename>
    <base>QTextEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>checkSpelling</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTextEdit</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const QString &amp;context=QString::null, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTextEdit</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KTextEdit</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setReadOnly</name>
      <anchor>a3</anchor>
      <arglist>(bool readOnly)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPalette</name>
      <anchor>a4</anchor>
      <arglist>(const QPalette &amp;palette)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCheckSpellingEnabled</name>
      <anchor>a5</anchor>
      <arglist>(bool check)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkSpellingEnabled</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>highLightWord</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int length, unsigned int pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>focusInEvent</name>
      <anchor>b1</anchor>
      <arglist>(QFocusEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>contentsWheelEvent</name>
      <anchor>b2</anchor>
      <arglist>(QWheelEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>deleteWordBack</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>deleteWordForward</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QPopupMenu *</type>
      <name>createPopupMenu</name>
      <anchor>b5</anchor>
      <arglist>(const QPoint &amp;pos)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QPopupMenu *</type>
      <name>createPopupMenu</name>
      <anchor>b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTimeWidget</name>
    <filename>classKTimeWidget.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setTime</name>
      <anchor>i0</anchor>
      <arglist>(const QTime &amp;time)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(const QTime &amp;time)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTimeWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTimeWidget</name>
      <anchor>a1</anchor>
      <arglist>(const QTime &amp;time, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KTimeWidget</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QTime</type>
      <name>time</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTipDatabase</name>
    <filename>classKTipDatabase.html</filename>
    <member kind="function">
      <type></type>
      <name>KTipDatabase</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;tipFile=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KTipDatabase</name>
      <anchor>a1</anchor>
      <arglist>(const QStringList &amp;tipFiles)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tip</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>nextTip</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prevTip</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTipDialog</name>
    <filename>classKTipDialog.html</filename>
    <base>KDialog</base>
    <member kind="function">
      <type></type>
      <name>KTipDialog</name>
      <anchor>a0</anchor>
      <arglist>(KTipDatabase *db, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showTip</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *parent, const QString &amp;tipFile=QString::null, bool force=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showMultiTip</name>
      <anchor>e1</anchor>
      <arglist>(QWidget *parent, const QStringList &amp;tipFiles, bool force=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showTip</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;tipFile=QString::null, bool force=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setShowOnStart</name>
      <anchor>e3</anchor>
      <arglist>(bool show)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToggleAction</name>
    <filename>classKToggleAction.html</filename>
    <base>KAction</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setChecked</name>
      <anchor>i0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toggled</name>
      <anchor>l0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;text, const QIconSet &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text, const QString &amp;pix, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleAction</name>
      <anchor>a6</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KToggleAction</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a8</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isChecked</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>exclusiveGroup</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setExclusiveGroup</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>slotActivated</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateChecked</name>
      <anchor>b0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToggleFullScreenAction</name>
    <filename>classKToggleFullScreenAction.html</filename>
    <base>KToggleAction</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setChecked</name>
      <anchor>i0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleFullScreenAction</name>
      <anchor>a0</anchor>
      <arglist>(const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent, QWidget *window, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindow</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *window)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToggleToolBarAction</name>
    <filename>classKToggleToolBarAction.html</filename>
    <base>KToggleAction</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setChecked</name>
      <anchor>i0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleToolBarAction</name>
      <anchor>a0</anchor>
      <arglist>(const char *toolBarName, const QString &amp;text, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToggleToolBarAction</name>
      <anchor>a1</anchor>
      <arglist>(KToolBar *toolBar, const QString &amp;text, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>KToolBar *</type>
      <name>toolBar</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToolBar</name>
    <filename>classKToolBar.html</filename>
    <base>QToolBar</base>
    <member kind="enumeration">
      <name>BarStatus</name>
      <anchor>w15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BarPosition</name>
      <anchor>w16</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setIconText</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;txt)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l1</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>pressed</name>
      <anchor>l2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>released</name>
      <anchor>l3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toggled</name>
      <anchor>l4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l5</anchor>
      <arglist>(int id, bool isHighlighted)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l6</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>moved</name>
      <anchor>l7</anchor>
      <arglist>(BarPosition)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>modechange</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toolbarDestroyed</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0, bool honorStyle=false, bool readConfig=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBar</name>
      <anchor>a1</anchor>
      <arglist>(QMainWindow *parentWindow, QMainWindow::ToolBarDock dock, bool newLine=false, const char *name=0, bool honorStyle=false, bool readConfig=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBar</name>
      <anchor>a2</anchor>
      <arglist>(QMainWindow *parentWindow, QWidget *dock, bool newLine=false, const char *name=0, bool honorStyle=false, bool readConfig=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KToolBar</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;icon, int id, bool enabled=true, const QString &amp;text=QString::null, int index=-1, KInstance *_instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;icon, int id, const char *signal, const QObject *receiver, const char *slot, bool enabled=true, const QString &amp;text=QString::null, int index=-1, KInstance *_instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a6</anchor>
      <arglist>(const QPixmap &amp;pixmap, int id, bool enabled=true, const QString &amp;text=QString::null, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a7</anchor>
      <arglist>(const QPixmap &amp;pixmap, int id, const char *signal, const QObject *receiver, const char *slot, bool enabled=true, const QString &amp;text=QString::null, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;icon, int id, QPopupMenu *popup, bool enabled, const QString &amp;_text, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertButton</name>
      <anchor>a9</anchor>
      <arglist>(const QPixmap &amp;pixmap, int id, QPopupMenu *popup, bool enabled, const QString &amp;_text, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertLined</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;text, int id, const char *signal, const QObject *receiver, const char *slot, bool enabled=true, const QString &amp;toolTipText=QString::null, int size=70, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertCombo</name>
      <anchor>a11</anchor>
      <arglist>(const QStringList &amp;list, int id, bool writable, const char *signal, const QObject *receiver, const char *slot, bool enabled=true, const QString &amp;tooltiptext=QString::null, int size=70, int index=-1, QComboBox::Policy policy=QComboBox::AtBottom)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertCombo</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;text, int id, bool writable, const char *signal, QObject *receiver, const char *slot, bool enabled=true, const QString &amp;tooltiptext=QString::null, int size=70, int index=-1, QComboBox::Policy policy=QComboBox::AtBottom)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertSeparator</name>
      <anchor>a13</anchor>
      <arglist>(int index=-1, int id=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertLineSeparator</name>
      <anchor>a14</anchor>
      <arglist>(int index=-1, int id=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertWidget</name>
      <anchor>a15</anchor>
      <arglist>(int id, int width, QWidget *_widget, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>insertAnimatedWidget</name>
      <anchor>a16</anchor>
      <arglist>(int id, QObject *receiver, const char *slot, const QString &amp;icons, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>KAnimWidget *</type>
      <name>animatedWidget</name>
      <anchor>a17</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addConnection</name>
      <anchor>a18</anchor>
      <arglist>(int id, const char *signal, const QObject *receiver, const char *slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemEnabled</name>
      <anchor>a19</anchor>
      <arglist>(int id, bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonIcon</name>
      <anchor>a20</anchor>
      <arglist>(int id, const QString &amp;_icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonPixmap</name>
      <anchor>a21</anchor>
      <arglist>(int id, const QPixmap &amp;_pixmap)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButtonIconSet</name>
      <anchor>a22</anchor>
      <arglist>(int id, const QIconSet &amp;iconset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDelayedPopup</name>
      <anchor>a23</anchor>
      <arglist>(int id, QPopupMenu *_popup, bool toggle=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoRepeat</name>
      <anchor>a24</anchor>
      <arglist>(int id, bool flag=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToggle</name>
      <anchor>a25</anchor>
      <arglist>(int id, bool flag=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>toggleButton</name>
      <anchor>a26</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setButton</name>
      <anchor>a27</anchor>
      <arglist>(int id, bool flag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isButtonOn</name>
      <anchor>a28</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLinedText</name>
      <anchor>a29</anchor>
      <arglist>(int id, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getLinedText</name>
      <anchor>a30</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertComboItem</name>
      <anchor>a31</anchor>
      <arglist>(int id, const QString &amp;text, int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertComboList</name>
      <anchor>a32</anchor>
      <arglist>(int id, const QStringList &amp;list, int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeComboItem</name>
      <anchor>a33</anchor>
      <arglist>(int id, int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentComboItem</name>
      <anchor>a34</anchor>
      <arglist>(int id, int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeComboItem</name>
      <anchor>a35</anchor>
      <arglist>(int id, const QString &amp;text, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearCombo</name>
      <anchor>a36</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getComboItem</name>
      <anchor>a37</anchor>
      <arglist>(int id, int index=-1) const </arglist>
    </member>
    <member kind="function">
      <type>KComboBox *</type>
      <name>getCombo</name>
      <anchor>a38</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>KLineEdit *</type>
      <name>getLined</name>
      <anchor>a39</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>KToolBarButton *</type>
      <name>getButton</name>
      <anchor>a40</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>alignItemRight</name>
      <anchor>a41</anchor>
      <arglist>(int id, bool right=true)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>getWidget</name>
      <anchor>a42</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemAutoSized</name>
      <anchor>a43</anchor>
      <arglist>(int id, bool yes=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchor>a45</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItemDelayed</name>
      <anchor>a46</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hideItem</name>
      <anchor>a47</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showItem</name>
      <anchor>a48</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>itemIndex</name>
      <anchor>a49</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>idAt</name>
      <anchor>a50</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFullSize</name>
      <anchor>a51</anchor>
      <arglist>(bool flag=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>fullSize</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableMoving</name>
      <anchor>a53</anchor>
      <arglist>(bool flag=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBarPos</name>
      <anchor>a54</anchor>
      <arglist>(BarPosition bpos)</arglist>
    </member>
    <member kind="function">
      <type>BarPosition</type>
      <name>barPos</name>
      <anchor>a55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>enable</name>
      <anchor>a56</anchor>
      <arglist>(BarStatus stat) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxHeight</name>
      <anchor>a57</anchor>
      <arglist>(int h) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxHeight</name>
      <anchor>a58</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxWidth</name>
      <anchor>a59</anchor>
      <arglist>(int dw) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxWidth</name>
      <anchor>a60</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a61</anchor>
      <arglist>(const QString &amp;_title)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableFloating</name>
      <anchor>a62</anchor>
      <arglist>(bool flag) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconText</name>
      <anchor>a63</anchor>
      <arglist>(IconText it)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconText</name>
      <anchor>a64</anchor>
      <arglist>(IconText it, bool update)</arglist>
    </member>
    <member kind="function">
      <type>IconText</type>
      <name>iconText</name>
      <anchor>a65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconSize</name>
      <anchor>a66</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIconSize</name>
      <anchor>a67</anchor>
      <arglist>(int size, bool update)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>iconSize</name>
      <anchor>a68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnableContextMenu</name>
      <anchor>a69</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contextMenuEnabled</name>
      <anchor>a70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemNoStyle</name>
      <anchor>a71</anchor>
      <arglist>(int id, bool no_style=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFlat</name>
      <anchor>a72</anchor>
      <arglist>(bool flag)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveState</name>
      <anchor>a74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveSettings</name>
      <anchor>a75</anchor>
      <arglist>(KConfig *config, const QString &amp;configGroup)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applySettings</name>
      <anchor>a76</anchor>
      <arglist>(KConfig *config, const QString &amp;configGroup)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXMLGUIClient</name>
      <anchor>a77</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a78</anchor>
      <arglist>(const QString &amp;txt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>text</name>
      <anchor>a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStretchableWidget</name>
      <anchor>a80</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function">
      <type>QSizePolicy</type>
      <name>sizePolicy</name>
      <anchor>a81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>highlight</name>
      <anchor>a82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>a84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>minimumSize</name>
      <anchor>a85</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hide</name>
      <anchor>a86</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchor>a87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateRects</name>
      <anchor>a88</anchor>
      <arglist>(bool=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadState</name>
      <anchor>a89</anchor>
      <arglist>(const QDomElement &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveState</name>
      <anchor>a90</anchor>
      <arglist>(QDomElement &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>positionYourself</name>
      <anchor>a91</anchor>
      <arglist>(bool force=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>highlightSetting</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>transparentSetting</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>IconText</type>
      <name>iconTextSetting</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>childEvent</name>
      <anchor>b1</anchor>
      <arglist>(QChildEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>showEvent</name>
      <anchor>b2</anchor>
      <arglist>(QShowEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b3</anchor>
      <arglist>(QResizeEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>event</name>
      <anchor>b4</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>applyAppearanceSettings</name>
      <anchor>b5</anchor>
      <arglist>(KConfig *config, const QString &amp;_configGroup, bool forceGlobal=false)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>settingsGroup</name>
      <anchor>b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToolBarButton</name>
    <filename>classKToolBarButton.html</filename>
    <base>QToolButton</base>
    <member kind="slot">
      <type>void</type>
      <name>modeChange</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setTextLabel</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;, bool tipToo)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>doubleClicked</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>pressed</name>
      <anchor>l2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>released</name>
      <anchor>l3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toggled</name>
      <anchor>l4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>highlighted</name>
      <anchor>l5</anchor>
      <arglist>(int, bool)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarButton</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;icon, int id, QWidget *parent, const char *name=0L, const QString &amp;txt=QString::null, KInstance *_instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarButton</name>
      <anchor>a1</anchor>
      <arglist>(const QPixmap &amp;pixmap, int id, QWidget *parent, const char *name=0L, const QString &amp;txt=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarButton</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KToolBarButton</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPixmap</name>
      <anchor>a4</anchor>
      <arglist>(const QPixmap &amp;pixmap) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultPixmap</name>
      <anchor>a5</anchor>
      <arglist>(const QPixmap &amp;pixmap) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabledPixmap</name>
      <anchor>a6</anchor>
      <arglist>(const QPixmap &amp;pixmap) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setText</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIcon</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;icon)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIcon</name>
      <anchor>a9</anchor>
      <arglist>(const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIconSet</name>
      <anchor>a10</anchor>
      <arglist>(const QIconSet &amp;iconset)</arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED void</type>
      <name>setIcon</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;icon, bool generate)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultIcon</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;icon) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDisabledIcon</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;icon) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>on</name>
      <anchor>a14</anchor>
      <arglist>(bool flag=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>toggle</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToggle</name>
      <anchor>a16</anchor>
      <arglist>(bool toggle=true)</arglist>
    </member>
    <member kind="function">
      <type>QPopupMenu *</type>
      <name>popup</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPopup</name>
      <anchor>a19</anchor>
      <arglist>(QPopupMenu *p, bool unused=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDelayedPopup</name>
      <anchor>a20</anchor>
      <arglist>(QPopupMenu *p, bool unused=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadio</name>
      <anchor>a21</anchor>
      <arglist>(bool f=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNoStyle</name>
      <anchor>a22</anchor>
      <arglist>(bool no_style=true)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotClicked</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotPressed</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotReleased</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotToggled</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDelayTimeout</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paletteChange</name>
      <anchor>b0</anchor>
      <arglist>(const QPalette &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>leaveEvent</name>
      <anchor>b1</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>enterEvent</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>drawButton</name>
      <anchor>b3</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>b4</anchor>
      <arglist>(QObject *o, QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>showMenu</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSize</type>
      <name>minimumSizeHint</name>
      <anchor>b7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSize</type>
      <name>minimumSize</name>
      <anchor>b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isRaised</name>
      <anchor>b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>isActive</name>
      <anchor>b10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>iconTextMode</name>
      <anchor>b11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b12</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToolBarButtonList</name>
    <filename>classKToolBarButtonList.html</filename>
    <base>QIntDict&lt; KToolBarButton &gt;</base>
  </compound>
  <compound kind="class">
    <name>KToolBarPopupAction</name>
    <filename>classKToolBarPopupAction.html</filename>
    <base>KAction</base>
    <member kind="function">
      <type></type>
      <name>KToolBarPopupAction</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text, const QString &amp;icon, const KShortcut &amp;cut=KShortcut(), QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarPopupAction</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, const QString &amp;icon, const KShortcut &amp;cut, const QObject *receiver, const char *slot, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarPopupAction</name>
      <anchor>a2</anchor>
      <arglist>(const KGuiItem &amp;item, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function">
      <type>KPopupMenu *</type>
      <name>popupMenu</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>delayed</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDelayed</name>
      <anchor>a7</anchor>
      <arglist>(bool delayed)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stickyMenu</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStickyMenu</name>
      <anchor>a9</anchor>
      <arglist>(bool sticky)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KToolBarRadioGroup</name>
    <filename>classKToolBarRadioGroup.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>slotToggled</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KToolBarRadioGroup</name>
      <anchor>a0</anchor>
      <arglist>(KToolBar *_parent, const char *_name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KToolBarRadioGroup</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addButton</name>
      <anchor>a2</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeButton</name>
      <anchor>a3</anchor>
      <arglist>(int id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KURLLabel</name>
    <filename>classKURLLabel.html</filename>
    <base>QLabel</base>
    <member kind="slot">
      <type>void</type>
      <name>setUnderline</name>
      <anchor>i0</anchor>
      <arglist>(bool on=true)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setURL</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>i2</anchor>
      <arglist>(const QFont &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setUseTips</name>
      <anchor>i3</anchor>
      <arglist>(bool on=true)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTipText</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;tip)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHighlightedColor</name>
      <anchor>i5</anchor>
      <arglist>(const QColor &amp;highcolor)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHighlightedColor</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;highcolor)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSelectedColor</name>
      <anchor>i7</anchor>
      <arglist>(const QColor &amp;selcolor)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setSelectedColor</name>
      <anchor>i8</anchor>
      <arglist>(const QString &amp;selcolor)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setUseCursor</name>
      <anchor>i9</anchor>
      <arglist>(bool on, QCursor *cursor=0L)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setGlow</name>
      <anchor>i10</anchor>
      <arglist>(bool glow=true)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setFloat</name>
      <anchor>i11</anchor>
      <arglist>(bool do_float=true)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setAltPixmap</name>
      <anchor>i12</anchor>
      <arglist>(const QPixmap &amp;altPix)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>enteredURL</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>enteredURL</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>leftURL</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>leftURL</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>leftClickedURL</name>
      <anchor>l4</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>leftClickedURL</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>rightClickedURL</name>
      <anchor>l6</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>rightClickedURL</name>
      <anchor>l7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>middleClickedURL</name>
      <anchor>l8</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>middleClickedURL</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURLLabel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURLLabel</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;url, const QString &amp;text=QString::null, QWidget *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KURLLabel</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>url</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>tipText</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>useTips</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>useCursor</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isGlowEnabled</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFloatEnabled</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QPixmap *</type>
      <name>altPixmap</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>enterEvent</name>
      <anchor>b1</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>leaveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>event</name>
      <anchor>b3</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KValueSelector</name>
    <filename>classKValueSelector.html</filename>
    <base>KSelector</base>
    <member kind="function">
      <type></type>
      <name>KValueSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KValueSelector</name>
      <anchor>a1</anchor>
      <arglist>(Orientation o, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>hue</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHue</name>
      <anchor>a3</anchor>
      <arglist>(int h)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>saturation</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSaturation</name>
      <anchor>a5</anchor>
      <arglist>(int s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateContents</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawPalette</name>
      <anchor>b0</anchor>
      <arglist>(QPixmap *pixmap)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b1</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b2</anchor>
      <arglist>(QPainter *painter)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWidgetAction</name>
    <filename>classKWidgetAction.html</filename>
    <base>KAction</base>
    <member kind="function">
      <type></type>
      <name>KWidgetAction</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *widget, const QString &amp;text, const KShortcut &amp;cut, const QObject *receiver, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>widget</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoSized</name>
      <anchor>a3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>plug</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *widget, int index=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unplug</name>
      <anchor>a5</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotToolbarDestroyed</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWindowInfo</name>
    <filename>classKWindowInfo.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>message</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>message</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;text, const QPixmap &amp;pix)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>message</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;text, int timeout)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>message</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;text, const QPixmap &amp;pix, int timeout)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>permanent</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>permanent</name>
      <anchor>i5</anchor>
      <arglist>(const QString &amp;text, const QPixmap &amp;pix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KWindowInfo</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KWindowInfo</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>autoDelete</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDelete</name>
      <anchor>a3</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showMessage</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *window, const QString &amp;text, int timeout=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showMessage</name>
      <anchor>e1</anchor>
      <arglist>(QWidget *window, const QString &amp;text, const QPixmap &amp;pix, int timeout=-1)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>save</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>restore</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>display</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;text, const QPixmap &amp;pix)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWizard</name>
    <filename>classKWizard.html</filename>
    <base>QWizard</base>
    <member kind="function">
      <type></type>
      <name>KWizard</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool modal=false, WFlags f=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KWizard</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWordWrap</name>
    <filename>classKWordWrap.html</filename>
    <member kind="function">
      <type>QRect</type>
      <name>boundingRect</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>wrappedString</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>truncatedString</name>
      <anchor>a2</anchor>
      <arglist>(bool dots=true) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawText</name>
      <anchor>a3</anchor>
      <arglist>(QPainter *painter, int x, int y, int flags=Qt::AlignAuto) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KWordWrap</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KWordWrap *</type>
      <name>formatText</name>
      <anchor>e0</anchor>
      <arglist>(QFontMetrics &amp;fm, const QRect &amp;r, int flags, const QString &amp;str, int len=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>drawFadeoutText</name>
      <anchor>e1</anchor>
      <arglist>(QPainter *p, int x, int y, int maxW, const QString &amp;t)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWritePermsIcon</name>
    <filename>classKWritePermsIcon.html</filename>
    <base>KAuthIcon</base>
    <member kind="slot">
      <type>void</type>
      <name>updateStatus</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KWritePermsIcon</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;fileName, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>status</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileName</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>writable</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QFileInfo</type>
      <name>fi</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KXMLGUIBuilder</name>
    <filename>classKXMLGUIBuilder.html</filename>
    <member kind="function">
      <type></type>
      <name>KXMLGUIBuilder</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>KXMLGUIClient *</type>
      <name>builderClient</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBuilderClient</name>
      <anchor>a3</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type>KInstance *</type>
      <name>builderInstance</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBuilderInstance</name>
      <anchor>a5</anchor>
      <arglist>(KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>widget</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>containerTags</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QWidget *</type>
      <name>createContainer</name>
      <anchor>a8</anchor>
      <arglist>(QWidget *parent, int index, const QDomElement &amp;element, int &amp;id)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeContainer</name>
      <anchor>a9</anchor>
      <arglist>(QWidget *container, QWidget *parent, QDomElement &amp;element, int id)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>customTags</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>createCustomElement</name>
      <anchor>a11</anchor>
      <arglist>(QWidget *parent, int index, const QDomElement &amp;element)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeCustomElement</name>
      <anchor>a12</anchor>
      <arglist>(QWidget *parent, int id)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>finalizeGUI</name>
      <anchor>a13</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KXMLGUIClient</name>
    <filename>classKXMLGUIClient.html</filename>
    <member kind="function">
      <type></type>
      <name>KXMLGUIClient</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KXMLGUIClient</name>
      <anchor>a1</anchor>
      <arglist>(KXMLGUIClient *parent)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KXMLGUIClient</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>action</name>
      <anchor>a3</anchor>
      <arglist>(const char *name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KAction *</type>
      <name>action</name>
      <anchor>a4</anchor>
      <arglist>(const QDomElement &amp;element) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KActionCollection *</type>
      <name>actionCollection</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KInstance *</type>
      <name>instance</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QDomDocument</type>
      <name>domDocument</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>xmlFile</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>localXMLFile</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXMLGUIBuildDocument</name>
      <anchor>a10</anchor>
      <arglist>(const QDomDocument &amp;doc)</arglist>
    </member>
    <member kind="function">
      <type>QDomDocument</type>
      <name>xmlguiBuildDocument</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFactory</name>
      <anchor>a12</anchor>
      <arglist>(KXMLGUIFactory *factory)</arglist>
    </member>
    <member kind="function">
      <type>KXMLGUIFactory *</type>
      <name>factory</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KXMLGUIClient *</type>
      <name>parentClient</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertChildClient</name>
      <anchor>a15</anchor>
      <arglist>(KXMLGUIClient *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeChildClient</name>
      <anchor>a16</anchor>
      <arglist>(KXMLGUIClient *child)</arglist>
    </member>
    <member kind="function">
      <type>const QPtrList&lt; KXMLGUIClient &gt; *</type>
      <name>childClients</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setClientBuilder</name>
      <anchor>a18</anchor>
      <arglist>(KXMLGUIBuilder *builder)</arglist>
    </member>
    <member kind="function">
      <type>KXMLGUIBuilder *</type>
      <name>clientBuilder</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reloadXML</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>plugActionList</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;name, const QPtrList&lt; KAction &gt; &amp;actionList)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unplugActionList</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addStateActionEnabled</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;state, const QString &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addStateActionDisabled</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;state, const QString &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>StateChange</type>
      <name>getActionsToChangeForState</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>beginXMLPlug</name>
      <anchor>a26</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endXMLPlug</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepareXMLUnplug</name>
      <anchor>a28</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>findMostRecentXMLFile</name>
      <anchor>e0</anchor>
      <arglist>(const QStringList &amp;files, QString &amp;doc)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setInstance</name>
      <anchor>b0</anchor>
      <arglist>(KInstance *instance)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setXMLFile</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;file, bool merge=false, bool setXMLDoc=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setLocalXMLFile</name>
      <anchor>b2</anchor>
      <arglist>(const QString &amp;file)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setXML</name>
      <anchor>b3</anchor>
      <arglist>(const QString &amp;document, bool merge=false)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setDOMDocument</name>
      <anchor>b4</anchor>
      <arglist>(const QDomDocument &amp;document, bool merge=false)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>conserveMemory</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>stateChanged</name>
      <anchor>b6</anchor>
      <arglist>(const QString &amp;newstate, ReverseStateChange reverse=StateNoReverse)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KEditToolbarWidget</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KXMLGUIFactory</name>
    <filename>classKXMLGUIFactory.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>clientAdded</name>
      <anchor>l0</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clientRemoved</name>
      <anchor>l1</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KXMLGUIFactory</name>
      <anchor>a0</anchor>
      <arglist>(KXMLGUIBuilder *builder, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KXMLGUIFactory</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addClient</name>
      <anchor>a2</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeClient</name>
      <anchor>a3</anchor>
      <arglist>(KXMLGUIClient *client)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>plugActionList</name>
      <anchor>a4</anchor>
      <arglist>(KXMLGUIClient *client, const QString &amp;name, const QPtrList&lt; KAction &gt; &amp;actionList)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unplugActionList</name>
      <anchor>a5</anchor>
      <arglist>(KXMLGUIClient *client, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; KXMLGUIClient &gt;</type>
      <name>clients</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>container</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;containerName, KXMLGUIClient *client, bool useTagName=false)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; QWidget &gt;</type>
      <name>containers</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;tagName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetContainer</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;containerName, bool useTagName=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>readConfigFile</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, bool never_null, const KInstance *instance=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>readConfigFile</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;filename, const KInstance *instance=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>saveConfigFile</name>
      <anchor>e2</anchor>
      <arglist>(const QDomDocument &amp;doc, const QString &amp;filename, const KInstance *instance=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>documentToXML</name>
      <anchor>e3</anchor>
      <arglist>(const QDomDocument &amp;doc)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>elementToXML</name>
      <anchor>e4</anchor>
      <arglist>(const QDomElement &amp;elem)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>removeDOMComments</name>
      <anchor>e5</anchor>
      <arglist>(QDomNode &amp;node)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KXMLGUI::BuildHelper</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KXYSelector</name>
    <filename>classKXYSelector.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>valueChanged</name>
      <anchor>l0</anchor>
      <arglist>(int x, int y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KXYSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KXYSelector</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValues</name>
      <anchor>a2</anchor>
      <arglist>(int xPos, int yPos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRange</name>
      <anchor>a3</anchor>
      <arglist>(int minX, int minY, int maxX, int maxY)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>yValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>contentsRect</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawContents</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>drawCursor</name>
      <anchor>b1</anchor>
      <arglist>(QPainter *p, int xp, int yp)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paintEvent</name>
      <anchor>b2</anchor>
      <arglist>(QPaintEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b3</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseMoveEvent</name>
      <anchor>b4</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>wheelEvent</name>
      <anchor>b5</anchor>
      <arglist>(QWheelEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>valuesFromPosition</name>
      <anchor>b6</anchor>
      <arglist>(int x, int y, int &amp;xVal, int &amp;yVal) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KAccelGen</name>
    <filename>namespaceKAccelGen.html</filename>
    <class kind="class">KAccelGen::Deref</class>
    <class kind="class">KAccelGen::Deref_Key</class>
    <member kind="function">
      <type>bool</type>
      <name>isLegalAccelerator</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;str, uint index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>loadPredefined</name>
      <anchor>a1</anchor>
      <arglist>(Iter begin, Iter end, QMap&lt; QChar, bool &gt; &amp;keys)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchor>a2</anchor>
      <arglist>(Iter begin, Iter end, QStringList &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generateFromKeys</name>
      <anchor>a3</anchor>
      <arglist>(Iter begin, Iter end, QStringList &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generate</name>
      <anchor>a4</anchor>
      <arglist>(const QStringList &amp;source, QStringList &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generateFromValues</name>
      <anchor>a5</anchor>
      <arglist>(const QMap&lt; Key, QString &gt; &amp;source, QStringList &amp;target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>generateFromKeys</name>
      <anchor>a6</anchor>
      <arglist>(const QMap&lt; QString, Data &gt; &amp;source, QStringList &amp;target)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccelGen::Deref</name>
    <filename>classKAccelGen_1_1Deref.html</filename>
    <templarg>Iter</templarg>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>deref</name>
      <anchor>e0</anchor>
      <arglist>(Iter i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccelGen::Deref_Key</name>
    <filename>classKAccelGen_1_1Deref__Key.html</filename>
    <templarg>Iter</templarg>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>deref</name>
      <anchor>e0</anchor>
      <arglist>(Iter i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDEPrivate::ToolBarHandler</name>
    <filename>classKDEPrivate_1_1ToolBarHandler.html</filename>
    <base>QObject</base>
    <base>KXMLGUIClient</base>
    <member kind="slot">
      <type>void</type>
      <name>setupActions</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ToolBarHandler</name>
      <anchor>a0</anchor>
      <arglist>(KMainWindow *mainWindow, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ToolBarHandler</name>
      <anchor>a1</anchor>
      <arglist>(KMainWindow *mainWindow, QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>toolBarMenuAction</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KStdAction</name>
    <filename>namespaceKStdAction.html</filename>
    <member kind="enumeration">
      <name>StdAction</name>
      <anchor>a135</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TipofDay</name>
      <anchor>a135a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FullScreen</name>
      <anchor>a135a60</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Clear</name>
      <anchor>a135a61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PasteText</name>
      <anchor>a135a62</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>stdNames</name>
      <anchor>a64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>create</name>
      <anchor>a65</anchor>
      <arglist>(StdAction id, const char *name, const QObject *recvr, const char *slot, KActionCollection *parent)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>name</name>
      <anchor>a66</anchor>
      <arglist>(StdAction id)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>openNew</name>
      <anchor>a67</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>open</name>
      <anchor>a68</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KRecentFilesAction *</type>
      <name>openRecent</name>
      <anchor>a69</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>save</name>
      <anchor>a70</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>saveAs</name>
      <anchor>a71</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>revert</name>
      <anchor>a72</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>print</name>
      <anchor>a73</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>printPreview</name>
      <anchor>a74</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>close</name>
      <anchor>a75</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>mail</name>
      <anchor>a76</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>quit</name>
      <anchor>a77</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>undo</name>
      <anchor>a78</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>redo</name>
      <anchor>a79</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>cut</name>
      <anchor>a80</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>copy</name>
      <anchor>a81</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>paste</name>
      <anchor>a82</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>pasteText</name>
      <anchor>a83</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>clear</name>
      <anchor>a84</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>selectAll</name>
      <anchor>a85</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>deselect</name>
      <anchor>a86</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>find</name>
      <anchor>a87</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>findNext</name>
      <anchor>a88</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>findPrev</name>
      <anchor>a89</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>replace</name>
      <anchor>a90</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>actualSize</name>
      <anchor>a91</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>fitToPage</name>
      <anchor>a92</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>fitToWidth</name>
      <anchor>a93</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>fitToHeight</name>
      <anchor>a94</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>zoomIn</name>
      <anchor>a95</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>zoomOut</name>
      <anchor>a96</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>zoom</name>
      <anchor>a97</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>redisplay</name>
      <anchor>a98</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>up</name>
      <anchor>a99</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>back</name>
      <anchor>a100</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>forward</name>
      <anchor>a101</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>home</name>
      <anchor>a102</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>prior</name>
      <anchor>a103</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>next</name>
      <anchor>a104</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>goTo</name>
      <anchor>a105</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>gotoPage</name>
      <anchor>a106</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>gotoLine</name>
      <anchor>a107</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>firstPage</name>
      <anchor>a108</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>lastPage</name>
      <anchor>a109</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>addBookmark</name>
      <anchor>a110</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>editBookmarks</name>
      <anchor>a111</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>spelling</name>
      <anchor>a112</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KToggleAction *</type>
      <name>showMenubar</name>
      <anchor>a113</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *_name)</arglist>
    </member>
    <member kind="function">
      <type>KToggleAction *</type>
      <name>showToolbar</name>
      <anchor>a114</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *_name)</arglist>
    </member>
    <member kind="function">
      <type>KToggleToolBarAction *</type>
      <name>showToolbar</name>
      <anchor>a115</anchor>
      <arglist>(const char *toolBarName, KActionCollection *parent, const char *_name)</arglist>
    </member>
    <member kind="function">
      <type>KToggleAction *</type>
      <name>showStatusbar</name>
      <anchor>a116</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *_name)</arglist>
    </member>
    <member kind="function">
      <type>KToggleFullScreenAction *</type>
      <name>fullScreen</name>
      <anchor>a117</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, QWidget *window, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>saveOptions</name>
      <anchor>a118</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>keyBindings</name>
      <anchor>a119</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>preferences</name>
      <anchor>a120</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>configureToolbars</name>
      <anchor>a121</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>configureNotifications</name>
      <anchor>a122</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>help</name>
      <anchor>a123</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>helpContents</name>
      <anchor>a124</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>whatsThis</name>
      <anchor>a125</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>tipOfDay</name>
      <anchor>a126</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>reportBug</name>
      <anchor>a127</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>aboutApp</name>
      <anchor>a128</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>aboutKDE</name>
      <anchor>a129</anchor>
      <arglist>(const QObject *recvr, const char *slot, KActionCollection *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>create</name>
      <anchor>a130</anchor>
      <arglist>(StdAction id, const QObject *recvr, const char *slot, KActionCollection *parent)</arglist>
    </member>
    <member kind="function">
      <type>KAction *</type>
      <name>action</name>
      <anchor>a131</anchor>
      <arglist>(StdAction act_enum, const QObject *recvr, const char *slot, KActionCollection *parent, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>stdName</name>
      <anchor>a132</anchor>
      <arglist>(StdAction act_enum)</arglist>
    </member>
    <member kind="function">
      <type>const KStdActionInfo *</type>
      <name>infoPtr</name>
      <anchor>a133</anchor>
      <arglist>(StdAction id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>internal_stdNames</name>
      <anchor>a134</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const KStdActionInfo</type>
      <name>g_rgActionInfo</name>
      <anchor>a63</anchor>
      <arglist>[]</arglist>
    </member>
  </compound>
</tagfile>
