<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>The KDEfx Library</title>
    <filename>index</filename>
  </compound>
  <compound kind="class">
    <name>KCPUInfo</name>
    <filename>classKCPUInfo.html</filename>
    <member kind="enumeration">
      <name>Extensions</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IntelMMX</name>
      <anchor>w5w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IntelSSE</name>
      <anchor>w5w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IntelSSE2</name>
      <anchor>w5w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AMD3DNOW</name>
      <anchor>w5w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AltiVec</name>
      <anchor>w5w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>haveExtension</name>
      <anchor>e0</anchor>
      <arglist>(unsigned int extension)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KImageEffect</name>
    <filename>classKImageEffect.html</filename>
    <member kind="enumeration">
      <name>GradientType</name>
      <anchor>w42</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RGBComponent</name>
      <anchor>w43</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Red</name>
      <anchor>w43w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Green</name>
      <anchor>w43w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Blue</name>
      <anchor>w43w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Gray</name>
      <anchor>w43w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>All</name>
      <anchor>w43w12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Lighting</name>
      <anchor>w44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NorthLite</name>
      <anchor>w44w13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NWLite</name>
      <anchor>w44w14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WestLite</name>
      <anchor>w44w15</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SWLite</name>
      <anchor>w44w16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SouthLite</name>
      <anchor>w44w17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SELite</name>
      <anchor>w44w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EastLite</name>
      <anchor>w44w19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NELite</name>
      <anchor>w44w20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModulationType</name>
      <anchor>w45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Intensity</name>
      <anchor>w45w21</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Saturation</name>
      <anchor>w45w22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HueShift</name>
      <anchor>w45w23</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Contrast</name>
      <anchor>w45w24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NoiseType</name>
      <anchor>w46</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UniformNoise</name>
      <anchor>w46w25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>GaussianNoise</name>
      <anchor>w46w26</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MultiplicativeGaussianNoise</name>
      <anchor>w46w27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ImpulseNoise</name>
      <anchor>w46w28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LaplacianNoise</name>
      <anchor>w46w29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PoissonNoise</name>
      <anchor>w46w30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RotateDirection</name>
      <anchor>w47</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Rotate90</name>
      <anchor>w47w31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Rotate180</name>
      <anchor>w47w32</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Rotate270</name>
      <anchor>w47w33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Disposition</name>
      <anchor>w48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NoImage</name>
      <anchor>w48w34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Centered</name>
      <anchor>w48w35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Tiled</name>
      <anchor>w48w36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CenterTiled</name>
      <anchor>w48w37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CenteredMaxpect</name>
      <anchor>w48w38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TiledMaxpect</name>
      <anchor>w48w39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Scaled</name>
      <anchor>w48w40</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CenteredAutoFit</name>
      <anchor>w48w41</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>gradient</name>
      <anchor>e0</anchor>
      <arglist>(const QSize &amp;size, const QColor &amp;ca, const QColor &amp;cb, GradientType type, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>unbalancedGradient</name>
      <anchor>e1</anchor>
      <arglist>(const QSize &amp;size, const QColor &amp;ca, const QColor &amp;cb, GradientType type, int xfactor=100, int yfactor=100, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>blend</name>
      <anchor>e2</anchor>
      <arglist>(const QColor &amp;clr, QImage &amp;dst, float opacity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>blend</name>
      <anchor>e3</anchor>
      <arglist>(QImage &amp;src, QImage &amp;dst, float opacity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>blend</name>
      <anchor>e4</anchor>
      <arglist>(QImage &amp;image, float initial_intensity, const QColor &amp;bgnd, GradientType eff, bool anti_dir=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>blend</name>
      <anchor>e5</anchor>
      <arglist>(QImage &amp;image1, QImage &amp;image2, GradientType gt, int xf=100, int yf=100)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>blend</name>
      <anchor>e6</anchor>
      <arglist>(QImage &amp;image1, QImage &amp;image2, QImage &amp;blendImage, RGBComponent channel)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>blend</name>
      <anchor>e7</anchor>
      <arglist>(const QImage &amp;upper, const QImage &amp;lower, QImage &amp;output)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>blend</name>
      <anchor>e8</anchor>
      <arglist>(int &amp;x, int &amp;y, const QImage &amp;upper, const QImage &amp;lower, QImage &amp;output)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>blendOnLower</name>
      <anchor>e9</anchor>
      <arglist>(int x, int y, const QImage &amp;upper, const QImage &amp;lower)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>blendOnLower</name>
      <anchor>e10</anchor>
      <arglist>(const QImage &amp;upper, const QPoint &amp;upperOffset, QImage &amp;lower, const QRect &amp;lowerRect)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>blendOnLower</name>
      <anchor>e11</anchor>
      <arglist>(const QImage &amp;upper, const QPoint &amp;upperOffset, QImage &amp;lower, const QRect &amp;lowerRect, float opacity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QRect</type>
      <name>computeDestinationRect</name>
      <anchor>e12</anchor>
      <arglist>(const QSize &amp;lowerSize, Disposition disposition, QImage &amp;upper)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>blendOnLower</name>
      <anchor>e13</anchor>
      <arglist>(QImage &amp;upper, QImage &amp;lower, Disposition disposition, float opacity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>channelIntensity</name>
      <anchor>e14</anchor>
      <arglist>(QImage &amp;image, float percent, RGBComponent channel)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>fade</name>
      <anchor>e15</anchor>
      <arglist>(QImage &amp;image, float val, const QColor &amp;color)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>flatten</name>
      <anchor>e16</anchor>
      <arglist>(QImage &amp;image, const QColor &amp;ca, const QColor &amp;cb, int ncols=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>hash</name>
      <anchor>e17</anchor>
      <arglist>(QImage &amp;image, Lighting lite=NorthLite, unsigned int spacing=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>intensity</name>
      <anchor>e18</anchor>
      <arglist>(QImage &amp;image, float percent)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>modulate</name>
      <anchor>e19</anchor>
      <arglist>(QImage &amp;image, QImage &amp;modImage, bool reverse, ModulationType type, int factor, RGBComponent channel)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>toGray</name>
      <anchor>e20</anchor>
      <arglist>(QImage &amp;image, bool fast=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>desaturate</name>
      <anchor>e21</anchor>
      <arglist>(QImage &amp;image, float desat=0.3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>contrast</name>
      <anchor>e22</anchor>
      <arglist>(QImage &amp;image, int c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>dither</name>
      <anchor>e23</anchor>
      <arglist>(QImage &amp;image, const QColor *palette, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage &amp;</type>
      <name>selectedImage</name>
      <anchor>e24</anchor>
      <arglist>(QImage &amp;img, const QColor &amp;col)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>contrastHSV</name>
      <anchor>e25</anchor>
      <arglist>(QImage &amp;img, bool sharpen=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>normalize</name>
      <anchor>e26</anchor>
      <arglist>(QImage &amp;img)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>equalize</name>
      <anchor>e27</anchor>
      <arglist>(QImage &amp;img)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>threshold</name>
      <anchor>e28</anchor>
      <arglist>(QImage &amp;img, unsigned int value=128)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>solarize</name>
      <anchor>e29</anchor>
      <arglist>(QImage &amp;img, double factor=50.0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>emboss</name>
      <anchor>e30</anchor>
      <arglist>(QImage &amp;src, double radius, double sigma)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>emboss</name>
      <anchor>e31</anchor>
      <arglist>(QImage &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>despeckle</name>
      <anchor>e32</anchor>
      <arglist>(QImage &amp;src)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>charcoal</name>
      <anchor>e33</anchor>
      <arglist>(QImage &amp;src, double radius, double sigma)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>charcoal</name>
      <anchor>e34</anchor>
      <arglist>(QImage &amp;src, double factor=50.0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>rotate</name>
      <anchor>e35</anchor>
      <arglist>(QImage &amp;src, RotateDirection r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>sample</name>
      <anchor>e36</anchor>
      <arglist>(QImage &amp;src, int w, int h)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>addNoise</name>
      <anchor>e37</anchor>
      <arglist>(QImage &amp;src, NoiseType type=GaussianNoise)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>blur</name>
      <anchor>e38</anchor>
      <arglist>(QImage &amp;src, double radius, double sigma)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>blur</name>
      <anchor>e39</anchor>
      <arglist>(QImage &amp;src, double factor=50.0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>edge</name>
      <anchor>e40</anchor>
      <arglist>(QImage &amp;src, double radius)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>implode</name>
      <anchor>e41</anchor>
      <arglist>(QImage &amp;src, double factor=30.0, unsigned int background=0xFFFFFFFF)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>oilPaintConvolve</name>
      <anchor>e42</anchor>
      <arglist>(QImage &amp;src, double radius)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>oilPaint</name>
      <anchor>e43</anchor>
      <arglist>(QImage &amp;src, int radius=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>sharpen</name>
      <anchor>e44</anchor>
      <arglist>(QImage &amp;src, double radius, double sigma)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>sharpen</name>
      <anchor>e45</anchor>
      <arglist>(QImage &amp;src, double factor=30.0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>spread</name>
      <anchor>e46</anchor>
      <arglist>(QImage &amp;src, unsigned int amount=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>shade</name>
      <anchor>e47</anchor>
      <arglist>(QImage &amp;src, bool color_shading=true, double azimuth=30.0, double elevation=30.0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>swirl</name>
      <anchor>e48</anchor>
      <arglist>(QImage &amp;src, double degrees=50.0, unsigned int background=0xFFFFFFFF)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>wave</name>
      <anchor>e49</anchor>
      <arglist>(QImage &amp;src, double amplitude=25.0, double frequency=150.0, unsigned int background=0xFFFFFFFF)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPixmap</name>
    <filename>classKPixmap.html</filename>
    <base>QPixmap</base>
    <member kind="enumeration">
      <name>ColorMode</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Auto</name>
      <anchor>w9w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Color</name>
      <anchor>w9w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Mono</name>
      <anchor>w9w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LowColor</name>
      <anchor>w9w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WebColor</name>
      <anchor>w9w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>GradientMode</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPixmap</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPixmap</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPixmap</name>
      <anchor>a2</anchor>
      <arglist>(const QPixmap &amp;pix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>convertFromImage</name>
      <anchor>a3</anchor>
      <arglist>(const QImage &amp;img, int conversion_flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>convertFromImage</name>
      <anchor>a4</anchor>
      <arglist>(const QImage &amp;img, ColorMode mode=WebColor)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;fileName, const char *format, int conversion_flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;fileName, const char *format=0, ColorMode mode=WebColor)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkColorTable</name>
      <anchor>a7</anchor>
      <arglist>(const QImage &amp;image)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPixmapEffect</name>
    <filename>classKPixmapEffect.html</filename>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>gradient</name>
      <anchor>e0</anchor>
      <arglist>(KPixmap &amp;pixmap, const QColor &amp;ca, const QColor &amp;cb, GradientType type, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>unbalancedGradient</name>
      <anchor>e1</anchor>
      <arglist>(KPixmap &amp;pixmap, const QColor &amp;ca, const QColor &amp;cb, GradientType type, int xfactor=100, int yfactor=100, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap</type>
      <name>createTiled</name>
      <anchor>e2</anchor>
      <arglist>(const KPixmap &amp;pixmap, QSize size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>intensity</name>
      <anchor>e3</anchor>
      <arglist>(KPixmap &amp;pixmap, float ratio)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>channelIntensity</name>
      <anchor>e4</anchor>
      <arglist>(KPixmap &amp;pixmap, float ratio, RGBComponent channel)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>blend</name>
      <anchor>e5</anchor>
      <arglist>(KPixmap &amp;pixmap, float initial_intensity, const QColor &amp;bgnd, GradientType eff, bool anti_dir=false, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>hash</name>
      <anchor>e6</anchor>
      <arglist>(KPixmap &amp;pixmap, Lighting lite=NorthLite, unsigned int spacing=0, int ncols=3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap</type>
      <name>pattern</name>
      <anchor>e7</anchor>
      <arglist>(const KPixmap &amp;pixmap, QSize size, const QColor &amp;ca, const QColor &amp;cb, int ncols=8)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>fade</name>
      <anchor>e8</anchor>
      <arglist>(KPixmap &amp;pixmap, double val, const QColor &amp;color)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>toGray</name>
      <anchor>e9</anchor>
      <arglist>(KPixmap &amp;pixmap, bool fast=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>desaturate</name>
      <anchor>e10</anchor>
      <arglist>(KPixmap &amp;pixmap, float desat=0.3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>contrast</name>
      <anchor>e11</anchor>
      <arglist>(KPixmap &amp;pixmap, int c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap &amp;</type>
      <name>dither</name>
      <anchor>e12</anchor>
      <arglist>(KPixmap &amp;pixmap, const QColor *palette, int size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KPixmap</type>
      <name>selectedPixmap</name>
      <anchor>e13</anchor>
      <arglist>(const KPixmap &amp;pixmap, const QColor &amp;col)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPixmapSplitter</name>
    <filename>classKPixmapSplitter.html</filename>
    <member kind="function">
      <type></type>
      <name>KPixmapSplitter</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixmap</name>
      <anchor>a2</anchor>
      <arglist>(const QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function">
      <type>const QPixmap &amp;</type>
      <name>pixmap</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItemSize</name>
      <anchor>a4</anchor>
      <arglist>(const QSize &amp;size)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>itemSize</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVSpacing</name>
      <anchor>a6</anchor>
      <arglist>(int spacing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHSpacing</name>
      <anchor>a7</anchor>
      <arglist>(int spacing)</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>coordinates</name>
      <anchor>a8</anchor>
      <arglist>(int pos)</arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>coordinates</name>
      <anchor>a9</anchor>
      <arglist>(const QChar &amp;ch)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStyle</name>
    <filename>classKStyle.html</filename>
    <base>QCommonStyle</base>
    <member kind="typedef">
      <type>uint</type>
      <name>KStyleFlags</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KStyleOption</name>
      <anchor>w24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Default</name>
      <anchor>w24w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AllowMenuTransparency</name>
      <anchor>w24w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FilledFrameWorkaround</name>
      <anchor>w24w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KStyleScrollBarType</name>
      <anchor>w25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WindowsStyleScrollBar</name>
      <anchor>w25w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PlatinumStyleScrollBar</name>
      <anchor>w25w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ThreeButtonScrollBar</name>
      <anchor>w25w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NextStyleScrollBar</name>
      <anchor>w25w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KStylePrimitive</name>
      <anchor>w26</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStyle</name>
      <anchor>a0</anchor>
      <arglist>(KStyleFlags flags=KStyle::Default, KStyleScrollBarType sbtype=KStyle::WindowsStyleScrollBar)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KStyle</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScrollBarType</name>
      <anchor>a2</anchor>
      <arglist>(KStyleScrollBarType sbtype)</arglist>
    </member>
    <member kind="function">
      <type>KStyleFlags</type>
      <name>styleFlags</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>renderMenuBlendPixmap</name>
      <anchor>a4</anchor>
      <arglist>(KPixmap &amp;pix, const QColorGroup &amp;cg, const QPopupMenu *popup) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>drawKStylePrimitive</name>
      <anchor>a5</anchor>
      <arglist>(KStylePrimitive kpe, QPainter *p, const QWidget *widget, const QRect &amp;r, const QColorGroup &amp;cg, SFlags flags=Style_Default, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>kPixelMetric</name>
      <anchor>a6</anchor>
      <arglist>(KStylePixelMetric kpm, const QWidget *widget=0) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>polish</name>
      <anchor>a7</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unPolish</name>
      <anchor>a8</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>polishPopupMenu</name>
      <anchor>a9</anchor>
      <arglist>(QPopupMenu *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawPrimitive</name>
      <anchor>a10</anchor>
      <arglist>(PrimitiveElement pe, QPainter *p, const QRect &amp;r, const QColorGroup &amp;cg, SFlags flags=Style_Default, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawControl</name>
      <anchor>a11</anchor>
      <arglist>(ControlElement element, QPainter *p, const QWidget *widget, const QRect &amp;r, const QColorGroup &amp;cg, SFlags flags=Style_Default, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>drawComplexControl</name>
      <anchor>a12</anchor>
      <arglist>(ComplexControl control, QPainter *p, const QWidget *widget, const QRect &amp;r, const QColorGroup &amp;cg, SFlags flags=Style_Default, SCFlags controls=SC_All, SCFlags active=SC_None, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>SubControl</type>
      <name>querySubControl</name>
      <anchor>a13</anchor>
      <arglist>(ComplexControl control, const QWidget *widget, const QPoint &amp;pos, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>querySubControlMetrics</name>
      <anchor>a14</anchor>
      <arglist>(ComplexControl control, const QWidget *widget, SubControl sc, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>pixelMetric</name>
      <anchor>a15</anchor>
      <arglist>(PixelMetric m, const QWidget *widget=0) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>subRect</name>
      <anchor>a16</anchor>
      <arglist>(SubRect r, const QWidget *widget) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>stylePixmap</name>
      <anchor>a17</anchor>
      <arglist>(StylePixmap stylepixmap, const QWidget *widget=0, const QStyleOption &amp;=QStyleOption::Default) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>styleHint</name>
      <anchor>a18</anchor>
      <arglist>(StyleHint sh, const QWidget *w=0, const QStyleOption &amp;opt=QStyleOption::Default, QStyleHintReturn *shr=0) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>defaultStyle</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QObject *object, QEvent *event)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawNextButton</name>
      <anchor>m0</anchor>
      <arglist>(QPainter *p, const QRect &amp;r, const QColorGroup &amp;g, bool sunken=false, const QBrush *fill=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawNextButton</name>
      <anchor>m1</anchor>
      <arglist>(QPainter *p, int x, int y, int w, int h, const QColorGroup &amp;g, bool sunken=false, const QBrush *fill=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawBeButton</name>
      <anchor>m2</anchor>
      <arglist>(QPainter *p, QRect &amp;r, const QColorGroup &amp;g, bool sunken=false, const QBrush *fill=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawBeButton</name>
      <anchor>m3</anchor>
      <arglist>(QPainter *p, int x, int y, int w, int h, const QColorGroup &amp;g, bool sunken=false, const QBrush *fill=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawRoundButton</name>
      <anchor>m4</anchor>
      <arglist>(QPainter *p, const QRect &amp;r, const QColorGroup &amp;g, bool sunken=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawRoundButton</name>
      <anchor>m5</anchor>
      <arglist>(QPainter *p, int x, int y, int w, int h, const QColorGroup &amp;g, bool sunken=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kRoundMaskRegion</name>
      <anchor>m6</anchor>
      <arglist>(QRegion &amp;r, int x, int y, int w, int h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kDrawRoundMask</name>
      <anchor>m7</anchor>
      <arglist>(QPainter *p, int x, int y, int w, int h, bool clear=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kColorBitmaps</name>
      <anchor>m8</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;g, int x, int y, QBitmap *lightColor=0, QBitmap *midColor=0, QBitmap *midlightColor=0, QBitmap *darkColor=0, QBitmap *blackColor=0, QBitmap *whiteColor=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kColorBitmaps</name>
      <anchor>m9</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;g, int x, int y, int w, int h, bool isXBitmaps=true, const uchar *lightColor=0, const uchar *midColor=0, const uchar *midlightColor=0, const uchar *darkColor=0, const uchar *blackColor=0, const uchar *whiteColor=0)</arglist>
    </member>
  </compound>
</tagfile>
