<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>The KDE Core Functionality Library</title>
    <filename>index</filename>
  </compound>
  <compound kind="class">
    <name>KAboutData</name>
    <filename>classKAboutData.html</filename>
    <member kind="enumeration">
      <name>LicenseKey</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAboutData</name>
      <anchor>a0</anchor>
      <arglist>(const char *appName, const char *programName, const char *version, const char *shortDescription=0, int licenseType=License_Unknown, const char *copyrightStatement=0, const char *text=0, const char *homePageAddress=0, const char *bugsEmailAddress=&quot;submit @bugs.kde.org&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addAuthor</name>
      <anchor>a2</anchor>
      <arglist>(const char *name, const char *task=0, const char *emailAddress=0, const char *webAddress=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCredit</name>
      <anchor>a3</anchor>
      <arglist>(const char *name, const char *task=0, const char *emailAddress=0, const char *webAddress=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranslator</name>
      <anchor>a4</anchor>
      <arglist>(const char *name, const char *emailAddress)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLicenseText</name>
      <anchor>a5</anchor>
      <arglist>(const char *license)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLicenseTextFile</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProductName</name>
      <anchor>a7</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>appName</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>productName</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>programName</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>version</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>shortDescription</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homepage</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>bugAddress</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; KAboutPerson &gt;</type>
      <name>authors</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; KAboutPerson &gt;</type>
      <name>credits</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; KAboutTranslator &gt;</type>
      <name>translators</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>otherText</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>license</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>copyrightStatement</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>aboutTranslationTeam</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutPerson</name>
    <filename>classKAboutPerson.html</filename>
    <member kind="function">
      <type></type>
      <name>KAboutPerson</name>
      <anchor>a0</anchor>
      <arglist>(const char *name, const char *task, const char *emailAddress, const char *webAddress)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>task</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>emailAddress</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>webAddress</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAboutTranslator</name>
    <filename>classKAboutTranslator.html</filename>
    <member kind="function">
      <type></type>
      <name>KAboutTranslator</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name=QString::null, const QString &amp;emailAddress=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>emailAddress</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccel</name>
    <filename>classKAccel.html</filename>
    <base>QAccel</base>
    <member kind="signal">
      <type>void</type>
      <name>keycodeChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAccel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *pParent, const char *psName=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAccel</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *watch, QObject *parent, const char *psName=0)</arglist>
    </member>
    <member kind="function">
      <type>KAccelActions &amp;</type>
      <name>actions</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KAccelActions &amp;</type>
      <name>actions</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEnabled</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnabled</name>
      <anchor>a6</anchor>
      <arglist>(bool bEnabled)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAutoUpdate</name>
      <anchor>a7</anchor>
      <arglist>(bool bAuto)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;sAction, const QString &amp;sLabel, const QString &amp;sWhatsThis, const KShortcut &amp;cutDef, const QObject *pObjSlot, const char *psMethodSlot, bool bConfigurable=true, bool bEnabled=true)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;sAction, const QString &amp;sLabel, const QString &amp;sWhatsThis, const KShortcut &amp;cutDef3, const KShortcut &amp;cutDef4, const QObject *pObjSlot, const char *psMethodSlot, bool bConfigurable=true, bool bEnabled=true)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a10</anchor>
      <arglist>(const char *psAction, const KShortcut &amp;cutDef, const QObject *pObjSlot, const char *psMethodSlot, bool bConfigurable=true, bool bEnabled=true)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a11</anchor>
      <arglist>(KStdAccel::StdAccel id, const QObject *pObjSlot, const char *psMethodSlot, bool bConfigurable=true, bool bEnabled=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;sAction)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>updateConnections</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;sAction) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setShortcut</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;sAction, const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setSlot</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;sAction, const QObject *pObjSlot, const char *psMethodSlot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setEnabled</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;sAction, bool bEnabled)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>configGroup</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConfigGroup</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readSettings</name>
      <anchor>a20</anchor>
      <arglist>(KConfigBase *pConfig=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeSettings</name>
      <anchor>a21</anchor>
      <arglist>(KConfigBase *pConfig=0) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitKeycodeChanged</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insertItem</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;sLabel, const QString &amp;sAction, const char *psKey, int nIDMenu=0, QPopupMenu *pMenu=0, bool bConfigurable=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insertItem</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;sLabel, const QString &amp;sAction, int key, int nIDMenu=0, QPopupMenu *pMenu=0, bool bConfigurable=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insertStdItem</name>
      <anchor>a25</anchor>
      <arglist>(KStdAccel::StdAccel id, const QString &amp;descr=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>connectItem</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;sAction, const QObject *pObjSlot, const char *psMethodSlot, bool bActivate=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED bool</type>
      <name>connectItem</name>
      <anchor>a27</anchor>
      <arglist>(KStdAccel::StdAccel accel, const QObject *pObjSlot, const char *psMethodSlot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeItem</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;sAction) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setItemEnabled</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;sAction, bool bEnable) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeMenuAccel</name>
      <anchor>a30</anchor>
      <arglist>(QPopupMenu *menu, int id, const QString &amp;action) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeMenuAccel</name>
      <anchor>a31</anchor>
      <arglist>(QPopupMenu *menu, int id, KStdAccel::StdAccel accel) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentKey</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;action) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>findKey</name>
      <anchor>a33</anchor>
      <arglist>(int key) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>stringToKey</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KAccelPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAcceleratorManager</name>
    <filename>classKAcceleratorManager.html</filename>
    <member kind="function" static="yes">
      <type>void</type>
      <name>manage</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>manage</name>
      <anchor>e1</anchor>
      <arglist>(QWidget *widget, bool programmers_mode)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>last_manage</name>
      <anchor>e2</anchor>
      <arglist>(QString &amp;added, QString &amp;changed, QString &amp;removed)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccelManagerAlgorithm</name>
    <filename>classKAccelManagerAlgorithm.html</filename>
    <member kind="function" static="yes">
      <type>void</type>
      <name>findAccelerators</name>
      <anchor>e0</anchor>
      <arglist>(KAccelStringList &amp;result, QString &amp;used)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>DEFAULT_WEIGHT</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>FIRST_CHARACTER_EXTRA_WEIGHT</name>
      <anchor>s1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>WORD_BEGINNING_EXTRA_WEIGHT</name>
      <anchor>s2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>WANTED_ACCEL_EXTRA_WEIGHT</name>
      <anchor>s3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>DIALOG_BUTTON_EXTRA_WEIGHT</name>
      <anchor>s4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>STANDARD_ACCEL</name>
      <anchor>s5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>ACTION_ELEMENT_WEIGHT</name>
      <anchor>s6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>GROUP_BOX_WEIGHT</name>
      <anchor>s7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>MENU_TITLE_WEIGHT</name>
      <anchor>s8</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccelShortcutList</name>
    <filename>classKAccelShortcutList.html</filename>
    <base>KShortcutList</base>
    <member kind="function">
      <type></type>
      <name>KAccelShortcutList</name>
      <anchor>a0</anchor>
      <arglist>(KAccel *accel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAccelShortcutList</name>
      <anchor>a1</anchor>
      <arglist>(KGlobalAccel *accel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAccelShortcutList</name>
      <anchor>a2</anchor>
      <arglist>(KAccelActions &amp;actions, bool bGlobal)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual uint</type>
      <name>count</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a5</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>label</name>
      <anchor>a6</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>whatsThis</name>
      <anchor>a7</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a8</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcutDefault</name>
      <anchor>a9</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isConfigurable</name>
      <anchor>a10</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setShortcut</name>
      <anchor>a11</anchor>
      <arglist>(uint index, const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isGlobal</name>
      <anchor>a12</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVariant</type>
      <name>getOther</name>
      <anchor>a13</anchor>
      <arglist>(Other, uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setOther</name>
      <anchor>a14</anchor>
      <arglist>(Other, uint index, QVariant)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>save</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KAccelActions &amp;</type>
      <name>m_actions</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bGlobal</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAccelString</name>
    <filename>classKAccelString.html</filename>
    <member kind="function">
      <type></type>
      <name>KAccelString</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;input, int initalWeight=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>calculateWeights</name>
      <anchor>a2</anchor>
      <arglist>(int initialWeight)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>pure</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>accelerated</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>accel</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAccel</name>
      <anchor>a6</anchor>
      <arglist>(int accel)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>originalAccel</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>originalText</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>accelerator</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>maxWeight</name>
      <anchor>a10</anchor>
      <arglist>(int &amp;index, const QString &amp;used)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a11</anchor>
      <arglist>(const KAccelString &amp;c) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAddressInfo</name>
    <filename>classKAddressInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>operator const KSocketAddress *</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const addrinfo &amp;</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const addrinfo *</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KSocketAddress *</type>
      <name>address</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>flags</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>family</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socktype</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>protocol</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>canonname</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>length</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KExtendedSocket</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAppDCOPInterface</name>
    <filename>classKAppDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>void</type>
      <name>disableSessionManagement</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QCString</type>
      <name>startupId</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QCString</type>
      <name>caption</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>quit</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAppDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(KApplication *theKapp)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KAppDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KApplication</name>
    <filename>classKApplication.html</filename>
    <base>QApplication</base>
    <base>KInstance</base>
    <member kind="enumeration">
      <name>ShutdownConfirm</name>
      <anchor>w35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownConfirmDefault</name>
      <anchor>w35w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownConfirmNo</name>
      <anchor>w35w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownConfirmYes</name>
      <anchor>w35w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ShutdownType</name>
      <anchor>w36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownTypeDefault</name>
      <anchor>w36w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownTypeNone</name>
      <anchor>w36w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownTypeReboot</name>
      <anchor>w36w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownTypeHalt</name>
      <anchor>w36w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ShutdownMode</name>
      <anchor>w37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownModeDefault</name>
      <anchor>w37w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownModeSchedule</name>
      <anchor>w37w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownModeTryNow</name>
      <anchor>w37w12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownModeForceNow</name>
      <anchor>w37w13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShutdownModeInteractive</name>
      <anchor>w37w14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SettingsCategory</name>
      <anchor>w40</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>invokeBrowser</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;url, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>invokeBrowser</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>cut</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>copy</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>paste</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>clear</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>selectAll</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>ref</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>deref</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>kdisplayPaletteChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>kdisplayStyleChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>kdisplayFontChanged</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>appearanceChanged</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toolbarAppearanceChanged</name>
      <anchor>l4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>backgroundChanged</name>
      <anchor>l5</anchor>
      <arglist>(int desk)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>settingsChanged</name>
      <anchor>l6</anchor>
      <arglist>(int category)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>iconChanged</name>
      <anchor>l7</anchor>
      <arglist>(int group)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>kipcMessage</name>
      <anchor>l8</anchor>
      <arglist>(int id, int data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>saveYourself</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>shutDown</name>
      <anchor>l10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KApplication</name>
      <anchor>a0</anchor>
      <arglist>(bool allowStyles=true, bool GUIenabled=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KApplication</name>
      <anchor>a1</anchor>
      <arglist>(Display *display, int &amp;argc, char **argv, const QCString &amp;rAppName, bool allowStyles=true, bool GUIenabled=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KApplication</name>
      <anchor>a2</anchor>
      <arglist>(int &amp;argc, char **argv, const QCString &amp;rAppName, bool allowStyles=true, bool GUIenabled=true) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>sessionConfig</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRestored</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disableSessionManagement</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableSessionManagement</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>requestShutDown</name>
      <anchor>a8</anchor>
      <arglist>(ShutdownConfirm confirm=ShutdownConfirmDefault, ShutdownType sdtype=ShutdownTypeDefault, ShutdownMode sdmode=ShutdownModeDefault)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>propagateSessionManager</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>commitData</name>
      <anchor>a10</anchor>
      <arglist>(QSessionManager &amp;sm)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveState</name>
      <anchor>a11</anchor>
      <arglist>(QSessionManager &amp;sm)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sessionSaving</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>icon</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>iconName</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>miniIcon</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>miniIconName</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTopWidget</name>
      <anchor>a17</anchor>
      <arglist>(QWidget *topWidget)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeHelp</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;anchor, const QString &amp;appname, const QCString &amp;startup_id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeHelp</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;anchor=QString::null, const QString &amp;appname=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeHTMLHelp</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;aFilename, const QString &amp;aTopic=QString::null) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;address, const QString &amp;subject, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;address, const QString &amp;subject)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a23</anchor>
      <arglist>(const KURL &amp;mailtoURL, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a24</anchor>
      <arglist>(const KURL &amp;mailtoURL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;to, const QString &amp;cc, const QString &amp;bcc, const QString &amp;subject, const QString &amp;body, const QString &amp;messageFile, const QStringList &amp;attachURLs, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeMailer</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;to, const QString &amp;cc, const QString &amp;bcc, const QString &amp;subject, const QString &amp;body, const QString &amp;messageFile=QString::null, const QStringList &amp;attachURLs=QStringList())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>caption</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED KStyle *</type>
      <name>kstyle</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>makeStdCaption</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;userCaption, bool withAppName=true, bool modified=false) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tempSaveName</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;pFilename) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>checkRecoverFile</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;pFilename, bool &amp;bRecover) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableStyles</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disableStyles</name>
      <anchor>a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>installX11EventFilter</name>
      <anchor>a34</anchor>
      <arglist>(QWidget *filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeX11EventFilter</name>
      <anchor>a35</anchor>
      <arglist>(const QWidget *filter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addKipcEventMask</name>
      <anchor>a36</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeKipcEventMask</name>
      <anchor>a37</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>startupId</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartupId</name>
      <anchor>a39</anchor>
      <arglist>(const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateUserTimestamp</name>
      <anchor>a40</anchor>
      <arglist>(unsigned long time=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>geometryArgument</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>installKDEPropertyMap</name>
      <anchor>a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorize</name>
      <anchor>a43</anchor>
      <arglist>(const QString &amp;genericAction)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorizeKAction</name>
      <anchor>a44</anchor>
      <arglist>(const char *action)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorizeURLAction</name>
      <anchor>a45</anchor>
      <arglist>(const QString &amp;action, const KURL &amp;baseURL, const KURL &amp;destURL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>allowURLAction</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;action, const KURL &amp;_baseURL, const KURL &amp;_destURL)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorizeControlModule</name>
      <anchor>a47</anchor>
      <arglist>(const QString &amp;menuId)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>authorizeControlModules</name>
      <anchor>a48</anchor>
      <arglist>(const QStringList &amp;menuIds)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>notify</name>
      <anchor>a49</anchor>
      <arglist>(QObject *receiver, QEvent *event)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xErrhandler</name>
      <anchor>a50</anchor>
      <arglist>(Display *, void *)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>xioErrhandler</name>
      <anchor>a51</anchor>
      <arglist>(Display *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>iceIOErrorHandler</name>
      <anchor>a52</anchor>
      <arglist>(_IceConn *conn)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addCmdLineOptions</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KApplication *</type>
      <name>kApplication</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DCOPClient *</type>
      <name>dcopClient</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>disableAutoDcopRegistration</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>launcher</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByName</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;_name, const QString &amp;URL, QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByName</name>
      <anchor>e6</anchor>
      <arglist>(const QString &amp;_name, const QStringList &amp;URLs=QStringList(), QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByDesktopPath</name>
      <anchor>e7</anchor>
      <arglist>(const QString &amp;_name, const QString &amp;URL, QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByDesktopPath</name>
      <anchor>e8</anchor>
      <arglist>(const QString &amp;_name, const QStringList &amp;URLs=QStringList(), QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByDesktopName</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;_name, const QString &amp;URL, QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>startServiceByDesktopName</name>
      <anchor>e10</anchor>
      <arglist>(const QString &amp;_name, const QStringList &amp;URLs=QStringList(), QString *error=0, QCString *dcopService=0, int *pid=0, const QCString &amp;startup_id=&quot;&quot;, bool noWait=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kdeinitExec</name>
      <anchor>e11</anchor>
      <arglist>(const QString &amp;name, const QStringList &amp;args, QString *error, int *pid, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kdeinitExec</name>
      <anchor>e12</anchor>
      <arglist>(const QString &amp;name, const QStringList &amp;args=QStringList(), QString *error=0, int *pid=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kdeinitExecWait</name>
      <anchor>e13</anchor>
      <arglist>(const QString &amp;name, const QStringList &amp;args, QString *error, int *pid, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>kdeinitExecWait</name>
      <anchor>e14</anchor>
      <arglist>(const QString &amp;name, const QStringList &amp;args=QStringList(), QString *error=0, int *pid=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>random</name>
      <anchor>e15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>randomString</name>
      <anchor>e16</anchor>
      <arglist>(int length)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>keyboardModifiers</name>
      <anchor>e17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>mouseState</name>
      <anchor>e18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>startKdeinit</name>
      <anchor>e19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPalette</type>
      <name>createApplicationPalette</name>
      <anchor>e20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPalette</type>
      <name>createApplicationPalette</name>
      <anchor>e21</anchor>
      <arglist>(KConfig *config, int contrast)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>installSigpipeHandler</name>
      <anchor>e22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>guiEnabled</name>
      <anchor>e23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>bool</type>
      <name>loadedByKdeinit</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KApplication</name>
      <anchor>b0</anchor>
      <arglist>(bool allowStyles, bool GUIenabled, KInstance *_instance)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>invokeEditSlot</name>
      <anchor>b1</anchor>
      <arglist>(const char *slot)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Atom</type>
      <name>kipcCommAtom</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>kipcEventMask</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>pArgc</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>KApplication *</type>
      <name>KApp</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAsyncIO</name>
    <filename>classKAsyncIO.html</filename>
    <base>QObject</base>
    <base>QIODevice</base>
    <member kind="signal">
      <type>void</type>
      <name>readyRead</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>readyWrite</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>enableRead</name>
      <anchor>a0</anchor>
      <arglist>(bool enable)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>enableWrite</name>
      <anchor>a1</anchor>
      <arglist>(bool enable)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KAudioPlayer</name>
    <filename>classKAudioPlayer.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>play</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KAudioPlayer</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;filename, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KAudioPlayer</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>play</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KBufferedIO</name>
    <filename>classKBufferedIO.html</filename>
    <base>KAsyncIO</base>
    <member kind="enumeration">
      <name>closeModes</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>bytesWritten</name>
      <anchor>l0</anchor>
      <arglist>(int nbytes)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closed</name>
      <anchor>l1</anchor>
      <arglist>(int state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KBufferedIO</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>closeNow</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setBufferSize</name>
      <anchor>a2</anchor>
      <arglist>(int rsize, int wsize=-2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>bytesAvailable</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>waitForMore</name>
      <anchor>a4</anchor>
      <arglist>(int msec)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>bytesToWrite</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>canReadLine</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>peekBlock</name>
      <anchor>a7</anchor>
      <arglist>(char *data, uint maxlen)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>unreadBlock</name>
      <anchor>a8</anchor>
      <arglist>(const char *data, uint len)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>consumeReadBuffer</name>
      <anchor>b1</anchor>
      <arglist>(unsigned nbytes, char *destbuffer, bool discard=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>consumeWriteBuffer</name>
      <anchor>b2</anchor>
      <arglist>(unsigned nbytes)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>feedReadBuffer</name>
      <anchor>b3</anchor>
      <arglist>(unsigned nbytes, const char *buffer, bool atBeginning=false)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>feedWriteBuffer</name>
      <anchor>b4</anchor>
      <arglist>(unsigned nbytes, const char *buffer)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>readBufferSize</name>
      <anchor>b5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual unsigned</type>
      <name>writeBufferSize</name>
      <anchor>b6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b7</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; QByteArray &gt;</type>
      <name>inBuf</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; QByteArray &gt;</type>
      <name>outBuf</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned</type>
      <name>inBufIndex</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned</type>
      <name>outBufIndex</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCalendarSystem</name>
    <filename>classKCalendarSystem.html</filename>
    <member kind="function">
      <type></type>
      <name>KCalendarSystem</name>
      <anchor>a0</anchor>
      <arglist>(const KLocale *locale=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCalendarSystem</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>year</name>
      <anchor>a2</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>yearString</name>
      <anchor>a3</anchor>
      <arglist>(const QDate &amp;pDate, bool bShort) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>yearStringToInteger</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;sNum, int &amp;iLength) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>month</name>
      <anchor>a5</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>monthString</name>
      <anchor>a6</anchor>
      <arglist>(const QDate &amp;pDate, bool bShort) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>monthStringToInteger</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;sNum, int &amp;iLength) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>day</name>
      <anchor>a8</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>dayString</name>
      <anchor>a9</anchor>
      <arglist>(const QDate &amp;pDate, bool bShort) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>dayStringToInteger</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;sNum, int &amp;iLength) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>dayOfWeek</name>
      <anchor>a11</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>dayOfYear</name>
      <anchor>a12</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setYMD</name>
      <anchor>a13</anchor>
      <arglist>(QDate &amp;date, int y, int m, int d) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QDate</type>
      <name>addYears</name>
      <anchor>a14</anchor>
      <arglist>(const QDate &amp;date, int nyears) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QDate</type>
      <name>addMonths</name>
      <anchor>a15</anchor>
      <arglist>(const QDate &amp;date, int nmonths) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QDate</type>
      <name>addDays</name>
      <anchor>a16</anchor>
      <arglist>(const QDate &amp;date, int ndays) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>monthsInYear</name>
      <anchor>a17</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>daysInYear</name>
      <anchor>a18</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>daysInMonth</name>
      <anchor>a19</anchor>
      <arglist>(const QDate &amp;date) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>weeksInYear</name>
      <anchor>a20</anchor>
      <arglist>(int year) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>weekNumber</name>
      <anchor>a21</anchor>
      <arglist>(const QDate &amp;date, int *yearNum=0) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>monthName</name>
      <anchor>a22</anchor>
      <arglist>(int month, int year, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>monthName</name>
      <anchor>a23</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>monthNamePossessive</name>
      <anchor>a24</anchor>
      <arglist>(int month, int year, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>monthNamePossessive</name>
      <anchor>a25</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>weekDayName</name>
      <anchor>a26</anchor>
      <arglist>(int weekDay, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>weekDayName</name>
      <anchor>a27</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>minValidYear</name>
      <anchor>a28</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>maxValidYear</name>
      <anchor>a29</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>weekDayOfPray</name>
      <anchor>a30</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>calendarName</name>
      <anchor>a31</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isLunar</name>
      <anchor>a32</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isLunisolar</name>
      <anchor>a33</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isSolar</name>
      <anchor>a34</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>const KLocale *</type>
      <name>locale</name>
      <anchor>b0</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCalendarSystemFactory</name>
    <filename>classKCalendarSystemFactory.html</filename>
    <member kind="function" static="yes">
      <type>KCalendarSystem *</type>
      <name>create</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;calType=QString::fromLatin1(&quot;gregorian&quot;), const KLocale *locale=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>calendarSystems</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCalendarSystemJalali</name>
    <filename>classKCalendarSystemJalali.html</filename>
    <base>KCalendarSystem</base>
    <member kind="function">
      <type></type>
      <name>KCalendarSystemJalali</name>
      <anchor>a0</anchor>
      <arglist>(const KLocale *locale=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>year</name>
      <anchor>a2</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>month</name>
      <anchor>a3</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>day</name>
      <anchor>a4</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>dayOfWeek</name>
      <anchor>a5</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>dayOfYear</name>
      <anchor>a6</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setYMD</name>
      <anchor>a7</anchor>
      <arglist>(QDate &amp;date, int y, int m, int d) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QDate</type>
      <name>addYears</name>
      <anchor>a8</anchor>
      <arglist>(const QDate &amp;date, int nyears) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QDate</type>
      <name>addMonths</name>
      <anchor>a9</anchor>
      <arglist>(const QDate &amp;date, int nmonths) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QDate</type>
      <name>addDays</name>
      <anchor>a10</anchor>
      <arglist>(const QDate &amp;date, int ndays) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>monthsInYear</name>
      <anchor>a11</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>daysInYear</name>
      <anchor>a12</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>daysInMonth</name>
      <anchor>a13</anchor>
      <arglist>(const QDate &amp;date) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>weeksInYear</name>
      <anchor>a14</anchor>
      <arglist>(int year) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>weekNumber</name>
      <anchor>a15</anchor>
      <arglist>(const QDate &amp;date, int *yearNum=0) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>monthName</name>
      <anchor>a16</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>monthNamePossessive</name>
      <anchor>a17</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>weekDayName</name>
      <anchor>a18</anchor>
      <arglist>(int weekDay, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>weekDayName</name>
      <anchor>a19</anchor>
      <arglist>(const QDate &amp;date, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>monthNamePossessive</name>
      <anchor>a20</anchor>
      <arglist>(int month, int year, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>monthName</name>
      <anchor>a21</anchor>
      <arglist>(int month, int year, bool shortName=false) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>minValidYear</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>maxValidYear</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>weekDayOfPray</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>calendarName</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isLunar</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isLunisolar</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isSolar</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCatalogue</name>
    <filename>classKCatalogue.html</filename>
    <member kind="function">
      <type></type>
      <name>KCatalogue</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCatalogue</name>
      <anchor>a1</anchor>
      <arglist>(const KCatalogue &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>KCatalogue &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const KCatalogue &amp;rhs)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCatalogue</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileName</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>translate</name>
      <anchor>a6</anchor>
      <arglist>(const char *msgid) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCharsets</name>
    <filename>classKCharsets.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCharsets</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QTextCodec *</type>
      <name>codecForName</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>QTextCodec *</type>
      <name>codecForName</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;n, bool &amp;ok) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>availableEncodingNames</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>descriptiveEncodingNames</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>languageForEncoding</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;encoding)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>encodingForName</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;descriptiveName)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QChar</type>
      <name>fromEntity</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QChar</type>
      <name>fromEntity</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;str, int &amp;len)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>toEntity</name>
      <anchor>e2</anchor>
      <arglist>(const QChar &amp;ch)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>resolveEntities</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KCharsets</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KGlobal</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KClipboardSynchronizer</name>
    <filename>classKClipboardSynchronizer.html</filename>
    <base>QObject</base>
    <member kind="function" static="yes">
      <type>KClipboardSynchronizer *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setSynchronizing</name>
      <anchor>e1</anchor>
      <arglist>(bool sync)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isSynchronizing</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setReverseSynchronizing</name>
      <anchor>e3</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isReverseSynchronizing</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KlipperWidget</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KApplication</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCmdLineArgs</name>
    <filename>classKCmdLineArgs.html</filename>
    <member kind="function">
      <type>QCString</type>
      <name>getOption</name>
      <anchor>a0</anchor>
      <arglist>(const char *option) const </arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>getOptionList</name>
      <anchor>a1</anchor>
      <arglist>(const char *option) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSet</name>
      <anchor>a2</anchor>
      <arglist>(const char *option) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>arg</name>
      <anchor>a4</anchor>
      <arglist>(int n) const </arglist>
    </member>
    <member kind="function">
      <type>KURL</type>
      <name>url</name>
      <anchor>a5</anchor>
      <arglist>(int n) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>init</name>
      <anchor>e0</anchor>
      <arglist>(int _argc, char **_argv, const char *_appname, const char *programName, const char *_description, const char *_version, bool noKApp=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>init</name>
      <anchor>e1</anchor>
      <arglist>(int _argc, char **_argv, const char *_appname, const char *_description, const char *_version, bool noKApp=false) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>init</name>
      <anchor>e2</anchor>
      <arglist>(int _argc, char **_argv, const KAboutData *about, bool noKApp=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>init</name>
      <anchor>e3</anchor>
      <arglist>(const KAboutData *about)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addCmdLineOptions</name>
      <anchor>e4</anchor>
      <arglist>(const KCmdLineOptions *options, const char *name=0, const char *id=0, const char *afterId=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KCmdLineArgs *</type>
      <name>parsedArgs</name>
      <anchor>e5</anchor>
      <arglist>(const char *id=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>cwd</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>appName</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>usage</name>
      <anchor>e8</anchor>
      <arglist>(const char *id=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>usage</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;error)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>enable_i18n</name>
      <anchor>e10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURL</type>
      <name>makeURL</name>
      <anchor>e11</anchor>
      <arglist>(const char *urlArg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setCwd</name>
      <anchor>e12</anchor>
      <arglist>(char *cwd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>reset</name>
      <anchor>e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>loadAppArgs</name>
      <anchor>e14</anchor>
      <arglist>(QDataStream &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KCmdLineArgs</name>
      <anchor>b0</anchor>
      <arglist>(const KCmdLineOptions *_options, const char *_name, const char *_id)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>~KCmdLineArgs</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KApplication</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KUniqueApplication</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>QPtrList&lt; KCmdLineArgs &gt;</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KCmdLineOptions</name>
    <filename>structKCmdLineOptions.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>description</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>def</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCodecs</name>
    <filename>classKCodecs.html</filename>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>quotedPrintableEncode</name>
      <anchor>e0</anchor>
      <arglist>(const QByteArray &amp;in, bool useCRLF=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>quotedPrintableEncode</name>
      <anchor>e1</anchor>
      <arglist>(const QCString &amp;str, bool useCRLF=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>quotedPrintableEncode</name>
      <anchor>e2</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out, bool useCRLF)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>quotedPrintableDecode</name>
      <anchor>e3</anchor>
      <arglist>(const QByteArray &amp;in)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>quotedPrintableDecode</name>
      <anchor>e4</anchor>
      <arglist>(const QCString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>quotedPrintableDecode</name>
      <anchor>e5</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>uuencode</name>
      <anchor>e6</anchor>
      <arglist>(const QByteArray &amp;in)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>uuencode</name>
      <anchor>e7</anchor>
      <arglist>(const QCString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>uuencode</name>
      <anchor>e8</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>uudecode</name>
      <anchor>e9</anchor>
      <arglist>(const QByteArray &amp;in)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>uudecode</name>
      <anchor>e10</anchor>
      <arglist>(const QCString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>uudecode</name>
      <anchor>e11</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>base64Encode</name>
      <anchor>e12</anchor>
      <arglist>(const QByteArray &amp;in, bool insertLFs=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>base64Encode</name>
      <anchor>e13</anchor>
      <arglist>(const QCString &amp;str, bool insertLFs=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>base64Encode</name>
      <anchor>e14</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out, bool insertLFs=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>base64Decode</name>
      <anchor>e15</anchor>
      <arglist>(const QByteArray &amp;in)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>base64Decode</name>
      <anchor>e16</anchor>
      <arglist>(const QCString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>base64Decode</name>
      <anchor>e17</anchor>
      <arglist>(const QByteArray &amp;in, QByteArray &amp;out)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCompletion</name>
    <filename>classKCompletion.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>CompOrder</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Sorted</name>
      <anchor>w3w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Insertion</name>
      <anchor>w3w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Weighted</name>
      <anchor>w3w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotMakeCompletion</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotPreviousMatch</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotNextMatch</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>insertItems</name>
      <anchor>i3</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setItems</name>
      <anchor>i4</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>addItem</name>
      <anchor>i5</anchor>
      <arglist>(const QString &amp;item)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>addItem</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;item, uint weight)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeItem</name>
      <anchor>i7</anchor>
      <arglist>(const QString &amp;item)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>clear</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>match</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;item)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>matches</name>
      <anchor>l1</anchor>
      <arglist>(const QStringList &amp;matchlist)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>multipleMatches</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCompletion</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCompletion</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>makeCompletion</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>substringCompletion</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;string) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>previousMatch</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>nextMatch</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const QString &amp;</type>
      <name>lastMatch</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>items</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletionMode</name>
      <anchor>a8</anchor>
      <arglist>(KGlobalSettings::Completion mode)</arglist>
    </member>
    <member kind="function">
      <type>KGlobalSettings::Completion</type>
      <name>completionMode</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setOrder</name>
      <anchor>a10</anchor>
      <arglist>(CompOrder order)</arglist>
    </member>
    <member kind="function">
      <type>CompOrder</type>
      <name>order</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setIgnoreCase</name>
      <anchor>a12</anchor>
      <arglist>(bool ignoreCase)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ignoreCase</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allMatches</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allMatches</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>KCompletionMatches</type>
      <name>allWeightedMatches</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KCompletionMatches</type>
      <name>allWeightedMatches</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setEnableSounds</name>
      <anchor>a18</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSoundsEnabled</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasMultipleMatches</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableSounds</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disableSounds</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>postProcessMatch</name>
      <anchor>b0</anchor>
      <arglist>(QString *match) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>postProcessMatches</name>
      <anchor>b1</anchor>
      <arglist>(QStringList *matches) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>postProcessMatches</name>
      <anchor>b2</anchor>
      <arglist>(KCompletionMatches *matches) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCompletionBase</name>
    <filename>classKCompletionBase.html</filename>
    <member kind="typedef">
      <type>QMap&lt; KeyBindingType, KShortcut &gt;</type>
      <name>KeyBindingMap</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyBindingType</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TextCompletion</name>
      <anchor>w5w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PrevCompletionMatch</name>
      <anchor>w5w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NextCompletionMatch</name>
      <anchor>w5w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SubstringCompletion</name>
      <anchor>w5w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCompletionBase</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KCompletionBase</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KCompletion *</type>
      <name>completionObject</name>
      <anchor>a2</anchor>
      <arglist>(bool hsig=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletionObject</name>
      <anchor>a3</anchor>
      <arglist>(KCompletion *compObj, bool hsig=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setHandleSignals</name>
      <anchor>a4</anchor>
      <arglist>(bool handle)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCompletionObjectAutoDeleted</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDeleteCompletionObject</name>
      <anchor>a6</anchor>
      <arglist>(bool autoDelete)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnableSignals</name>
      <anchor>a7</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>handleSignals</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>emitSignals</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCompletionMode</name>
      <anchor>a10</anchor>
      <arglist>(KGlobalSettings::Completion mode)</arglist>
    </member>
    <member kind="function">
      <type>KGlobalSettings::Completion</type>
      <name>completionMode</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setKeyBinding</name>
      <anchor>a12</anchor>
      <arglist>(KeyBindingType item, const KShortcut &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>getKeyBinding</name>
      <anchor>a13</anchor>
      <arglist>(KeyBindingType item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>useGlobalKeyBindings</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setCompletedText</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;text)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setCompletedItems</name>
      <anchor>a16</anchor>
      <arglist>(const QStringList &amp;items)=0</arglist>
    </member>
    <member kind="function">
      <type>KCompletion *</type>
      <name>compObj</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>KeyBindingMap</type>
      <name>getKeyBindings</name>
      <anchor>b0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setDelegate</name>
      <anchor>b1</anchor>
      <arglist>(KCompletionBase *delegate)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>KCompletionBase *</type>
      <name>delegate</name>
      <anchor>b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b3</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCompletionMatches</name>
    <filename>classKCompletionMatches.html</filename>
    <base>KSortableValueList</base>
    <member kind="function">
      <type></type>
      <name>KCompletionMatches</name>
      <anchor>a0</anchor>
      <arglist>(bool sort)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KCompletionMatches</name>
      <anchor>a1</anchor>
      <arglist>(const KCompletionMatchesWrapper &amp;matches)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeDuplicates</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>list</name>
      <anchor>a4</anchor>
      <arglist>(bool sort=true) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>sorting</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCompTreeNode</name>
    <filename>classKCompTreeNode.html</filename>
    <base>QChar</base>
    <member kind="function">
      <type></type>
      <name>KCompTreeNode</name>
      <anchor>a1</anchor>
      <arglist>(const QChar &amp;ch, uint weight=0)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator new</name>
      <anchor>a3</anchor>
      <arglist>(size_t s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>operator delete</name>
      <anchor>a4</anchor>
      <arglist>(void *s)</arglist>
    </member>
    <member kind="function">
      <type>KCompTreeNode *</type>
      <name>find</name>
      <anchor>a5</anchor>
      <arglist>(const QChar &amp;ch) const </arglist>
    </member>
    <member kind="function">
      <type>KCompTreeNode *</type>
      <name>insert</name>
      <anchor>a6</anchor>
      <arglist>(const QChar &amp;, bool sorted)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>childrenCount</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>confirm</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>confirm</name>
      <anchor>a10</anchor>
      <arglist>(uint w)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decline</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>weight</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KCompTreeChildren *</type>
      <name>children</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KCompTreeNode *</type>
      <name>childAt</name>
      <anchor>a14</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const KCompTreeNode *</type>
      <name>firstChild</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KCompTreeNode *</type>
      <name>lastChild</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>KCompTreeNode *</type>
      <name>next</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfig</name>
    <filename>classKConfig.html</filename>
    <base>KConfigBase</base>
    <member kind="function">
      <type></type>
      <name>KConfig</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;fileName=QString::null, bool bReadOnly=false, bool bUseKDEGlobals=true, const char *resType=&quot;config&quot;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfigBackEnd *backEnd, bool bReadOnly=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfig</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rollback</name>
      <anchor>a3</anchor>
      <arglist>(bool bDeep=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>groupList</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QMap&lt; QString, QString &gt;</type>
      <name>entryMap</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;pGroup) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reparseConfiguration</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileWriteMode</name>
      <anchor>a7</anchor>
      <arglist>(int mode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForceGlobal</name>
      <anchor>a8</anchor>
      <arglist>(bool force)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>forceGlobal</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>checkUpdate</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;id, const QString &amp;updateFile)</arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>copyTo</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;file, KConfig *config=0) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual bool</type>
      <name>internalHasGroup</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;group) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KEntryMap</type>
      <name>internalEntryMap</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;pGroup) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KEntryMap</type>
      <name>internalEntryMap</name>
      <anchor>b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>putData</name>
      <anchor>b3</anchor>
      <arglist>(const KEntryKey &amp;_key, const KEntry &amp;_data, bool _checkGroup=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KEntry</type>
      <name>lookupData</name>
      <anchor>b4</anchor>
      <arglist>(const KEntryKey &amp;_key) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b5</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KEntryMap</type>
      <name>aEntryMap</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigBackEnd</name>
    <filename>classKConfigBackEnd.html</filename>
    <member kind="function">
      <type></type>
      <name>KConfigBackEnd</name>
      <anchor>a0</anchor>
      <arglist>(KConfigBase *_config, const QString &amp;_fileName, const char *_resType, bool _useKDEGlobals)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfigBackEnd</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>parseConfigFiles</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>sync</name>
      <anchor>a3</anchor>
      <arglist>(bool bMerge=true)=0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeFileName</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;_fileName, const char *_resType, bool _useKDEGlobals)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KConfigBase::ConfigState</type>
      <name>getConfigState</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>resource</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLocaleString</name>
      <anchor>a8</anchor>
      <arglist>(const QCString &amp;_localeString)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileWriteMode</name>
      <anchor>a9</anchor>
      <arglist>(int mode)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkConfigFilesWritable</name>
      <anchor>a10</anchor>
      <arglist>(bool warnUser)</arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED QString</type>
      <name>filename</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfigBase *</type>
      <name>pConfig</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mfileName</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>resType</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>useKDEGlobals</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bFileImmutable</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>localeString</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mLocalFileName</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mGlobalFileName</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfigBase::ConfigState</type>
      <name>mConfigState</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>mFileMode</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfigBackEndPrivate *</type>
      <name>d</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KConfig</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigBase</name>
    <filename>classKConfigBase.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>ConfigState</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigBase</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfigBase</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGroup</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDesktopGroup</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>group</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasGroup</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;group) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QStringList</type>
      <name>groupList</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locale</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntry</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntry</name>
      <anchor>a9</anchor>
      <arglist>(const char *pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>readPropertyEntry</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;pKey, QVariant::Type) const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>readPropertyEntry</name>
      <anchor>a11</anchor>
      <arglist>(const char *pKey, QVariant::Type) const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>readPropertyEntry</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;pKey, const QVariant &amp;aDefault) const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>readPropertyEntry</name>
      <anchor>a13</anchor>
      <arglist>(const char *pKey, const QVariant &amp;aDefault) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readListEntry</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;pKey, QStrList &amp;list, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readListEntry</name>
      <anchor>a15</anchor>
      <arglist>(const char *pKey, QStrList &amp;list, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readListEntry</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;pKey, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readListEntry</name>
      <anchor>a17</anchor>
      <arglist>(const char *pKey, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>readIntListEntry</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;pKey) const </arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>readIntListEntry</name>
      <anchor>a19</anchor>
      <arglist>(const char *pKey) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readPathEntry</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readPathEntry</name>
      <anchor>a21</anchor>
      <arglist>(const char *pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readPathListEntry</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;pKey, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readPathListEntry</name>
      <anchor>a23</anchor>
      <arglist>(const char *pKey, char sep= &apos;,&apos;) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readNumEntry</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;pKey, int nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readNumEntry</name>
      <anchor>a25</anchor>
      <arglist>(const char *pKey, int nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>readUnsignedNumEntry</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;pKey, unsigned int nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>readUnsignedNumEntry</name>
      <anchor>a27</anchor>
      <arglist>(const char *pKey, unsigned int nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>readLongNumEntry</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;pKey, long nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>readLongNumEntry</name>
      <anchor>a29</anchor>
      <arglist>(const char *pKey, long nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>readUnsignedLongNumEntry</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;pKey, unsigned long nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>readUnsignedLongNumEntry</name>
      <anchor>a31</anchor>
      <arglist>(const char *pKey, unsigned long nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>Q_INT64</type>
      <name>readNum64Entry</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;pKey, Q_INT64 nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>Q_INT64</type>
      <name>readNum64Entry</name>
      <anchor>a33</anchor>
      <arglist>(const char *pKey, Q_INT64 nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>Q_UINT64</type>
      <name>readUnsignedNum64Entry</name>
      <anchor>a34</anchor>
      <arglist>(const QString &amp;pKey, Q_UINT64 nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>Q_UINT64</type>
      <name>readUnsignedNum64Entry</name>
      <anchor>a35</anchor>
      <arglist>(const char *pKey, Q_UINT64 nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>readDoubleNumEntry</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;pKey, double nDefault=0.0) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>readDoubleNumEntry</name>
      <anchor>a37</anchor>
      <arglist>(const char *pKey, double nDefault=0.0) const </arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>readFontEntry</name>
      <anchor>a38</anchor>
      <arglist>(const QString &amp;pKey, const QFont *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>readFontEntry</name>
      <anchor>a39</anchor>
      <arglist>(const char *pKey, const QFont *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readBoolEntry</name>
      <anchor>a40</anchor>
      <arglist>(const QString &amp;pKey, const bool bDefault=false) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readBoolEntry</name>
      <anchor>a41</anchor>
      <arglist>(const char *pKey, const bool bDefault=false) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>readRectEntry</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;pKey, const QRect *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>readRectEntry</name>
      <anchor>a43</anchor>
      <arglist>(const char *pKey, const QRect *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>readPointEntry</name>
      <anchor>a44</anchor>
      <arglist>(const QString &amp;pKey, const QPoint *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QPoint</type>
      <name>readPointEntry</name>
      <anchor>a45</anchor>
      <arglist>(const char *pKey, const QPoint *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>readSizeEntry</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;pKey, const QSize *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>readSizeEntry</name>
      <anchor>a47</anchor>
      <arglist>(const char *pKey, const QSize *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>readColorEntry</name>
      <anchor>a48</anchor>
      <arglist>(const QString &amp;pKey, const QColor *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>readColorEntry</name>
      <anchor>a49</anchor>
      <arglist>(const char *pKey, const QColor *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>readDateTimeEntry</name>
      <anchor>a50</anchor>
      <arglist>(const QString &amp;pKey, const QDateTime *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>readDateTimeEntry</name>
      <anchor>a51</anchor>
      <arglist>(const char *pKey, const QDateTime *pDefault=0L) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryUntranslated</name>
      <anchor>a52</anchor>
      <arglist>(const QString &amp;pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryUntranslated</name>
      <anchor>a53</anchor>
      <arglist>(const char *pKey, const QString &amp;aDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a54</anchor>
      <arglist>(const QString &amp;pKey, const QString &amp;pValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a55</anchor>
      <arglist>(const char *pKey, const QString &amp;pValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a56</anchor>
      <arglist>(const QString &amp;pKey, const QVariant &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a57</anchor>
      <arglist>(const char *pKey, const QVariant &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a58</anchor>
      <arglist>(const QString &amp;pKey, const QStrList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a59</anchor>
      <arglist>(const char *pKey, const QStrList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a60</anchor>
      <arglist>(const QString &amp;pKey, const QStringList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a61</anchor>
      <arglist>(const char *pKey, const QStringList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a62</anchor>
      <arglist>(const QString &amp;pKey, const QValueList&lt; int &gt; &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a63</anchor>
      <arglist>(const char *pKey, const QValueList&lt; int &gt; &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a64</anchor>
      <arglist>(const QString &amp;pKey, const char *pValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a65</anchor>
      <arglist>(const char *pKey, const char *pValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a66</anchor>
      <arglist>(const QString &amp;pKey, int nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a67</anchor>
      <arglist>(const char *pKey, int nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a68</anchor>
      <arglist>(const QString &amp;pKey, unsigned int nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a69</anchor>
      <arglist>(const char *pKey, unsigned int nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a70</anchor>
      <arglist>(const QString &amp;pKey, long nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a71</anchor>
      <arglist>(const char *pKey, long nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a72</anchor>
      <arglist>(const QString &amp;pKey, unsigned long nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a73</anchor>
      <arglist>(const char *pKey, unsigned long nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a74</anchor>
      <arglist>(const QString &amp;pKey, Q_LLONG nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a75</anchor>
      <arglist>(const char *pKey, Q_LLONG nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a76</anchor>
      <arglist>(const QString &amp;pKey, Q_ULLONG nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a77</anchor>
      <arglist>(const char *pKey, Q_ULLONG nValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a78</anchor>
      <arglist>(const QString &amp;pKey, double nValue, bool bPersistent=true, bool bGlobal=false, char format= &apos;g&apos;, int precision=6, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a79</anchor>
      <arglist>(const char *pKey, double nValue, bool bPersistent=true, bool bGlobal=false, char format= &apos;g&apos;, int precision=6, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a80</anchor>
      <arglist>(const QString &amp;pKey, bool bValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a81</anchor>
      <arglist>(const char *pKey, bool bValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a82</anchor>
      <arglist>(const QString &amp;pKey, const QFont &amp;rFont, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a83</anchor>
      <arglist>(const char *pKey, const QFont &amp;rFont, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a84</anchor>
      <arglist>(const QString &amp;pKey, const QColor &amp;rColor, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a85</anchor>
      <arglist>(const char *pKey, const QColor &amp;rColor, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a86</anchor>
      <arglist>(const QString &amp;pKey, const QDateTime &amp;rDateTime, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a87</anchor>
      <arglist>(const char *pKey, const QDateTime &amp;rDateTime, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a88</anchor>
      <arglist>(const QString &amp;pKey, const QRect &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a89</anchor>
      <arglist>(const char *pKey, const QRect &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a90</anchor>
      <arglist>(const QString &amp;pKey, const QPoint &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a91</anchor>
      <arglist>(const char *pKey, const QPoint &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a92</anchor>
      <arglist>(const QString &amp;pKey, const QSize &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a93</anchor>
      <arglist>(const char *pKey, const QSize &amp;rValue, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePathEntry</name>
      <anchor>a94</anchor>
      <arglist>(const QString &amp;pKey, const QString &amp;path, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePathEntry</name>
      <anchor>a95</anchor>
      <arglist>(const char *pKey, const QString &amp;path, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePathEntry</name>
      <anchor>a96</anchor>
      <arglist>(const QString &amp;pKey, const QStringList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writePathEntry</name>
      <anchor>a97</anchor>
      <arglist>(const char *pKey, const QStringList &amp;rValue, char sep= &apos;,&apos;, bool bPersistent=true, bool bGlobal=false, bool bNLS=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteEntry</name>
      <anchor>a98</anchor>
      <arglist>(const QString &amp;pKey, bool bNLS=false, bool bGlobal=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteEntry</name>
      <anchor>a99</anchor>
      <arglist>(const char *pKey, bool bNLS=false, bool bGlobal=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>deleteGroup</name>
      <anchor>a100</anchor>
      <arglist>(const QString &amp;group, bool bDeep=true, bool bGlobal=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDollarExpansion</name>
      <anchor>a101</anchor>
      <arglist>(bool _bExpand=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDollarExpansion</name>
      <anchor>a102</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rollback</name>
      <anchor>a103</anchor>
      <arglist>(bool bDeep=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sync</name>
      <anchor>a104</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDirty</name>
      <anchor>a105</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setReadOnly</name>
      <anchor>a106</anchor>
      <arglist>(bool _ro)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isReadOnly</name>
      <anchor>a107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasKey</name>
      <anchor>a108</anchor>
      <arglist>(const QString &amp;key) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QMap&lt; QString, QString &gt;</type>
      <name>entryMap</name>
      <anchor>a109</anchor>
      <arglist>(const QString &amp;group) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>reparseConfiguration</name>
      <anchor>a110</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isImmutable</name>
      <anchor>a111</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>groupIsImmutable</name>
      <anchor>a112</anchor>
      <arglist>(const QString &amp;group) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>entryIsImmutable</name>
      <anchor>a113</anchor>
      <arglist>(const QString &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>ConfigState</type>
      <name>getConfigState</name>
      <anchor>a114</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkConfigFilesWritable</name>
      <anchor>a115</anchor>
      <arglist>(bool warnUser)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReadDefaults</name>
      <anchor>a116</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readDefaults</name>
      <anchor>a117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>revertToDefault</name>
      <anchor>a118</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasDefault</name>
      <anchor>a119</anchor>
      <arglist>(const QString &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGroup</name>
      <anchor>a120</anchor>
      <arglist>(const QCString &amp;pGroup)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGroup</name>
      <anchor>a121</anchor>
      <arglist>(const char *pGroup)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasGroup</name>
      <anchor>a122</anchor>
      <arglist>(const QCString &amp;_pGroup) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasGroup</name>
      <anchor>a123</anchor>
      <arglist>(const char *_pGroup) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasKey</name>
      <anchor>a124</anchor>
      <arglist>(const char *pKey) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setLocale</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>setDirty</name>
      <anchor>b1</anchor>
      <arglist>(bool _bDirty=true)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>parseConfigFiles</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual KEntryMap</type>
      <name>internalEntryMap</name>
      <anchor>b3</anchor>
      <arglist>(const QString &amp;pGroup) const=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual KEntryMap</type>
      <name>internalEntryMap</name>
      <anchor>b4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>putData</name>
      <anchor>b5</anchor>
      <arglist>(const KEntryKey &amp;_key, const KEntry &amp;_data, bool _checkGroup=true)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual KEntry</type>
      <name>lookupData</name>
      <anchor>b6</anchor>
      <arglist>(const KEntryKey &amp;_key) const=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual bool</type>
      <name>internalHasGroup</name>
      <anchor>b7</anchor>
      <arglist>(const QCString &amp;group) const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QCString</type>
      <name>readEntryUtf8</name>
      <anchor>b8</anchor>
      <arglist>(const char *pKey) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b9</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfigBackEnd *</type>
      <name>backEnd</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>mGroup</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>aLocaleString</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bDirty</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bLocaleInitialized</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bReadOnly</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>bExpand</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KConfigINIBackEnd</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KConfigGroup</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigDialogManager</name>
    <filename>classKConfigDialogManager.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>updateSettings</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateWidgets</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateWidgetsDefault</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>settingsChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>settingsChanged</name>
      <anchor>l1</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>widgetModified</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigDialogManager</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, KConfigSkeleton *conf, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KConfigDialogManager</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addWidget</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasChanged</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDefault</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>(bool trackChanges)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>parseChildren</name>
      <anchor>b1</anchor>
      <arglist>(const QWidget *widget, bool trackChanges)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setProperty</name>
      <anchor>b2</anchor>
      <arglist>(QWidget *w, const QVariant &amp;v)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QVariant</type>
      <name>property</name>
      <anchor>b3</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setupWidget</name>
      <anchor>b4</anchor>
      <arglist>(QWidget *widget, KConfigSkeletonItem *item)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KConfigSkeleton *</type>
      <name>m_conf</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QWidget *</type>
      <name>m_dialog</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSqlPropertyMap *</type>
      <name>propertyMap</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMap&lt; QString, QCString &gt;</type>
      <name>changedMap</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigGroup</name>
    <filename>classKConfigGroup.html</filename>
    <base>KConfigBase</base>
    <member kind="function">
      <type></type>
      <name>KConfigGroup</name>
      <anchor>a0</anchor>
      <arglist>(KConfigBase *master, const QCString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigGroup</name>
      <anchor>a1</anchor>
      <arglist>(KConfigBase *master, const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigGroup</name>
      <anchor>a2</anchor>
      <arglist>(KConfigBase *master, const char *group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteGroup</name>
      <anchor>a3</anchor>
      <arglist>(bool bGlobal=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setDirty</name>
      <anchor>a4</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>putData</name>
      <anchor>a5</anchor>
      <arglist>(const KEntryKey &amp;_key, const KEntry &amp;_data, bool _checkGroup=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KEntry</type>
      <name>lookupData</name>
      <anchor>a6</anchor>
      <arglist>(const KEntryKey &amp;_key) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sync</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigGroupSaver</name>
    <filename>classKConfigGroupSaver.html</filename>
    <member kind="function">
      <type></type>
      <name>KConfigGroupSaver</name>
      <anchor>a0</anchor>
      <arglist>(KConfigBase *config, QString group)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigGroupSaver</name>
      <anchor>a1</anchor>
      <arglist>(KConfigBase *config, const char *group)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigGroupSaver</name>
      <anchor>a2</anchor>
      <arglist>(KConfigBase *config, const QCString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>KConfigBase *</type>
      <name>config</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigINIBackEnd</name>
    <filename>classKConfigINIBackEnd.html</filename>
    <base>KConfigBackEnd</base>
    <member kind="function">
      <type></type>
      <name>KConfigINIBackEnd</name>
      <anchor>a0</anchor>
      <arglist>(KConfigBase *_config, const QString &amp;_fileName, const char *_resType, bool _useKDEGlobals=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfigINIBackEnd</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parseConfigFiles</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sync</name>
      <anchor>a3</anchor>
      <arglist>(bool bMerge=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseSingleConfigFile</name>
      <anchor>b0</anchor>
      <arglist>(QFile &amp;rFile, KEntryMap *pWriteBackMap=0L, bool bGlobal=false, bool bDefault=false)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>writeConfigFile</name>
      <anchor>b1</anchor>
      <arglist>(QString filename, bool bGlobal=false, bool bMerge=true)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>getEntryMap</name>
      <anchor>b2</anchor>
      <arglist>(KEntryMap &amp;map, bool bGlobal, QFile *mergeFile)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>writeEntries</name>
      <anchor>b3</anchor>
      <arglist>(FILE *pStream, const KEntryMap &amp;aTempMap)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton</name>
    <filename>classKConfigSkeleton.html</filename>
    <member kind="function">
      <type></type>
      <name>KConfigSkeleton</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;configname=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigSkeleton</name>
      <anchor>a1</anchor>
      <arglist>(KSharedConfig::Ptr config)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfigSkeleton</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaults</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeConfig</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentGroup</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currentGroup</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addItem</name>
      <anchor>a8</anchor>
      <arglist>(KConfigSkeletonItem *, const QString &amp;name=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemString *</type>
      <name>addItemString</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;name, QString &amp;reference, const QString &amp;defaultValue=QString::fromLatin1(&quot;&quot;), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemPassword *</type>
      <name>addItemPassword</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;name, QString &amp;reference, const QString &amp;defaultValue=QString::fromLatin1(&quot;&quot;), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemPath *</type>
      <name>addItemPath</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;name, QString &amp;reference, const QString &amp;defaultValue=QString::fromLatin1(&quot;&quot;), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemProperty *</type>
      <name>addItemProperty</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;name, QVariant &amp;reference, const QVariant &amp;defaultValue=QVariant(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemBool *</type>
      <name>addItemBool</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;name, bool &amp;reference, bool defaultValue=false, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemInt *</type>
      <name>addItemInt</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;name, int &amp;reference, int defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemUInt *</type>
      <name>addItemUInt</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;name, unsigned int &amp;reference, unsigned int defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemLong *</type>
      <name>addItemLong</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;name, long &amp;reference, long defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemULong *</type>
      <name>addItemULong</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;name, unsigned long &amp;reference, unsigned long defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemInt64 *</type>
      <name>addItemInt64</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;name, Q_INT64 &amp;reference, Q_INT64 defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemUInt64 *</type>
      <name>addItemUInt64</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;name, Q_UINT64 &amp;reference, Q_UINT64 defaultValue=0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemDouble *</type>
      <name>addItemDouble</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;name, double &amp;reference, double defaultValue=0.0, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemColor *</type>
      <name>addItemColor</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;name, QColor &amp;reference, const QColor &amp;defaultValue=QColor(128, 128, 128), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemFont *</type>
      <name>addItemFont</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;name, QFont &amp;reference, const QFont &amp;defaultValue=KGlobalSettings::generalFont(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemRect *</type>
      <name>addItemRect</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;name, QRect &amp;reference, const QRect &amp;defaultValue=QRect(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemPoint *</type>
      <name>addItemPoint</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;name, QPoint &amp;reference, const QPoint &amp;defaultValue=QPoint(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemSize *</type>
      <name>addItemSize</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;name, QSize &amp;reference, const QSize &amp;defaultValue=QSize(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemDateTime *</type>
      <name>addItemDateTime</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;name, QDateTime &amp;reference, const QDateTime &amp;defaultValue=QDateTime(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemStringList *</type>
      <name>addItemStringList</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;name, QStringList &amp;reference, const QStringList &amp;defaultValue=QStringList(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>ItemIntList *</type>
      <name>addItemIntList</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;name, QValueList&lt; int &gt; &amp;reference, const QValueList&lt; int &gt; &amp;defaultValue=QValueList&lt; int &gt;(), const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KConfigSkeletonItem::List</type>
      <name>items</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isImmutable</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>KConfigSkeletonItem *</type>
      <name>findItem</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>useDefaults</name>
      <anchor>a33</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>usrUseDefaults</name>
      <anchor>b0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>usrSetDefaults</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>usrReadConfig</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>usrWriteConfig</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemBool</name>
    <filename>classKConfigSkeleton_1_1ItemBool.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemBool</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, bool &amp;reference, bool defaultValue=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemColor</name>
    <filename>classKConfigSkeleton_1_1ItemColor.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemColor</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QColor &amp;reference, const QColor &amp;defaultValue=QColor(128, 128, 128))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemDateTime</name>
    <filename>classKConfigSkeleton_1_1ItemDateTime.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemDateTime</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QDateTime &amp;reference, const QDateTime &amp;defaultValue=QDateTime())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemDouble</name>
    <filename>classKConfigSkeleton_1_1ItemDouble.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemDouble</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, double &amp;reference, double defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(double)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemEnum</name>
    <filename>classKConfigSkeleton_1_1ItemEnum.html</filename>
    <base>KConfigSkeleton::ItemInt</base>
    <member kind="function">
      <type></type>
      <name>ItemEnum</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, int &amp;reference, const QValueList&lt; Choice &gt; &amp;choices, int defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; Choice &gt;</type>
      <name>choices</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a2</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeConfig</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemFont</name>
    <filename>classKConfigSkeleton_1_1ItemFont.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemFont</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QFont &amp;reference, const QFont &amp;defaultValue=KGlobalSettings::generalFont())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemInt</name>
    <filename>classKConfigSkeleton_1_1ItemInt.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemInt</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, int &amp;reference, int defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemInt64</name>
    <filename>classKConfigSkeleton_1_1ItemInt64.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemInt64</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, Q_INT64 &amp;reference, Q_INT64 defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(Q_INT64)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(Q_INT64)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemIntList</name>
    <filename>classKConfigSkeleton_1_1ItemIntList.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemIntList</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QValueList&lt; int &gt; &amp;reference, const QValueList&lt; int &gt; &amp;defaultValue=QValueList&lt; int &gt;())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemLong</name>
    <filename>classKConfigSkeleton_1_1ItemLong.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemLong</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, long &amp;reference, long defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(long)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemPassword</name>
    <filename>classKConfigSkeleton_1_1ItemPassword.html</filename>
    <base>KConfigSkeleton::ItemString</base>
    <member kind="function">
      <type></type>
      <name>ItemPassword</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QString &amp;reference, const QString &amp;defaultValue=QString::fromLatin1(&quot;&quot;))</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemPath</name>
    <filename>classKConfigSkeleton_1_1ItemPath.html</filename>
    <base>KConfigSkeleton::ItemString</base>
    <member kind="function">
      <type></type>
      <name>ItemPath</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QString &amp;reference, const QString &amp;defaultValue=QString::null)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemPoint</name>
    <filename>classKConfigSkeleton_1_1ItemPoint.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemPoint</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QPoint &amp;reference, const QPoint &amp;defaultValue=QPoint())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemProperty</name>
    <filename>classKConfigSkeleton_1_1ItemProperty.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemProperty</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QVariant &amp;reference, QVariant defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemRect</name>
    <filename>classKConfigSkeleton_1_1ItemRect.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemRect</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QRect &amp;reference, const QRect &amp;defaultValue=QRect())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemSize</name>
    <filename>classKConfigSkeleton_1_1ItemSize.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemSize</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QSize &amp;reference, const QSize &amp;defaultValue=QSize())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemString</name>
    <filename>classKConfigSkeleton_1_1ItemString.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemString</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QString &amp;reference, const QString &amp;defaultValue=QString::fromLatin1(&quot;&quot;), Type type=Normal)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a2</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a3</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemStringList</name>
    <filename>classKConfigSkeleton_1_1ItemStringList.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemStringList</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, QStringList &amp;reference, const QStringList &amp;defaultValue=QStringList())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemUInt</name>
    <filename>classKConfigSkeleton_1_1ItemUInt.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemUInt</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, unsigned int &amp;reference, unsigned int defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(unsigned int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemUInt64</name>
    <filename>classKConfigSkeleton_1_1ItemUInt64.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemUInt64</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, Q_UINT64 &amp;reference, Q_UINT64 defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(Q_UINT64)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(Q_UINT64)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeleton::ItemULong</name>
    <filename>classKConfigSkeleton_1_1ItemULong.html</filename>
    <member kind="function">
      <type></type>
      <name>ItemULong</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key, unsigned long &amp;reference, unsigned long defaultValue=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a2</anchor>
      <arglist>(const QVariant &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>property</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>minValue</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QVariant</type>
      <name>maxValue</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinValue</name>
      <anchor>a6</anchor>
      <arglist>(unsigned long)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMaxValue</name>
      <anchor>a7</anchor>
      <arglist>(unsigned long)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KConfigSkeletonItem</name>
    <filename>classKConfigSkeletonItem.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; KConfigSkeletonItem * &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QDict&lt; KConfigSkeletonItem &gt;</type>
      <name>Dict</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QDictIterator&lt; KConfigSkeletonItem &gt;</type>
      <name>DictIterator</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KConfigSkeletonItem</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;group, const QString &amp;key)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KConfigSkeletonItem</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGroup</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>group</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKey</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>key</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWhatsThis</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;w)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>whatsThis</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readConfig</name>
      <anchor>a12</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeConfig</name>
      <anchor>a13</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readDefault</name>
      <anchor>a14</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setProperty</name>
      <anchor>a15</anchor>
      <arglist>(const QVariant &amp;p)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QVariant</type>
      <name>property</name>
      <anchor>a16</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVariant</type>
      <name>minValue</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVariant</type>
      <name>maxValue</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setDefault</name>
      <anchor>a19</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>swapDefault</name>
      <anchor>a20</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isImmutable</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>readImmutability</name>
      <anchor>b0</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mGroup</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mKey</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mName</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KCrash</name>
    <filename>classKCrash.html</filename>
    <member kind="typedef">
      <type>void(*</type>
      <name>HandlerType</name>
      <anchor>w0</anchor>
      <arglist>)(int)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>defaultCrashHandler</name>
      <anchor>e0</anchor>
      <arglist>(int signal)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setCrashHandler</name>
      <anchor>e1</anchor>
      <arglist>(HandlerType handler=defaultCrashHandler)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>HandlerType</type>
      <name>crashHandler</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setEmergencySaveFunction</name>
      <anchor>e3</anchor>
      <arglist>(HandlerType saveFunction=(HandlerType) 0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>HandlerType</type>
      <name>emergencySaveFunction</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setSafer</name>
      <anchor>e5</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setApplicationPath</name>
      <anchor>e6</anchor>
      <arglist>(QString path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setApplicationName</name>
      <anchor>e7</anchor>
      <arglist>(QString name)</arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>HandlerType</type>
      <name>_crashHandler</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>HandlerType</type>
      <name>_emergencySaveFunction</name>
      <anchor>t1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDCOPPropertyProxy</name>
    <filename>classKDCOPPropertyProxy.html</filename>
    <member kind="function">
      <type></type>
      <name>KDCOPPropertyProxy</name>
      <anchor>a0</anchor>
      <arglist>(QObject *object)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KDCOPPropertyProxy</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPropertyRequest</name>
      <anchor>a2</anchor>
      <arglist>(const QCString &amp;fun)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>processPropertyRequest</name>
      <anchor>a3</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; QCString &gt;</type>
      <name>functions</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QValueList&lt; QCString &gt;</type>
      <name>functions</name>
      <anchor>e0</anchor>
      <arglist>(QObject *object)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isPropertyRequest</name>
      <anchor>e1</anchor>
      <arglist>(const QCString &amp;fun, QObject *object)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>processPropertyRequest</name>
      <anchor>e2</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData, QObject *object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDebugDCOPIface</name>
    <filename>classKDebugDCOPIface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>void</type>
      <name>notifyKDebugConfigChanged</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KDesktopFile</name>
    <filename>classKDesktopFile.html</filename>
    <base>KConfig</base>
    <member kind="function">
      <type></type>
      <name>KDesktopFile</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;fileName, bool readOnly=false, const char *resType=&quot;apps&quot;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KDesktopFile</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readType</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readIcon</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readName</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readComment</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readGenericName</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readPath</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readDevice</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readURL</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readActions</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionGroup</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasActionGroup</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;group) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasLinkType</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasApplicationType</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasMimeTypeType</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasDeviceType</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>tryExec</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>resource</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readDocPath</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>sortOrder</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDesktopFile *</type>
      <name>copyTo</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;file) const </arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED QString</type>
      <name>filename</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isDesktopFile</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isAuthorizedDesktopFile</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>locateLocal</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KEntry</name>
    <filename>structKEntry.html</filename>
    <member kind="variable">
      <type>QCString</type>
      <name>mValue</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bDirty</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bNLS</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bGlobal</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bImmutable</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bDeleted</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bExpand</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KEntryKey</name>
    <filename>structKEntryKey.html</filename>
    <member kind="function">
      <type></type>
      <name>KEntryKey</name>
      <anchor>a0</anchor>
      <arglist>(const QCString &amp;_group=0, const QCString &amp;_key=0)</arglist>
    </member>
    <member kind="variable">
      <type>QCString</type>
      <name>mGroup</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QCString</type>
      <name>mKey</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bLocal</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>bDefault</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>c_key</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KExtendedSocket</name>
    <filename>classKExtendedSocket.html</filename>
    <base>KBufferedIO</base>
    <member kind="enumeration">
      <name>Flags</name>
      <anchor>w27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SockStatus</name>
      <anchor>w28</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>lookupFinished</name>
      <anchor>l0</anchor>
      <arglist>(int count)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>connectionSuccess</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>connectionFailed</name>
      <anchor>l2</anchor>
      <arglist>(int error)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>readyAccept</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KExtendedSocket</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KExtendedSocket</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;host, int port, int flags=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KExtendedSocket</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;host, const QString &amp;service, int flags=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KExtendedSocket</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socketStatus</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>systemError</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>setSocketFlags</name>
      <anchor>a7</anchor>
      <arglist>(int flags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socketFlags</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setHost</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;host)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>host</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPort</name>
      <anchor>a11</anchor>
      <arglist>(int port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPort</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;port)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>port</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;host, int port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;host, const QString &amp;serv)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBindHost</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;host)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unsetBindHost</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>bindHost</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBindPort</name>
      <anchor>a19</anchor>
      <arglist>(int port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBindPort</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;service)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unsetBindPort</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>bindPort</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBindAddress</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;host, int port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBindAddress</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;host, const QString &amp;service)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unsetBindAddress</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setTimeout</name>
      <anchor>a26</anchor>
      <arglist>(int secs, int usecs=0)</arglist>
    </member>
    <member kind="function">
      <type>timeval</type>
      <name>timeout</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setBlockingMode</name>
      <anchor>a28</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>blockingMode</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddressReusable</name>
      <anchor>a30</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addressReusable</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setIPv6Only</name>
      <anchor>a32</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isIPv6Only</name>
      <anchor>a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setBufferSize</name>
      <anchor>a34</anchor>
      <arglist>(int rsize, int wsize=-2)</arglist>
    </member>
    <member kind="function">
      <type>const KSocketAddress *</type>
      <name>localAddress</name>
      <anchor>a35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KSocketAddress *</type>
      <name>peerAddress</name>
      <anchor>a36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fd</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>lookup</name>
      <anchor>a38</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>startAsyncLookup</name>
      <anchor>a39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>cancelAsyncLookup</name>
      <anchor>a40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>listen</name>
      <anchor>a41</anchor>
      <arglist>(int N=5)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>accept</name>
      <anchor>a42</anchor>
      <arglist>(KExtendedSocket *&amp;sock)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>connect</name>
      <anchor>a43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>startAsyncConnect</name>
      <anchor>a44</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>cancelAsyncConnect</name>
      <anchor>a45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>open</name>
      <anchor>a46</anchor>
      <arglist>(int mode=IO_Raw|IO_ReadWrite)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>close</name>
      <anchor>a47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>closeNow</name>
      <anchor>a48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>release</name>
      <anchor>a49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>flush</name>
      <anchor>a50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Q_ULONG</type>
      <name>size</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Q_ULONG</type>
      <name>at</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>at</name>
      <anchor>a53</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>atEnd</name>
      <anchor>a54</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Q_LONG</type>
      <name>readBlock</name>
      <anchor>a55</anchor>
      <arglist>(char *data, Q_ULONG maxlen)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Q_LONG</type>
      <name>writeBlock</name>
      <anchor>a56</anchor>
      <arglist>(const char *data, Q_ULONG len)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>peekBlock</name>
      <anchor>a57</anchor>
      <arglist>(char *data, uint maxlen)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>unreadBlock</name>
      <anchor>a58</anchor>
      <arglist>(const char *data, uint len)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>bytesAvailable</name>
      <anchor>a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>waitForMore</name>
      <anchor>a60</anchor>
      <arglist>(int msec)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getch</name>
      <anchor>a61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>putch</name>
      <anchor>a62</anchor>
      <arglist>(int ch)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>ungetch</name>
      <anchor>a63</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>enableRead</name>
      <anchor>a64</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>enableWrite</name>
      <anchor>a65</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>resolve</name>
      <anchor>e0</anchor>
      <arglist>(sockaddr *sock, ksocklen_t len, QString &amp;host, QString &amp;port, int flags=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>resolve</name>
      <anchor>e1</anchor>
      <arglist>(KSocketAddress *sock, QString &amp;host, QString &amp;port, int flags=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPtrList&lt; KAddressInfo &gt;</type>
      <name>lookup</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;host, const QString &amp;port, int flags=0, int *error=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KSocketAddress *</type>
      <name>localAddress</name>
      <anchor>e3</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KSocketAddress *</type>
      <name>peerAddress</name>
      <anchor>e4</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>strError</name>
      <anchor>e5</anchor>
      <arglist>(int code, int syserr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>setAddressReusable</name>
      <anchor>e6</anchor>
      <arglist>(int fd, bool enable)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>socketActivityRead</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>socketActivityWrite</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>dnsResultsReady</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>startAsyncConnectSlot</name>
      <anchor>j3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>connectionEvent</name>
      <anchor>j4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSocketNotifier *</type>
      <name>readNotifier</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QSocketNotifier *</type>
      <name>writeNotifier</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setError</name>
      <anchor>b2</anchor>
      <arglist>(int errorkind, int error)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>cleanError</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSocketStatus</name>
      <anchor>b4</anchor>
      <arglist>(int status)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b5</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>sockfd</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KSocket</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KServerSocket</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGenericFactory</name>
    <filename>classKGenericFactory.html</filename>
    <templarg>Product</templarg>
    <templarg>ParentType</templarg>
    <base>KLibFactory</base>
    <member kind="function">
      <type></type>
      <name>KGenericFactory</name>
      <anchor>a0</anchor>
      <arglist>(const char *instanceName=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QObject *</type>
      <name>createObject</name>
      <anchor>b0</anchor>
      <arglist>(QObject *parent, const char *name, const char *className, const QStringList &amp;args)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGenericFactory&lt; KTypeList&lt; Product, ProductListTail &gt;, KTypeList&lt; ParentType, ParentTypeListTail &gt; &gt;</name>
    <filename>classKGenericFactory_3_01KTypeList_3_01Product_00_01ProductListTail_01_4_00_01KTypeList_3_01ParentType_00_01ParentTypeListTail_01_4_01_4.html</filename>
    <templarg>Product</templarg>
    <templarg>ProductListTail</templarg>
    <templarg>ParentType</templarg>
    <templarg>ParentTypeListTail</templarg>
    <base>KLibFactory</base>
    <member kind="function">
      <type></type>
      <name>KGenericFactory</name>
      <anchor>a0</anchor>
      <arglist>(const char *instanceName=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QObject *</type>
      <name>createObject</name>
      <anchor>b0</anchor>
      <arglist>(QObject *parent, const char *name, const char *className, const QStringList &amp;args)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGenericFactory&lt; KTypeList&lt; Product, ProductListTail &gt;, QObject &gt;</name>
    <filename>classKGenericFactory_3_01KTypeList_3_01Product_00_01ProductListTail_01_4_00_01QObject_01_4.html</filename>
    <templarg>Product</templarg>
    <templarg>ProductListTail</templarg>
    <base>KLibFactory</base>
    <member kind="function">
      <type></type>
      <name>KGenericFactory</name>
      <anchor>a0</anchor>
      <arglist>(const char *instanceName=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QObject *</type>
      <name>createObject</name>
      <anchor>b0</anchor>
      <arglist>(QObject *parent, const char *name, const char *className, const QStringList &amp;args)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGlobal</name>
    <filename>classKGlobal.html</filename>
    <member kind="function" static="yes">
      <type>KInstance *</type>
      <name>instance</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KStandardDirs *</type>
      <name>dirs</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KSharedConfig *</type>
      <name>sharedConfig</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KIconLoader *</type>
      <name>iconLoader</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KLocale *</type>
      <name>locale</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KCharsets *</type>
      <name>charsets</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QString &amp;</type>
      <name>staticQString</name>
      <anchor>e7</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QString &amp;</type>
      <name>staticQString</name>
      <anchor>e8</anchor>
      <arglist>(const QString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>registerStaticDeleter</name>
      <anchor>e9</anchor>
      <arglist>(KStaticDeleterBase *d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>unregisterStaticDeleter</name>
      <anchor>e10</anchor>
      <arglist>(KStaticDeleterBase *d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>deleteStaticDeleters</name>
      <anchor>e11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setActiveInstance</name>
      <anchor>e12</anchor>
      <arglist>(KInstance *d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KInstance *</type>
      <name>activeInstance</name>
      <anchor>e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KStringDict *</type>
      <name>_stringDict</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KInstance *</type>
      <name>_instance</name>
      <anchor>s1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KLocale *</type>
      <name>_locale</name>
      <anchor>s2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KCharsets *</type>
      <name>_charsets</name>
      <anchor>s3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KStaticDeleterList *</type>
      <name>_staticDeleters</name>
      <anchor>s4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KInstance *</type>
      <name>_activeInstance</name>
      <anchor>s5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkAccess</name>
      <anchor>m0</anchor>
      <arglist>(const QString &amp;pathname, int mode)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>endl</name>
      <anchor>ga16</anchor>
      <arglist>(kdbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>flush</name>
      <anchor>ga17</anchor>
      <arglist>(kdbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdDebug</name>
      <anchor>ga18</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kdBacktrace</name>
      <anchor>ga19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kdBacktrace</name>
      <anchor>ga20</anchor>
      <arglist>(int levels)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdWarning</name>
      <anchor>ga21</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdError</name>
      <anchor>ga22</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdFatal</name>
      <anchor>ga23</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kdClearDebugConfig</name>
      <anchor>ga24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>KMIN</name>
      <anchor>m10</anchor>
      <arglist>(a, b)</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>KMAX</name>
      <anchor>m11</anchor>
      <arglist>(a, b)</arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>KABS</name>
      <anchor>m12</anchor>
      <arglist>(a)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGlobalAccel</name>
    <filename>classKGlobalAccel.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>KGlobalAccel</name>
      <anchor>a0</anchor>
      <arglist>(QObject *pParent, const char *psName=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEnabled</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnabled</name>
      <anchor>a3</anchor>
      <arglist>(bool bEnabled)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;sAction, const QString &amp;sLabel, const QString &amp;sWhatsThis, const KShortcut &amp;cutDef3, const KShortcut &amp;cutDef4, const QObject *pObjSlot, const char *psMethodSlot, bool bConfigurable=true, bool bEnabled=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;sAction)</arglist>
    </member>
    <member kind="function">
      <type>KAccelAction *</type>
      <name>insert</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;sName, const QString &amp;sLabel)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>updateConnections</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;sAction) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setShortcut</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;sAction, const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setSlot</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;sAction, const QObject *pObjSlot, const char *psMethodSlot)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>configGroup</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setConfigGroup</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;cg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readSettings</name>
      <anchor>a13</anchor>
      <arglist>(KConfigBase *pConfig=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeSettings</name>
      <anchor>a14</anchor>
      <arglist>(KConfigBase *pConfig=0) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeSettings</name>
      <anchor>a15</anchor>
      <arglist>(KConfigBase *pConfig, bool bGlobal) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>useFourModifierKeys</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KGlobalAccelPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KAccelShortcutList</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KGlobalSettings</name>
    <filename>classKGlobalSettings.html</filename>
    <member kind="enumeration">
      <name>TearOffHandle</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Disable</name>
      <anchor>w9w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ApplicationLevel</name>
      <anchor>w9w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Enable</name>
      <anchor>w9w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Completion</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionNone</name>
      <anchor>w10w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionAuto</name>
      <anchor>w10w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionMan</name>
      <anchor>w10w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionShell</name>
      <anchor>w10w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionPopup</name>
      <anchor>w10w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CompletionPopupAuto</name>
      <anchor>w10w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>dndEventDelay</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>singleClick</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>TearOffHandle</type>
      <name>insertTearOffHandle</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>changeCursorOverIcon</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>visualActivate</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>unsigned int</type>
      <name>visualActivateSpeed</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>autoSelectDelay</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>contextMenuKey</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>showContextMenusOnPress</name>
      <anchor>e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Completion</type>
      <name>completionMode</name>
      <anchor>e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KMouseSettings &amp;</type>
      <name>mouseSettings</name>
      <anchor>e10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>desktopPath</name>
      <anchor>e11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>autostartPath</name>
      <anchor>e12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>trashPath</name>
      <anchor>e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>documentPath</name>
      <anchor>e14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>toolBarHighlightColor</name>
      <anchor>e15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>inactiveTitleColor</name>
      <anchor>e16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>inactiveTextColor</name>
      <anchor>e17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>activeTitleColor</name>
      <anchor>e18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>activeTextColor</name>
      <anchor>e19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>contrast</name>
      <anchor>e20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>baseColor</name>
      <anchor>e21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>textColor</name>
      <anchor>e22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>linkColor</name>
      <anchor>e23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>visitedLinkColor</name>
      <anchor>e24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>highlightedTextColor</name>
      <anchor>e25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>highlightColor</name>
      <anchor>e26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>alternateBackgroundColor</name>
      <anchor>e27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QColor</type>
      <name>calculateAlternateBackgroundColor</name>
      <anchor>e28</anchor>
      <arglist>(const QColor &amp;base)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>generalFont</name>
      <anchor>e29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>fixedFont</name>
      <anchor>e30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>toolBarFont</name>
      <anchor>e31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>menuFont</name>
      <anchor>e32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>windowTitleFont</name>
      <anchor>e33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>taskbarFont</name>
      <anchor>e34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QFont</type>
      <name>largeFont</name>
      <anchor>e35</anchor>
      <arglist>(const QString &amp;text=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isMultiHead</name>
      <anchor>e36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>wheelMouseZooms</name>
      <anchor>e37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QRect</type>
      <name>splashScreenDesktopGeometry</name>
      <anchor>e38</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QRect</type>
      <name>desktopGeometry</name>
      <anchor>e39</anchor>
      <arglist>(const QPoint &amp;point)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QRect</type>
      <name>desktopGeometry</name>
      <anchor>e40</anchor>
      <arglist>(QWidget *w)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>showIconsOnPushButtons</name>
      <anchor>e41</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>showFilePreview</name>
      <anchor>e42</anchor>
      <arglist>(const KURL &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>opaqueResize</name>
      <anchor>e43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KApplication</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KGlobalSettings::KMouseSettings</name>
    <filename>structKGlobalSettings_1_1KMouseSettings.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>handed</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIcon</name>
    <filename>classKIcon.html</filename>
    <member kind="enumeration">
      <name>Context</name>
      <anchor>w34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Any</name>
      <anchor>w34w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Action</name>
      <anchor>w34w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Application</name>
      <anchor>w34w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Device</name>
      <anchor>w34w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FileSystem</name>
      <anchor>w34w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MimeType</name>
      <anchor>w34w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Type</name>
      <anchor>w35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Fixed</name>
      <anchor>w35w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Scalable</name>
      <anchor>w35w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Threshold</name>
      <anchor>w35w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MatchType</name>
      <anchor>w36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MatchExact</name>
      <anchor>w36w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MatchBest</name>
      <anchor>w36w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Group</name>
      <anchor>w37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>StdSizes</name>
      <anchor>w38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeSmall</name>
      <anchor>w38w20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeMedium</name>
      <anchor>w38w21</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeLarge</name>
      <anchor>w38w22</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SizeHuge</name>
      <anchor>w38w23</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>States</name>
      <anchor>w39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DefaultState</name>
      <anchor>w39w24</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ActiveState</name>
      <anchor>w39w25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DisabledState</name>
      <anchor>w39w26</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LastState</name>
      <anchor>w39w27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Overlays</name>
      <anchor>w40</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LockOverlay</name>
      <anchor>w40w28</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ZipOverlay</name>
      <anchor>w40w29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LinkOverlay</name>
      <anchor>w40w30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HiddenOverlay</name>
      <anchor>w40w31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ShareOverlay</name>
      <anchor>w40w32</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>size</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Context</type>
      <name>context</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Type</type>
      <name>type</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>threshold</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>path</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIconEffect</name>
    <filename>classKIconEffect.html</filename>
    <member kind="enumeration">
      <name>Effects</name>
      <anchor>w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KIconEffect</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasEffect</name>
      <anchor>a3</anchor>
      <arglist>(int group, int state) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fingerprint</name>
      <anchor>a4</anchor>
      <arglist>(int group, int state) const </arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>apply</name>
      <anchor>a5</anchor>
      <arglist>(QImage src, int group, int state) const </arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>apply</name>
      <anchor>a6</anchor>
      <arglist>(QImage src, int effect, float value, const QColor rgb, bool trans) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>apply</name>
      <anchor>a7</anchor>
      <arglist>(QPixmap src, int group, int state) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>apply</name>
      <anchor>a8</anchor>
      <arglist>(QPixmap src, int effect, float value, const QColor rgb, bool trans) const </arglist>
    </member>
    <member kind="function">
      <type>QImage</type>
      <name>doublePixels</name>
      <anchor>a9</anchor>
      <arglist>(QImage src) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>visualActivate</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *widget, QRect rect)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>toGray</name>
      <anchor>e1</anchor>
      <arglist>(QImage &amp;image, float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>colorize</name>
      <anchor>e2</anchor>
      <arglist>(QImage &amp;image, const QColor &amp;col, float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>deSaturate</name>
      <anchor>e3</anchor>
      <arglist>(QImage &amp;image, float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>toGamma</name>
      <anchor>e4</anchor>
      <arglist>(QImage &amp;image, float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>semiTransparent</name>
      <anchor>e5</anchor>
      <arglist>(QImage &amp;image)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>semiTransparent</name>
      <anchor>e6</anchor>
      <arglist>(QPixmap &amp;pixmap)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>overlay</name>
      <anchor>e7</anchor>
      <arglist>(QImage &amp;src, QImage &amp;overlay)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIconLoader</name>
    <filename>classKIconLoader.html</filename>
    <member kind="function">
      <type></type>
      <name>KIconLoader</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;appname=QString::null, KStandardDirs *dirs=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KIconLoader</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addAppDir</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;appname)</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>loadIcon</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size=0, int state=KIcon::DefaultState, QString *path_store=0L, bool canReturnNull=false) const </arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>loadIconSet</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size, bool canReturnNull)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>loadIconSet</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>iconPath</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;name, int group_or_size, bool canReturnNull=false) const </arglist>
    </member>
    <member kind="function">
      <type>QMovie</type>
      <name>loadMovie</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size=0) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>moviePath</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size=0) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>loadAnimated</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;name, KIcon::Group group, int size=0) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>queryIcons</name>
      <anchor>a10</anchor>
      <arglist>(int group_or_size, KIcon::Context context=KIcon::Any) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>queryIconsByContext</name>
      <anchor>a11</anchor>
      <arglist>(int group_or_size, KIcon::Context context=KIcon::Any) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>queryIconsByDir</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;iconsDir) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentSize</name>
      <anchor>a13</anchor>
      <arglist>(KIcon::Group group) const </arglist>
    </member>
    <member kind="function">
      <type>KIconTheme *</type>
      <name>theme</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KIconEffect *</type>
      <name>iconEffect</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reconfigure</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;_appname, KStandardDirs *_dirs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>alphaBlending</name>
      <anchor>a17</anchor>
      <arglist>(KIcon::Group group) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addExtraDesktopThemes</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>extraDesktopThemesAdded</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableDelayedIconSetLoading</name>
      <anchor>a20</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isDelayedIconSetLoadingEnabled</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPixmap</type>
      <name>unknown</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>DesktopIcon</name>
      <anchor>m0</anchor>
      <arglist>(const QString &amp;name, int size=0, int state=KIcon::DefaultState, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>DesktopIcon</name>
      <anchor>m1</anchor>
      <arglist>(const QString &amp;name, KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>DesktopIconSet</name>
      <anchor>m2</anchor>
      <arglist>(const QString &amp;name, int size=0, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>BarIcon</name>
      <anchor>m3</anchor>
      <arglist>(const QString &amp;name, int size=0, int state=KIcon::DefaultState, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>BarIcon</name>
      <anchor>m4</anchor>
      <arglist>(const QString &amp;name, KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>BarIconSet</name>
      <anchor>m5</anchor>
      <arglist>(const QString &amp;name, int size=0, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>SmallIcon</name>
      <anchor>m6</anchor>
      <arglist>(const QString &amp;name, int size=0, int state=KIcon::DefaultState, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>SmallIcon</name>
      <anchor>m7</anchor>
      <arglist>(const QString &amp;name, KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>SmallIconSet</name>
      <anchor>m8</anchor>
      <arglist>(const QString &amp;name, int size=0, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>MainBarIcon</name>
      <anchor>m9</anchor>
      <arglist>(const QString &amp;name, int size=0, int state=KIcon::DefaultState, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>MainBarIcon</name>
      <anchor>m10</anchor>
      <arglist>(const QString &amp;name, KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>MainBarIconSet</name>
      <anchor>m11</anchor>
      <arglist>(const QString &amp;name, int size=0, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>UserIcon</name>
      <anchor>m12</anchor>
      <arglist>(const QString &amp;name, int state=KIcon::DefaultState, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>UserIcon</name>
      <anchor>m13</anchor>
      <arglist>(const QString &amp;name, KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type>QIconSet</type>
      <name>UserIconSet</name>
      <anchor>m14</anchor>
      <arglist>(const QString &amp;name, KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>IconSize</name>
      <anchor>m15</anchor>
      <arglist>(KIcon::Group group, KInstance *instance=KGlobal::instance())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIconTheme</name>
    <filename>classKIconTheme.html</filename>
    <member kind="function">
      <type></type>
      <name>KIconTheme</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name, const QString &amp;appName=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>description</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>example</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>screenshot</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>linkOverlay</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>zipOverlay</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>lockOverlay</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>shareOverlay</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>dir</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>inherits</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isHidden</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>depth</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>defaultSize</name>
      <anchor>a15</anchor>
      <arglist>(KIcon::Group group) const </arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; int &gt;</type>
      <name>querySizes</name>
      <anchor>a16</anchor>
      <arglist>(KIcon::Group group) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>queryIcons</name>
      <anchor>a17</anchor>
      <arglist>(int size, KIcon::Context context=KIcon::Any) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>queryIconsByContext</name>
      <anchor>a18</anchor>
      <arglist>(int size, KIcon::Context context=KIcon::Any) const </arglist>
    </member>
    <member kind="function">
      <type>KIcon</type>
      <name>iconPath</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;name, int size, KIcon::MatchType match) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>list</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>current</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>reconfigure</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>defaultThemeName</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KInetSocketAddress</name>
    <filename>classKInetSocketAddress.html</filename>
    <base>KSocketAddress</base>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a1</anchor>
      <arglist>(const KInetSocketAddress &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a2</anchor>
      <arglist>(const sockaddr_in *sin, ksocklen_t len)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a3</anchor>
      <arglist>(const sockaddr_in6 *sin6, ksocklen_t len)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a4</anchor>
      <arglist>(const in_addr &amp;addr, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a5</anchor>
      <arglist>(const in6_addr &amp;addr, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInetSocketAddress</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;addr, unsigned short port, int family=-1)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KInetSocketAddress</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a8</anchor>
      <arglist>(const KInetSocketAddress &amp;ksa)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a9</anchor>
      <arglist>(const sockaddr_in *sin, ksocklen_t len)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a10</anchor>
      <arglist>(const sockaddr_in6 *sin6, ksocklen_t len)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a11</anchor>
      <arglist>(const in_addr &amp;addr, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a12</anchor>
      <arglist>(const in6_addr &amp;addr, unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;addr, unsigned short port, int family=-1)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setHost</name>
      <anchor>a14</anchor>
      <arglist>(const in_addr &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setHost</name>
      <anchor>a15</anchor>
      <arglist>(const in6_addr &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setHost</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;addr, int family=-1)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPort</name>
      <anchor>a17</anchor>
      <arglist>(unsigned short port)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setFamily</name>
      <anchor>a18</anchor>
      <arglist>(int family)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setFlowinfo</name>
      <anchor>a19</anchor>
      <arglist>(Q_UINT32 flowinfo)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setScopeId</name>
      <anchor>a20</anchor>
      <arglist>(int scopeid)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>pretty</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>nodeName</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>serviceName</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const sockaddr_in *</type>
      <name>addressV4</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const sockaddr_in6 *</type>
      <name>addressV6</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>in_addr</type>
      <name>hostV4</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>in6_addr</type>
      <name>hostV6</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>port</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Q_UINT32</type>
      <name>flowinfo</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>scopeId</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ksocklen_t</type>
      <name>size</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const sockaddr_in *</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const sockaddr_in6 *</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KInetSocketAddress &amp;</type>
      <name>operator=</name>
      <anchor>a34</anchor>
      <arglist>(const KInetSocketAddress &amp;other)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>areEqualInet</name>
      <anchor>e0</anchor>
      <arglist>(const KSocketAddress &amp;s1, const KSocketAddress &amp;s2, bool coreOnly)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>areEqualInet6</name>
      <anchor>e1</anchor>
      <arglist>(const KSocketAddress &amp;s1, const KSocketAddress &amp;s2, bool coreOnly)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>addrToString</name>
      <anchor>e2</anchor>
      <arglist>(int family, const void *addr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>stringToAddr</name>
      <anchor>e3</anchor>
      <arglist>(int family, const char *text, void *dest)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KExtendedSocket</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KInstance</name>
    <filename>classKInstance.html</filename>
    <member kind="function">
      <type></type>
      <name>KInstance</name>
      <anchor>a0</anchor>
      <arglist>(const QCString &amp;instanceName)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInstance</name>
      <anchor>a1</anchor>
      <arglist>(const KAboutData *aboutData)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KInstance</name>
      <anchor>a2</anchor>
      <arglist>(KInstance *src)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KInstance</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KStandardDirs *</type>
      <name>dirs</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KSharedConfig *</type>
      <name>sharedConfig</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KIconLoader *</type>
      <name>iconLoader</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>newIconLoader</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KAboutData *</type>
      <name>aboutData</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>instanceName</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KMimeSourceFactory *</type>
      <name>mimeSourceFactory</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KInstance</name>
      <anchor>b0</anchor>
      <arglist>(const KInstance &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setConfigName</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KStandardDirs</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KIPC</name>
    <filename>classKIPC.html</filename>
    <member kind="enumeration">
      <name>Message</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UserMessage</name>
      <anchor>w9w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>sendMessage</name>
      <anchor>e0</anchor>
      <arglist>(Message msg, WId w, int data=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>sendMessageAll</name>
      <anchor>e1</anchor>
      <arglist>(Message msg, int data=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>kdbgstream</name>
    <filename>classkdbgstream.html</filename>
    <member kind="function">
      <type></type>
      <name>kdbgstream</name>
      <anchor>a0</anchor>
      <arglist>(unsigned int _area, unsigned int _level, bool _print=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>kdbgstream</name>
      <anchor>a1</anchor>
      <arglist>(const char *initialString, unsigned int _area, unsigned int _level, bool _print=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>kdbgstream</name>
      <anchor>a2</anchor>
      <arglist>(kdbgstream &amp;str)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>kdbgstream</name>
      <anchor>a3</anchor>
      <arglist>(const kdbgstream &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a5</anchor>
      <arglist>(bool i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a6</anchor>
      <arglist>(short i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a7</anchor>
      <arglist>(unsigned short i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a8</anchor>
      <arglist>(char i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a9</anchor>
      <arglist>(unsigned char i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a10</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a11</anchor>
      <arglist>(unsigned int i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a12</anchor>
      <arglist>(long i)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a13</anchor>
      <arglist>(unsigned long i)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a16</anchor>
      <arglist>(const char *string)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a17</anchor>
      <arglist>(const QCString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a18</anchor>
      <arglist>(const void *p)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a19</anchor>
      <arglist>(KDBGFUNC f)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a20</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>form</name>
      <anchor>a21</anchor>
      <arglist>(const char *format,...)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a22</anchor>
      <arglist>(const QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a23</anchor>
      <arglist>(QWidget *widget)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a24</anchor>
      <arglist>(const QDateTime &amp;dateTime)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a25</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a26</anchor>
      <arglist>(const QTime &amp;time)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a27</anchor>
      <arglist>(const QPoint &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a28</anchor>
      <arglist>(const QSize &amp;size)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a29</anchor>
      <arglist>(const QRect &amp;rect)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a30</anchor>
      <arglist>(const QRegion &amp;region)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a31</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a32</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a33</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a34</anchor>
      <arglist>(const QPen &amp;pen)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a35</anchor>
      <arglist>(const QBrush &amp;brush)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKey</name>
    <filename>classKKey.html</filename>
    <member kind="enumeration">
      <name>ModFlag</name>
      <anchor>w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a1</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a2</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a3</anchor>
      <arglist>(const QKeyEvent *keyEvent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a4</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKey</name>
      <anchor>a6</anchor>
      <arglist>(uint key, uint mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a9</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a10</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a11</anchor>
      <arglist>(const QKeyEvent *keyEvent)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a12</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a14</anchor>
      <arglist>(uint key, uint mod)</arglist>
    </member>
    <member kind="function">
      <type>KKey &amp;</type>
      <name>operator=</name>
      <anchor>a15</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>sym</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modFlags</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a19</anchor>
      <arglist>(const KKey &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a20</anchor>
      <arglist>(const KKey &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a21</anchor>
      <arglist>(const KKey &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a22</anchor>
      <arglist>(const KKey &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCodeQt</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toStringInternal</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>simplify</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KKey &amp;</type>
      <name>null</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>modFlagLabel</name>
      <anchor>e1</anchor>
      <arglist>(ModFlag f)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KKeyNative</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKeyNative</name>
    <filename>classKKeyNative.html</filename>
    <member kind="function">
      <type></type>
      <name>KKeyNative</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyNative</name>
      <anchor>a1</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyNative</name>
      <anchor>a2</anchor>
      <arglist>(const KKeyNative &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeyNative</name>
      <anchor>a3</anchor>
      <arglist>(uint code, uint mod, uint sym)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a6</anchor>
      <arglist>(const XEvent *xevent)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a7</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a8</anchor>
      <arglist>(const KKeyNative &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>KKeyNative &amp;</type>
      <name>operator=</name>
      <anchor>a9</anchor>
      <arglist>(const KKeyNative &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCodeQt</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KKey</type>
      <name>key</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator KKey</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>code</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>mod</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>sym</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a17</anchor>
      <arglist>(const KKeyNative &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a18</anchor>
      <arglist>(const KKeyNative &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a19</anchor>
      <arglist>(const KKeyNative &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a20</anchor>
      <arglist>(const KKeyNative &amp;key) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KKeyNative &amp;</type>
      <name>null</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>keyboardHasWinKey</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>modX</name>
      <anchor>e2</anchor>
      <arglist>(KKey::ModFlag modFlag)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>accelModMaskX</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>modXNumLock</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>modXLock</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>uint</type>
      <name>modXScrollLock</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KKeySequence</name>
    <filename>classKKeySequence.html</filename>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a1</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a2</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a3</anchor>
      <arglist>(const KKeyNative &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a4</anchor>
      <arglist>(const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KKeySequence</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a8</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a9</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a10</anchor>
      <arglist>(const KKeyNative &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a11</anchor>
      <arglist>(const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>KKeySequence &amp;</type>
      <name>operator=</name>
      <anchor>a13</anchor>
      <arglist>(const KKeySequence &amp;seq)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>count</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KKey &amp;</type>
      <name>key</name>
      <anchor>a15</anchor>
      <arglist>(uint i) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isTriggerOnRelease</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setKey</name>
      <anchor>a17</anchor>
      <arglist>(uint i, const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startsWith</name>
      <anchor>a19</anchor>
      <arglist>(const KKeySequence &amp;keySeq) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a20</anchor>
      <arglist>(const KKeySequence &amp;keySeq) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a21</anchor>
      <arglist>(const KKeySequence &amp;seq) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a22</anchor>
      <arglist>(const KKeySequence &amp;seq) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a23</anchor>
      <arglist>(const KKeySequence &amp;seq) const </arglist>
    </member>
    <member kind="function">
      <type>QKeySequence</type>
      <name>qt</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCodeQt</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toStringInternal</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KKeySequence &amp;</type>
      <name>null</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uchar</type>
      <name>m_nKeys</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uchar</type>
      <name>m_bTriggerOnRelease</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KKey</type>
      <name>m_rgvar</name>
      <anchor>p2</anchor>
      <arglist>[MAX_KEYS]</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KKeyNative</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>kndbgstream</name>
    <filename>classkndbgstream.html</filename>
    <member kind="function">
      <type></type>
      <name>kndbgstream</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a2</anchor>
      <arglist>(short int)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a3</anchor>
      <arglist>(unsigned short int)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a4</anchor>
      <arglist>(char)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a5</anchor>
      <arglist>(unsigned char)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a6</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a10</anchor>
      <arglist>(const QCString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a11</anchor>
      <arglist>(const char *)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a12</anchor>
      <arglist>(const void *)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a13</anchor>
      <arglist>(void *)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a14</anchor>
      <arglist>(double)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a15</anchor>
      <arglist>(long)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a16</anchor>
      <arglist>(unsigned long)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a17</anchor>
      <arglist>(KNDBGFUNC)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a18</anchor>
      <arglist>(const QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a19</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>form</name>
      <anchor>a20</anchor>
      <arglist>(const char *,...)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a21</anchor>
      <arglist>(const QDateTime &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a22</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a23</anchor>
      <arglist>(const QTime &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a24</anchor>
      <arglist>(const QPoint &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a25</anchor>
      <arglist>(const QSize &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a26</anchor>
      <arglist>(const QRect &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a27</anchor>
      <arglist>(const QRegion &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a28</anchor>
      <arglist>(const KURL &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a29</anchor>
      <arglist>(const QStringList &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a30</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a31</anchor>
      <arglist>(const QPen &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a32</anchor>
      <arglist>(const QBrush &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLibFactory</name>
    <filename>classKLibFactory.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>objectCreated</name>
      <anchor>l0</anchor>
      <arglist>(QObject *obj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLibFactory</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QObject *</type>
      <name>create</name>
      <anchor>a2</anchor>
      <arglist>(QObject *parent=0, const char *name=0, const char *classname=&quot;QObject&quot;, const QStringList &amp;args=QStringList())</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual QObject *</type>
      <name>createObject</name>
      <anchor>b0</anchor>
      <arglist>(QObject *parent=0, const char *name=0, const char *className=&quot;QObject&quot;, const QStringList &amp;args=QStringList())=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLibLoader</name>
    <filename>classKLibLoader.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>~KLibLoader</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KLibFactory *</type>
      <name>factory</name>
      <anchor>a1</anchor>
      <arglist>(const char *libname)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KLibrary *</type>
      <name>library</name>
      <anchor>a2</anchor>
      <arglist>(const char *libname)</arglist>
    </member>
    <member kind="function">
      <type>KLibrary *</type>
      <name>globalLibrary</name>
      <anchor>a3</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>lastErrorMessage</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unloadLibrary</name>
      <anchor>a5</anchor>
      <arglist>(const char *libname)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KLibLoader *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>cleanUp</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>findLibrary</name>
      <anchor>e2</anchor>
      <arglist>(const char *name, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KLibLoader</name>
      <anchor>b0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KLibrary</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLibrary</name>
    <filename>classKLibrary.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>KLibrary</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;libname, const QString &amp;filename, void *handle)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KLibFactory *</type>
      <name>factory</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>symbol</name>
      <anchor>a4</anchor>
      <arglist>(const char *name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSymbol</name>
      <anchor>a5</anchor>
      <arglist>(const char *name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unload</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KLibLoader</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>QAsciiDict&lt; KLibrary &gt;</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KLocale</name>
    <filename>classKLocale.html</filename>
    <member kind="enumeration">
      <name>SignPosition</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MeasureSystem</name>
      <anchor>w14</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLocale</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;catalog, KConfig *config=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KLocale</name>
      <anchor>a1</anchor>
      <arglist>(const KLocale &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>KLocale &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const KLocale &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KLocale</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>translate</name>
      <anchor>a4</anchor>
      <arglist>(const char *index) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>translate</name>
      <anchor>a5</anchor>
      <arglist>(const char *comment, const char *fallback) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>translate</name>
      <anchor>a6</anchor>
      <arglist>(const char *singular, const char *plural, unsigned long n) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setEncoding</name>
      <anchor>a7</anchor>
      <arglist>(int mibEnum)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setLanguage</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;language)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setLanguage</name>
      <anchor>a9</anchor>
      <arglist>(const QStringList &amp;languages)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setCountry</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;country)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>decimalSymbol</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>thousandsSeparator</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currencySymbol</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>monetaryDecimalSymbol</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>monetaryThousandsSeparator</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>positiveSign</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>negativeSign</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fracDigits</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>positivePrefixCurrencySymbol</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>negativePrefixCurrencySymbol</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SignPosition</type>
      <name>positiveMonetarySignPosition</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SignPosition</type>
      <name>negativeMonetarySignPosition</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatMoney</name>
      <anchor>a23</anchor>
      <arglist>(double num, const QString &amp;currency=QString::null, int digits=-1) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatNumber</name>
      <anchor>a24</anchor>
      <arglist>(double num, int precision=-1) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatLong</name>
      <anchor>a25</anchor>
      <arglist>(long num) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nounDeclension</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatDate</name>
      <anchor>a27</anchor>
      <arglist>(const QDate &amp;pDate, bool shortFormat=false) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>dateMonthNamePossessive</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatTime</name>
      <anchor>a29</anchor>
      <arglist>(const QTime &amp;pTime, bool includeSecs=false) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>use12Clock</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>weekStartsMonday</name>
      <anchor>a31</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>weekStartDay</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>monthName</name>
      <anchor>a33</anchor>
      <arglist>(int i, bool shortName=false) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>monthNamePossessive</name>
      <anchor>a34</anchor>
      <arglist>(int i, bool shortName=false) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>weekDayName</name>
      <anchor>a35</anchor>
      <arglist>(int i, bool shortName=false) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>const KCalendarSystem *</type>
      <name>calendar</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>calendarType</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCalendar</name>
      <anchor>a38</anchor>
      <arglist>(const QString &amp;calendarType)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatDateTime</name>
      <anchor>a39</anchor>
      <arglist>(const QDateTime &amp;pDateTime, bool shortFormat=true, bool includeSecs=false) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>readMoney</name>
      <anchor>a40</anchor>
      <arglist>(const QString &amp;numStr, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>readNumber</name>
      <anchor>a41</anchor>
      <arglist>(const QString &amp;numStr, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>readDate</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;str, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>readDate</name>
      <anchor>a43</anchor>
      <arglist>(const QString &amp;intstr, const QString &amp;fmt, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>readDate</name>
      <anchor>a44</anchor>
      <arglist>(const QString &amp;str, ReadDateFlags flags, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QTime</type>
      <name>readTime</name>
      <anchor>a45</anchor>
      <arglist>(const QString &amp;str, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QTime</type>
      <name>readTime</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;str, ReadTimeFlags flags, bool *ok=0) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>language</name>
      <anchor>a47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>country</name>
      <anchor>a48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>languagesTwoAlpha</name>
      <anchor>a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>languageList</name>
      <anchor>a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>encoding</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>encodingMib</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QTextCodec *</type>
      <name>codecForEncoding</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fileEncodingMib</name>
      <anchor>a54</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDateFormat</name>
      <anchor>a55</anchor>
      <arglist>(const QString &amp;format)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDateFormatShort</name>
      <anchor>a56</anchor>
      <arglist>(const QString &amp;format)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDateMonthNamePossessive</name>
      <anchor>a57</anchor>
      <arglist>(bool possessive)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeFormat</name>
      <anchor>a58</anchor>
      <arglist>(const QString &amp;format)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWeekStartsMonday</name>
      <anchor>a59</anchor>
      <arglist>(bool start) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWeekStartDay</name>
      <anchor>a60</anchor>
      <arglist>(int day)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>dateFormat</name>
      <anchor>a61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>dateFormatShort</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>timeFormat</name>
      <anchor>a63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDecimalSymbol</name>
      <anchor>a64</anchor>
      <arglist>(const QString &amp;symbol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setThousandsSeparator</name>
      <anchor>a65</anchor>
      <arglist>(const QString &amp;separator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositiveSign</name>
      <anchor>a66</anchor>
      <arglist>(const QString &amp;sign)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNegativeSign</name>
      <anchor>a67</anchor>
      <arglist>(const QString &amp;sign)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositiveMonetarySignPosition</name>
      <anchor>a68</anchor>
      <arglist>(SignPosition signpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNegativeMonetarySignPosition</name>
      <anchor>a69</anchor>
      <arglist>(SignPosition signpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPositivePrefixCurrencySymbol</name>
      <anchor>a70</anchor>
      <arglist>(bool prefix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNegativePrefixCurrencySymbol</name>
      <anchor>a71</anchor>
      <arglist>(bool prefix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFracDigits</name>
      <anchor>a72</anchor>
      <arglist>(int digits)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMonetaryThousandsSeparator</name>
      <anchor>a73</anchor>
      <arglist>(const QString &amp;separator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMonetaryDecimalSymbol</name>
      <anchor>a74</anchor>
      <arglist>(const QString &amp;symbol)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrencySymbol</name>
      <anchor>a75</anchor>
      <arglist>(const QString &amp;symbol)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>pageSize</name>
      <anchor>a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPageSize</name>
      <anchor>a77</anchor>
      <arglist>(int paperFormat)</arglist>
    </member>
    <member kind="function">
      <type>MeasureSystem</type>
      <name>measureSystem</name>
      <anchor>a78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMeasureSystem</name>
      <anchor>a79</anchor>
      <arglist>(MeasureSystem value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertCatalogue</name>
      <anchor>a80</anchor>
      <arglist>(const QString &amp;catalog)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeCatalogue</name>
      <anchor>a81</anchor>
      <arglist>(const QString &amp;catalog)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActiveCatalogue</name>
      <anchor>a82</anchor>
      <arglist>(const QString &amp;catalog)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>translateQt</name>
      <anchor>a83</anchor>
      <arglist>(const char *context, const char *sourceText, const char *message) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allLanguagesTwoAlpha</name>
      <anchor>a84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>twoAlphaToLanguageName</name>
      <anchor>a85</anchor>
      <arglist>(const QString &amp;code) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allCountriesTwoAlpha</name>
      <anchor>a86</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>twoAlphaToCountryName</name>
      <anchor>a87</anchor>
      <arglist>(const QString &amp;code) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatMoney</name>
      <anchor>a88</anchor>
      <arglist>(const QString &amp;numStr) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formatNumber</name>
      <anchor>a89</anchor>
      <arglist>(const QString &amp;numStr) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>languages</name>
      <anchor>a90</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setCharset</name>
      <anchor>a91</anchor>
      <arglist>(const QString &amp;charset) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>charset</name>
      <anchor>a92</anchor>
      <arglist>() const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>splitLocale</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;str, QString &amp;language, QString &amp;country, QString &amp;charset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setMainCatalogue</name>
      <anchor>e1</anchor>
      <arglist>(const char *catalog)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>langLookup</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;fname, const char *rtype=&quot;html&quot;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>defaultLanguage</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>defaultCountry</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>_initLanguage</name>
      <anchor>e5</anchor>
      <arglist>(KConfigBase *config)</arglist>
    </member>
    <member kind="function" protection="public" static="yes">
      <type>void</type>
      <name>initInstance</name>
      <anchor>f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KGlobal</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type></type>
      <name>I18N_NOOP</name>
      <anchor>m0</anchor>
      <arglist>(x)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>i18n</name>
      <anchor>m1</anchor>
      <arglist>(const char *text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>i18n</name>
      <anchor>m2</anchor>
      <arglist>(const char *comment, const char *text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>i18n</name>
      <anchor>m3</anchor>
      <arglist>(const char *singular, const char *plural, unsigned long n)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tr2i18n</name>
      <anchor>m4</anchor>
      <arglist>(const char *message, const char *=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMacroExpanderBase</name>
    <filename>classKMacroExpanderBase.html</filename>
    <member kind="function">
      <type></type>
      <name>KMacroExpanderBase</name>
      <anchor>a0</anchor>
      <arglist>(QChar c= &apos;%&apos;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KMacroExpanderBase</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>expandMacros</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a3</anchor>
      <arglist>(QString &amp;str, uint &amp;pos)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a4</anchor>
      <arglist>(QString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEscapeChar</name>
      <anchor>a5</anchor>
      <arglist>(QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>escapeChar</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>expandPlainMacro</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;str, uint pos, QStringList &amp;ret)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>expandEscapedMacro</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;str, uint pos, QStringList &amp;ret)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMD5</name>
    <filename>classKMD5.html</filename>
    <member kind="typedef">
      <type>unsigned char</type>
      <name>Digest</name>
      <anchor>w0</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMD5</name>
      <anchor>a1</anchor>
      <arglist>(const char *in, int len=-1)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMD5</name>
      <anchor>a2</anchor>
      <arglist>(const QByteArray &amp;a)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMD5</name>
      <anchor>a3</anchor>
      <arglist>(const QCString &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchor>a4</anchor>
      <arglist>(const char *in, int len=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchor>a5</anchor>
      <arglist>(const unsigned char *in, int len=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchor>a6</anchor>
      <arglist>(const QByteArray &amp;in)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchor>a7</anchor>
      <arglist>(const QCString &amp;in)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>update</name>
      <anchor>a8</anchor>
      <arglist>(QIODevice &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Digest &amp;</type>
      <name>rawDigest</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rawDigest</name>
      <anchor>a11</anchor>
      <arglist>(KMD5::Digest &amp;bin)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>hexDigest</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hexDigest</name>
      <anchor>a13</anchor>
      <arglist>(QCString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>base64Digest</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>verify</name>
      <anchor>a15</anchor>
      <arglist>(const KMD5::Digest &amp;digest)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>verify</name>
      <anchor>a16</anchor>
      <arglist>(const QCString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>transform</name>
      <anchor>b0</anchor>
      <arglist>(const unsigned char buffer[64])</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>finalize</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMimeSourceFactory</name>
    <filename>classKMimeSourceFactory.html</filename>
    <base>QMimeSourceFactory</base>
    <member kind="function">
      <type></type>
      <name>KMimeSourceFactory</name>
      <anchor>a0</anchor>
      <arglist>(KIconLoader *loader=KGlobal::iconLoader())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KMimeSourceFactory</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>makeAbsolute</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;abs_or_rel_name, const QString &amp;context) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMountPoint</name>
    <filename>classKMountPoint.html</filename>
    <base>KShared</base>
    <member kind="typedef">
      <type>KSharedPtr&lt; KMountPoint &gt;</type>
      <name>Ptr</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueList&lt; Ptr &gt;</type>
      <name>List</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mountedFrom</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>realDeviceName</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mountPoint</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mountType</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>mountOptions</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KMountPoint</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KMountPoint::List</type>
      <name>possibleMountPoints</name>
      <anchor>e0</anchor>
      <arglist>(int infoNeeded=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KMountPoint::List</type>
      <name>currentMountPoints</name>
      <anchor>e1</anchor>
      <arglist>(int infoNeeded=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMultipleDrag</name>
    <filename>classKMultipleDrag.html</filename>
    <base>QDragObject</base>
    <member kind="function">
      <type></type>
      <name>KMultipleDrag</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *dragSource=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addDragObject</name>
      <anchor>a1</anchor>
      <arglist>(QDragObject *dragObject)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QByteArray</type>
      <name>encodedData</name>
      <anchor>b0</anchor>
      <arglist>(const char *mime) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual const char *</type>
      <name>format</name>
      <anchor>b1</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; QDragObject &gt;</type>
      <name>m_dragObjects</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QValueList&lt; int &gt;</type>
      <name>m_numberFormats</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>NET</name>
    <filename>classNET.html</filename>
    <member kind="enumeration">
      <name>Role</name>
      <anchor>w106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>WindowType</name>
      <anchor>w107</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Utility</name>
      <anchor>w107w12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Splash</name>
      <anchor>w107w13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>WindowTypeMask</name>
      <anchor>w108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>State</name>
      <anchor>w109</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KeepAbove</name>
      <anchor>w109w31</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Hidden</name>
      <anchor>w109w34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FullScreen</name>
      <anchor>w109w35</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KeepBelow</name>
      <anchor>w109w36</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DemandsAttention</name>
      <anchor>w109w37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Direction</name>
      <anchor>w110</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KeyboardSize</name>
      <anchor>w110w47</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KeyboardMove</name>
      <anchor>w110w48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MappingState</name>
      <anchor>w111</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Action</name>
      <anchor>w112</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Property</name>
      <anchor>w113</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Property2</name>
      <anchor>w114</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RequestSource</name>
      <anchor>w116</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETIcon</name>
    <filename>structNETIcon.html</filename>
    <member kind="function">
      <type></type>
      <name>NETIcon</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>NETSize</type>
      <name>size</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char *</type>
      <name>data</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETPoint</name>
    <filename>structNETPoint.html</filename>
    <member kind="function">
      <type></type>
      <name>NETPoint</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>x</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>y</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>NETRArray</name>
    <filename>classNETRArray.html</filename>
    <templarg>Z</templarg>
    <member kind="function">
      <type></type>
      <name>NETRArray</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~NETRArray</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Z &amp;</type>
      <name>operator[]</name>
      <anchor>a2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETRect</name>
    <filename>structNETRect.html</filename>
    <member kind="variable">
      <type>NETPoint</type>
      <name>pos</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETSize</type>
      <name>size</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETRootInfoPrivate</name>
    <filename>structNETRootInfoPrivate.html</filename>
    <member kind="variable">
      <type>Display *</type>
      <name>display</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETSize</type>
      <name>rootSize</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>root</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>supportwindow</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>name</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>screen</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRArray&lt; NETPoint &gt;</type>
      <name>viewport</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRArray&lt; NETRect &gt;</type>
      <name>workarea</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETSize</type>
      <name>geometry</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>active</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window *</type>
      <name>clients</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window *</type>
      <name>stacking</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window *</type>
      <name>virtual_roots</name>
      <anchor>o12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window *</type>
      <name>kde_system_tray_windows</name>
      <anchor>o13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRArray&lt; const char * &gt;</type>
      <name>desktop_names</name>
      <anchor>o14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>number_of_desktops</name>
      <anchor>o15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>current_desktop</name>
      <anchor>o16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>clients_count</name>
      <anchor>o17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>stacking_count</name>
      <anchor>o18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>virtual_roots_count</name>
      <anchor>o19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>kde_system_tray_windows_count</name>
      <anchor>o20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>properties</name>
      <anchor>o21</anchor>
      <arglist>[5]</arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>client_properties</name>
      <anchor>o22</anchor>
      <arglist>[5]</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ref</name>
      <anchor>o23</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETSize</name>
    <filename>structNETSize.html</filename>
    <member kind="function">
      <type></type>
      <name>NETSize</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>width</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>height</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETStrut</name>
    <filename>structNETStrut.html</filename>
    <member kind="function">
      <type></type>
      <name>NETStrut</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>left</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>right</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>top</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>bottom</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>NETWinInfoPrivate</name>
    <filename>structNETWinInfoPrivate.html</filename>
    <member kind="variable">
      <type>Display *</type>
      <name>display</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>window</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>root</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NET::MappingState</type>
      <name>mapping_state</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Bool</type>
      <name>mapping_state_dirty</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRArray&lt; NETIcon &gt;</type>
      <name>icons</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>icon_count</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRect</type>
      <name>icon_geom</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRect</type>
      <name>win_geom</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>state</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETStrut</type>
      <name>strut</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETStrut</type>
      <name>frame_strut</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETRArray&lt; NET::WindowType &gt;</type>
      <name>types</name>
      <anchor>o12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>name</name>
      <anchor>o13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>visible_name</name>
      <anchor>o14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>icon_name</name>
      <anchor>o15</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>visible_icon_name</name>
      <anchor>o16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>desktop</name>
      <anchor>o17</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>pid</name>
      <anchor>o18</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>handled_icons</name>
      <anchor>o19</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>kde_system_tray_win_for</name>
      <anchor>o20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Time</type>
      <name>user_time</name>
      <anchor>o21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char *</type>
      <name>startup_id</name>
      <anchor>o22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>transient_for</name>
      <anchor>o23</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Window</type>
      <name>window_group</name>
      <anchor>o24</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>allowed_actions</name>
      <anchor>o25</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned long</type>
      <name>properties</name>
      <anchor>o26</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>has_net_support</name>
      <anchor>o27</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>ref</name>
      <anchor>o28</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPalette</name>
    <filename>classKPalette.html</filename>
    <member kind="enumeration">
      <name>Editable</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Yes</name>
      <anchor>w3w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>No</name>
      <anchor>w3w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Ask</name>
      <anchor>w3w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPalette</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KPalette</name>
      <anchor>a1</anchor>
      <arglist>(const KPalette &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KPalette</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KPalette &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const KPalette &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>description</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDescription</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;desc)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Editable</type>
      <name>editable</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEditable</name>
      <anchor>a10</anchor>
      <arglist>(Editable editable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nrColors</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a12</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findColor</name>
      <anchor>a13</anchor>
      <arglist>(const QColor &amp;color) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>colorName</name>
      <anchor>a14</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>colorName</name>
      <anchor>a15</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addColor</name>
      <anchor>a16</anchor>
      <arglist>(const QColor &amp;newColor, const QString &amp;newColorName=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>changeColor</name>
      <anchor>a17</anchor>
      <arglist>(int index, const QColor &amp;newColor, const QString &amp;newColorName=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>changeColor</name>
      <anchor>a18</anchor>
      <arglist>(const QColor &amp;oldColor, const QColor &amp;newColor, const QString &amp;newColorName=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>getPaletteList</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPixmapProvider</name>
    <filename>classKPixmapProvider.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QPixmap</type>
      <name>pixmapFor</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;text, int size=0)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPopupAccelManager</name>
    <filename>classKPopupAccelManager.html</filename>
    <base>QObject</base>
    <member kind="function" static="yes">
      <type>void</type>
      <name>manage</name>
      <anchor>e0</anchor>
      <arglist>(QPopupMenu *popup)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KPopupAccelManager</name>
      <anchor>b0</anchor>
      <arglist>(QPopupMenu *popup)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProcess</name>
    <filename>classKProcess.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>Communication</name>
      <anchor>w18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RunMode</name>
      <anchor>w19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DontCare</name>
      <anchor>w19w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NotifyOnExit</name>
      <anchor>w19w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Block</name>
      <anchor>w19w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OwnGroup</name>
      <anchor>w19w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>processExited</name>
      <anchor>l0</anchor>
      <arglist>(KProcess *proc)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStdout</name>
      <anchor>l1</anchor>
      <arglist>(KProcess *proc, char *buffer, int buflen)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStdout</name>
      <anchor>l2</anchor>
      <arglist>(int fd, int &amp;len)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStderr</name>
      <anchor>l3</anchor>
      <arglist>(KProcess *proc, char *buffer, int buflen)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>wroteStdin</name>
      <anchor>l4</anchor>
      <arglist>(KProcess *proc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KProcess</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KProcess</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KProcess</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setExecutable</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;proc) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>KProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>KProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a5</anchor>
      <arglist>(const char *arg)</arglist>
    </member>
    <member kind="function">
      <type>KProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a6</anchor>
      <arglist>(const QCString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>KProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a7</anchor>
      <arglist>(const QStringList &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearArguments</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>start</name>
      <anchor>a9</anchor>
      <arglist>(RunMode runmode=NotifyOnExit, Communication comm=NoCommunication)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>kill</name>
      <anchor>a10</anchor>
      <arglist>(int signo=SIGTERM)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRunning</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>pid_t</type>
      <name>pid</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED pid_t</type>
      <name>getPid</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>suspend</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resume</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>wait</name>
      <anchor>a16</anchor>
      <arglist>(int timeout=-1)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>normalExit</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>signalled</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>coreDumped</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exitStatus</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exitSignal</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeStdin</name>
      <anchor>a22</anchor>
      <arglist>(const char *buffer, int buflen)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStdin</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStdout</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStderr</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closePty</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeAll</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; QCString &gt; &amp;</type>
      <name>args</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRunPrivileged</name>
      <anchor>a29</anchor>
      <arglist>(bool keepPrivileges)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPrivileged</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnvironment</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;name, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWorkingDirectory</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseShell</name>
      <anchor>a33</anchor>
      <arglist>(bool useShell, const char *shell=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>detach</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUsePty</name>
      <anchor>a35</anchor>
      <arglist>(Communication comm, bool addUtmp)</arglist>
    </member>
    <member kind="function">
      <type>KPty *</type>
      <name>pty</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPriority</name>
      <anchor>a37</anchor>
      <arglist>(int prio)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>quote</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotChildOutput</name>
      <anchor>j0</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotChildError</name>
      <anchor>j1</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSendData</name>
      <anchor>j2</anchor>
      <arglist>(int dummy)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setupEnvironment</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>setupCommunication</name>
      <anchor>b1</anchor>
      <arglist>(Communication comm)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>commSetupDoneP</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>commSetupDoneC</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>processHasExited</name>
      <anchor>b4</anchor>
      <arglist>(int state)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>commClose</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setBinaryExecutable</name>
      <anchor>b6</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>childOutput</name>
      <anchor>b7</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>childError</name>
      <anchor>b8</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b9</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QValueList&lt; QCString &gt;</type>
      <name>arguments</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RunMode</type>
      <name>run_mode</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>runs</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>pid_t</type>
      <name>pid_</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>status</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>keepPrivs</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>out</name>
      <anchor>p6</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>in</name>
      <anchor>p7</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>err</name>
      <anchor>p8</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>innot</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>outnot</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>errnot</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Communication</type>
      <name>communication</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>const char *</type>
      <name>input_data</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>input_sent</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>input_total</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>KProcessController</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProcessController</name>
    <filename>classKProcessController.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type>bool</type>
      <name>waitForProcessExit</name>
      <anchor>a0</anchor>
      <arglist>(int timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unscheduleCheck</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rescheduleCheck</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>notifierFd</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addKProcess</name>
      <anchor>a4</anchor>
      <arglist>(KProcess *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeKProcess</name>
      <anchor>a5</anchor>
      <arglist>(KProcess *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addProcess</name>
      <anchor>a6</anchor>
      <arglist>(int pid)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>ref</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>deref</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>theSigCHLDHandler</name>
      <anchor>e2</anchor>
      <arglist>(int signal)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KProcessController *</type>
      <name>theKProcessController</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>I_just_love_gcc</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProcIO</name>
    <filename>classKProcIO.html</filename>
    <base>KProcess</base>
    <member kind="signal">
      <type>void</type>
      <name>readReady</name>
      <anchor>l0</anchor>
      <arglist>(KProcIO *pio)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KProcIO</name>
      <anchor>a0</anchor>
      <arglist>(QTextCodec *codec=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KProcIO</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setComm</name>
      <anchor>a2</anchor>
      <arglist>(Communication comm)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start</name>
      <anchor>a3</anchor>
      <arglist>(RunMode runmode=NotifyOnExit, bool includeStderr=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeStdin</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;line, bool appendnewline=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeStdin</name>
      <anchor>a5</anchor>
      <arglist>(const QCString &amp;line, bool appendnewline)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeStdin</name>
      <anchor>a6</anchor>
      <arglist>(const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED bool</type>
      <name>fputs</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;line, bool AppendNewLine=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>closeWhenDone</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readln</name>
      <anchor>a9</anchor>
      <arglist>(QString &amp;line, bool autoAck=true, bool *partial=0)</arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED int</type>
      <name>fgets</name>
      <anchor>a10</anchor>
      <arglist>(QString &amp;line, bool autoAck=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resetAll</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ackRead</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableReadSignals</name>
      <anchor>a13</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>received</name>
      <anchor>j0</anchor>
      <arglist>(KProcess *proc, char *buffer, int buflen)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sent</name>
      <anchor>j1</anchor>
      <arglist>(KProcess *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>controlledEmission</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b1</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPtrList&lt; QByteArray &gt;</type>
      <name>outbuffer</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>recvbuffer</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QTextCodec *</type>
      <name>codec</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>rbi</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>needreadsignal</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>readsignalon</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>writeready</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KProtocolInfoFactory</name>
    <filename>classKProtocolInfoFactory.html</filename>
    <member kind="function">
      <type>KProtocolInfo *</type>
      <name>findProtocol</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;protocol)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>protocols</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KProtocolInfoFactory *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KSycocaEntry *</type>
      <name>createEntry</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;, const char *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual KProtocolInfo *</type>
      <name>createEntry</name>
      <anchor>b1</anchor>
      <arglist>(int offset)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMap&lt; QString, KProtocolInfo::Ptr &gt;</type>
      <name>m_cache</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>KProtocolInfoFactory *</type>
      <name>_self</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KPty</name>
    <filename>classKPty.html</filename>
    <member kind="function">
      <type></type>
      <name>KPty</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KPty</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>open</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCTty</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>login</name>
      <anchor>a5</anchor>
      <arglist>(const char *user=0, const char *remotehost=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>logout</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWinSize</name>
      <anchor>a7</anchor>
      <arglist>(int lines, int columns)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXonXoff</name>
      <anchor>a8</anchor>
      <arglist>(bool useXonXoff)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>ttyName</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>masterFd</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>slaveFd</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRandomSequence</name>
    <filename>classKRandomSequence.html</filename>
    <member kind="function">
      <type></type>
      <name>KRandomSequence</name>
      <anchor>a0</anchor>
      <arglist>(long lngSeed=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KRandomSequence</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRandomSequence</name>
      <anchor>a2</anchor>
      <arglist>(const KRandomSequence &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>KRandomSequence &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const KRandomSequence &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSeed</name>
      <anchor>a4</anchor>
      <arglist>(long lngSeed=1)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDouble</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>getLong</name>
      <anchor>a6</anchor>
      <arglist>(unsigned long max)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>getBool</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>randomize</name>
      <anchor>a8</anchor>
      <arglist>(QGList *list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>modulate</name>
      <anchor>a9</anchor>
      <arglist>(int i)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRegExp</name>
    <filename>classKRegExp.html</filename>
    <member kind="function">
      <type></type>
      <name>KRegExp</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KRegExp</name>
      <anchor>a1</anchor>
      <arglist>(const char *_pattern, const char *_mode=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compile</name>
      <anchor>a3</anchor>
      <arglist>(const char *_pattern, const char *_mode=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchor>a4</anchor>
      <arglist>(const char *_string)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>group</name>
      <anchor>a5</anchor>
      <arglist>(int _grp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>groupStart</name>
      <anchor>a6</anchor>
      <arglist>(int _grp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>groupEnd</name>
      <anchor>a7</anchor>
      <arglist>(int _grp)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRegExpPrivate</name>
    <filename>classKRegExpPrivate.html</filename>
    <member kind="function">
      <type></type>
      <name>KRegExpPrivate</name>
      <anchor>a1</anchor>
      <arglist>(const char *_pattern, const char *_mode=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>compile</name>
      <anchor>a3</anchor>
      <arglist>(const char *_pattern, const char *_mode=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchor>a4</anchor>
      <arglist>(const char *_string)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>group</name>
      <anchor>a5</anchor>
      <arglist>(int _grp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>groupStart</name>
      <anchor>a6</anchor>
      <arglist>(int _grp)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>groupEnd</name>
      <anchor>a7</anchor>
      <arglist>(int _grp)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>regex_t</type>
      <name>m_pattern</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>regmatch_t</type>
      <name>m_matches</name>
      <anchor>p1</anchor>
      <arglist>[10]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>char *</type>
      <name>m_strMatches</name>
      <anchor>p2</anchor>
      <arglist>[10]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bInit</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRFCDate</name>
    <filename>classKRFCDate.html</filename>
    <member kind="function" static="yes">
      <type>time_t</type>
      <name>parseDate</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;date)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>time_t</type>
      <name>parseDateISO8601</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;date)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>localUTCOffset</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>rfc2822DateString</name>
      <anchor>e3</anchor>
      <arglist>(time_t utcTime, int utcOffset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>rfc2822DateString</name>
      <anchor>e4</anchor>
      <arglist>(time_t utcTime)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRootProp</name>
    <filename>classKRootProp.html</filename>
    <member kind="function">
      <type></type>
      <name>KRootProp</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;rProp=QString::null)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KRootProp</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProp</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;rProp=QString())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prop</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>destroy</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntry</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;rKey, const QString &amp;pDefault=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readNumEntry</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;rKey, int nDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>readFontEntry</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;rKey, const QFont *pDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>readColorEntry</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;rKey, const QColor *pDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>writeEntry</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;rKey, const QString &amp;rValue)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>writeEntry</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;rKey, int nValue)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>writeEntry</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;rKey, const QFont &amp;rFont)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>writeEntry</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;rKey, const QColor &amp;rColor)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>removeEntry</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;rKey)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>listEntries</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sync</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSaveFile</name>
    <filename>classKSaveFile.html</filename>
    <member kind="function">
      <type></type>
      <name>KSaveFile</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;filename, int mode=0666)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KSaveFile</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>status</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>handle</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FILE *</type>
      <name>fstream</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QFile *</type>
      <name>file</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QTextStream *</type>
      <name>textStream</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QDataStream *</type>
      <name>dataStream</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>abort</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>backupFile</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, const QString &amp;backupDir=QString::null, const QString &amp;backupExtension=QString::fromLatin1(&quot;~&quot;))</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KServerSocket</name>
    <filename>classKServerSocket.html</filename>
    <base>QObject</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotAccept</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>accepted</name>
      <anchor>l0</anchor>
      <arglist>(KSocket *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KServerSocket</name>
      <anchor>a0</anchor>
      <arglist>(unsigned short int _port, bool _bind=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KServerSocket</name>
      <anchor>a1</anchor>
      <arglist>(const char *_path, bool _bind=true)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KServerSocket</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bindAndListen</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socket</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short int</type>
      <name>port</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>(unsigned short int)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>init</name>
      <anchor>b1</anchor>
      <arglist>(const char *_path)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>sock</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSessionManaged</name>
    <filename>classKSessionManaged.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>saveState</name>
      <anchor>a2</anchor>
      <arglist>(QSessionManager &amp;sm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>commitData</name>
      <anchor>a3</anchor>
      <arglist>(QSessionManager &amp;sm)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KShared</name>
    <filename>classKShared.html</filename>
    <member kind="function">
      <type></type>
      <name>KShared</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShared</name>
      <anchor>a1</anchor>
      <arglist>(const KShared &amp;)</arglist>
    </member>
    <member kind="function">
      <type>KShared &amp;</type>
      <name>operator=</name>
      <anchor>a2</anchor>
      <arglist>(const KShared &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_KShared_ref</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>_KShared_unref</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>_KShared_count</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KSharedPtr</name>
    <filename>structKSharedPtr.html</filename>
    <templarg>T</templarg>
    <member kind="function">
      <type></type>
      <name>KSharedPtr</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSharedPtr</name>
      <anchor>a1</anchor>
      <arglist>(T *t)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSharedPtr</name>
      <anchor>a2</anchor>
      <arglist>(const KSharedPtr &amp;p)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KSharedPtr</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KSharedPtr&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const KSharedPtr&lt; T &gt; &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>KSharedPtr&lt; T &gt; &amp;</type>
      <name>operator=</name>
      <anchor>a5</anchor>
      <arglist>(T *p)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a6</anchor>
      <arglist>(const KSharedPtr&lt; T &gt; &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a7</anchor>
      <arglist>(const KSharedPtr&lt; T &gt; &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a8</anchor>
      <arglist>(const T *p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a9</anchor>
      <arglist>(const T *p) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator T *</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>data</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T *</type>
      <name>data</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>operator *</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>operator *</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T *</type>
      <name>operator-&gt;</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>T *</type>
      <name>operator-&gt;</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KShellProcess</name>
    <filename>classKShellProcess.html</filename>
    <base>KProcess</base>
    <member kind="function">
      <type></type>
      <name>KShellProcess</name>
      <anchor>a0</anchor>
      <arglist>(const char *shellname=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KShellProcess</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>start</name>
      <anchor>a2</anchor>
      <arglist>(RunMode runmode=NotifyOnExit, Communication comm=NoCommunication)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>quote</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KShortcut</name>
    <filename>classKShortcut.html</filename>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a1</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a2</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a3</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a4</anchor>
      <arglist>(const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a5</anchor>
      <arglist>(const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a6</anchor>
      <arglist>(const char *shortcut)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KShortcut</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a10</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a11</anchor>
      <arglist>(const QKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a12</anchor>
      <arglist>(const KKey &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a13</anchor>
      <arglist>(const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a14</anchor>
      <arglist>(const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;shortcut)</arglist>
    </member>
    <member kind="function">
      <type>KShortcut &amp;</type>
      <name>operator=</name>
      <anchor>a16</anchor>
      <arglist>(const KShortcut &amp;cut)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>count</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const KKeySequence &amp;</type>
      <name>seq</name>
      <anchor>a18</anchor>
      <arglist>(uint i) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCodeQt</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a21</anchor>
      <arglist>(const KShortcut &amp;shortcut) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a22</anchor>
      <arglist>(const KShortcut &amp;cut) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a23</anchor>
      <arglist>(const KShortcut &amp;cut) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a24</anchor>
      <arglist>(const KShortcut &amp;cut) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a25</anchor>
      <arglist>(const KKey &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a26</anchor>
      <arglist>(const KKeyNative &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a27</anchor>
      <arglist>(const KKeySequence &amp;keySeq) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setSeq</name>
      <anchor>a28</anchor>
      <arglist>(uint i, const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>append</name>
      <anchor>a29</anchor>
      <arglist>(const KKeySequence &amp;keySeq)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>append</name>
      <anchor>a30</anchor>
      <arglist>(const KKey &amp;spec)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>append</name>
      <anchor>a31</anchor>
      <arglist>(const KShortcut &amp;cut)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator QKeySequence</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toStringInternal</name>
      <anchor>a34</anchor>
      <arglist>(const KShortcut *pcutDefault=0) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator int</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KShortcut &amp;</type>
      <name>null</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>uint</type>
      <name>m_nSeqs</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KKeySequence</type>
      <name>m_rgseq</name>
      <anchor>p1</anchor>
      <arglist>[MAX_SEQUENCES]</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KKeyNative</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KShortcutList</name>
    <filename>classKShortcutList.html</filename>
    <member kind="function">
      <type></type>
      <name>KShortcutList</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>count</name>
      <anchor>a2</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>label</name>
      <anchor>a4</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>whatsThis</name>
      <anchor>a5</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a6</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcutDefault</name>
      <anchor>a7</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isConfigurable</name>
      <anchor>a8</anchor>
      <arglist>(uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setShortcut</name>
      <anchor>a9</anchor>
      <arglist>(uint index, const KShortcut &amp;shortcut)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isGlobal</name>
      <anchor>a10</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>index</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;sName) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>index</name>
      <anchor>a12</anchor>
      <arglist>(const KKeySequence &amp;keySeq) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KInstance *</type>
      <name>instance</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QVariant</type>
      <name>getOther</name>
      <anchor>a14</anchor>
      <arglist>(Other, uint index) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setOther</name>
      <anchor>a15</anchor>
      <arglist>(Other, uint index, QVariant)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>save</name>
      <anchor>a16</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>readSettings</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;sConfigGroup=QString::null, KConfigBase *pConfig=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>writeSettings</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;sConfigGroup=QString::null, KConfigBase *pConfig=0, bool bWriteAll=false, bool bGlobal=false) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSimpleConfig</name>
    <filename>classKSimpleConfig.html</filename>
    <base>KConfig</base>
    <member kind="function">
      <type></type>
      <name>KSimpleConfig</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;fileName, bool bReadOnly=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSimpleConfig</name>
      <anchor>a1</anchor>
      <arglist>(KConfigBackEnd *backEnd, bool bReadOnly=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSimpleConfig</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>sync</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSocket</name>
    <filename>classKSocket.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>slotWrite</name>
      <anchor>i0</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotRead</name>
      <anchor>i1</anchor>
      <arglist>(int x)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>readEvent</name>
      <anchor>l0</anchor>
      <arglist>(KSocket *s)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>writeEvent</name>
      <anchor>l1</anchor>
      <arglist>(KSocket *s)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeEvent</name>
      <anchor>l2</anchor>
      <arglist>(KSocket *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSocket</name>
      <anchor>a0</anchor>
      <arglist>(int _sock)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSocket</name>
      <anchor>a1</anchor>
      <arglist>(const char *_host, unsigned short int _port, int timeOut=30)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSocket</name>
      <anchor>a2</anchor>
      <arglist>(const char *_path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSocket</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socket</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableRead</name>
      <anchor>a5</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableWrite</name>
      <anchor>a6</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>connect</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;_host, unsigned short int _port, int timeout=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>connect</name>
      <anchor>b1</anchor>
      <arglist>(const char *_path)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>sock</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSocketAddress</name>
    <filename>classKSocketAddress.html</filename>
    <base>QObject</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KSocketAddress</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>pretty</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const sockaddr *</type>
      <name>address</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ksocklen_t</type>
      <name>size</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const sockaddr *</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>family</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>ianaFamily</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isEqual</name>
      <anchor>a7</anchor>
      <arglist>(const KSocketAddress &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEqual</name>
      <anchor>a8</anchor>
      <arglist>(const KSocketAddress *other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a9</anchor>
      <arglist>(const KSocketAddress &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCoreEqual</name>
      <anchor>a10</anchor>
      <arglist>(const KSocketAddress &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCoreEqual</name>
      <anchor>a11</anchor>
      <arglist>(const KSocketAddress *other) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>nodeName</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>serviceName</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KSocketAddress *</type>
      <name>newAddress</name>
      <anchor>e0</anchor>
      <arglist>(const struct sockaddr *sa, ksocklen_t size)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>ianaFamily</name>
      <anchor>e1</anchor>
      <arglist>(int af)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>fromIanaFamily</name>
      <anchor>e2</anchor>
      <arglist>(int iana)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KSocketAddress</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KSocketAddress</name>
      <anchor>b1</anchor>
      <arglist>(const sockaddr *sa, ksocklen_t size)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b2</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>sockaddr *</type>
      <name>data</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>ksocklen_t</type>
      <name>datasize</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>owndata</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KExtendedSocket</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSocks</name>
    <filename>classKSocks.html</filename>
    <member kind="function">
      <type>void</type>
      <name>disableSocks</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enableSocks</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>usingSocks</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSocks</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasWorkingAsyncConnect</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>connect</name>
      <anchor>a5</anchor>
      <arglist>(int sockfd, const sockaddr *serv_addr, ksocklen_t addrlen)</arglist>
    </member>
    <member kind="function">
      <type>signed long int</type>
      <name>read</name>
      <anchor>a6</anchor>
      <arglist>(int fd, void *buf, unsigned long int count)</arglist>
    </member>
    <member kind="function">
      <type>signed long int</type>
      <name>write</name>
      <anchor>a7</anchor>
      <arglist>(int fd, const void *buf, unsigned long int count)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>recvfrom</name>
      <anchor>a8</anchor>
      <arglist>(int s, void *buf, unsigned long int len, int flags, sockaddr *from, ksocklen_t *fromlen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>sendto</name>
      <anchor>a9</anchor>
      <arglist>(int s, const void *msg, unsigned long int len, int flags, const sockaddr *to, ksocklen_t tolen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>recv</name>
      <anchor>a10</anchor>
      <arglist>(int s, void *buf, unsigned long int len, int flags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>send</name>
      <anchor>a11</anchor>
      <arglist>(int s, const void *msg, unsigned long int len, int flags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getsockname</name>
      <anchor>a12</anchor>
      <arglist>(int s, sockaddr *name, ksocklen_t *namelen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getpeername</name>
      <anchor>a13</anchor>
      <arglist>(int s, sockaddr *name, ksocklen_t *namelen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>accept</name>
      <anchor>a14</anchor>
      <arglist>(int s, sockaddr *addr, ksocklen_t *addrlen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>select</name>
      <anchor>a15</anchor>
      <arglist>(int n, fd_set *readfds, fd_set *writefds, fd_set *exceptfds, struct timeval *timeout)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>listen</name>
      <anchor>a16</anchor>
      <arglist>(int s, int backlog)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>bind</name>
      <anchor>a17</anchor>
      <arglist>(int sockfd, sockaddr *my_addr, ksocklen_t addrlen)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>bind</name>
      <anchor>a18</anchor>
      <arglist>(int sockfd, const sockaddr *my_addr, ksocklen_t addrlen)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>die</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KSocks *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>activated</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>disable</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setConfig</name>
      <anchor>e3</anchor>
      <arglist>(KConfigBase *config)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KStaticDeleter&lt; KSocks &gt;</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSortableItem</name>
    <filename>classKSortableItem.html</filename>
    <templarg>T</templarg>
    <templarg>Key</templarg>
    <base>QPair&lt; Key, T &gt;</base>
    <member kind="function">
      <type></type>
      <name>KSortableItem</name>
      <anchor>a0</anchor>
      <arglist>(Key i, const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSortableItem</name>
      <anchor>a1</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSortableItem</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KSortableItem&lt; T, Key &gt; &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchor>a4</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a5</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchor>a6</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchor>a7</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a8</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a9</anchor>
      <arglist>(const KSortableItem&lt; T, Key &gt; &amp;i2) const </arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>value</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>value</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Key</type>
      <name>index</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSortableValueList</name>
    <filename>classKSortableValueList.html</filename>
    <templarg>T</templarg>
    <templarg>Key</templarg>
    <base>QValueList&lt; KSortableItem&lt; T, Key &gt; &gt;</base>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchor>a0</anchor>
      <arglist>(Key i, const T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>T &amp;</type>
      <name>operator[]</name>
      <anchor>a1</anchor>
      <arglist>(Key i)</arglist>
    </member>
    <member kind="function">
      <type>const T &amp;</type>
      <name>operator[]</name>
      <anchor>a2</anchor>
      <arglist>(Key i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStandardDirs</name>
    <filename>classKStandardDirs.html</filename>
    <member kind="function">
      <type></type>
      <name>KStandardDirs</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KStandardDirs</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPrefix</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addXdgConfigPrefix</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addXdgDataPrefix</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addResourceType</name>
      <anchor>a5</anchor>
      <arglist>(const char *type, const QString &amp;relativename)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addResourceDir</name>
      <anchor>a6</anchor>
      <arglist>(const char *type, const QString &amp;absdir)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>findResource</name>
      <anchor>a7</anchor>
      <arglist>(const char *type, const QString &amp;filename) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRestrictedResource</name>
      <anchor>a8</anchor>
      <arglist>(const char *type, const QString &amp;relPath=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>Q_UINT32</type>
      <name>calcResourceHash</name>
      <anchor>a9</anchor>
      <arglist>(const char *type, const QString &amp;filename, bool deep) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>findDirs</name>
      <anchor>a10</anchor>
      <arglist>(const char *type, const QString &amp;reldir) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>findResourceDir</name>
      <anchor>a11</anchor>
      <arglist>(const char *type, const QString &amp;filename) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>findAllResources</name>
      <anchor>a12</anchor>
      <arglist>(const char *type, const QString &amp;filter=QString::null, bool recursive=false, bool unique=false) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>findAllResources</name>
      <anchor>a13</anchor>
      <arglist>(const char *type, const QString &amp;filter, bool recursive, bool unique, QStringList &amp;relPaths) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addKDEDefaults</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addCustomized</name>
      <anchor>a15</anchor>
      <arglist>(KConfig *config)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>resourceDirs</name>
      <anchor>a16</anchor>
      <arglist>(const char *type) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allTypes</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>saveLocation</name>
      <anchor>a18</anchor>
      <arglist>(const char *type, const QString &amp;suffix=QString::null, bool create=true) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>relativeLocation</name>
      <anchor>a19</anchor>
      <arglist>(const char *type, const QString &amp;absPath)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kfsstnd_prefixes</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>localkdedir</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>localxdgdatadir</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>localxdgconfdir</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>systemPaths</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;pstr=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>findExe</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;pathstr=QString::null, bool ignoreExecBit=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>findAllExe</name>
      <anchor>e2</anchor>
      <arglist>(QStringList &amp;list, const QString &amp;appname, const QString &amp;pathstr=QString::null, bool ignoreExecBit=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>makeDir</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;dir, int mode=0755)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>kde_default</name>
      <anchor>e4</anchor>
      <arglist>(const char *type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>exists</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;fullPath)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>realPath</name>
      <anchor>e6</anchor>
      <arglist>(const QString &amp;dirname)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locate</name>
      <anchor>ga0</anchor>
      <arglist>(const char *type, const QString &amp;filename, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locateLocal</name>
      <anchor>ga1</anchor>
      <arglist>(const char *type, const QString &amp;filename, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locateLocal</name>
      <anchor>ga2</anchor>
      <arglist>(const char *type, const QString &amp;filename, bool createDir, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStartupInfo</name>
    <filename>classKStartupInfo.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>startup_t</name>
      <anchor>w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>gotNewStartup</name>
      <anchor>l0</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>gotStartupChange</name>
      <anchor>l1</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>gotRemoveStartup</name>
      <anchor>l2</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfo</name>
      <anchor>a0</anchor>
      <arglist>(int flags, QObject *parent=NULL, const char *name=NULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfo</name>
      <anchor>a1</anchor>
      <arglist>(bool clean_on_cantdetect, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>startup_t</type>
      <name>checkStartup</name>
      <anchor>a3</anchor>
      <arglist>(WId w)</arglist>
    </member>
    <member kind="function">
      <type>startup_t</type>
      <name>checkStartup</name>
      <anchor>a4</anchor>
      <arglist>(WId w, KStartupInfoId &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>startup_t</type>
      <name>checkStartup</name>
      <anchor>a5</anchor>
      <arglist>(WId w, KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>startup_t</type>
      <name>checkStartup</name>
      <anchor>a6</anchor>
      <arglist>(WId w, KStartupInfoId &amp;id, KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeout</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int secs)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>disableAutoAppStartedSending</name>
      <anchor>e0</anchor>
      <arglist>(bool disable=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>appStarted</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>appStarted</name>
      <anchor>e2</anchor>
      <arglist>(const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setNewStartupId</name>
      <anchor>e3</anchor>
      <arglist>(QWidget *window, const QCString &amp;startup_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>silenceStartup</name>
      <anchor>e4</anchor>
      <arglist>(bool silence)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendStartup</name>
      <anchor>e5</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendStartupX</name>
      <anchor>e6</anchor>
      <arglist>(Display *dpy, const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendChange</name>
      <anchor>e7</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendChangeX</name>
      <anchor>e8</anchor>
      <arglist>(Display *dpy, const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendFinish</name>
      <anchor>e9</anchor>
      <arglist>(const KStartupInfoId &amp;id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendFinishX</name>
      <anchor>e10</anchor>
      <arglist>(Display *dpy, const KStartupInfoId &amp;id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendFinish</name>
      <anchor>e11</anchor>
      <arglist>(const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>sendFinishX</name>
      <anchor>e12</anchor>
      <arglist>(Display *dpy, const KStartupInfoId &amp;id, const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KStartupInfoId</type>
      <name>currentStartupIdEnv</name>
      <anchor>e13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>resetStartupEnv</name>
      <anchor>e14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setWindowStartupId</name>
      <anchor>e15</anchor>
      <arglist>(WId window, const QCString &amp;id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>windowStartupId</name>
      <anchor>e16</anchor>
      <arglist>(WId w)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>handleAutoAppStartedSending</name>
      <anchor>e17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>customEvent</name>
      <anchor>b0</anchor>
      <arglist>(QCustomEvent *e_P)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KStartupInfoPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStartupInfoData</name>
    <filename>classKStartupInfoData.html</filename>
    <member kind="function">
      <type>void</type>
      <name>setBin</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;bin)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>bin</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>findName</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>name</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDescription</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;descr)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>findDescription</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>description</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIcon</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>findIcon</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>icon</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDesktop</name>
      <anchor>a11</anchor>
      <arglist>(int desktop)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>desktop</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWMClass</name>
      <anchor>a13</anchor>
      <arglist>(const QCString &amp;wmclass)</arglist>
    </member>
    <member kind="function">
      <type>const QCString</type>
      <name>findWMClass</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QCString &amp;</type>
      <name>WMClass</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPid</name>
      <anchor>a16</anchor>
      <arglist>(pid_t pid)</arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; pid_t &gt; &amp;</type>
      <name>pids</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_pid</name>
      <anchor>a18</anchor>
      <arglist>(pid_t pid) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHostname</name>
      <anchor>a19</anchor>
      <arglist>(const QCString &amp;hostname=QCString())</arglist>
    </member>
    <member kind="function">
      <type>const QCString &amp;</type>
      <name>hostname</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSilent</name>
      <anchor>a21</anchor>
      <arglist>(TriState state)</arglist>
    </member>
    <member kind="function">
      <type>TriState</type>
      <name>silent</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimestamp</name>
      <anchor>a23</anchor>
      <arglist>(unsigned long time)</arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>timestamp</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>screen</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScreen</name>
      <anchor>a26</anchor>
      <arglist>(int screen)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>update</name>
      <anchor>a27</anchor>
      <arglist>(const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfoData</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfoData</name>
      <anchor>a29</anchor>
      <arglist>(const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>KStartupInfoData &amp;</type>
      <name>operator=</name>
      <anchor>a31</anchor>
      <arglist>(const KStartupInfoData &amp;data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KStartupInfo</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend class</type>
      <name>KStartupInfo::Data</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStartupInfoId</name>
    <filename>classKStartupInfoId.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a0</anchor>
      <arglist>(const KStartupInfoId &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a1</anchor>
      <arglist>(const KStartupInfoId &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>none</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>initId</name>
      <anchor>a3</anchor>
      <arglist>(const QCString &amp;id=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>const QCString &amp;</type>
      <name>id</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setupStartupEnv</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfoId</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KStartupInfoId</name>
      <anchor>a7</anchor>
      <arglist>(const KStartupInfoId &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>KStartupInfoId &amp;</type>
      <name>operator=</name>
      <anchor>a9</anchor>
      <arglist>(const KStartupInfoId &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a10</anchor>
      <arglist>(const KStartupInfoId &amp;id) const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KStartupInfo</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStaticDeleter</name>
    <filename>classKStaticDeleter.html</filename>
    <templarg>type</templarg>
    <base>KStaticDeleterBase</base>
    <member kind="function">
      <type>KDE_DEPRECATED type *</type>
      <name>setObject</name>
      <anchor>a1</anchor>
      <arglist>(type *obj, bool isArray=false)</arglist>
    </member>
    <member kind="function">
      <type>type *</type>
      <name>setObject</name>
      <anchor>a2</anchor>
      <arglist>(type *&amp;globalRef, type *obj, bool isArray=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destructObject</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStaticDeleterBase</name>
    <filename>classKStaticDeleterBase.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>destructObject</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStringHandler</name>
    <filename>classKStringHandler.html</filename>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>word</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;text, uint pos)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>word</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;text, const char *range)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>insword</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;text, const QString &amp;word, uint pos)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>setword</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;text, const QString &amp;word, uint pos)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>remrange</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;text, const char *range)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>remword</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;text, uint pos)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>remword</name>
      <anchor>e6</anchor>
      <arglist>(const QString &amp;text, const QString &amp;word)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>capwords</name>
      <anchor>e7</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>capwords</name>
      <anchor>e8</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>reverse</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>reverse</name>
      <anchor>e10</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>ljust</name>
      <anchor>e11</anchor>
      <arglist>(const QString &amp;text, uint width)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>rjust</name>
      <anchor>e12</anchor>
      <arglist>(const QString &amp;text, uint width)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>center</name>
      <anchor>e13</anchor>
      <arglist>(const QString &amp;text, uint width)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>lsqueeze</name>
      <anchor>e14</anchor>
      <arglist>(const QString &amp;str, uint maxlen=40)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>lEmSqueeze</name>
      <anchor>e15</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxlen=30)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>lPixelSqueeze</name>
      <anchor>e16</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxPixels)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>csqueeze</name>
      <anchor>e17</anchor>
      <arglist>(const QString &amp;str, uint maxlen=40)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>cEmSqueeze</name>
      <anchor>e18</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxlen=30)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>cPixelSqueeze</name>
      <anchor>e19</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxPixels)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>rsqueeze</name>
      <anchor>e20</anchor>
      <arglist>(const QString &amp;str, uint maxlen=40)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>rEmSqueeze</name>
      <anchor>e21</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxlen=30)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>rPixelSqueeze</name>
      <anchor>e22</anchor>
      <arglist>(const QString &amp;name, const QFontMetrics &amp;fontMetrics, uint maxPixels)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>matchFileName</name>
      <anchor>e23</anchor>
      <arglist>(const QString &amp;filename, const QString &amp;pattern)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>perlSplit</name>
      <anchor>e24</anchor>
      <arglist>(const QString &amp;sep, const QString &amp;s, uint max=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>perlSplit</name>
      <anchor>e25</anchor>
      <arglist>(const QChar &amp;sep, const QString &amp;s, uint max=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>perlSplit</name>
      <anchor>e26</anchor>
      <arglist>(const QRegExp &amp;sep, const QString &amp;s, uint max=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>tagURLs</name>
      <anchor>e27</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>obscure</name>
      <anchor>e28</anchor>
      <arglist>(const QString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isUtf8</name>
      <anchor>e29</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>from8Bit</name>
      <anchor>e30</anchor>
      <arglist>(const char *str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KDE_DEPRECATED bool</type>
      <name>matchFilename</name>
      <anchor>e31</anchor>
      <arglist>(const QString &amp;filename, const QString &amp;pattern)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSycocaEntry</name>
    <filename>classKSycocaEntry.html</filename>
    <base>KShared</base>
    <member kind="typedef">
      <type>KSharedPtr&lt; KSycocaEntry &gt;</type>
      <name>Ptr</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueList&lt; Ptr &gt;</type>
      <name>List</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isType</name>
      <anchor>a0</anchor>
      <arglist>(KSycocaType t) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KSycocaType</type>
      <name>sycocaType</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSycocaEntry</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KSycocaEntry</name>
      <anchor>a3</anchor>
      <arglist>(QDataStream &amp;_str, int offset)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>entryPath</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isValid</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isDeleted</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>offset</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>save</name>
      <anchor>a9</anchor>
      <arglist>(QDataStream &amp;s)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>load</name>
      <anchor>a10</anchor>
      <arglist>(QDataStream &amp;)=0</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>read</name>
      <anchor>e0</anchor>
      <arglist>(QDataStream &amp;s, QString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>read</name>
      <anchor>e1</anchor>
      <arglist>(QDataStream &amp;s, QStringList &amp;list)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>m_bDeleted</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mPath</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KSycocaFactoryList</name>
    <filename>classKSycocaFactoryList.html</filename>
    <base>QPtrList&lt; KSycocaFactory &gt;</base>
  </compound>
  <compound kind="class">
    <name>KTempDir</name>
    <filename>classKTempDir.html</filename>
    <member kind="function">
      <type></type>
      <name>KTempDir</name>
      <anchor>a0</anchor>
      <arglist>(QString directoryPrefix=QString::null, int mode=0700)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KTempDir</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDelete</name>
      <anchor>a2</anchor>
      <arglist>(bool autoDelete)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>status</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QDir *</type>
      <name>qDir</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlink</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>existing</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>create</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;directoryPrefix, int mode)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setError</name>
      <anchor>b1</anchor>
      <arglist>(int error)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTempFile</name>
    <filename>classKTempFile.html</filename>
    <member kind="function">
      <type></type>
      <name>KTempFile</name>
      <anchor>a0</anchor>
      <arglist>(QString filePrefix=QString::null, QString fileExtension=QString::null, int mode=0600)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KTempFile</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoDelete</name>
      <anchor>a2</anchor>
      <arglist>(bool autoDelete)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>status</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>handle</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FILE *</type>
      <name>fstream</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QTextStream *</type>
      <name>textStream</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QDataStream *</type>
      <name>dataStream</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QFile *</type>
      <name>file</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unlink</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KTempFile</name>
      <anchor>b0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>create</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;filePrefix, const QString &amp;fileExtension, int mode)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setError</name>
      <anchor>b2</anchor>
      <arglist>(int error)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KSaveFile</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KTypeList</name>
    <filename>structKTypeList.html</filename>
    <templarg>T</templarg>
    <templarg>U</templarg>
    <member kind="typedef">
      <type>T</type>
      <name>Head</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>U</type>
      <name>Tail</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KTypeListLength&lt; KTypeList&lt; T, U &gt; &gt;</name>
    <filename>structKTypeListLength_3_01KTypeList_3_01T_00_01U_01_4_01_4.html</filename>
    <templarg>T</templarg>
    <templarg>U</templarg>
  </compound>
  <compound kind="class">
    <name>KUniqueApplication</name>
    <filename>classKUniqueApplication.html</filename>
    <base>KApplication</base>
    <base>DCOPObject</base>
    <member kind="function">
      <type></type>
      <name>KUniqueApplication</name>
      <anchor>a0</anchor>
      <arglist>(bool allowStyles=true, bool GUIenabled=true, bool configUnique=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KUniqueApplication</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>process</name>
      <anchor>a2</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>newInstance</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addCmdLineOptions</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>start</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KUnixSocketAddress</name>
    <filename>classKUnixSocketAddress.html</filename>
    <base>KSocketAddress</base>
    <member kind="function">
      <type></type>
      <name>KUnixSocketAddress</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUnixSocketAddress</name>
      <anchor>a1</anchor>
      <arglist>(const sockaddr_un *raw_data, ksocklen_t size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUnixSocketAddress</name>
      <anchor>a2</anchor>
      <arglist>(QCString pathname)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KUnixSocketAddress</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a4</anchor>
      <arglist>(const sockaddr_un *socket_address, ksocklen_t size)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setAddress</name>
      <anchor>a5</anchor>
      <arglist>(QCString path)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>pathname</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>pretty</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>serviceName</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const sockaddr_un *</type>
      <name>address</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const sockaddr_un *</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>areEqualUnix</name>
      <anchor>e0</anchor>
      <arglist>(const KSocketAddress &amp;s1, const KSocketAddress &amp;s2, bool coreOnly)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KExtendedSocket</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KURL</name>
    <filename>classKURL.html</filename>
    <member kind="enumeration">
      <name>URIMode</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Auto</name>
      <anchor>w9w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Invalid</name>
      <anchor>w9w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>RawURI</name>
      <anchor>w9w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>URL</name>
      <anchor>w9w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Mailto</name>
      <anchor>w9w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>QueryItemsOptions</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KURL</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a3</anchor>
      <arglist>(const char *url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a4</anchor>
      <arglist>(const QCString &amp;url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a5</anchor>
      <arglist>(const KURL &amp;u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a6</anchor>
      <arglist>(const QUrl &amp;u)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURL</name>
      <anchor>a7</anchor>
      <arglist>(const KURL &amp;_baseurl, const QString &amp;_rel_url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>protocol</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProtocol</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>uriMode</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>user</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUser</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasUser</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>pass</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPass</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasPass</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>host</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHost</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasHost</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short int</type>
      <name>port</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPort</name>
      <anchor>a21</anchor>
      <arglist>(unsigned short int _p)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>path</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>path</name>
      <anchor>a23</anchor>
      <arglist>(int _trailing) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPath</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasPath</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cleanPath</name>
      <anchor>a26</anchor>
      <arglist>(bool cleanDirSeparator=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>adjustPath</name>
      <anchor>a27</anchor>
      <arglist>(int _trailing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEncodedPathAndQuery</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;_txt, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEncodedPath</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;_txt, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>encodedPathAndQuery</name>
      <anchor>a30</anchor>
      <arglist>(int _trailing=0, bool _no_empty_path=false, int encoding_hint=0) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setQuery</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;_txt, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>query</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>ref</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRef</name>
      <anchor>a34</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasRef</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>htmlRef</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>encodedHtmlRef</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHTMLRef</name>
      <anchor>a38</anchor>
      <arglist>(const QString &amp;_ref)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasHTMLRef</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KDE_DEPRECATED bool</type>
      <name>isMalformed</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLocalFile</name>
      <anchor>a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileEncoding</name>
      <anchor>a43</anchor>
      <arglist>(const QString &amp;encoding)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileEncoding</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasSubURL</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPath</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;txt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>queryItem</name>
      <anchor>a47</anchor>
      <arglist>(const QString &amp;item) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>queryItem</name>
      <anchor>a48</anchor>
      <arglist>(const QString &amp;item, int encoding_hint) const </arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; QString, QString &gt;</type>
      <name>queryItems</name>
      <anchor>a49</anchor>
      <arglist>(int options=0) const </arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; QString, QString &gt;</type>
      <name>queryItems</name>
      <anchor>a50</anchor>
      <arglist>(int options, int encoding_hint) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addQueryItem</name>
      <anchor>a51</anchor>
      <arglist>(const QString &amp;_item, const QString &amp;_value, int encoding_hint=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeQueryItem</name>
      <anchor>a52</anchor>
      <arglist>(const QString &amp;_item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileName</name>
      <anchor>a53</anchor>
      <arglist>(const QString &amp;_txt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a54</anchor>
      <arglist>(bool _ignore_trailing_slash_in_path=true) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>directory</name>
      <anchor>a55</anchor>
      <arglist>(bool _strip_trailing_slash_from_result=true, bool _ignore_trailing_slash_in_path=true) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDirectory</name>
      <anchor>a56</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cd</name>
      <anchor>a57</anchor>
      <arglist>(const QString &amp;_dir)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>url</name>
      <anchor>a58</anchor>
      <arglist>(int _trailing=0, int encoding_hint=0) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prettyURL</name>
      <anchor>a59</anchor>
      <arglist>(int _trailing=0) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>prettyURL</name>
      <anchor>a60</anchor>
      <arglist>(int _trailing, AdjustementFlags _flags) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>htmlURL</name>
      <anchor>a61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KURL</type>
      <name>upURL</name>
      <anchor>a63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a64</anchor>
      <arglist>(const KURL &amp;_u) const </arglist>
    </member>
    <member kind="function">
      <type>KURL &amp;</type>
      <name>operator=</name>
      <anchor>a65</anchor>
      <arglist>(const KURL &amp;_u)</arglist>
    </member>
    <member kind="function">
      <type>KURL &amp;</type>
      <name>operator=</name>
      <anchor>a66</anchor>
      <arglist>(const QString &amp;_url)</arglist>
    </member>
    <member kind="function">
      <type>KURL &amp;</type>
      <name>operator=</name>
      <anchor>a67</anchor>
      <arglist>(const char *_url)</arglist>
    </member>
    <member kind="function">
      <type>KURL &amp;</type>
      <name>operator=</name>
      <anchor>a68</anchor>
      <arglist>(const QUrl &amp;u)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a69</anchor>
      <arglist>(const KURL &amp;_u) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a70</anchor>
      <arglist>(const QString &amp;_u) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a71</anchor>
      <arglist>(const KURL &amp;_u) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a72</anchor>
      <arglist>(const QString &amp;_u) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cmp</name>
      <anchor>a73</anchor>
      <arglist>(const KURL &amp;u, bool ignore_trailing=false) const KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equals</name>
      <anchor>a74</anchor>
      <arglist>(const KURL &amp;u, bool ignore_trailing=false) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isParentOf</name>
      <anchor>a75</anchor>
      <arglist>(const KURL &amp;u) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>filename</name>
      <anchor>a76</anchor>
      <arglist>(bool _ignore_trailing_slash_in_path=true) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>List</type>
      <name>split</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;_url)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>List</type>
      <name>split</name>
      <anchor>e1</anchor>
      <arglist>(const KURL &amp;_url)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURL</type>
      <name>join</name>
      <anchor>e2</anchor>
      <arglist>(const List &amp;_list)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURL</type>
      <name>fromPathOrURL</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>encode_string</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;str, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>encode_string_no_slash</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;str, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>decode_string</name>
      <anchor>e6</anchor>
      <arglist>(const QString &amp;str, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isRelativeURL</name>
      <anchor>e7</anchor>
      <arglist>(const QString &amp;_url)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>relativeURL</name>
      <anchor>e8</anchor>
      <arglist>(const KURL &amp;base_url, const KURL &amp;url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>relativePath</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;base_dir, const QString &amp;path, bool *isParent=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>URIMode</type>
      <name>uriModeForProtocol</name>
      <anchor>e10</anchor>
      <arglist>(const QString &amp;protocol)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>reset</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseURL</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;_url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseRawURI</name>
      <anchor>b2</anchor>
      <arglist>(const QString &amp;_url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseMailto</name>
      <anchor>b3</anchor>
      <arglist>(const QString &amp;_url, int encoding_hint=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parse</name>
      <anchor>b4</anchor>
      <arglist>(const QString &amp;_url, int encoding_hint=0)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;s, const KURL &amp;a)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;s, KURL &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>urlcmp</name>
      <anchor>m0</anchor>
      <arglist>(const QString &amp;_url1, const QString &amp;_url2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>urlcmp</name>
      <anchor>m1</anchor>
      <arglist>(const QString &amp;_url1, const QString &amp;_url2, bool _ignore_trailing, bool _ignore_ref)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KURL::List</name>
    <filename>classKURL_1_1List.html</filename>
    <base>QValueList&lt; KURL &gt;</base>
    <member kind="function">
      <type></type>
      <name>List</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>List</name>
      <anchor>a1</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>List</name>
      <anchor>a2</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>toStringList</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KURLDrag</name>
    <filename>classKURLDrag.html</filename>
    <base>QUriDrag</base>
    <member kind="function">
      <type></type>
      <name>KURLDrag</name>
      <anchor>a0</anchor>
      <arglist>(const KURL::List &amp;urls, QWidget *dragSource=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KURLDrag</name>
      <anchor>a1</anchor>
      <arglist>(const KURL::List &amp;urls, const QMap&lt; QString, QString &gt; &amp;metaData, QWidget *dragSource=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; QString, QString &gt; &amp;</type>
      <name>metaData</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURLDrag *</type>
      <name>newDrag</name>
      <anchor>e0</anchor>
      <arglist>(const KURL::List &amp;urls, QWidget *dragSource=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURLDrag *</type>
      <name>newDrag</name>
      <anchor>e1</anchor>
      <arglist>(const KURL::List &amp;urls, const QMap&lt; QString, QString &gt; &amp;metaData, QWidget *dragSource=0, const char *name=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>decode</name>
      <anchor>e2</anchor>
      <arglist>(const QMimeSource *e, KURL::List &amp;urls)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>decode</name>
      <anchor>e3</anchor>
      <arglist>(const QMimeSource *e, KURL::List &amp;urls, QMap&lt; QString, QString &gt; &amp;metaData)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>urlToString</name>
      <anchor>e4</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KURL</type>
      <name>stringToUrl</name>
      <anchor>e5</anchor>
      <arglist>(const QCString &amp;s)</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>KURLDrag</name>
      <anchor>b0</anchor>
      <arglist>(const QStrList &amp;urls, const QMap&lt; QString, QString &gt; &amp;metaData, QWidget *dragSource, const char *name) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual const char *</type>
      <name>format</name>
      <anchor>b1</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QByteArray</type>
      <name>encodedData</name>
      <anchor>b2</anchor>
      <arglist>(const char *mime) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KUser</name>
    <filename>classKUser.html</filename>
    <member kind="enumeration">
      <name>UIDMode</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UseEffectiveUID</name>
      <anchor>w2w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UseRealUserID</name>
      <anchor>w2w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUser</name>
      <anchor>a0</anchor>
      <arglist>(UIDMode mode=UseEffectiveUID)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUser</name>
      <anchor>a1</anchor>
      <arglist>(long uid)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUser</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUser</name>
      <anchor>a3</anchor>
      <arglist>(const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KUser</name>
      <anchor>a4</anchor>
      <arglist>(struct passwd *p)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a5</anchor>
      <arglist>(const KUser &amp;user) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a6</anchor>
      <arglist>(const KUser &amp;user) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>uid</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>gid</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSuperUser</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>loginName</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fullName</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>roomNumber</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>workPhone</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homePhone</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeDir</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>shell</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KUser</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KVMAllocator</name>
    <filename>classKVMAllocator.html</filename>
    <member kind="function">
      <type></type>
      <name>KVMAllocator</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KVMAllocator</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Block *</type>
      <name>allocate</name>
      <anchor>a2</anchor>
      <arglist>(size_t _size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>free</name>
      <anchor>a3</anchor>
      <arglist>(Block *block)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copyBlock</name>
      <anchor>a4</anchor>
      <arglist>(void *dest, Block *src, int _offset=0, size_t length=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchor>a5</anchor>
      <arglist>(void *dest, Block *src, int _offset=0, size_t length=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copyBlock</name>
      <anchor>a6</anchor>
      <arglist>(Block *dest, void *src, int _offset=0, size_t length=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchor>a7</anchor>
      <arglist>(Block *dest, void *src, int _offset=0, size_t length=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>map</name>
      <anchor>a8</anchor>
      <arglist>(Block *block)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmap</name>
      <anchor>a9</anchor>
      <arglist>(Block *block)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWin</name>
    <filename>classKWin.html</filename>
    <member kind="enumeration">
      <name>IconSource</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NETWM</name>
      <anchor>w4w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WMHints</name>
      <anchor>w4w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ClassHint</name>
      <anchor>w4w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>XApp</name>
      <anchor>w4w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>activateWindow</name>
      <anchor>e0</anchor>
      <arglist>(WId win, long time=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>forceActiveWindow</name>
      <anchor>e1</anchor>
      <arglist>(WId win, long time=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setActiveWindow</name>
      <anchor>e2</anchor>
      <arglist>(WId win) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>demandAttention</name>
      <anchor>e3</anchor>
      <arglist>(WId win, bool set=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setUserTime</name>
      <anchor>e4</anchor>
      <arglist>(WId win, long time)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>invokeContextHelp</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setSystemTrayWindowFor</name>
      <anchor>e6</anchor>
      <arglist>(WId trayWin, WId forWin)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>WindowInfo</type>
      <name>windowInfo</name>
      <anchor>e7</anchor>
      <arglist>(WId win, unsigned long properties=0, unsigned long properties2=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>WId</type>
      <name>transientFor</name>
      <anchor>e8</anchor>
      <arglist>(WId window)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>WId</type>
      <name>groupLeader</name>
      <anchor>e9</anchor>
      <arglist>(WId window)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPixmap</type>
      <name>icon</name>
      <anchor>e10</anchor>
      <arglist>(WId win, int width=-1, int height=-1, bool scale=false)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPixmap</type>
      <name>icon</name>
      <anchor>e11</anchor>
      <arglist>(WId win, int width, int height, bool scale, int flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setIcons</name>
      <anchor>e12</anchor>
      <arglist>(WId win, const QPixmap &amp;icon, const QPixmap &amp;miniIcon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setType</name>
      <anchor>e13</anchor>
      <arglist>(WId win, NET::WindowType windowType)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setState</name>
      <anchor>e14</anchor>
      <arglist>(WId win, unsigned long state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>clearState</name>
      <anchor>e15</anchor>
      <arglist>(WId win, unsigned long state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setOnAllDesktops</name>
      <anchor>e16</anchor>
      <arglist>(WId win, bool b)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setOnDesktop</name>
      <anchor>e17</anchor>
      <arglist>(WId win, int desktop)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setStrut</name>
      <anchor>e18</anchor>
      <arglist>(WId win, int left, int right, int top, int bottom)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>currentDesktop</name>
      <anchor>e19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>numberOfDesktops</name>
      <anchor>e20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setCurrentDesktop</name>
      <anchor>e21</anchor>
      <arglist>(int desktop)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>iconifyWindow</name>
      <anchor>e22</anchor>
      <arglist>(WId win, bool animation=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>deIconifyWindow</name>
      <anchor>e23</anchor>
      <arglist>(WId win, bool animation=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>raiseWindow</name>
      <anchor>e24</anchor>
      <arglist>(WId win)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>lowerWindow</name>
      <anchor>e25</anchor>
      <arglist>(WId win)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>icccmCompliantMappingState</name>
      <anchor>e26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>allowedActionsSupported</name>
      <anchor>e27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>readNameProperty</name>
      <anchor>e28</anchor>
      <arglist>(WId window, unsigned long atom)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Info</type>
      <name>info</name>
      <anchor>e29</anchor>
      <arglist>(WId win) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>appStarted</name>
      <anchor>e30</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KWin::Info</name>
    <filename>structKWin_1_1Info.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>isMinimized</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isIconified</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>visibleNameWithState</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>WId</type>
      <name>win</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>long unsigned int</type>
      <name>state</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NET::MappingState</type>
      <name>mappingState</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NETStrut</type>
      <name>strut</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>NET::WindowType</type>
      <name>windowType</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>visibleName</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>name</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>desktop</name>
      <anchor>o7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>onAllDesktops</name>
      <anchor>o8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>pid_t</type>
      <name>pid</name>
      <anchor>o9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QRect</type>
      <name>geometry</name>
      <anchor>o10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QRect</type>
      <name>frameGeometry</name>
      <anchor>o11</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWin::WindowInfo</name>
    <filename>classKWin_1_1WindowInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>WindowInfo</name>
      <anchor>a0</anchor>
      <arglist>(WId window, unsigned long properties, unsigned long properties2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>valid</name>
      <anchor>a3</anchor>
      <arglist>(bool withdrawn_is_valid=false) const </arglist>
    </member>
    <member kind="function">
      <type>WId</type>
      <name>win</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>state</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isMinimized</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NET::MappingState</type>
      <name>mappingState</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NETStrut</type>
      <name>strut</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>NET::WindowType</type>
      <name>windowType</name>
      <anchor>a9</anchor>
      <arglist>(int supported_types) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>visibleName</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>visibleNameWithState</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>visibleIconName</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>visibleIconNameWithState</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>iconName</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnCurrentDesktop</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isOnDesktop</name>
      <anchor>a17</anchor>
      <arglist>(int desktop) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>onAllDesktops</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>desktop</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>geometry</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>frameGeometry</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WId</type>
      <name>transientFor</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WId</type>
      <name>groupLeader</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>actionSupported</name>
      <anchor>a24</anchor>
      <arglist>(NET::Action action) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>WindowInfo</name>
      <anchor>a25</anchor>
      <arglist>(const WindowInfo &amp;)</arglist>
    </member>
    <member kind="function">
      <type>WindowInfo &amp;</type>
      <name>operator=</name>
      <anchor>a26</anchor>
      <arglist>(const WindowInfo &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KWinModule</name>
    <filename>classKWinModule.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>currentDesktopChanged</name>
      <anchor>l0</anchor>
      <arglist>(int desktop)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>windowAdded</name>
      <anchor>l1</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>windowRemoved</name>
      <anchor>l2</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>activeWindowChanged</name>
      <anchor>l3</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>desktopNamesChanged</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>numberOfDesktopsChanged</name>
      <anchor>l5</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>systemTrayWindowAdded</name>
      <anchor>l6</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>systemTrayWindowRemoved</name>
      <anchor>l7</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>workAreaChanged</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>strutChanged</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>stackingOrderChanged</name>
      <anchor>l10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>windowChanged</name>
      <anchor>l11</anchor>
      <arglist>(WId id, const unsigned long *properties)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>windowChanged</name>
      <anchor>l12</anchor>
      <arglist>(WId id, unsigned int properties) KDE_DEPRECATED</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>windowChanged</name>
      <anchor>l13</anchor>
      <arglist>(WId id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KWinModule</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, int what)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KWinModule</name>
      <anchor>a1</anchor>
      <arglist>(QObject *parent=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KWinModule</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; WId &gt; &amp;</type>
      <name>windows</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; WId &gt; &amp;</type>
      <name>stackingOrder</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasWId</name>
      <anchor>a5</anchor>
      <arglist>(WId id) const </arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; WId &gt; &amp;</type>
      <name>systemTrayWindows</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentDesktop</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numberOfDesktops</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>WId</type>
      <name>activeWindow</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>workArea</name>
      <anchor>a10</anchor>
      <arglist>(int desktop=-1) const </arglist>
    </member>
    <member kind="function">
      <type>QRect</type>
      <name>workArea</name>
      <anchor>a11</anchor>
      <arglist>(const QValueList&lt; WId &gt; &amp;excludes, int desktop=-1) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>desktopName</name>
      <anchor>a12</anchor>
      <arglist>(int desktop) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDesktopName</name>
      <anchor>a13</anchor>
      <arglist>(int desktop, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>doNotManage</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;title)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>connectNotify</name>
      <anchor>b0</anchor>
      <arglist>(const char *signal)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KWinModulePrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KXErrorHandler</name>
    <filename>classKXErrorHandler.html</filename>
    <member kind="function">
      <type></type>
      <name>KXErrorHandler</name>
      <anchor>a0</anchor>
      <arglist>(Display *dpy=qt_xdisplay())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KXErrorHandler</name>
      <anchor>a1</anchor>
      <arglist>(bool(*handler)(int request, int error_code, unsigned long resource_id), Display *dpy=qt_xdisplay())</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KXErrorHandler</name>
      <anchor>a2</anchor>
      <arglist>(int(*handler)(Display *, XErrorEvent *), Display *dpy=qt_xdisplay())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>error</name>
      <anchor>a3</anchor>
      <arglist>(bool sync) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KZoneAllocator</name>
    <filename>classKZoneAllocator.html</filename>
    <member kind="function">
      <type></type>
      <name>KZoneAllocator</name>
      <anchor>a0</anchor>
      <arglist>(unsigned long _blockSize=8 *1024)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KZoneAllocator</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>allocate</name>
      <anchor>a2</anchor>
      <arglist>(size_t _size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deallocate</name>
      <anchor>a3</anchor>
      <arglist>(void *ptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>free_since</name>
      <anchor>a4</anchor>
      <arglist>(void *ptr)</arglist>
    </member>
    <member kind="typedef" protection="public">
      <type>QValueList&lt; MemBlock * &gt;</type>
      <name>MemList</name>
      <anchor>x0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addBlock</name>
      <anchor>b0</anchor>
      <arglist>(MemBlock *b)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>delBlock</name>
      <anchor>b1</anchor>
      <arglist>(MemBlock *b)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>insertHash</name>
      <anchor>b2</anchor>
      <arglist>(MemBlock *b)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>initHash</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MemBlock *</type>
      <name>currentBlock</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned long</type>
      <name>blockSize</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned long</type>
      <name>blockOffset</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>log2</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>num_blocks</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>MemList **</type>
      <name>hashList</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>unsigned int</type>
      <name>hashSize</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>hashDirty</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>kconfig_compiler</name>
    <title>The KDE Configuration Compiler</title>
    <filename>kconfig_compiler</filename>
  </compound>
  <compound kind="group">
    <name>kdebug</name>
    <title>Debug message generators</title>
    <filename>group__kdebug.html</filename>
    <class kind="class">kdbgstream</class>
    <class kind="class">kndbgstream</class>
    <member kind="define">
      <type>#define</type>
      <name>k_funcinfo</name>
      <anchor>ga14</anchor>
      <arglist></arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>k_lineinfo</name>
      <anchor>ga15</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>kdbgstream &amp;(*</type>
      <name>KDBGFUNC</name>
      <anchor>ga0</anchor>
      <arglist>)(kdbgstream &amp;)</arglist>
    </member>
    <member kind="typedef">
      <type>kndbgstream &amp;(*</type>
      <name>KNDBGFUNC</name>
      <anchor>ga1</anchor>
      <arglist>)(kndbgstream &amp;)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>perror</name>
      <anchor>ga2</anchor>
      <arglist>(kdbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>endl</name>
      <anchor>ga3</anchor>
      <arglist>(kndbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>flush</name>
      <anchor>ga4</anchor>
      <arglist>(kndbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream &amp;</type>
      <name>perror</name>
      <anchor>ga5</anchor>
      <arglist>(kndbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdDebug</name>
      <anchor>ga6</anchor>
      <arglist>(bool cond, int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream</type>
      <name>kndDebug</name>
      <anchor>ga7</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kndbgstream</type>
      <name>kndDebug</name>
      <anchor>ga8</anchor>
      <arglist>(bool, int=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kndBacktrace</name>
      <anchor>ga9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kndBacktrace</name>
      <anchor>ga10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdWarning</name>
      <anchor>ga11</anchor>
      <arglist>(bool cond, int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdError</name>
      <anchor>ga12</anchor>
      <arglist>(bool cond, int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdFatal</name>
      <anchor>ga13</anchor>
      <arglist>(bool cond, int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>endl</name>
      <anchor>ga16</anchor>
      <arglist>(kdbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream &amp;</type>
      <name>flush</name>
      <anchor>ga17</anchor>
      <arglist>(kdbgstream &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdDebug</name>
      <anchor>ga18</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kdBacktrace</name>
      <anchor>ga19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>kdBacktrace</name>
      <anchor>ga20</anchor>
      <arglist>(int levels)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdWarning</name>
      <anchor>ga21</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdError</name>
      <anchor>ga22</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>kdbgstream</type>
      <name>kdFatal</name>
      <anchor>ga23</anchor>
      <arglist>(int area=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>kdClearDebugConfig</name>
      <anchor>ga24</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>locates</name>
    <title>Locate Functions</title>
    <filename>group__locates.html</filename>
    <member kind="function">
      <type>QString</type>
      <name>locate</name>
      <anchor>ga0</anchor>
      <arglist>(const char *type, const QString &amp;filename, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locateLocal</name>
      <anchor>ga1</anchor>
      <arglist>(const char *type, const QString &amp;filename, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locateLocal</name>
      <anchor>ga2</anchor>
      <arglist>(const char *type, const QString &amp;filename, bool createDir, const KInstance *instance=KGlobal::instance())</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KDE</name>
    <filename>namespaceKDE.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>version</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>versionMajor</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>versionMinor</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>versionRelease</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>versionString</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getaddrinfo</name>
      <anchor>a6</anchor>
      <arglist>(const char *name, const char *service, const struct addrinfo *hint, struct addrinfo **result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>freeaddrinfo</name>
      <anchor>a7</anchor>
      <arglist>(struct addrinfo *ai)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>gai_strerror</name>
      <anchor>a8</anchor>
      <arglist>(int errorcode)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getnameinfo</name>
      <anchor>a9</anchor>
      <arglist>(const struct sockaddr *sa, unsigned int salen, char *host, size_t hostlen, char *serv, size_t servlen, int flags)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>inet_pton</name>
      <anchor>a10</anchor>
      <arglist>(int af, const char *cp, void *buf)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>inet_ntop</name>
      <anchor>a11</anchor>
      <arglist>(int af, const void *cp, char *buf, size_t len)</arglist>
    </member>
    <member kind="variable">
      <type>const int</type>
      <name>resolverFlags</name>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KKeyServer</name>
    <filename>namespaceKKeyServer.html</filename>
    <class kind="struct">KKeyServer::Sym</class>
    <class kind="struct">KKeyServer::Key</class>
    <class kind="struct">KKeyServer::Variations</class>
    <member kind="enumeration">
      <name>ExtraModFlag</name>
      <anchor>a24</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initializeMods</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modX</name>
      <anchor>a2</anchor>
      <arglist>(KKey::ModFlag modFlag)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keyboardHasWinKey</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXShift</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXLock</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXCtrl</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXAlt</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXNumLock</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXWin</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>modXScrollLock</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>accelModMaskX</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keyQtToSym</name>
      <anchor>a12</anchor>
      <arglist>(int keyQt, uint &amp;sym)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keyQtToMod</name>
      <anchor>a13</anchor>
      <arglist>(int keyQt, uint &amp;mod)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>symToKeyQt</name>
      <anchor>a14</anchor>
      <arglist>(uint sym, int &amp;keyQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>modToModQt</name>
      <anchor>a15</anchor>
      <arglist>(uint mod, int &amp;modQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>modToModX</name>
      <anchor>a16</anchor>
      <arglist>(uint mod, uint &amp;modX)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>modXToModQt</name>
      <anchor>a17</anchor>
      <arglist>(uint modX, int &amp;modQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>modXToMod</name>
      <anchor>a18</anchor>
      <arglist>(uint modX, uint &amp;mod)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>codeXToSym</name>
      <anchor>a19</anchor>
      <arglist>(uchar codeX, uint modX, uint &amp;symX)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>modToStringInternal</name>
      <anchor>a20</anchor>
      <arglist>(uint mod)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>modToStringUser</name>
      <anchor>a21</anchor>
      <arglist>(uint mod)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stringToSymMod</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;, uint &amp;sym, uint &amp;mod)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>keyQtToKeyX</name>
      <anchor>a23</anchor>
      <arglist>(uint keyCombQt, unsigned char *pKeyCodeX, uint *pKeySymX, uint *pKeyModX)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KKeyServer::Sym</name>
    <filename>structKKeyServer_1_1Sym.html</filename>
    <member kind="function">
      <type></type>
      <name>Sym</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Sym</name>
      <anchor>a1</anchor>
      <arglist>(uint sym)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Sym</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>initQt</name>
      <anchor>a3</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>qt</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toStringInternal</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>getModsRequired</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>getSymVariation</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator uint</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Sym &amp;</type>
      <name>operator=</name>
      <anchor>a11</anchor>
      <arglist>(uint sym)</arglist>
    </member>
    <member kind="variable">
      <type>uint</type>
      <name>m_sym</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KKeyServer::Key</name>
    <filename>structKKeyServer_1_1Key.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>init</name>
      <anchor>a0</anchor>
      <arglist>(const KKey &amp;key, bool bQt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNative</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>code</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>mod</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>sym</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>keyCodeQt</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeycodeQt</name>
      <anchor>a6</anchor>
      <arglist>(int keyQt)</arglist>
    </member>
    <member kind="function">
      <type>Key &amp;</type>
      <name>operator=</name>
      <anchor>a7</anchor>
      <arglist>(const KKeyNative &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a8</anchor>
      <arglist>(const Key &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a9</anchor>
      <arglist>(const Key &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a10</anchor>
      <arglist>(const Key &amp;b) const </arglist>
    </member>
    <member kind="function">
      <type>KKey</type>
      <name>key</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>uint</type>
      <name>m_code</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint</type>
      <name>m_mod</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint</type>
      <name>m_sym</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KKeyServer::Variations</name>
    <filename>structKKeyServer_1_1Variations.html</filename>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchor>a1</anchor>
      <arglist>(const KKey &amp;, bool bQt)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>count</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Key &amp;</type>
      <name>key</name>
      <anchor>a3</anchor>
      <arglist>(uint i) const </arglist>
    </member>
    <member kind="variable">
      <type>Key</type>
      <name>m_rgkey</name>
      <anchor>o0</anchor>
      <arglist>[MAX_VARIATIONS]</arglist>
    </member>
    <member kind="variable">
      <type>uint</type>
      <name>m_nVariations</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KMacroExpander</name>
    <filename>namespaceKMacroExpander.html</filename>
    <member kind="function">
      <type>QString</type>
      <name>expandMacros</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QChar, QString &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QChar, QString &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacros</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QString, QString &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QString, QString &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacros</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QChar, QStringList &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QChar, QStringList &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacros</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QString, QStringList &gt; &amp;map, QChar c)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>expandMacrosShellQuote</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;ostr, const QMap&lt; QString, QStringList &gt; &amp;map, QChar c)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KNotifyClient</name>
    <filename>namespaceKNotifyClient.html</filename>
    <class kind="class">KNotifyClient::Instance</class>
    <member kind="enumvalue">
      <name>PassivePopup</name>
      <anchor>a31a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Execute</name>
      <anchor>a31a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Taskbar</name>
      <anchor>a31a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>StandardEvent</name>
      <anchor>a33</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startDaemon</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>event</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;message, const QString &amp;text=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>event</name>
      <anchor>a20</anchor>
      <arglist>(StandardEvent event, const QString &amp;text=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>userEvent</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;text=QString::null, int present=Default, int level=Default, const QString &amp;sound=QString::null, const QString &amp;file=QString::null) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>event</name>
      <anchor>a22</anchor>
      <arglist>(int winId, const QString &amp;message, const QString &amp;text=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>event</name>
      <anchor>a23</anchor>
      <arglist>(int winId, StandardEvent event, const QString &amp;text=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>userEvent</name>
      <anchor>a24</anchor>
      <arglist>(int winId, const QString &amp;text=QString::null, int present=Default, int level=Default, const QString &amp;sound=QString::null, const QString &amp;file=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>beep</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;reason=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getPresentation</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;eventname)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getFile</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;eventname, int present)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getDefaultPresentation</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;eventname)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getDefaultFile</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;eventname, int present)</arglist>
    </member>
    <member kind="function">
      <type>KInstance *</type>
      <name>instance</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KNotifyClient::Instance</name>
    <filename>classKNotifyClient_1_1Instance.html</filename>
    <member kind="function">
      <type></type>
      <name>Instance</name>
      <anchor>a0</anchor>
      <arglist>(KInstance *instance)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Instance</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>useSystemBell</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>KInstance *</type>
      <name>current</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Instance *</type>
      <name>currentInstance</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KShell</name>
    <filename>namespaceKShell.html</filename>
    <member kind="enumeration">
      <name>Options</name>
      <anchor>a12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TildeExpand</name>
      <anchor>a12a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AbortOnMeta</name>
      <anchor>a12a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Errors</name>
      <anchor>a13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NoError</name>
      <anchor>a13a3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BadQuoting</name>
      <anchor>a13a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FoundMeta</name>
      <anchor>a13a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>splitArgs</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;cmd, int flags=0, int *err=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>joinArgs</name>
      <anchor>a7</anchor>
      <arglist>(const QStringList &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>joinArgsDQ</name>
      <anchor>a8</anchor>
      <arglist>(const QStringList &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>joinArgs</name>
      <anchor>a9</anchor>
      <arglist>(const char *const *argv, int argc=-1)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tildeExpand</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeDir</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;user)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KStdAccel</name>
    <filename>namespaceKStdAccel.html</filename>
    <class kind="class">KStdAccel::ShortcutList</class>
    <member kind="enumeration">
      <name>StdAccel</name>
      <anchor>a108</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" static="yes">
      <type>KStdAccelInfo *</type>
      <name>infoPtr</name>
      <anchor>a48</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>initialize</name>
      <anchor>a49</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a50</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a51</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a52</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>StdAccel</type>
      <name>findStdAccel</name>
      <anchor>a53</anchor>
      <arglist>(const KKeySequence &amp;seq)</arglist>
    </member>
    <member kind="function">
      <type>KShortcut</type>
      <name>shortcutDefault</name>
      <anchor>a54</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>KShortcut</type>
      <name>shortcutDefault3</name>
      <anchor>a55</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>KShortcut</type>
      <name>shortcutDefault4</name>
      <anchor>a56</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>createAccelActions</name>
      <anchor>a57</anchor>
      <arglist>(KAccelActions &amp;actions)</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>open</name>
      <anchor>a58</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>openNew</name>
      <anchor>a59</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>close</name>
      <anchor>a60</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>save</name>
      <anchor>a61</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>print</name>
      <anchor>a62</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>quit</name>
      <anchor>a63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>cut</name>
      <anchor>a64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>copy</name>
      <anchor>a65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>paste</name>
      <anchor>a66</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>deleteWordBack</name>
      <anchor>a67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>deleteWordForward</name>
      <anchor>a68</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>undo</name>
      <anchor>a69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>redo</name>
      <anchor>a70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>find</name>
      <anchor>a71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>findNext</name>
      <anchor>a72</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>findPrev</name>
      <anchor>a73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>replace</name>
      <anchor>a74</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>home</name>
      <anchor>a75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>end</name>
      <anchor>a76</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>prior</name>
      <anchor>a77</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>next</name>
      <anchor>a78</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>gotoLine</name>
      <anchor>a79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>addBookmark</name>
      <anchor>a80</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>tabNext</name>
      <anchor>a81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>tabPrev</name>
      <anchor>a82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>fullScreen</name>
      <anchor>a83</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>zoomIn</name>
      <anchor>a84</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>zoomOut</name>
      <anchor>a85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>help</name>
      <anchor>a86</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>completion</name>
      <anchor>a87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>prevCompletion</name>
      <anchor>a88</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>nextCompletion</name>
      <anchor>a89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>rotateUp</name>
      <anchor>a90</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>rotateDown</name>
      <anchor>a91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>substringCompletion</name>
      <anchor>a92</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>popupMenuContext</name>
      <anchor>a93</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>whatsThis</name>
      <anchor>a94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>reload</name>
      <anchor>a95</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>selectAll</name>
      <anchor>a96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>up</name>
      <anchor>a97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>back</name>
      <anchor>a98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>forward</name>
      <anchor>a99</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>showMenubar</name>
      <anchor>a100</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>action</name>
      <anchor>a101</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>description</name>
      <anchor>a102</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>key</name>
      <anchor>a103</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>defaultKey</name>
      <anchor>a104</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEqual</name>
      <anchor>a105</anchor>
      <arglist>(const QKeyEvent *ev, int keyQt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>whatsThis</name>
      <anchor>a106</anchor>
      <arglist>(StdAccel id)</arglist>
    </member>
    <member kind="function">
      <type>const KShortcut &amp;</type>
      <name>insert</name>
      <anchor>a107</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>KStdAccelInfo</type>
      <name>g_infoStdAccel</name>
      <anchor>a0</anchor>
      <arglist>[]</arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>whatsThis</name>
      <anchor>a1</anchor>
      <arglist>(StdAccel)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KStdAccel::ShortcutList</name>
    <filename>classKStdAccel_1_1ShortcutList.html</filename>
    <base>KShortcutList</base>
    <member kind="function">
      <type></type>
      <name>ShortcutList</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual uint</type>
      <name>count</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>label</name>
      <anchor>a4</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>whatsThis</name>
      <anchor>a5</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcut</name>
      <anchor>a6</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KShortcut &amp;</type>
      <name>shortcutDefault</name>
      <anchor>a7</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isConfigurable</name>
      <anchor>a8</anchor>
      <arglist>(uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setShortcut</name>
      <anchor>a9</anchor>
      <arglist>(uint index, const KShortcut &amp;shortcut)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QVariant</type>
      <name>getOther</name>
      <anchor>a10</anchor>
      <arglist>(Other, uint index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setOther</name>
      <anchor>a11</anchor>
      <arglist>(Other, uint index, QVariant)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>save</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
</tagfile>
