<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>KateArbitraryHighlight</name>
    <filename>classKateArbitraryHighlight.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>tagLines</name>
      <anchor>l0</anchor>
      <arglist>(KateView *view, KateSuperRange *range)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateArbitraryHighlight</name>
      <anchor>a0</anchor>
      <arglist>(KateDocument *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addHighlightToDocument</name>
      <anchor>a1</anchor>
      <arglist>(KateSuperRangeList *list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addHighlightToView</name>
      <anchor>a2</anchor>
      <arglist>(KateSuperRangeList *list, KateView *view)</arglist>
    </member>
    <member kind="function">
      <type>KateSuperRangeList &amp;</type>
      <name>rangesIncluding</name>
      <anchor>a3</anchor>
      <arglist>(uint line, KateView *view=0L)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateAttribute</name>
    <filename>classKateAttribute.html</filename>
    <member kind="function">
      <type>QFont</type>
      <name>font</name>
      <anchor>a2</anchor>
      <arglist>(const QFont &amp;ref)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>width</name>
      <anchor>a3</anchor>
      <arglist>(FontStruct &amp;fs, const QString &amp;text, int col, int tabWidth) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>width</name>
      <anchor>a4</anchor>
      <arglist>(FontStruct &amp;fs, const QChar &amp;c, int tabWidth) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>itemSet</name>
      <anchor>a5</anchor>
      <arglist>(int item) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSomethingSet</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>itemsSet</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearAttribute</name>
      <anchor>a8</anchor>
      <arglist>(int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>weight</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWeight</name>
      <anchor>a10</anchor>
      <arglist>(int weight)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>bold</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBold</name>
      <anchor>a12</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>italic</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setItalic</name>
      <anchor>a14</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>underline</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUnderline</name>
      <anchor>a16</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strikeOut</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStrikeOut</name>
      <anchor>a18</anchor>
      <arglist>(bool enable=true)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>outline</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOutline</name>
      <anchor>a20</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>textColor</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextColor</name>
      <anchor>a22</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>selectedTextColor</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectedTextColor</name>
      <anchor>a24</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>bgColor</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBGColor</name>
      <anchor>a26</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>const QColor &amp;</type>
      <name>selectedBGColor</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSelectedBGColor</name>
      <anchor>a28</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>KateAttribute &amp;</type>
      <name>operator+=</name>
      <anchor>a29</anchor>
      <arglist>(const KateAttribute &amp;a)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>changed</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isChanged</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator==</name>
      <anchor>n0</anchor>
      <arglist>(const KateAttribute &amp;h1, const KateAttribute &amp;h2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator!=</name>
      <anchor>n1</anchor>
      <arglist>(const KateAttribute &amp;h1, const KateAttribute &amp;h2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateBuffer</name>
    <filename>classKateBuffer.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>bool</type>
      <name>openFile</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;m_file)</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>canEncode</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>saveFile</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;m_file)</arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>count</name>
      <anchor>i3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>countVisible</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>lineNumber</name>
      <anchor>i5</anchor>
      <arglist>(uint visibleLine)</arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>lineVisibleNumber</name>
      <anchor>i6</anchor>
      <arglist>(uint line)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>lineInfo</name>
      <anchor>i7</anchor>
      <arglist>(KateLineInfo *info, unsigned int line)</arglist>
    </member>
    <member kind="slot">
      <type>KateCodeFoldingTree *</type>
      <name>foldingTree</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHlUpdate</name>
      <anchor>i9</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>dumpRegionTree</name>
      <anchor>i10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>TextLine::Ptr</type>
      <name>line</name>
      <anchor>i11</anchor>
      <arglist>(uint i)</arglist>
    </member>
    <member kind="slot">
      <type>TextLine::Ptr</type>
      <name>plainLine</name>
      <anchor>i12</anchor>
      <arglist>(uint i)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>textLine</name>
      <anchor>i13</anchor>
      <arglist>(uint i, bool withoutTrailingSpaces=false)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>insertLine</name>
      <anchor>i14</anchor>
      <arglist>(uint i, TextLine::Ptr line)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>removeLine</name>
      <anchor>i15</anchor>
      <arglist>(uint i)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>changeLine</name>
      <anchor>i16</anchor>
      <arglist>(uint i)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>clear</name>
      <anchor>i17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHighlight</name>
      <anchor>i18</anchor>
      <arglist>(Highlight *highlight)</arglist>
    </member>
    <member kind="slot">
      <type>Highlight *</type>
      <name>highlight</name>
      <anchor>i19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>updateHighlighting</name>
      <anchor>i20</anchor>
      <arglist>(uint from, uint to, bool invalidate)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>invalidateHighlighting</name>
      <anchor>i21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>text</name>
      <anchor>i22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>text</name>
      <anchor>i23</anchor>
      <arglist>(uint startLine, uint startCol, uint endLine, uint endCol, bool blockwise=false)</arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>length</name>
      <anchor>i24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>int</type>
      <name>lineLength</name>
      <anchor>i25</anchor>
      <arglist>(uint line)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setLineVisible</name>
      <anchor>i26</anchor>
      <arglist>(unsigned int lineNr, bool visible)</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>loadingBorked</name>
      <anchor>i27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTabWidth</name>
      <anchor>i28</anchor>
      <arglist>(uint w)</arglist>
    </member>
    <member kind="slot">
      <type>uint</type>
      <name>tabWidth</name>
      <anchor>i29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>linesChanged</name>
      <anchor>l0</anchor>
      <arglist>(int lines)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>codeFoldingUpdated</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tagLines</name>
      <anchor>l2</anchor>
      <arglist>(int start, int end)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>loadingFinished</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateBuffer</name>
      <anchor>a0</anchor>
      <arglist>(KateDocument *doc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~KateBuffer</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>KateDocument *</type>
      <name>document</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateDocCursor</name>
    <filename>classKateDocCursor.html</filename>
    <base>KateTextCursor</base>
    <member kind="function">
      <type></type>
      <name>KateDocCursor</name>
      <anchor>a0</anchor>
      <arglist>(KateDocument *doc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateDocCursor</name>
      <anchor>a1</anchor>
      <arglist>(int line, int col, KateDocument *doc)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>validPosition</name>
      <anchor>a3</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>validPosition</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>gotoNextLine</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>gotoPreviousLine</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>gotoEndOfNextLine</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>gotoEndOfPreviousLine</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nbCharsOnLineAfter</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>moveForward</name>
      <anchor>a10</anchor>
      <arglist>(uint nbChar)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>moveBackward</name>
      <anchor>a11</anchor>
      <arglist>(uint nbChar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>position</name>
      <anchor>a12</anchor>
      <arglist>(uint *line, uint *col) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPosition</name>
      <anchor>a13</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insertText</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeText</name>
      <anchor>a15</anchor>
      <arglist>(uint numberOfCharacters)</arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>currentChar</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nextNonSpaceChar</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>previousNonSpaceChar</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>KateDocument *</type>
      <name>m_doc</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateRenderer</name>
    <filename>classKateRenderer.html</filename>
    <member kind="function">
      <type></type>
      <name>KateRenderer</name>
      <anchor>a0</anchor>
      <arglist>(KateDocument *doc, KateView *view=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateAttributes</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>drawCaret</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDrawCaret</name>
      <anchor>a4</anchor>
      <arglist>(bool drawCaret)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>caretStyle</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCaretStyle</name>
      <anchor>a6</anchor>
      <arglist>(int style)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showTabs</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowTabs</name>
      <anchor>a8</anchor>
      <arglist>(bool showTabs)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabWidth</name>
      <anchor>a9</anchor>
      <arglist>(int tabWidth)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>showSelections</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShowSelections</name>
      <anchor>a11</anchor>
      <arglist>(bool showSelections)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>increaseFontSizes</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>decreaseFontSizes</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QFont *</type>
      <name>currentFont</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QFontMetrics *</type>
      <name>currentFontMetrics</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isPrinterFriendly</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPrinterFriendly</name>
      <anchor>a17</anchor>
      <arglist>(bool printerFriendly)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>spaceWidth</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textWidth</name>
      <anchor>a19</anchor>
      <arglist>(const TextLine::Ptr &amp;, int cursorCol)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textWidth</name>
      <anchor>a20</anchor>
      <arglist>(const TextLine::Ptr &amp;textLine, uint startcol, uint maxwidth, bool *needWrap, int *endX=0)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textWidth</name>
      <anchor>a21</anchor>
      <arglist>(const KateTextCursor &amp;cursor)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textWidth</name>
      <anchor>a22</anchor>
      <arglist>(KateTextCursor &amp;cursor, int xPos, uint startCol=0)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textPos</name>
      <anchor>a23</anchor>
      <arglist>(uint line, int xPos, uint startCol=0)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>textPos</name>
      <anchor>a24</anchor>
      <arglist>(const TextLine::Ptr &amp;, int xPos, uint startCol=0)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>fontHeight</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>documentHeight</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>selectBounds</name>
      <anchor>a27</anchor>
      <arglist>(uint line, uint &amp;start, uint &amp;end, uint lineLength)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paintTextLine</name>
      <anchor>a28</anchor>
      <arglist>(QPainter &amp;paint, const LineRange *range, int xStart, int xEnd, const KateTextCursor *cursor=0L, const KateTextRange *bracketmark=0L)</arglist>
    </member>
    <member kind="function">
      <type>KateAttribute *</type>
      <name>attribute</name>
      <anchor>a29</anchor>
      <arglist>(uint pos)</arglist>
    </member>
    <member kind="function">
      <type>KateRendererConfig *</type>
      <name>config</name>
      <anchor>a30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>updateConfig</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateScrollBar</name>
    <filename>classKateScrollBar.html</filename>
    <base>QScrollBar</base>
    <member kind="signal">
      <type>void</type>
      <name>sliderMMBMoved</name>
      <anchor>l0</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateScrollBar</name>
      <anchor>a0</anchor>
      <arglist>(Orientation orientation, QWidget *parent, const char *name=0L)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>sliderMaybeMoved</name>
      <anchor>j0</anchor>
      <arglist>(int value)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateSuperCursor</name>
    <filename>classKateSuperCursor.html</filename>
    <base>QObject</base>
    <base>KateDocCursor</base>
    <member kind="signal">
      <type>void</type>
      <name>positionDirectlyChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>positionChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>positionUnChanged</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>positionDeleted</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>charInsertedAt</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>charDeletedBefore</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>charDeletedAfter</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateSuperCursor</name>
      <anchor>a0</anchor>
      <arglist>(KateDocument *doc, bool privateC, const KateTextCursor &amp;cursor, QObject *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateSuperCursor</name>
      <anchor>a1</anchor>
      <arglist>(KateDocument *doc, bool privateC, int lineNum=0, int col=0, QObject *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>position</name>
      <anchor>a3</anchor>
      <arglist>(uint *line, uint *col) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setPosition</name>
      <anchor>a4</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>insertText</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeText</name>
      <anchor>a6</anchor>
      <arglist>(uint numberOfCharacters)</arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>currentChar</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>atStartOfLine</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>atEndOfLine</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>moveOnInsert</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMoveOnInsert</name>
      <anchor>a11</anchor>
      <arglist>(bool moveOnInsert)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator QString</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLine</name>
      <anchor>a13</anchor>
      <arglist>(int lineNum)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCol</name>
      <anchor>a14</anchor>
      <arglist>(int colNum)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPos</name>
      <anchor>a15</anchor>
      <arglist>(const KateTextCursor &amp;pos)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPos</name>
      <anchor>a16</anchor>
      <arglist>(int lineNum, int colNum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editTextInserted</name>
      <anchor>a17</anchor>
      <arglist>(uint line, uint col, uint len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editTextRemoved</name>
      <anchor>a18</anchor>
      <arglist>(uint line, uint col, uint len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editLineWrapped</name>
      <anchor>a19</anchor>
      <arglist>(uint line, uint col, bool newLine=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editLineUnWrapped</name>
      <anchor>a20</anchor>
      <arglist>(uint line, uint col, bool removeLine=true, uint length=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editLineInserted</name>
      <anchor>a21</anchor>
      <arglist>(uint line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>editLineRemoved</name>
      <anchor>a22</anchor>
      <arglist>(uint line)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateSuperRange</name>
    <filename>classKateSuperRange.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>InsertBehaviour</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DoNotExpand</name>
      <anchor>w3w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ExpandLeft</name>
      <anchor>w3w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ExpandRight</name>
      <anchor>w3w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotTagRange</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>positionChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>positionUnChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>contentsChanged</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>boundaryDeleted</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>eliminated</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>tagRange</name>
      <anchor>l5</anchor>
      <arglist>(KateSuperRange *range)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateSuperRange</name>
      <anchor>a0</anchor>
      <arglist>(KateSuperCursor *start, KateSuperCursor *end, QObject *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateSuperRange</name>
      <anchor>a1</anchor>
      <arglist>(KateDocument *doc, const KateRange &amp;range, QObject *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KateSuperRange</name>
      <anchor>a2</anchor>
      <arglist>(KateDocument *doc, const KateTextCursor &amp;start, const KateTextCursor &amp;end, QObject *parent=0L, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KateTextCursor &amp;</type>
      <name>start</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual KateTextCursor &amp;</type>
      <name>end</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KateTextCursor &amp;</type>
      <name>start</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const KateTextCursor &amp;</type>
      <name>end</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KateSuperCursor &amp;</type>
      <name>superStart</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KateSuperCursor &amp;</type>
      <name>superStart</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>KateSuperCursor &amp;</type>
      <name>superEnd</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const KateSuperCursor &amp;</type>
      <name>superEnd</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>behaviour</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBehaviour</name>
      <anchor>a13</anchor>
      <arglist>(int behaviour)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isValid</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>owns</name>
      <anchor>a15</anchor>
      <arglist>(const KateTextCursor &amp;cursor) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchor>a16</anchor>
      <arglist>(const KateTextCursor &amp;cursor) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includes</name>
      <anchor>a17</anchor>
      <arglist>(uint lineNum) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>includesWholeLine</name>
      <anchor>a18</anchor>
      <arglist>(uint lineNum) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>boundaryAt</name>
      <anchor>a19</anchor>
      <arglist>(const KateTextCursor &amp;cursor) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>boundaryOn</name>
      <anchor>a20</anchor>
      <arglist>(uint lineNum) const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>KateSuperRangeList</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateTextCursor</name>
    <filename>classKateTextCursor.html</filename>
    <member kind="function">
      <type></type>
      <name>KateTextCursor</name>
      <anchor>a1</anchor>
      <arglist>(int line, int col)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pos</name>
      <anchor>a3</anchor>
      <arglist>(int *pline, int *pcol) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>line</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>col</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setLine</name>
      <anchor>a6</anchor>
      <arglist>(int line)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCol</name>
      <anchor>a7</anchor>
      <arglist>(int col)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPos</name>
      <anchor>a8</anchor>
      <arglist>(const KateTextCursor &amp;pos)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setPos</name>
      <anchor>a9</anchor>
      <arglist>(int line, int col)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_line</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>m_col</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator==</name>
      <anchor>n0</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator!=</name>
      <anchor>n1</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator&gt;</name>
      <anchor>n2</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator&gt;=</name>
      <anchor>n3</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator&lt;</name>
      <anchor>n4</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
    <member kind="friend">
      <type>friend bool</type>
      <name>operator&lt;=</name>
      <anchor>n5</anchor>
      <arglist>(const KateTextCursor &amp;c1, const KateTextCursor &amp;c2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMimeTypeChooser</name>
    <filename>classKMimeTypeChooser.html</filename>
    <base>QVBox</base>
    <member kind="slot">
      <type>void</type>
      <name>editMimeType</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotCurrentChanged</name>
      <anchor>i1</anchor>
      <arglist>(QListViewItem *i)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KMimeTypeChooser</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const QString &amp;text=QString::null, const QStringList &amp;selectedMimeTypes=0, bool editbutton=true, bool showcomment=true, bool showpattern=true)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>selectedMimeTypesStringList</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>patterns</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMimeTypeChooserDlg</name>
    <filename>classKMimeTypeChooserDlg.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>KMimeTypeChooserDlg</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const QString &amp;caption=QString::null, const QString &amp;text=QString::null, const QStringList &amp;selectedMimeTypes=QStringList(), bool editbutton=true, bool showcomment=true, bool showpatterns=true)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>mimeTypes</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>patterns</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>syntaxContextData</name>
    <filename>classsyntaxContextData.html</filename>
    <member kind="variable">
      <type>QDomElement</type>
      <name>parent</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QDomElement</type>
      <name>currentGroup</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QDomElement</type>
      <name>item</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SyntaxDocument</name>
    <filename>classSyntaxDocument.html</filename>
    <base>QDomDocument</base>
    <member kind="function">
      <type></type>
      <name>SyntaxDocument</name>
      <anchor>a0</anchor>
      <arglist>(bool force=false)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SyntaxDocument</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setIdentifier</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;identifier)</arglist>
    </member>
    <member kind="function">
      <type>SyntaxModeList</type>
      <name>modeList</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nextGroup</name>
      <anchor>a4</anchor>
      <arglist>(syntaxContextData *data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>nextItem</name>
      <anchor>a5</anchor>
      <arglist>(syntaxContextData *data)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>groupItemData</name>
      <anchor>a6</anchor>
      <arglist>(const syntaxContextData *data, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>groupData</name>
      <anchor>a7</anchor>
      <arglist>(const syntaxContextData *data, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>freeGroupInfo</name>
      <anchor>a8</anchor>
      <arglist>(syntaxContextData *data)</arglist>
    </member>
    <member kind="function">
      <type>syntaxContextData *</type>
      <name>getSubItems</name>
      <anchor>a9</anchor>
      <arglist>(syntaxContextData *data)</arglist>
    </member>
    <member kind="function">
      <type>syntaxContextData *</type>
      <name>getConfig</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;mainGroupName, const QString &amp;config)</arglist>
    </member>
    <member kind="function">
      <type>syntaxContextData *</type>
      <name>getGroupInfo</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;mainGroupName, const QString &amp;group)</arglist>
    </member>
    <member kind="function">
      <type>QStringList &amp;</type>
      <name>finddata</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;mainGroup, const QString &amp;type, bool clearList=true)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>syntaxModeListItem</name>
    <filename>classsyntaxModeListItem.html</filename>
    <member kind="variable">
      <type>QString</type>
      <name>name</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>section</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>mimetype</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>extension</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>identifier</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>version</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>priority</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TextLine</name>
    <filename>classTextLine.html</filename>
    <base>KShared</base>
    <member kind="typedef">
      <type>KSharedPtr&lt; TextLine &gt;</type>
      <name>Ptr</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueVector&lt; Ptr &gt;</type>
      <name>List</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TextLine</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>length</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hlLineContinue</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isVisible</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAutoWrapped</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>firstChar</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>lastChar</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>nextNonSpaceChar</name>
      <anchor>a8</anchor>
      <arglist>(uint pos) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>previousNonSpaceChar</name>
      <anchor>a9</anchor>
      <arglist>(uint pos) const </arglist>
    </member>
    <member kind="function">
      <type>QChar</type>
      <name>getChar</name>
      <anchor>a10</anchor>
      <arglist>(uint pos) const </arglist>
    </member>
    <member kind="function">
      <type>const QChar *</type>
      <name>text</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uchar *</type>
      <name>attributes</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>string</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>string</name>
      <anchor>a14</anchor>
      <arglist>(uint startCol, uint length) const </arglist>
    </member>
    <member kind="function">
      <type>QConstString</type>
      <name>constString</name>
      <anchor>a15</anchor>
      <arglist>(uint startCol, uint length) const </arglist>
    </member>
    <member kind="function">
      <type>const QChar *</type>
      <name>firstNonSpace</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>indentDepth</name>
      <anchor>a17</anchor>
      <arglist>(uint tabwidth) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cursorX</name>
      <anchor>a18</anchor>
      <arglist>(uint pos, uint tabChars) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stringAtPos</name>
      <anchor>a19</anchor>
      <arglist>(uint pos, const QString &amp;match) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startingWith</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;match) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>endingWith</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;match) const </arglist>
    </member>
    <member kind="function">
      <type>short *</type>
      <name>ctx</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ctxSize</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ctxEmpty</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>searchText</name>
      <anchor>a25</anchor>
      <arglist>(uint startCol, const QString &amp;text, uint *foundAtCol, uint *matchLen, bool casesensitive=true, bool backwards=false)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>searchText</name>
      <anchor>a26</anchor>
      <arglist>(uint startCol, const QRegExp &amp;regexp, uint *foundAtCol, uint *matchLen, bool backwards=false)</arglist>
    </member>
    <member kind="function">
      <type>uchar</type>
      <name>attribute</name>
      <anchor>a27</anchor>
      <arglist>(uint pos) const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>textArray</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QMemArray&lt; uchar &gt; &amp;</type>
      <name>attributesArray</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QMemArray&lt; short &gt; &amp;</type>
      <name>ctxArray</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QMemArray&lt; signed char &gt; &amp;</type>
      <name>foldingListArray</name>
      <anchor>a31</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QMemArray&lt; unsigned short &gt; &amp;</type>
      <name>indentationDepthArray</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertText</name>
      <anchor>a33</anchor>
      <arglist>(uint pos, uint insLen, const QChar *insText, uchar *insAttribs=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeText</name>
      <anchor>a34</anchor>
      <arglist>(uint pos, uint delLen)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchor>a35</anchor>
      <arglist>(const QChar *s, uint l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchor>a36</anchor>
      <arglist>(uint newLen)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>withoutTrailingSpaces</name>
      <anchor>a37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHlLineContinue</name>
      <anchor>a38</anchor>
      <arglist>(bool cont)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisible</name>
      <anchor>a39</anchor>
      <arglist>(bool val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAutoWrapped</name>
      <anchor>a40</anchor>
      <arglist>(bool wrapped)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttribs</name>
      <anchor>a41</anchor>
      <arglist>(uchar attribute, uint start, uint end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setContext</name>
      <anchor>a42</anchor>
      <arglist>(short *newctx, uint len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFoldingList</name>
      <anchor>a43</anchor>
      <arglist>(QMemArray&lt; signed char &gt; &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIndentationDepth</name>
      <anchor>a44</anchor>
      <arglist>(QMemArray&lt; unsigned short &gt; &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>dumpSize</name>
      <anchor>a45</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>dump</name>
      <anchor>a46</anchor>
      <arglist>(char *buf) const </arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>restore</name>
      <anchor>a47</anchor>
      <arglist>(char *buf)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Kate::Command</name>
    <filename>classKate_1_1Command.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QStringList</type>
      <name>cmds</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>exec</name>
      <anchor>a3</anchor>
      <arglist>(View *view, const QString &amp;cmd, QString &amp;msg)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>help</name>
      <anchor>a4</anchor>
      <arglist>(View *view, const QString &amp;cmd, QString &amp;msg)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Kate::Document</name>
    <filename>classKate_1_1Document.html</filename>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>flush</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>reloadFile</name>
      <anchor>i1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>spellcheck</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>exportAs</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;)=0</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>applyWordWrap</name>
      <anchor>i4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>modifiedOnDisc</name>
      <anchor>l0</anchor>
      <arglist>(Kate::Document *doc, bool isModified, unsigned char reason)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchor>a1</anchor>
      <arglist>(QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>isModOnHD</name>
      <anchor>a3</anchor>
      <arglist>(bool=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>docName</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setDocName</name>
      <anchor>a5</anchor>
      <arglist>(QString)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ActionMenu *</type>
      <name>hlActionMenu</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;, QObject *=0, const char *=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ActionMenu *</type>
      <name>exportActionMenu</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;, QObject *=0, const char *=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setWordWrap</name>
      <anchor>a8</anchor>
      <arglist>(bool)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>wordWrap</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setWordWrapAt</name>
      <anchor>a10</anchor>
      <arglist>(uint)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>wordWrapAt</name>
      <anchor>a11</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setEncoding</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;e)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>encoding</name>
      <anchor>a13</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>colorConfigPage</name>
      <anchor>a14</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>fontConfigPage</name>
      <anchor>a15</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>indentConfigPage</name>
      <anchor>a16</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>selectConfigPage</name>
      <anchor>a17</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>editConfigPage</name>
      <anchor>a18</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>keysConfigPage</name>
      <anchor>a19</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConfigPage *</type>
      <name>kSpellConfigPage</name>
      <anchor>a20</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>hlConfigPage</name>
      <anchor>a21</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>configFlags</name>
      <anchor>a22</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setConfigFlags</name>
      <anchor>a23</anchor>
      <arglist>(uint flags)=0</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>registerCommand</name>
      <anchor>e0</anchor>
      <arglist>(Command *cmd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>unregisterCommand</name>
      <anchor>e1</anchor>
      <arglist>(Command *cmd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Command *</type>
      <name>queryCommand</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;cmd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setOpenErrorDialogsActivated</name>
      <anchor>e3</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setFileChangedDialogsActivated</name>
      <anchor>e4</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QString &amp;</type>
      <name>defaultEncoding</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>bool</type>
      <name>s_openErrorDialogsActivated</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>bool</type>
      <name>s_fileChangedDialogsActivated</name>
      <anchor>t1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>QString</type>
      <name>s_defaultEncoding</name>
      <anchor>t2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Kate::View</name>
    <filename>classKate_1_1View.html</filename>
    <member kind="enumeration">
      <name>saveResult</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>flush</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual saveResult</type>
      <name>save</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual saveResult</type>
      <name>saveAs</name>
      <anchor>i2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>indent</name>
      <anchor>i3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>unIndent</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>cleanIndent</name>
      <anchor>i5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>comment</name>
      <anchor>i6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>uncomment</name>
      <anchor>i7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>keyReturn</name>
      <anchor>i8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>keyDelete</name>
      <anchor>i9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>backspace</name>
      <anchor>i10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>killLine</name>
      <anchor>i11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>cursorLeft</name>
      <anchor>i12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftCursorLeft</name>
      <anchor>i13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>cursorRight</name>
      <anchor>i14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftCursorRight</name>
      <anchor>i15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>wordLeft</name>
      <anchor>i16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftWordLeft</name>
      <anchor>i17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>wordRight</name>
      <anchor>i18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftWordRight</name>
      <anchor>i19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>home</name>
      <anchor>i20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftHome</name>
      <anchor>i21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>end</name>
      <anchor>i22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftEnd</name>
      <anchor>i23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>up</name>
      <anchor>i24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftUp</name>
      <anchor>i25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>down</name>
      <anchor>i26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftDown</name>
      <anchor>i27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>scrollUp</name>
      <anchor>i28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>scrollDown</name>
      <anchor>i29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>topOfView</name>
      <anchor>i30</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>bottomOfView</name>
      <anchor>i31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>pageUp</name>
      <anchor>i32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftPageUp</name>
      <anchor>i33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>pageDown</name>
      <anchor>i34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftPageDown</name>
      <anchor>i35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>top</name>
      <anchor>i36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftTop</name>
      <anchor>i37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>bottom</name>
      <anchor>i38</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>shiftBottom</name>
      <anchor>i39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>find</name>
      <anchor>i40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>replace</name>
      <anchor>i41</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>gotoLine</name>
      <anchor>i42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual int</type>
      <name>getEol</name>
      <anchor>i43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setEol</name>
      <anchor>i44</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setFocus</name>
      <anchor>i45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>findAgain</name>
      <anchor>i46</anchor>
      <arglist>(bool forward)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>findAgain</name>
      <anchor>i47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>findPrev</name>
      <anchor>i48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotEditCommand</name>
      <anchor>i49</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setIconBorder</name>
      <anchor>i50</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>toggleIconBorder</name>
      <anchor>i51</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setLineNumbersOn</name>
      <anchor>i52</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>toggleLineNumbersOn</name>
      <anchor>i53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotIncFontSizes</name>
      <anchor>i54</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>slotDecFontSizes</name>
      <anchor>i55</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>gotoMark</name>
      <anchor>i56</anchor>
      <arglist>(KTextEditor::Mark *mark)=0</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>toggleBookmark</name>
      <anchor>i57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>gotoLineNumber</name>
      <anchor>i58</anchor>
      <arglist>(int)=0</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>gotFocus</name>
      <anchor>l0</anchor>
      <arglist>(View *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View</name>
      <anchor>a0</anchor>
      <arglist>(KTextEditor::Document *, QWidget *, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~View</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>isOverwriteMode</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setOverwriteMode</name>
      <anchor>a3</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>currentTextLine</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>currentWord</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>word</name>
      <anchor>a6</anchor>
      <arglist>(int, int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>insertText</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;mark)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>canDiscard</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>tabWidth</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setTabWidth</name>
      <anchor>a10</anchor>
      <arglist>(int)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setEncoding</name>
      <anchor>a11</anchor>
      <arglist>(QString e)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isLastView</name>
      <anchor>a12</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>readSessionConfig</name>
      <anchor>a13</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>writeSessionConfig</name>
      <anchor>a14</anchor>
      <arglist>(KConfig *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>iconBorder</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>lineNumbersOn</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Document *</type>
      <name>getDoc</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setActive</name>
      <anchor>a18</anchor>
      <arglist>(bool b)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isActive</name>
      <anchor>a19</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KateCommands</name>
    <filename>namespaceKateCommands.html</filename>
    <class kind="class">KateCommands::SedReplace</class>
    <class kind="class">KateCommands::Character</class>
  </compound>
  <compound kind="class">
    <name>KateCommands::SedReplace</name>
    <filename>classKateCommands_1_1SedReplace.html</filename>
    <base>Kate::Command</base>
    <member kind="function">
      <type>bool</type>
      <name>exec</name>
      <anchor>a0</anchor>
      <arglist>(class Kate::View *view, const QString &amp;cmd, QString &amp;errorMsg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>help</name>
      <anchor>a1</anchor>
      <arglist>(class Kate::View *, const QString &amp;, QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>cmds</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KateCommands::Character</name>
    <filename>classKateCommands_1_1Character.html</filename>
    <base>Kate::Command</base>
    <member kind="function">
      <type>bool</type>
      <name>exec</name>
      <anchor>a0</anchor>
      <arglist>(class Kate::View *view, const QString &amp;cmd, QString &amp;errorMsg)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>help</name>
      <anchor>a1</anchor>
      <arglist>(class Kate::View *, const QString &amp;, QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>cmds</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
</tagfile>
