<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>VCard21ParserImpl</name>
    <filename>classVCard21ParserImpl.html</filename>
    <member kind="function">
      <type>QString</type>
      <name>getValue</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;name, const QString &amp;qualifier)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>getValue</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getValues</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;name, const QString &amp;qualifier)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>getValues</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>VCard21ParserImpl *</type>
      <name>parseVCard</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;vc, int *err=NULL)</arglist>
    </member>
    <member kind="variable">
      <type>QValueList&lt; VCardLineX &gt; *</type>
      <name>_vcdata</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>VCardLineX</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>VCardLineX</name>
    <filename>classVCardLineX.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>name</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>qualified</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QValueList&lt; QString &gt;</type>
      <name>qualifiers</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QValueList&lt; QString &gt;</type>
      <name>parameters</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KABC</name>
    <filename>namespaceKABC.html</filename>
    <class kind="class">KABC::Address</class>
    <class kind="class">KABC::AddressBook</class>
    <class kind="class">KABC::AddressBook::Iterator</class>
    <class kind="class">KABC::AddressBook::ConstIterator</class>
    <class kind="class">KABC::AddresseeItem</class>
    <class kind="class">KABC::AddresseeDialog</class>
    <class kind="class">KABC::AddresseeList</class>
    <class kind="class">KABC::AddressLineEdit</class>
    <class kind="class">KABC::Agent</class>
    <class kind="class">KABC::DistributionList</class>
    <class kind="struct">KABC::DistributionList::Entry</class>
    <class kind="class">KABC::DistributionListManager</class>
    <class kind="class">KABC::DistributionListWatcher</class>
    <class kind="class">KABC::DistributionListDialog</class>
    <class kind="class">KABC::EmailSelector</class>
    <class kind="class">KABC::DistributionListEditorWidget</class>
    <class kind="class">KABC::DistributionListEditor</class>
    <class kind="class">KABC::ErrorHandler</class>
    <class kind="class">KABC::ConsoleErrorHandler</class>
    <class kind="class">KABC::GUIErrorHandler</class>
    <class kind="class">KABC::GuiErrorHandler</class>
    <class kind="class">KABC::Format</class>
    <class kind="class">KABC::FormatFactory</class>
    <class kind="class">KABC::FormatPlugin</class>
    <class kind="class">KABC::BinaryFormat</class>
    <class kind="class">KABC::Geo</class>
    <class kind="class">KABC::Key</class>
    <class kind="class">KABC::LdapObject</class>
    <class kind="class">KABC::LdapClient</class>
    <class kind="class">KABC::LdapSearch</class>
    <class kind="class">KABC::Lock</class>
    <class kind="class">KABC::LockNull</class>
    <class kind="class">KABC::PhoneNumber</class>
    <class kind="class">KABC::ResourceFile</class>
    <class kind="class">KABC::Ticket</class>
    <class kind="class">KABC::Resource::Iterator</class>
    <class kind="class">KABC::Resource::ConstIterator</class>
    <class kind="class">KABC::ResourceSelectDialog</class>
    <class kind="class">KABC::Addressee</class>
    <class kind="class">KABC::StdAddressBook</class>
    <class kind="class">KABC::TimeZone</class>
    <class kind="class">KABC::VCard21Parser</class>
    <class kind="class">KABC::VCardConverter</class>
    <class kind="class">KABC::VCardFormat</class>
    <class kind="class">KABC::VCardFormatImpl</class>
    <class kind="class">KABC::VCardFormatPlugin</class>
    <member kind="typedef">
      <type>QValueList&lt; QByteArray &gt;</type>
      <name>LdapAttrValue</name>
      <anchor>a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QMap&lt; QString, LdapAttrValue &gt;</type>
      <name>LdapAttrMap</name>
      <anchor>a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SortingCriterion</name>
      <anchor>a30</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a7</anchor>
      <arglist>(QDataStream &amp;, const Address &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a8</anchor>
      <arglist>(QDataStream &amp;, Address &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a9</anchor>
      <arglist>(QDataStream &amp;, const AddressBook &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a10</anchor>
      <arglist>(QDataStream &amp;, AddressBook &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a11</anchor>
      <arglist>(QDataStream &amp;, const Agent &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a12</anchor>
      <arglist>(QDataStream &amp;, Agent &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a13</anchor>
      <arglist>(QDataStream &amp;, const Geo &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a14</anchor>
      <arglist>(QDataStream &amp;, Geo &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a15</anchor>
      <arglist>(QDataStream &amp;, const Key &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a16</anchor>
      <arglist>(QDataStream &amp;, Key &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a17</anchor>
      <arglist>(QDataStream &amp;, const PhoneNumber &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a18</anchor>
      <arglist>(QDataStream &amp;, PhoneNumber &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a19</anchor>
      <arglist>(QDataStream &amp;, const Picture &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a20</anchor>
      <arglist>(QDataStream &amp;, Picture &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a21</anchor>
      <arglist>(QDataStream &amp;, const Addressee &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a22</anchor>
      <arglist>(QDataStream &amp;, Addressee &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a23</anchor>
      <arglist>(QDataStream &amp;, const Sound &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a24</anchor>
      <arglist>(QDataStream &amp;, Sound &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a25</anchor>
      <arglist>(QDataStream &amp;, const TimeZone &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>a26</anchor>
      <arglist>(QDataStream &amp;, TimeZone &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>dateToVCardString</name>
      <anchor>a27</anchor>
      <arglist>(const QDateTime &amp;dateTime)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>dateToVCardString</name>
      <anchor>a28</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>VCardStringToDate</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;dateString)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Address</name>
    <filename>classKABC_1_1Address.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Address &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueList&lt; int &gt;</type>
      <name>TypeList</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Type</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Address</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Address</name>
      <anchor>a1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a2</anchor>
      <arglist>(const Address &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a3</anchor>
      <arglist>(const Address &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setId</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>id</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a8</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>typeLabel</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPostOfficeBox</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>postOfficeBox</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setExtended</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>extended</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStreet</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>street</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLocality</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>locality</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRegion</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>region</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPostalCode</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>postalCode</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCountry</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>country</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>formattedAddress</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;realName=QString::null, const QString &amp;orgaName=QString::null) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>postOfficeBoxLabel</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>extendedLabel</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>streetLabel</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>localityLabel</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>regionLabel</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>postalCodeLabel</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>countryLabel</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>labelLabel</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>TypeList</type>
      <name>typeList</name>
      <anchor>e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>typeLabel</name>
      <anchor>e9</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>countryToISO</name>
      <anchor>e10</anchor>
      <arglist>(const QString &amp;cname)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>ISOtoCountry</name>
      <anchor>e11</anchor>
      <arglist>(const QString &amp;ISOname)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const Address &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, Address &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressBook</name>
    <filename>classKABC_1_1AddressBook.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>addressBookChanged</name>
      <anchor>l0</anchor>
      <arglist>(AddressBook *addressBook)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addressBookLocked</name>
      <anchor>l1</anchor>
      <arglist>(AddressBook *addressBook)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>addressBookUnlocked</name>
      <anchor>l2</anchor>
      <arglist>(AddressBook *addressBook)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>loadingFinished</name>
      <anchor>l3</anchor>
      <arglist>(Resource *resource)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>savingFinished</name>
      <anchor>l4</anchor>
      <arglist>(Resource *resource)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AddressBook</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AddressBook</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;config)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AddressBook</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Ticket *</type>
      <name>requestSaveTicket</name>
      <anchor>a3</anchor>
      <arglist>(Resource *resource=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>releaseSaveTicket</name>
      <anchor>a4</anchor>
      <arglist>(Ticket *ticket)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>asyncLoad</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a7</anchor>
      <arglist>(Ticket *ticket)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>asyncSave</name>
      <anchor>a8</anchor>
      <arglist>(Ticket *ticket)</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator</type>
      <name>begin</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>begin</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator</type>
      <name>end</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>end</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertAddressee</name>
      <anchor>a14</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAddressee</name>
      <anchor>a15</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAddressee</name>
      <anchor>a16</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="function">
      <type>Iterator</type>
      <name>find</name>
      <anchor>a17</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>Addressee</type>
      <name>findByUid</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;uid)</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>allAddressees</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>findByName</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>findByEmail</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;email)</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>findByCategory</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;category)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>identifier</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Field::List</type>
      <name>fields</name>
      <anchor>a24</anchor>
      <arglist>(int category=Field::All)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addCustomField</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;label, int category=Field::All, const QString &amp;key=QString::null, const QString &amp;app=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addResource</name>
      <anchor>a26</anchor>
      <arglist>(Resource *resource)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeResource</name>
      <anchor>a27</anchor>
      <arglist>(Resource *resource)</arglist>
    </member>
    <member kind="function">
      <type>QPtrList&lt; Resource &gt;</type>
      <name>resources</name>
      <anchor>a28</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setErrorHandler</name>
      <anchor>a29</anchor>
      <arglist>(ErrorHandler *errorHandler)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>error</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cleanUp</name>
      <anchor>a31</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a32</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitAddressBookLocked</name>
      <anchor>a33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitAddressBookUnlocked</name>
      <anchor>a34</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitAddressBookChanged</name>
      <anchor>a35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>resourceLoadingFinished</name>
      <anchor>j0</anchor>
      <arglist>(Resource *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>resourceSavingFinished</name>
      <anchor>j1</anchor>
      <arglist>(Resource *)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>resourceLoadingError</name>
      <anchor>j2</anchor>
      <arglist>(Resource *, const QString &amp;)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>resourceSavingError</name>
      <anchor>j3</anchor>
      <arglist>(Resource *, const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>deleteRemovedAddressees</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setStandardResource</name>
      <anchor>b1</anchor>
      <arglist>(Resource *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Resource *</type>
      <name>standardResource</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>KRES::Manager&lt; Resource &gt; *</type>
      <name>resourceManager</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>StdAddressBook</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>Q_OBJECT friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, const AddressBook &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n2</anchor>
      <arglist>(QDataStream &amp;, AddressBook &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressBook::ConstIterator</name>
    <filename>classKABC_1_1AddressBook_1_1ConstIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a1</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a2</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Addressee *</type>
      <name>operator-&gt;</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a8</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a11</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a12</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>ConstIteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressBook::Iterator</name>
    <filename>classKABC_1_1AddressBook_1_1Iterator.html</filename>
    <member kind="function">
      <type></type>
      <name>Iterator</name>
      <anchor>a1</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee *</type>
      <name>operator-&gt;</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a8</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a11</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a12</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>IteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressBook::Iterator</name>
    <filename>classKABC_1_1AddressBook_1_1Iterator.html</filename>
    <member kind="function">
      <type></type>
      <name>Iterator</name>
      <anchor>a1</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee *</type>
      <name>operator-&gt;</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a8</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a11</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a12</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>IteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressBook::ConstIterator</name>
    <filename>classKABC_1_1AddressBook_1_1ConstIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a1</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a2</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Addressee *</type>
      <name>operator-&gt;</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a8</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a10</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a11</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a12</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>ConstIteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddresseeItem</name>
    <filename>classKABC_1_1AddresseeItem.html</filename>
    <base>QListViewItem</base>
    <member kind="enumeration">
      <name>columns</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AddresseeItem</name>
      <anchor>a0</anchor>
      <arglist>(QListView *parent, const Addressee &amp;addressee)</arglist>
    </member>
    <member kind="function">
      <type>Addressee</type>
      <name>addressee</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>key</name>
      <anchor>a2</anchor>
      <arglist>(int column, bool ascending) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddresseeDialog</name>
    <filename>classKABC_1_1AddresseeDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>AddresseeDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, bool multiple=false)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AddresseeDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee</type>
      <name>addressee</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>addressees</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Addressee</type>
      <name>getAddressee</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *parent)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Addressee::List</type>
      <name>getAddressees</name>
      <anchor>e1</anchor>
      <arglist>(QWidget *parent)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>addressBookChanged</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddresseeList</name>
    <filename>classKABC_1_1AddresseeList.html</filename>
    <base>QValueList&lt; Addressee &gt;</base>
    <member kind="function">
      <type></type>
      <name>AddresseeList</name>
      <anchor>a2</anchor>
      <arglist>(const AddresseeList &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AddresseeList</name>
      <anchor>a3</anchor>
      <arglist>(const QValueList&lt; Addressee &gt; &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setReverseSorting</name>
      <anchor>a5</anchor>
      <arglist>(bool r=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>reverseSorting</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sortBy</name>
      <anchor>a7</anchor>
      <arglist>(SortingCriterion c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sortByField</name>
      <anchor>a8</anchor>
      <arglist>(Field *field=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sort</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>sortByTrait</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SortingCriterion</type>
      <name>sortingCriterion</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Field *</type>
      <name>sortingField</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::AddressLineEdit</name>
    <filename>classKABC_1_1AddressLineEdit.html</filename>
    <base>KLineEdit</base>
    <member kind="slot">
      <type>void</type>
      <name>cursorAtEnd</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>enableCompletion</name>
      <anchor>i1</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AddressLineEdit</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, bool useCompletion=true, const char *name=0L)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setFont</name>
      <anchor>a2</anchor>
      <arglist>(const QFont &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KConfig *</type>
      <name>config</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>loadAddresses</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addAddress</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b2</anchor>
      <arglist>(QKeyEvent *)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>dropEvent</name>
      <anchor>b3</anchor>
      <arglist>(QDropEvent *e)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>paste</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>insert</name>
      <anchor>b5</anchor>
      <arglist>(const QString &amp;t)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b6</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>doCompletion</name>
      <anchor>b7</anchor>
      <arglist>(bool ctrlT)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Agent</name>
    <filename>classKABC_1_1Agent.html</filename>
    <member kind="function">
      <type></type>
      <name>Agent</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Agent</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Agent</name>
      <anchor>a2</anchor>
      <arglist>(Addressee *addressee)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Agent</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a4</anchor>
      <arglist>(const Agent &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a5</anchor>
      <arglist>(const Agent &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>Agent &amp;</type>
      <name>operator=</name>
      <anchor>a6</anchor>
      <arglist>(const Agent &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUrl</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;url)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAddressee</name>
      <anchor>a8</anchor>
      <arglist>(Addressee *addressee)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isIntern</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>url</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Addressee *</type>
      <name>addressee</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>asString</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const Agent &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, Agent &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionList</name>
    <filename>classKABC_1_1DistributionList.html</filename>
    <member kind="function">
      <type></type>
      <name>DistributionList</name>
      <anchor>a0</anchor>
      <arglist>(DistributionListManager *manager, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DistributionList</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertEntry</name>
      <anchor>a4</anchor>
      <arglist>(const Addressee &amp;, const QString &amp;email=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeEntry</name>
      <anchor>a5</anchor>
      <arglist>(const Addressee &amp;, const QString &amp;email=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>emails</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Entry::List</type>
      <name>entries</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KABC::DistributionList::Entry</name>
    <filename>structKABC_1_1DistributionList_1_1Entry.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Entry &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Entry</name>
      <anchor>a1</anchor>
      <arglist>(const Addressee &amp;_addressee, const QString &amp;_email)</arglist>
    </member>
    <member kind="variable">
      <type>Addressee</type>
      <name>addressee</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>email</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>KABC::DistributionList::Entry</name>
    <filename>structKABC_1_1DistributionList_1_1Entry.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Entry &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Entry</name>
      <anchor>a1</anchor>
      <arglist>(const Addressee &amp;_addressee, const QString &amp;_email)</arglist>
    </member>
    <member kind="variable">
      <type>Addressee</type>
      <name>addressee</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>email</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionListManager</name>
    <filename>classKABC_1_1DistributionListManager.html</filename>
    <member kind="function">
      <type></type>
      <name>DistributionListManager</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~DistributionListManager</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DistributionList *</type>
      <name>list</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchor>a3</anchor>
      <arglist>(DistributionList *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a4</anchor>
      <arglist>(DistributionList *)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>listNames</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionListWatcher</name>
    <filename>classKABC_1_1DistributionListWatcher.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>changed</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DistributionListWatcher *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionListDialog</name>
    <filename>classKABC_1_1DistributionListDialog.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>DistributionListDialog</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *ab, QWidget *parent)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DistributionListDialog</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::EmailSelector</name>
    <filename>classKABC_1_1EmailSelector.html</filename>
    <base>KDialogBase</base>
    <member kind="function">
      <type></type>
      <name>EmailSelector</name>
      <anchor>a0</anchor>
      <arglist>(const QStringList &amp;emails, const QString &amp;current, QWidget *parent)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>selected</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getEmail</name>
      <anchor>e0</anchor>
      <arglist>(const QStringList &amp;emails, const QString &amp;current, QWidget *parent)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionListEditorWidget</name>
    <filename>classKABC_1_1DistributionListEditorWidget.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>DistributionListEditorWidget</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *, QWidget *parent)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::DistributionListEditor</name>
    <filename>classKABC_1_1DistributionListEditor.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>DistributionListEditor</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *, QWidget *parent)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::ErrorHandler</name>
    <filename>classKABC_1_1ErrorHandler.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>error</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;msg)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::ConsoleErrorHandler</name>
    <filename>classKABC_1_1ConsoleErrorHandler.html</filename>
    <base>KABC::ErrorHandler</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>error</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::GUIErrorHandler</name>
    <filename>classKABC_1_1GUIErrorHandler.html</filename>
    <base>KABC::ErrorHandler</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>error</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::GuiErrorHandler</name>
    <filename>classKABC_1_1GuiErrorHandler.html</filename>
    <base>KABC::ErrorHandler</base>
    <member kind="function">
      <type></type>
      <name>GuiErrorHandler</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>error</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Format</name>
    <filename>classKABC_1_1Format.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>load</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *, const QString &amp;fileName)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>save</name>
      <anchor>a1</anchor>
      <arglist>(AddressBook *, const QString &amp;fileName)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::FormatFactory</name>
    <filename>classKABC_1_1FormatFactory.html</filename>
    <member kind="function">
      <type></type>
      <name>~FormatFactory</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FormatPlugin *</type>
      <name>format</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>formats</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FormatInfo *</type>
      <name>info</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>FormatFactory *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::FormatPlugin</name>
    <filename>classKABC_1_1FormatPlugin.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>load</name>
      <anchor>a0</anchor>
      <arglist>(Addressee &amp;, QFile *file)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>loadAll</name>
      <anchor>a1</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>save</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;, QFile *file)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>saveAll</name>
      <anchor>a3</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>checkFormat</name>
      <anchor>a4</anchor>
      <arglist>(QFile *file) const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::BinaryFormat</name>
    <filename>classKABC_1_1BinaryFormat.html</filename>
    <base>KABC::FormatPlugin</base>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a0</anchor>
      <arglist>(Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadAll</name>
      <anchor>a1</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveAll</name>
      <anchor>a3</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFormat</name>
      <anchor>a4</anchor>
      <arglist>(QFile *file) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Geo</name>
    <filename>classKABC_1_1Geo.html</filename>
    <member kind="function">
      <type></type>
      <name>Geo</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Geo</name>
      <anchor>a1</anchor>
      <arglist>(float latitude, float longitude)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLatitude</name>
      <anchor>a2</anchor>
      <arglist>(float)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>latitude</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLongitude</name>
      <anchor>a4</anchor>
      <arglist>(float)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>longitude</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a7</anchor>
      <arglist>(const Geo &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a8</anchor>
      <arglist>(const Geo &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>asString</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const Geo &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, Geo &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Key</name>
    <filename>classKABC_1_1Key.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Key &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueList&lt; int &gt;</type>
      <name>TypeList</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Types</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Key</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;text=QString::null, int type=PGP)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Key</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a2</anchor>
      <arglist>(const Key &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a3</anchor>
      <arglist>(const Key &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setId</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>id</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBinaryData</name>
      <anchor>a6</anchor>
      <arglist>(const QByteArray &amp;binary)</arglist>
    </member>
    <member kind="function">
      <type>QByteArray</type>
      <name>binaryData</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTextData</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>textData</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isBinary</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a11</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustomTypeString</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;custom)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>customTypeString</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>TypeList</type>
      <name>typeList</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>typeLabel</name>
      <anchor>e1</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const Key &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, Key &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::LdapObject</name>
    <filename>classKABC_1_1LdapObject.html</filename>
    <member kind="function">
      <type></type>
      <name>LdapObject</name>
      <anchor>a1</anchor>
      <arglist>(QString _dn)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LdapObject</name>
      <anchor>a2</anchor>
      <arglist>(const LdapObject &amp;that)</arglist>
    </member>
    <member kind="function">
      <type>LdapObject &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const LdapObject &amp;that)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>dn</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>LdapAttrMap</type>
      <name>attrs</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>assign</name>
      <anchor>b0</anchor>
      <arglist>(const LdapObject &amp;that)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::LdapClient</name>
    <filename>classKABC_1_1LdapClient.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>setHost</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;host)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>host</name>
      <anchor>i1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPort</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;port)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>port</name>
      <anchor>i3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBase</name>
      <anchor>i4</anchor>
      <arglist>(const QString &amp;base)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>base</name>
      <anchor>i5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setBindDN</name>
      <anchor>i6</anchor>
      <arglist>(const QString &amp;bindDN)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>bindDN</name>
      <anchor>i7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setPwdBindDN</name>
      <anchor>i8</anchor>
      <arglist>(const QString &amp;pwdBindDN)</arglist>
    </member>
    <member kind="slot">
      <type>QString</type>
      <name>pwdBindDN</name>
      <anchor>i9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setAttrs</name>
      <anchor>i10</anchor>
      <arglist>(const QStringList &amp;attrs)</arglist>
    </member>
    <member kind="slot">
      <type>QStringList</type>
      <name>attrs</name>
      <anchor>i11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setScope</name>
      <anchor>i12</anchor>
      <arglist>(const QString scope)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>startQuery</name>
      <anchor>i13</anchor>
      <arglist>(const QString &amp;filter)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>cancelQuery</name>
      <anchor>i14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>done</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>error</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>result</name>
      <anchor>l2</anchor>
      <arglist>(const KABC::LdapObject &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>LdapClient</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isActive</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotData</name>
      <anchor>j0</anchor>
      <arglist>(KIO::Job *, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotInfoMessage</name>
      <anchor>j1</anchor>
      <arglist>(KIO::Job *, const QString &amp;info)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotDone</name>
      <anchor>j2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>startParseLDIF</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>parseLDIF</name>
      <anchor>b1</anchor>
      <arglist>(const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>endParseLDIF</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mHost</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mPort</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mBase</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mScope</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>mAttrs</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QGuardedPtr&lt; KIO::SimpleJob &gt;</type>
      <name>mJob</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>mActive</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>LdapObject</type>
      <name>mCurrentObject</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>mBuf</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>mLastAttrName</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QCString</type>
      <name>mLastAttrValue</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>mIsBase64</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::LdapSearch</name>
    <filename>classKABC_1_1LdapSearch.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>searchData</name>
      <anchor>l0</anchor>
      <arglist>(const QStringList &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>searchDone</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>startSearch</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;txt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancelSearch</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAvailable</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Lock</name>
    <filename>classKABC_1_1Lock.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>locked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>unlocked</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Lock</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;identifier)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Lock</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>lock</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>unlock</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>error</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>lockFileName</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>readLockFile</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, int &amp;pid, QString &amp;app)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>writeLockFile</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>locksDir</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::LockNull</name>
    <filename>classKABC_1_1LockNull.html</filename>
    <base>KABC::Lock</base>
    <member kind="function">
      <type></type>
      <name>LockNull</name>
      <anchor>a0</anchor>
      <arglist>(bool allowAccess)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>lock</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unlock</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>error</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::PhoneNumber</name>
    <filename>classKABC_1_1PhoneNumber.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; PhoneNumber &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QValueList&lt; int &gt;</type>
      <name>TypeList</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Types</name>
      <anchor>w16</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PhoneNumber</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PhoneNumber</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;number, int type=Home)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~PhoneNumber</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a3</anchor>
      <arglist>(const PhoneNumber &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a4</anchor>
      <arglist>(const PhoneNumber &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setId</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>id</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumber</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>number</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>type</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>typeLabel</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>TypeList</type>
      <name>typeList</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>typeLabel</name>
      <anchor>e1</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>label</name>
      <anchor>e2</anchor>
      <arglist>(int type)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const PhoneNumber &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, PhoneNumber &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::ResourceFile</name>
    <filename>classKABC_1_1ResourceFile.html</filename>
    <member kind="function">
      <type></type>
      <name>ResourceFile</name>
      <anchor>a0</anchor>
      <arglist>(const KConfig *cfg)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResourceFile</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;fileName, const QString &amp;formatName=&quot;vcard&quot;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~ResourceFile</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>writeConfig</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *cfg)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>doOpen</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doClose</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Ticket *</type>
      <name>requestSaveTicket</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>releaseSaveTicket</name>
      <anchor>a7</anchor>
      <arglist>(Ticket *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>load</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>asyncLoad</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>save</name>
      <anchor>a10</anchor>
      <arglist>(Ticket *ticket)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>asyncSave</name>
      <anchor>a11</anchor>
      <arglist>(Ticket *ticket)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileName</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFormat</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>format</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeAddressee</name>
      <anchor>a16</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>fileChanged</name>
      <anchor>j0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;fileName, const QString &amp;format)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>lock</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>unlock</name>
      <anchor>b2</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Ticket</name>
    <filename>classKABC_1_1Ticket.html</filename>
    <member kind="function">
      <type>Resource *</type>
      <name>resource</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Resource</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Resource::ConstIterator</name>
    <filename>classKABC_1_1Resource_1_1ConstIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a1</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a2</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a10</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a11</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>ConstIteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Resource::Iterator</name>
    <filename>classKABC_1_1Resource_1_1Iterator.html</filename>
    <member kind="function">
      <type></type>
      <name>Iterator</name>
      <anchor>a1</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a10</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a11</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>IteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Resource::Iterator</name>
    <filename>classKABC_1_1Resource_1_1Iterator.html</filename>
    <member kind="function">
      <type></type>
      <name>Iterator</name>
      <anchor>a1</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Iterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a10</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a11</anchor>
      <arglist>(const Iterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>IteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Resource::ConstIterator</name>
    <filename>classKABC_1_1Resource_1_1ConstIterator.html</filename>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a1</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ConstIterator</name>
      <anchor>a2</anchor>
      <arglist>(const Iterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator=</name>
      <anchor>a4</anchor>
      <arglist>(const ConstIterator &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const Addressee &amp;</type>
      <name>operator *</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator++</name>
      <anchor>a7</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ConstIterator &amp;</type>
      <name>operator--</name>
      <anchor>a9</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a10</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a11</anchor>
      <arglist>(const ConstIterator &amp;it)</arglist>
    </member>
    <member kind="variable">
      <type>ConstIteratorData *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::ResourceSelectDialog</name>
    <filename>classKABC_1_1ResourceSelectDialog.html</filename>
    <base protection="private">KDialog</base>
    <member kind="function">
      <type></type>
      <name>ResourceSelectDialog</name>
      <anchor>a0</anchor>
      <arglist>(AddressBook *ab, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>Resource *</type>
      <name>resource</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>Resource *</type>
      <name>getResource</name>
      <anchor>e0</anchor>
      <arglist>(AddressBook *ab, QWidget *parent=0)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::Addressee</name>
    <filename>classKABC_1_1Addressee.html</filename>
    <member kind="typedef">
      <type>QValueList&lt; Addressee &gt;</type>
      <name>List</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>QMap&lt; QString, Addressee &gt;</type>
      <name>Map</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Addressee</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Addressee</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;)</arglist>
    </member>
    <member kind="function">
      <type>Addressee &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Addressee &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a4</anchor>
      <arglist>(const Addressee &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a5</anchor>
      <arglist>(const Addressee &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isEmpty</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUid</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;uid)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>uid</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DECLARATIONS void</type>
      <name>setNameFromString</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>realName</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>assembledName</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fullEmail</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;email=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertEmail</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;email, bool preferred=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeEmail</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;email)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>preferredEmail</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>emails</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEmails</name>
      <anchor>a17</anchor>
      <arglist>(const QStringList &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertPhoneNumber</name>
      <anchor>a18</anchor>
      <arglist>(const PhoneNumber &amp;phoneNumber)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePhoneNumber</name>
      <anchor>a19</anchor>
      <arglist>(const PhoneNumber &amp;phoneNumber)</arglist>
    </member>
    <member kind="function">
      <type>PhoneNumber</type>
      <name>phoneNumber</name>
      <anchor>a20</anchor>
      <arglist>(int type) const </arglist>
    </member>
    <member kind="function">
      <type>PhoneNumber::List</type>
      <name>phoneNumbers</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>PhoneNumber::List</type>
      <name>phoneNumbers</name>
      <anchor>a22</anchor>
      <arglist>(int type) const </arglist>
    </member>
    <member kind="function">
      <type>PhoneNumber</type>
      <name>findPhoneNumber</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertKey</name>
      <anchor>a24</anchor>
      <arglist>(const Key &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeKey</name>
      <anchor>a25</anchor>
      <arglist>(const Key &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>Key</type>
      <name>key</name>
      <anchor>a26</anchor>
      <arglist>(int type, QString customTypeString=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>Key::List</type>
      <name>keys</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeys</name>
      <anchor>a28</anchor>
      <arglist>(const Key::List &amp;keys)</arglist>
    </member>
    <member kind="function">
      <type>Key::List</type>
      <name>keys</name>
      <anchor>a29</anchor>
      <arglist>(int type, QString customTypeString=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>Key</type>
      <name>findKey</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertAddress</name>
      <anchor>a31</anchor>
      <arglist>(const Address &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAddress</name>
      <anchor>a32</anchor>
      <arglist>(const Address &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>Address</type>
      <name>address</name>
      <anchor>a33</anchor>
      <arglist>(int type) const </arglist>
    </member>
    <member kind="function">
      <type>Address::List</type>
      <name>addresses</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Address::List</type>
      <name>addresses</name>
      <anchor>a35</anchor>
      <arglist>(int type) const </arglist>
    </member>
    <member kind="function">
      <type>Address</type>
      <name>findAddress</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;id) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertCategory</name>
      <anchor>a37</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeCategory</name>
      <anchor>a38</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasCategory</name>
      <anchor>a39</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCategories</name>
      <anchor>a40</anchor>
      <arglist>(const QStringList &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>categories</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertCustom</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;app, const QString &amp;name, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeCustom</name>
      <anchor>a43</anchor>
      <arglist>(const QString &amp;app, const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>custom</name>
      <anchor>a44</anchor>
      <arglist>(const QString &amp;app, const QString &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCustoms</name>
      <anchor>a45</anchor>
      <arglist>(const QStringList &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>customs</name>
      <anchor>a46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>asString</name>
      <anchor>a48</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setResource</name>
      <anchor>a49</anchor>
      <arglist>(Resource *resource)</arglist>
    </member>
    <member kind="function">
      <type>Resource *</type>
      <name>resource</name>
      <anchor>a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChanged</name>
      <anchor>a51</anchor>
      <arglist>(bool value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>changed</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a53</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>uidLabel</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>parseEmailAddress</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;rawEmail, QString &amp;fullName, QString &amp;email)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setSortKey</name>
      <anchor>e2</anchor>
      <arglist>(KABC::Field *field)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const Addressee &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, Addressee &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::StdAddressBook</name>
    <filename>classKABC_1_1StdAddressBook.html</filename>
    <base>KABC::AddressBook</base>
    <member kind="function">
      <type></type>
      <name>~StdAddressBook</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Addressee</type>
      <name>whoAmI</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWhoAmI</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>StdAddressBook *</type>
      <name>self</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>StdAddressBook *</type>
      <name>self</name>
      <anchor>e1</anchor>
      <arglist>(bool asyncronous)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>save</name>
      <anchor>e2</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>handleCrash</name>
      <anchor>e3</anchor>
      <arglist>() KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>fileName</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>directoryName</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setAutomaticSave</name>
      <anchor>e6</anchor>
      <arglist>(bool state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>close</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>automaticSave</name>
      <anchor>e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>StdAddressBook</name>
      <anchor>b1</anchor>
      <arglist>(bool asynchronous)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>init</name>
      <anchor>b2</anchor>
      <arglist>(bool asynchronous)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::TimeZone</name>
    <filename>classKABC_1_1TimeZone.html</filename>
    <member kind="function">
      <type></type>
      <name>TimeZone</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimeZone</name>
      <anchor>a1</anchor>
      <arglist>(int offset)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOffset</name>
      <anchor>a2</anchor>
      <arglist>(int offset)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>offset</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a5</anchor>
      <arglist>(const TimeZone &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a6</anchor>
      <arglist>(const TimeZone &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>asString</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>n0</anchor>
      <arglist>(QDataStream &amp;, const TimeZone &amp;)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend QDataStream &amp;</type>
      <name>operator&gt;&gt;</name>
      <anchor>n1</anchor>
      <arglist>(QDataStream &amp;, TimeZone &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::VCard21Parser</name>
    <filename>classKABC_1_1VCard21Parser.html</filename>
    <member kind="function">
      <type></type>
      <name>VCard21Parser</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~VCard21Parser</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readFromString</name>
      <anchor>a2</anchor>
      <arglist>(KABC::AddressBook *ab, const QString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>KABC::Addressee</type>
      <name>readFromString</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>KABC::Address</type>
      <name>readAddressFromQStringList</name>
      <anchor>e0</anchor>
      <arglist>(const QStringList &amp;data, const int type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::VCardConverter</name>
    <filename>classKABC_1_1VCardConverter.html</filename>
    <member kind="enumeration">
      <name>Version</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>VCardConverter</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~VCardConverter</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>createVCard</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;addr, Version version=v3_0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>createVCards</name>
      <anchor>a3</anchor>
      <arglist>(Addressee::List list, Version version=v3_0)</arglist>
    </member>
    <member kind="function">
      <type>Addressee</type>
      <name>parseVCard</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;vcard)</arglist>
    </member>
    <member kind="function">
      <type>Addressee::List</type>
      <name>parseVCards</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;vcard)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>vCardToAddressee</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;, Addressee &amp;, Version version=v3_0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addresseeToVCard</name>
      <anchor>a7</anchor>
      <arglist>(const Addressee &amp;, QString &amp;, Version version=v3_0) KDE_DEPRECATED</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::VCardFormat</name>
    <filename>classKABC_1_1VCardFormat.html</filename>
    <base>KABC::Format</base>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a2</anchor>
      <arglist>(AddressBook *, const QString &amp;fileName)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a3</anchor>
      <arglist>(AddressBook *, const QString &amp;fileName)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::VCardFormatImpl</name>
    <filename>classKABC_1_1VCardFormatImpl.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a0</anchor>
      <arglist>(Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadAll</name>
      <anchor>a1</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveAll</name>
      <anchor>a3</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readFromString</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;vcard, Addressee &amp;addr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeToString</name>
      <anchor>a5</anchor>
      <arglist>(const Addressee &amp;addressee, QString &amp;vcard)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>loadAddressee</name>
      <anchor>b0</anchor>
      <arglist>(Addressee &amp;, VCARD::VCard &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>saveAddressee</name>
      <anchor>b1</anchor>
      <arglist>(const Addressee &amp;, VCARD::VCard *, bool intern)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addTextValue</name>
      <anchor>b2</anchor>
      <arglist>(VCARD::VCard *, VCARD::EntityType, const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QString</type>
      <name>readTextValue</name>
      <anchor>b3</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addDateValue</name>
      <anchor>b4</anchor>
      <arglist>(VCARD::VCard *, VCARD::EntityType, const QDate &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QDate</type>
      <name>readDateValue</name>
      <anchor>b5</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addDateTimeValue</name>
      <anchor>b6</anchor>
      <arglist>(VCARD::VCard *, VCARD::EntityType, const QDateTime &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>QDateTime</type>
      <name>readDateTimeValue</name>
      <anchor>b7</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addAddressValue</name>
      <anchor>b8</anchor>
      <arglist>(VCARD::VCard *, const Address &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Address</type>
      <name>readAddressValue</name>
      <anchor>b9</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addLabelValue</name>
      <anchor>b10</anchor>
      <arglist>(VCARD::VCard *, const Address &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addTelephoneValue</name>
      <anchor>b11</anchor>
      <arglist>(VCARD::VCard *, const PhoneNumber &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>PhoneNumber</type>
      <name>readTelephoneValue</name>
      <anchor>b12</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addNValue</name>
      <anchor>b13</anchor>
      <arglist>(VCARD::VCard *, const Addressee &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>readNValue</name>
      <anchor>b14</anchor>
      <arglist>(VCARD::ContentLine *, Addressee &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addCustomValue</name>
      <anchor>b15</anchor>
      <arglist>(VCARD::VCard *, const QString &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addAddressParam</name>
      <anchor>b16</anchor>
      <arglist>(VCARD::ContentLine *, int)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>readAddressParam</name>
      <anchor>b17</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addGeoValue</name>
      <anchor>b18</anchor>
      <arglist>(VCARD::VCard *, const Geo &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Geo</type>
      <name>readGeoValue</name>
      <anchor>b19</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addUTCValue</name>
      <anchor>b20</anchor>
      <arglist>(VCARD::VCard *, const TimeZone &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>TimeZone</type>
      <name>readUTCValue</name>
      <anchor>b21</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addClassValue</name>
      <anchor>b22</anchor>
      <arglist>(VCARD::VCard *, const Secrecy &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Secrecy</type>
      <name>readClassValue</name>
      <anchor>b23</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addKeyValue</name>
      <anchor>b24</anchor>
      <arglist>(VCARD::VCard *, const Key &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Key</type>
      <name>readKeyValue</name>
      <anchor>b25</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addPictureValue</name>
      <anchor>b26</anchor>
      <arglist>(VCARD::VCard *, VCARD::EntityType, const Picture &amp;, const Addressee &amp;, bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Picture</type>
      <name>readPictureValue</name>
      <anchor>b27</anchor>
      <arglist>(VCARD::ContentLine *, VCARD::EntityType, const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addSoundValue</name>
      <anchor>b28</anchor>
      <arglist>(VCARD::VCard *, const Sound &amp;, const Addressee &amp;, bool)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Sound</type>
      <name>readSoundValue</name>
      <anchor>b29</anchor>
      <arglist>(VCARD::ContentLine *, const Addressee &amp;addr)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>addAgentValue</name>
      <anchor>b30</anchor>
      <arglist>(VCARD::VCard *, const Agent &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>Agent</type>
      <name>readAgentValue</name>
      <anchor>b31</anchor>
      <arglist>(VCARD::ContentLine *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KABC::VCardFormatPlugin</name>
    <filename>classKABC_1_1VCardFormatPlugin.html</filename>
    <base>KABC::FormatPlugin</base>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a2</anchor>
      <arglist>(Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadAll</name>
      <anchor>a3</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a4</anchor>
      <arglist>(const Addressee &amp;, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveAll</name>
      <anchor>a5</anchor>
      <arglist>(AddressBook *, Resource *, QFile *file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>checkFormat</name>
      <anchor>a6</anchor>
      <arglist>(QFile *file) const </arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KABC::LDIFConverter</name>
    <filename>namespaceKABC_1_1LDIFConverter.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>LDIFToAddressee</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;str, AddresseeList &amp;addrList, QDateTime dt=QDateTime::currentDateTime())</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addresseeToLDIF</name>
      <anchor>a1</anchor>
      <arglist>(const AddresseeList &amp;addrList, QString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addresseeToLDIF</name>
      <anchor>a2</anchor>
      <arglist>(const Addressee &amp;addr, QString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>makeLDIFfieldString</name>
      <anchor>a3</anchor>
      <arglist>(QString field, QString value, bool allowEncode=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>parseSingleLine</name>
      <anchor>a4</anchor>
      <arglist>(Addressee &amp;a, Address &amp;homeAddr, Address &amp;workAddr, QString &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>splitLine</name>
      <anchor>a5</anchor>
      <arglist>(QString &amp;line, QString &amp;fieldname, QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>evaluatePair</name>
      <anchor>a6</anchor>
      <arglist>(Addressee &amp;a, Address &amp;homeAddr, Address &amp;workAddr, QString &amp;fieldname, QString &amp;value)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KABC::SortingTraits</name>
    <filename>namespaceKABC_1_1SortingTraits.html</filename>
  </compound>
</tagfile>
