<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>Generic interface for building scripting engines</title>
    <filename>index</filename>
  </compound>
  <compound kind="class">
    <name>KFileAudioPreview</name>
    <filename>classKFileAudioPreview.html</filename>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>showPreview</name>
      <anchor>i0</anchor>
      <arglist>(const KURL &amp;url)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>clearPreview</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KFileAudioPreview</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KRegExpEditorInterface</name>
    <filename>classKRegExpEditorInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>regExp</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setRegExp</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;regexp)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>redo</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>undo</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setMatchText</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>doSomething</name>
      <anchor>a5</anchor>
      <arglist>(QString method, void *arguments)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>canUndo</name>
      <anchor>b0</anchor>
      <arglist>(bool)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>canRedo</name>
      <anchor>b1</anchor>
      <arglist>(bool)=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual void</type>
      <name>changes</name>
      <anchor>b2</anchor>
      <arglist>(bool)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KScriptClientInterface</name>
    <filename>classKScriptClientInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>error</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;msg)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>warning</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;msg)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>output</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;msg)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>progress</name>
      <anchor>a3</anchor>
      <arglist>(int percent)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>done</name>
      <anchor>a4</anchor>
      <arglist>(KScriptClientInterface::Result result, const QVariant &amp;returned)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KScriptInterface</name>
    <filename>classKScriptInterface.html</filename>
    <base>QObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>script</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setScript</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;scriptFile)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setScript</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;scriptLibFile, const QString &amp;method)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>run</name>
      <anchor>a3</anchor>
      <arglist>(QObject *context=0, const QVariant &amp;arg=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>kill</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="variable">
      <type>KScriptClientInterface *</type>
      <name>ScriptClientInterface</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KScriptManager</name>
    <filename>classKScriptManager.html</filename>
    <base>QObject</base>
    <base>KScriptClientInterface</base>
    <member kind="slot">
      <type>void</type>
      <name>runScript</name>
      <anchor>i0</anchor>
      <arglist>(const QString &amp;scriptName, QObject *context=0, const QVariant &amp;arg=0)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>scriptError</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>scriptWarning</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>scriptOutput</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>scriptProgress</name>
      <anchor>l3</anchor>
      <arglist>(int percent)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>scriptDone</name>
      <anchor>l4</anchor>
      <arglist>(KScriptClientInterface::Result result, const QVariant &amp;returned)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>KScriptManager</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~KScriptManager</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>addScript</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;scriptDesktopFile)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeScript</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;scriptName)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>scripts</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>error</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>warning</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>output</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>progress</name>
      <anchor>a9</anchor>
      <arglist>(int percent)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>done</name>
      <anchor>a10</anchor>
      <arglist>(KScriptClientInterface::Result result, const QVariant &amp;returned)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QDict&lt; ScriptInfo &gt;</type>
      <name>m_scripts</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QDict&lt; KScriptInterface &gt;</type>
      <name>m_scriptCache</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>m_currentScript</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TermEmuInterface</name>
    <filename>classTermEmuInterface.html</filename>
    <member kind="signal" virtualness="pure">
      <type>virtual void</type>
      <name>sizeChanged</name>
      <anchor>l0</anchor>
      <arglist>(int width, int height)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setCursorShown</name>
      <anchor>a0</anchor>
      <arglist>(const bool)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isCursorShown</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setInteractive</name>
      <anchor>a2</anchor>
      <arglist>(const bool)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isInteractive</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setProcess</name>
      <anchor>a4</anchor>
      <arglist>(KProcess *proc)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TerminalInterface</name>
    <filename>classTerminalInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>startProgram</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;program, const QStrList &amp;args)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>showShellInDir</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;dir)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>sendInput</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text)=0</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KHE</name>
    <filename>namespaceKHE.html</filename>
    <class kind="class">KHE::BytesEditInterface</class>
    <class kind="class">KHE::CharColumnInterface</class>
    <class kind="class">KHE::ClipboardInterface</class>
    <class kind="class">KHE::ValueColumnInterface</class>
    <class kind="class">KHE::ZoomInterface</class>
    <member kind="function">
      <type>BytesEditInterface *</type>
      <name>bytesEditInterface</name>
      <anchor>a0</anchor>
      <arglist>(T *t)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>createBytesEditWidget</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *Parent=0, const char *Name=0)</arglist>
    </member>
    <member kind="function">
      <type>CharColumnInterface *</type>
      <name>charColumnInterface</name>
      <anchor>a2</anchor>
      <arglist>(T *t)</arglist>
    </member>
    <member kind="function">
      <type>ClipboardInterface *</type>
      <name>clipboardInterface</name>
      <anchor>a3</anchor>
      <arglist>(T *t)</arglist>
    </member>
    <member kind="function">
      <type>ValueColumnInterface *</type>
      <name>valueColumnInterface</name>
      <anchor>a4</anchor>
      <arglist>(T *t)</arglist>
    </member>
    <member kind="function">
      <type>ZoomInterface *</type>
      <name>zoomInterface</name>
      <anchor>a5</anchor>
      <arglist>(T *t)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHE::BytesEditInterface</name>
    <filename>classKHE_1_1BytesEditInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setData</name>
      <anchor>a0</anchor>
      <arglist>(char *D, int S, int RS=-1, bool KM=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setReadOnly</name>
      <anchor>a1</anchor>
      <arglist>(bool RO=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setMaxDataSize</name>
      <anchor>a2</anchor>
      <arglist>(int MS)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setAutoDelete</name>
      <anchor>a3</anchor>
      <arglist>(bool AD=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setKeepsMemory</name>
      <anchor>a4</anchor>
      <arglist>(bool KM=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setOverwriteOnly</name>
      <anchor>a5</anchor>
      <arglist>(bool b)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setOverwriteMode</name>
      <anchor>a6</anchor>
      <arglist>(bool b)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setModified</name>
      <anchor>a7</anchor>
      <arglist>(bool b)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual char *</type>
      <name>data</name>
      <anchor>a8</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>dataSize</name>
      <anchor>a9</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>maxDataSize</name>
      <anchor>a10</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isAutoDelete</name>
      <anchor>a11</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>keepsMemory</name>
      <anchor>a12</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isOverwriteMode</name>
      <anchor>a13</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isOverwriteOnly</name>
      <anchor>a14</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isReadOnly</name>
      <anchor>a15</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isModified</name>
      <anchor>a16</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>repaintRange</name>
      <anchor>a17</anchor>
      <arglist>(int i1, int i2)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHE::CharColumnInterface</name>
    <filename>classKHE_1_1CharColumnInterface.html</filename>
    <member kind="enumeration">
      <name>KEncoding</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LocalEncoding</name>
      <anchor>w4w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ISO8859_1Encoding</name>
      <anchor>w4w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setShowUnprintable</name>
      <anchor>a0</anchor>
      <arglist>(bool SU=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setSubstituteChar</name>
      <anchor>a1</anchor>
      <arglist>(QChar SC)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setEncoding</name>
      <anchor>a2</anchor>
      <arglist>(KEncoding C)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>showUnprintable</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QChar</type>
      <name>substituteChar</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual KEncoding</type>
      <name>encoding</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHE::ClipboardInterface</name>
    <filename>classKHE_1_1ClipboardInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>copy</name>
      <anchor>a0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cut</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>paste</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>copyAvailable</name>
      <anchor>a3</anchor>
      <arglist>(bool Really)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHE::ValueColumnInterface</name>
    <filename>classKHE_1_1ValueColumnInterface.html</filename>
    <member kind="enumeration">
      <name>KCoding</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HexadecimalCoding</name>
      <anchor>w9w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DecimalCoding</name>
      <anchor>w9w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OctalCoding</name>
      <anchor>w9w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BinaryCoding</name>
      <anchor>w9w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KResizeStyle</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NoResize</name>
      <anchor>w10w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LockGrouping</name>
      <anchor>w10w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FullSizeUsage</name>
      <anchor>w10w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual KResizeStyle</type>
      <name>resizeStyle</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>noOfBytesPerLine</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual KCoding</type>
      <name>coding</name>
      <anchor>a2</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>byteSpacingWidth</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>noOfGroupedBytes</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>groupSpacingWidth</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>binaryGapWidth</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setResizeStyle</name>
      <anchor>a7</anchor>
      <arglist>(KResizeStyle Style)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setNoOfBytesPerLine</name>
      <anchor>a8</anchor>
      <arglist>(int NoCpL)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setCoding</name>
      <anchor>a9</anchor>
      <arglist>(KCoding C)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setByteSpacingWidth</name>
      <anchor>a10</anchor>
      <arglist>(int BSW)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setNoOfGroupedBytes</name>
      <anchor>a11</anchor>
      <arglist>(int NoGB)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setGroupSpacingWidth</name>
      <anchor>a12</anchor>
      <arglist>(int GSW)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setBinaryGapWidth</name>
      <anchor>a13</anchor>
      <arglist>(int BGW)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KHE::ZoomInterface</name>
    <filename>classKHE_1_1ZoomInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zoomIn</name>
      <anchor>a0</anchor>
      <arglist>(int PointInc)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zoomIn</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zoomOut</name>
      <anchor>a2</anchor>
      <arglist>(int PointDec)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zoomOut</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>zoomTo</name>
      <anchor>a4</anchor>
      <arglist>(int PointSize)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>unZoom</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KMediaPlayer</name>
    <filename>namespaceKMediaPlayer.html</filename>
    <class kind="class">KMediaPlayer::Player</class>
    <class kind="class">KMediaPlayer::View</class>
  </compound>
  <compound kind="class">
    <name>KMediaPlayer::Player</name>
    <filename>classKMediaPlayer_1_1Player.html</filename>
    <base>KParts::ReadOnlyPart</base>
    <member kind="enumeration">
      <name>State</name>
      <anchor>w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Empty</name>
      <anchor>w4w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Stop</name>
      <anchor>w4w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Pause</name>
      <anchor>w4w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Play</name>
      <anchor>w4w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>pause</name>
      <anchor>i0</anchor>
      <arglist>(void)=0</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>play</name>
      <anchor>i1</anchor>
      <arglist>(void)=0</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>stop</name>
      <anchor>i2</anchor>
      <arglist>(void)=0</arglist>
    </member>
    <member kind="slot" virtualness="pure">
      <type>virtual void</type>
      <name>seek</name>
      <anchor>i3</anchor>
      <arglist>(unsigned long msec)=0</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setLooping</name>
      <anchor>i4</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>loopingChanged</name>
      <anchor>l0</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>stateChanged</name>
      <anchor>l1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Player</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Player</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual View *</type>
      <name>view</name>
      <anchor>a3</anchor>
      <arglist>(void)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>isSeekable</name>
      <anchor>a4</anchor>
      <arglist>(void) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned long</type>
      <name>position</name>
      <anchor>a5</anchor>
      <arglist>(void) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>hasLength</name>
      <anchor>a6</anchor>
      <arglist>(void) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned long</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>(void) const=0</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLooping</name>
      <anchor>a8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>state</name>
      <anchor>a9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>setState</name>
      <anchor>j0</anchor>
      <arglist>(int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KMediaPlayer::View</name>
    <filename>classKMediaPlayer_1_1View.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>Button</name>
      <anchor>w5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Play</name>
      <anchor>w5w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Stop</name>
      <anchor>w5w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Pause</name>
      <anchor>w5w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Seeker</name>
      <anchor>w5w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>All</name>
      <anchor>w5w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setButtons</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>bool</type>
      <name>button</name>
      <anchor>i1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>showButton</name>
      <anchor>i2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>hideButton</name>
      <anchor>i3</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>toggleButton</name>
      <anchor>i4</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>buttonsChanged</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>View</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>buttons</name>
      <anchor>a2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>videoWidget</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setVideoWidget</name>
      <anchor>b0</anchor>
      <arglist>(QWidget *videoWidget)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>KTextEditor</name>
    <filename>namespaceKTextEditor.html</filename>
    <class kind="class">KTextEditor::BlockSelectionDCOPInterface</class>
    <class kind="class">KTextEditor::BlockSelectionInterface</class>
    <class kind="class">KTextEditor::ClipboardDCOPInterface</class>
    <class kind="class">KTextEditor::ClipboardInterface</class>
    <class kind="class">KTextEditor::CompletionEntry</class>
    <class kind="class">KTextEditor::CodeCompletionInterface</class>
    <class kind="class">KTextEditor::ConfigInterface</class>
    <class kind="class">KTextEditor::ConfigInterfaceExtension</class>
    <class kind="class">KTextEditor::Cursor</class>
    <class kind="class">KTextEditor::CursorInterface</class>
    <class kind="class">KTextEditor::Document</class>
    <class kind="class">KTextEditor::DocumentInfoDCOPInterface</class>
    <class kind="class">KTextEditor::DocumentInfoInterface</class>
    <class kind="class">KTextEditor::DynWordWrapInterface</class>
    <class kind="class">KTextEditor::EditDCOPInterface</class>
    <class kind="class">KTextEditor::EditInterface</class>
    <class kind="class">KTextEditor::EditInterfaceExt</class>
    <class kind="class">KTextEditor::Editor</class>
    <class kind="class">KTextEditor::EncodingDCOPInterface</class>
    <class kind="class">KTextEditor::EncodingInterface</class>
    <class kind="class">KTextEditor::HighlightingInterface</class>
    <class kind="class">KTextEditor::MarkInterface</class>
    <class kind="class">KTextEditor::MarkInterfaceExtension</class>
    <class kind="class">KTextEditor::Plugin</class>
    <class kind="class">KTextEditor::PluginViewInterface</class>
    <class kind="class">KTextEditor::PopupMenuInterface</class>
    <class kind="class">KTextEditor::PrintDCOPInterface</class>
    <class kind="class">KTextEditor::PrintInterface</class>
    <class kind="class">KTextEditor::SearchDCOPInterface</class>
    <class kind="class">KTextEditor::SearchInterface</class>
    <class kind="class">KTextEditor::SelectionDCOPInterface</class>
    <class kind="class">KTextEditor::SelectionExtDCOPInterface</class>
    <class kind="class">KTextEditor::SelectionInterface</class>
    <class kind="class">KTextEditor::SelectionInterfaceExt</class>
    <class kind="class">KTextEditor::SessionConfigInterface</class>
    <class kind="class">KTextEditor::TextHintInterface</class>
    <class kind="class">KTextEditor::UndoDCOPInterface</class>
    <class kind="class">KTextEditor::UndoInterface</class>
    <class kind="class">KTextEditor::View</class>
    <class kind="class">KTextEditor::ViewCursorDCOPInterface</class>
    <class kind="class">KTextEditor::ViewCursorInterface</class>
    <class kind="class">KTextEditor::ViewStatusMsgDCOPInterface</class>
    <class kind="class">KTextEditor::ViewStatusMsgInterface</class>
    <class kind="class">KTextEditor::WordWrapInterface</class>
    <member kind="function">
      <type>BlockSelectionInterface *</type>
      <name>blockSelectionInterface</name>
      <anchor>a0</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>ClipboardInterface *</type>
      <name>clipboardInterface</name>
      <anchor>a1</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>CodeCompletionInterface *</type>
      <name>codeCompletionInterface</name>
      <anchor>a2</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>ConfigInterface *</type>
      <name>configInterface</name>
      <anchor>a3</anchor>
      <arglist>(Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>ConfigInterface *</type>
      <name>configInterface</name>
      <anchor>a4</anchor>
      <arglist>(Plugin *plugin)</arglist>
    </member>
    <member kind="function">
      <type>ConfigInterfaceExtension *</type>
      <name>configInterfaceExtension</name>
      <anchor>a5</anchor>
      <arglist>(Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>ConfigInterfaceExtension *</type>
      <name>configInterfaceExtension</name>
      <anchor>a6</anchor>
      <arglist>(Plugin *plugin)</arglist>
    </member>
    <member kind="function">
      <type>CursorInterface *</type>
      <name>cursorInterface</name>
      <anchor>a7</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>Document *</type>
      <name>createDocument</name>
      <anchor>a8</anchor>
      <arglist>(const char *libname, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>DynWordWrapInterface *</type>
      <name>dynWordWrapInterface</name>
      <anchor>a9</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>EditInterface *</type>
      <name>editInterface</name>
      <anchor>a10</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>EditInterfaceExt *</type>
      <name>editInterfaceExt</name>
      <anchor>a11</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>Editor *</type>
      <name>createEditor</name>
      <anchor>a12</anchor>
      <arglist>(const char *libname, QWidget *parentWidget=0, const char *widgetName=0, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>EncodingInterface *</type>
      <name>encodingInterface</name>
      <anchor>a13</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>HighlightingInterface *</type>
      <name>highlightingInterface</name>
      <anchor>a14</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>MarkInterface *</type>
      <name>markInterface</name>
      <anchor>a15</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>MarkInterfaceExtension *</type>
      <name>markInterfaceExtension</name>
      <anchor>a16</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>Plugin *</type>
      <name>createPlugin</name>
      <anchor>a17</anchor>
      <arglist>(const char *libname, Document *document=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>PluginViewInterface *</type>
      <name>pluginViewInterface</name>
      <anchor>a18</anchor>
      <arglist>(Plugin *plugin)</arglist>
    </member>
    <member kind="function">
      <type>PopupMenuInterface *</type>
      <name>popupMenuInterface</name>
      <anchor>a19</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>PrintInterface *</type>
      <name>printInterface</name>
      <anchor>a20</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>SearchInterface *</type>
      <name>searchInterface</name>
      <anchor>a21</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>SelectionInterface *</type>
      <name>selectionInterface</name>
      <anchor>a22</anchor>
      <arglist>(Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>SelectionInterface *</type>
      <name>selectionInterface</name>
      <anchor>a23</anchor>
      <arglist>(View *view)</arglist>
    </member>
    <member kind="function">
      <type>SelectionInterfaceExt *</type>
      <name>selectionInterfaceExt</name>
      <anchor>a24</anchor>
      <arglist>(Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>SelectionInterfaceExt *</type>
      <name>selectionInterfaceExt</name>
      <anchor>a25</anchor>
      <arglist>(View *view)</arglist>
    </member>
    <member kind="function">
      <type>SessionConfigInterface *</type>
      <name>sessionConfigInterface</name>
      <anchor>a26</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>SessionConfigInterface *</type>
      <name>sessionConfigInterface</name>
      <anchor>a27</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>SessionConfigInterface *</type>
      <name>sessionConfigInterface</name>
      <anchor>a28</anchor>
      <arglist>(class Plugin *plugin)</arglist>
    </member>
    <member kind="function">
      <type>TextHintInterface *</type>
      <name>textHintInterface</name>
      <anchor>a29</anchor>
      <arglist>(View *view)</arglist>
    </member>
    <member kind="function">
      <type>UndoInterface *</type>
      <name>undoInterface</name>
      <anchor>a30</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
    <member kind="function">
      <type>ViewCursorInterface *</type>
      <name>viewCursorInterface</name>
      <anchor>a31</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>ViewStatusMsgInterface *</type>
      <name>viewStatusMsgInterface</name>
      <anchor>a32</anchor>
      <arglist>(class View *view)</arglist>
    </member>
    <member kind="function">
      <type>WordWrapInterface *</type>
      <name>wordWrapInterface</name>
      <anchor>a33</anchor>
      <arglist>(class Document *doc)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::BlockSelectionDCOPInterface</name>
    <filename>classKTextEditor_1_1BlockSelectionDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>blockSelectionInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>blockSelectionMode</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>setBlockSelectionMode</name>
      <anchor>z2</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>toggleBlockSelectionMode</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>BlockSelectionDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(BlockSelectionInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BlockSelectionDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::BlockSelectionInterface</name>
    <filename>classKTextEditor_1_1BlockSelectionInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>blockSelectionInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>blockSelectionMode</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setBlockSelectionMode</name>
      <anchor>a4</anchor>
      <arglist>(bool on)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>toggleBlockSelectionMode</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setBlockSelectionInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateBlockSelectionInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ClipboardDCOPInterface</name>
    <filename>classKTextEditor_1_1ClipboardDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>void</type>
      <name>copy</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>cut</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>paste</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ClipboardDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(ClipboardInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ClipboardDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ClipboardInterface</name>
    <filename>classKTextEditor_1_1ClipboardInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>clipboardInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>copy</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cut</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>paste</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setClipboardInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateClipboardInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::CompletionEntry</name>
    <filename>classKTextEditor_1_1CompletionEntry.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a0</anchor>
      <arglist>(const CompletionEntry &amp;c) const </arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>type</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>text</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>prefix</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>postfix</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>comment</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>userdata</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::CodeCompletionInterface</name>
    <filename>classKTextEditor_1_1CodeCompletionInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>codeCompletionInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>showArgHint</name>
      <anchor>a3</anchor>
      <arglist>(QStringList functionList, const QString &amp;strWrapping, const QString &amp;strDelimiter)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>showCompletionBox</name>
      <anchor>a4</anchor>
      <arglist>(QValueList&lt; CompletionEntry &gt; complList, int offset=0, bool casesensitive=true)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>completionAborted</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>completionDone</name>
      <anchor>a6</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>completionDone</name>
      <anchor>a7</anchor>
      <arglist>(CompletionEntry)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>argHintHidden</name>
      <anchor>a8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>filterInsertString</name>
      <anchor>a9</anchor>
      <arglist>(CompletionEntry *, QString *)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setCodeCompletionInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateCodeCompletionInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ConfigInterface</name>
    <filename>classKTextEditor_1_1ConfigInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>configInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readConfig</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeConfig</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readConfig</name>
      <anchor>a5</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeConfig</name>
      <anchor>a6</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readSessionConfig</name>
      <anchor>a7</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeSessionConfig</name>
      <anchor>a8</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>configDialog</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setConfigInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateConfigInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ConfigInterfaceExtension</name>
    <filename>classKTextEditor_1_1ConfigInterfaceExtension.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>configInterfaceExtensionNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>configPages</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual ConfigPage *</type>
      <name>configPage</name>
      <anchor>a4</anchor>
      <arglist>(uint number=0, QWidget *parent=0, const char *name=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>configPageName</name>
      <anchor>a5</anchor>
      <arglist>(uint number=0) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>configPageFullName</name>
      <anchor>a6</anchor>
      <arglist>(uint number=0) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPixmap</type>
      <name>configPagePixmap</name>
      <anchor>a7</anchor>
      <arglist>(uint number=0, int size=KIcon::SizeSmall) const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setConfigInterfaceExtensionDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateConfigInterfaceExtension</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::Cursor</name>
    <filename>classKTextEditor_1_1Cursor.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>position</name>
      <anchor>a0</anchor>
      <arglist>(unsigned int *line, unsigned int *col) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setPosition</name>
      <anchor>a1</anchor>
      <arglist>(unsigned int line, unsigned int col)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>insertText</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>removeText</name>
      <anchor>a3</anchor>
      <arglist>(unsigned int numberOfCharacters)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QChar</type>
      <name>currentChar</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::CursorInterface</name>
    <filename>classKTextEditor_1_1CursorInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>cursorInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual Cursor *</type>
      <name>createCursor</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPtrList&lt; Cursor &gt;</type>
      <name>cursors</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setCursorInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateCursorInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::Document</name>
    <filename>classKTextEditor_1_1Document.html</filename>
    <base>KTextEditor::Editor</base>
    <member kind="function">
      <type></type>
      <name>Document</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>documentNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>documentDCOPSuffix</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual class View *</type>
      <name>createView</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *parent, const char *name=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPtrList&lt; class View &gt;</type>
      <name>views</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateDocument</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::DocumentInfoDCOPInterface</name>
    <filename>classKTextEditor_1_1DocumentInfoDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>QString</type>
      <name>mimeType</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>long</type>
      <name>fileSize</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>niceFileSize</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>documentInfoInterfaceNumber</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocumentInfoDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(DocumentInfoInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DocumentInfoDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::DocumentInfoInterface</name>
    <filename>classKTextEditor_1_1DocumentInfoInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>mimeType</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual long</type>
      <name>fileSize</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>niceFileSize</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>documentInfoInterfaceNumber</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setDocumentInfoInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateDocumentInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::DynWordWrapInterface</name>
    <filename>classKTextEditor_1_1DynWordWrapInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>dynWordWrapInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setDynWordWrap</name>
      <anchor>a3</anchor>
      <arglist>(bool)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>dynWordWrap</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setDynWordWrapInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateDynWordWrapInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::EditDCOPInterface</name>
    <filename>classKTextEditor_1_1EditDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop" virtualness="virtual">
      <type>virtual QString</type>
      <name>text</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual QString</type>
      <name>textLine</name>
      <anchor>z1</anchor>
      <arglist>(uint line)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual int</type>
      <name>numLines</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual int</type>
      <name>length</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual void</type>
      <name>setText</name>
      <anchor>z4</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual bool</type>
      <name>insertText</name>
      <anchor>z5</anchor>
      <arglist>(uint line, uint col, const QString &amp;text)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual bool</type>
      <name>removeText</name>
      <anchor>z6</anchor>
      <arglist>(uint startLine, uint startCol, uint endLine, uint endCol)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual bool</type>
      <name>insertLine</name>
      <anchor>z7</anchor>
      <arglist>(uint line, const QString &amp;text)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual bool</type>
      <name>removeLine</name>
      <anchor>z8</anchor>
      <arglist>(uint line)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EditDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(EditInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EditDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::EditInterface</name>
    <filename>classKTextEditor_1_1EditInterface.html</filename>
    <member kind="function">
      <type>uint</type>
      <name>editInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>text</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>text</name>
      <anchor>a4</anchor>
      <arglist>(uint startLine, uint startCol, uint endLine, uint endCol) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>textLine</name>
      <anchor>a5</anchor>
      <arglist>(uint line) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>numLines</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>length</name>
      <anchor>a7</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>lineLength</name>
      <anchor>a8</anchor>
      <arglist>(uint line) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setText</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;text)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>clear</name>
      <anchor>a10</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>insertText</name>
      <anchor>a11</anchor>
      <arglist>(uint line, uint col, const QString &amp;text)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>removeText</name>
      <anchor>a12</anchor>
      <arglist>(uint startLine, uint startCol, uint endLine, uint endCol)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>insertLine</name>
      <anchor>a13</anchor>
      <arglist>(uint line, const QString &amp;text)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>removeLine</name>
      <anchor>a14</anchor>
      <arglist>(uint line)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>textChanged</name>
      <anchor>a15</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>charactersInteractivelyInserted</name>
      <anchor>a16</anchor>
      <arglist>(int,int,const QString &amp;)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setEditInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateEditInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::EditInterfaceExt</name>
    <filename>classKTextEditor_1_1EditInterfaceExt.html</filename>
    <member kind="function">
      <type>uint</type>
      <name>editInterfaceExtNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>editBegin</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>editEnd</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateEditInterfaceExt</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::Editor</name>
    <filename>classKTextEditor_1_1Editor.html</filename>
    <base>KParts::ReadWritePart</base>
    <member kind="function">
      <type></type>
      <name>Editor</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>editorNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateEditor</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::EncodingDCOPInterface</name>
    <filename>classKTextEditor_1_1EncodingDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>encodingInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setEncoding</name>
      <anchor>z1</anchor>
      <arglist>(QString e)</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>encoding</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EncodingDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(EncodingInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EncodingDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::EncodingInterface</name>
    <filename>classKTextEditor_1_1EncodingInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>encodingInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setEncoding</name>
      <anchor>a3</anchor>
      <arglist>(const class QString &amp;e)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual class QString</type>
      <name>encoding</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setEncodingInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateEncodingInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::HighlightingInterface</name>
    <filename>classKTextEditor_1_1HighlightingInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>highlightingInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>hlMode</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setHlMode</name>
      <anchor>a4</anchor>
      <arglist>(unsigned int mode)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>hlModeCount</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>hlModeName</name>
      <anchor>a6</anchor>
      <arglist>(unsigned int mode)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>hlModeSectionName</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int mode)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>hlChanged</name>
      <anchor>a8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setHighlightingInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateHighlightingInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::MarkInterface</name>
    <filename>classKTextEditor_1_1MarkInterface.html</filename>
    <member kind="enumeration">
      <name>MarkTypes</name>
      <anchor>w32</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>markType01</name>
      <anchor>w32w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>markType02</name>
      <anchor>w32w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>markType03</name>
      <anchor>w32w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>markType04</name>
      <anchor>w32w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>markType05</name>
      <anchor>w32w4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>markInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual uint</type>
      <name>mark</name>
      <anchor>a3</anchor>
      <arglist>(uint line)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setMark</name>
      <anchor>a4</anchor>
      <arglist>(uint line, uint markType)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>clearMark</name>
      <anchor>a5</anchor>
      <arglist>(uint line)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addMark</name>
      <anchor>a6</anchor>
      <arglist>(uint line, uint markType)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>removeMark</name>
      <anchor>a7</anchor>
      <arglist>(uint line, uint markType)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPtrList&lt; KTextEditor::Mark &gt;</type>
      <name>marks</name>
      <anchor>a8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>clearMarks</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>marksChanged</name>
      <anchor>a10</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setMarkInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateMarkInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::MarkInterfaceExtension</name>
    <filename>classKTextEditor_1_1MarkInterfaceExtension.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>markInterfaceExtensionNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setPixmap</name>
      <anchor>a3</anchor>
      <arglist>(MarkInterface::MarkTypes, const QPixmap &amp;)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setDescription</name>
      <anchor>a4</anchor>
      <arglist>(MarkInterface::MarkTypes, const QString &amp;)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setMarksUserChangable</name>
      <anchor>a5</anchor>
      <arglist>(uint markMask)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>markChanged</name>
      <anchor>a6</anchor>
      <arglist>(KTextEditor::Mark mark, KTextEditor::MarkInterfaceExtension::MarkChangeAction action)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setMarkInterfaceExtensionDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateMarkInterfaceExtension</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::Plugin</name>
    <filename>classKTextEditor_1_1Plugin.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>Plugin</name>
      <anchor>a0</anchor>
      <arglist>(Document *document=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>pluginNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Document *</type>
      <name>document</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivatePlugin</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::PluginViewInterface</name>
    <filename>classKTextEditor_1_1PluginViewInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>pluginViewInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addView</name>
      <anchor>a3</anchor>
      <arglist>(View *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>removeView</name>
      <anchor>a4</anchor>
      <arglist>(View *)=0</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivatePluginViewInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::PopupMenuInterface</name>
    <filename>classKTextEditor_1_1PopupMenuInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>popupMenuInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>installPopup</name>
      <anchor>a3</anchor>
      <arglist>(QPopupMenu *rmb_Menu)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setPopupMenuInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivatePopupMenuInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::PrintDCOPInterface</name>
    <filename>classKTextEditor_1_1PrintDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>printInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>printDialog</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>print</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>PrintDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(PrintInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~PrintDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::PrintInterface</name>
    <filename>classKTextEditor_1_1PrintInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>printInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>printDialog</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>print</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setPrintInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivatePrintInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SearchDCOPInterface</name>
    <filename>classKTextEditor_1_1SearchDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>bool</type>
      <name>findFirstString</name>
      <anchor>z0</anchor>
      <arglist>(QString text, bool caseSensitive)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findNextString</name>
      <anchor>z1</anchor>
      <arglist>(QString text, bool caseSensitive)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findPreviousString</name>
      <anchor>z2</anchor>
      <arglist>(QString text, bool caseSensitive)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findLastString</name>
      <anchor>z3</anchor>
      <arglist>(QString text, bool caseSensitive)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findStringAt</name>
      <anchor>z4</anchor>
      <arglist>(uint row, uint col, QString text, bool caseSensitive)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findFirstRegExp</name>
      <anchor>z5</anchor>
      <arglist>(QString regexp)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findNextRegExp</name>
      <anchor>z6</anchor>
      <arglist>(QString regexp)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findPreviousRegExp</name>
      <anchor>z7</anchor>
      <arglist>(QString regexp)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findLastRegExp</name>
      <anchor>z8</anchor>
      <arglist>(QString regexp)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>findRegExpAt</name>
      <anchor>z9</anchor>
      <arglist>(uint row, uint col, QString regexp)</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>currentMatchLine</name>
      <anchor>z10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>currentMatchCol</name>
      <anchor>z11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>currentMatchLength</name>
      <anchor>z12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SearchDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(SearchInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SearchDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SearchInterface</name>
    <filename>classKTextEditor_1_1SearchInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>searchInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>searchText</name>
      <anchor>a3</anchor>
      <arglist>(unsigned int startLine, unsigned int startCol, const QString &amp;text, unsigned int *foundAtLine, unsigned int *foundAtCol, unsigned int *matchLen, bool casesensitive=true, bool backwards=false)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>searchText</name>
      <anchor>a4</anchor>
      <arglist>(unsigned int startLine, unsigned int startCol, const QRegExp &amp;regexp, unsigned int *foundAtLine, unsigned int *foundAtCol, unsigned int *matchLen, bool backwards=false)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSearchInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateSearchInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SelectionDCOPInterface</name>
    <filename>classKTextEditor_1_1SelectionDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>bool</type>
      <name>setSelection</name>
      <anchor>z0</anchor>
      <arglist>(uint startLine, uint startCol, uint endLine, uint endCol)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>clearSelection</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>hasSelection</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QString</type>
      <name>selection</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>removeSelectedText</name>
      <anchor>z4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>selectAll</name>
      <anchor>z5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelectionDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(SelectionInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SelectionDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SelectionExtDCOPInterface</name>
    <filename>classKTextEditor_1_1SelectionExtDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>int</type>
      <name>selStartLine</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>int</type>
      <name>selStartCol</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>int</type>
      <name>selEndLine</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>int</type>
      <name>selEndCol</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SelectionExtDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(SelectionInterfaceExt *parent, const char *name)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SelectionInterface</name>
    <filename>classKTextEditor_1_1SelectionInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>selectionInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setSelection</name>
      <anchor>a3</anchor>
      <arglist>(unsigned int startLine, unsigned int startCol, unsigned int endLine, unsigned int endCol)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>clearSelection</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>hasSelection</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>selection</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>removeSelectedText</name>
      <anchor>a7</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>selectAll</name>
      <anchor>a8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>selectionChanged</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSelectionInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateSelectionInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SelectionInterfaceExt</name>
    <filename>classKTextEditor_1_1SelectionInterfaceExt.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>selectionInterfaceExtNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>selStartLine</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>selStartCol</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>selEndLine</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>selEndCol</name>
      <anchor>a6</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSelectionInterfaceExtDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateSelectionInterfaceExt</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::SessionConfigInterface</name>
    <filename>classKTextEditor_1_1SessionConfigInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>configInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>readSessionConfig</name>
      <anchor>a3</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeSessionConfig</name>
      <anchor>a4</anchor>
      <arglist>(KConfig *)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setSessionConfigInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateSessionConfigInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::TextHintInterface</name>
    <filename>classKTextEditor_1_1TextHintInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>enableTextHints</name>
      <anchor>a2</anchor>
      <arglist>(int timeout)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>disableTextHints</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>textHintInterfaceNumber</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>needTextHint</name>
      <anchor>a5</anchor>
      <arglist>(int line, int col, QString &amp;text)=0</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateTextHintInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::UndoDCOPInterface</name>
    <filename>classKTextEditor_1_1UndoDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>undoInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>undo</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>redo</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>clearUndo</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>clearRedo</name>
      <anchor>z4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>undoCount</name>
      <anchor>z5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>redoCount</name>
      <anchor>z6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>undoSteps</name>
      <anchor>z7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setUndoSteps</name>
      <anchor>z8</anchor>
      <arglist>(uint steps)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>undoChanged</name>
      <anchor>z9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>UndoDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(UndoInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UndoDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::UndoInterface</name>
    <filename>classKTextEditor_1_1UndoInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>undoInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>undo</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>redo</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>clearUndo</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>clearRedo</name>
      <anchor>a6</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>undoCount</name>
      <anchor>a7</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>redoCount</name>
      <anchor>a8</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>undoSteps</name>
      <anchor>a9</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setUndoSteps</name>
      <anchor>a10</anchor>
      <arglist>(unsigned int steps)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>undoChanged</name>
      <anchor>a11</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setUndoInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateUndoInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::View</name>
    <filename>classKTextEditor_1_1View.html</filename>
    <base>QWidget</base>
    <base>KXMLGUIClient</base>
    <member kind="function">
      <type></type>
      <name>View</name>
      <anchor>a0</anchor>
      <arglist>(class Document *, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>viewNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>viewDCOPSuffix</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual class Document *</type>
      <name>document</name>
      <anchor>a4</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateView</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ViewCursorDCOPInterface</name>
    <filename>classKTextEditor_1_1ViewCursorDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>viewCursorInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>QPoint</type>
      <name>cursorCoordinates</name>
      <anchor>z1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>cursorPosition</name>
      <anchor>z2</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>cursorPositionReal</name>
      <anchor>z3</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>setCursorPosition</name>
      <anchor>z4</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="dcop">
      <type>bool</type>
      <name>setCursorPositionReal</name>
      <anchor>z5</anchor>
      <arglist>(uint line, uint col)</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>cursorLine</name>
      <anchor>z6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>cursorColumn</name>
      <anchor>z7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>uint</type>
      <name>cursorColumnReal</name>
      <anchor>z8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>cursorPositionChanged</name>
      <anchor>z9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ViewCursorDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(ViewCursorInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ViewCursorDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ViewCursorInterface</name>
    <filename>classKTextEditor_1_1ViewCursorInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>viewCursorInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual class QPoint</type>
      <name>cursorCoordinates</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cursorPosition</name>
      <anchor>a4</anchor>
      <arglist>(unsigned int *line, unsigned int *col)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cursorPositionReal</name>
      <anchor>a5</anchor>
      <arglist>(unsigned int *line, unsigned int *col)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setCursorPosition</name>
      <anchor>a6</anchor>
      <arglist>(unsigned int line, unsigned int col)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>setCursorPositionReal</name>
      <anchor>a7</anchor>
      <arglist>(unsigned int line, unsigned int col)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>cursorLine</name>
      <anchor>a8</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>cursorColumn</name>
      <anchor>a9</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>cursorColumnReal</name>
      <anchor>a10</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cursorPositionChanged</name>
      <anchor>a11</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setViewCursorInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateViewCursorInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ViewStatusMsgDCOPInterface</name>
    <filename>classKTextEditor_1_1ViewStatusMsgDCOPInterface.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <member kind="dcop">
      <type>uint</type>
      <name>viewStatusMsgInterfaceNumber</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>viewStatusMsg</name>
      <anchor>z1</anchor>
      <arglist>(class QString msg)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ViewStatusMsgDCOPInterface</name>
      <anchor>a0</anchor>
      <arglist>(ViewStatusMsgInterface *Parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ViewStatusMsgDCOPInterface</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::ViewStatusMsgInterface</name>
    <filename>classKTextEditor_1_1ViewStatusMsgInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>viewStatusMsgInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>viewStatusMsg</name>
      <anchor>a3</anchor>
      <arglist>(const class QString &amp;msg)=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setViewStatusMsgInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateViewStatusMsgInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>KTextEditor::WordWrapInterface</name>
    <filename>classKTextEditor_1_1WordWrapInterface.html</filename>
    <member kind="function">
      <type>unsigned int</type>
      <name>wordWrapInterfaceNumber</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setWordWrap</name>
      <anchor>a3</anchor>
      <arglist>(bool)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>wordWrap</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>setWordWrapAt</name>
      <anchor>a5</anchor>
      <arglist>(unsigned int)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual unsigned int</type>
      <name>wordWrapAt</name>
      <anchor>a6</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setWordWrapInterfaceDCOPSuffix</name>
      <anchor>b0</anchor>
      <arglist>(const QCString &amp;suffix)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>PrivateWordWrapInterface</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
</tagfile>
