<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>The DCOP Desktop COmmunication Protocol library</title>
    <filename>index</filename>
    <docanchor>protocol</docanchor>
    <docanchor>iuc</docanchor>
    <docanchor>conclusion</docanchor>
    <docanchor>sending_data</docanchor>
    <docanchor>model</docanchor>
    <docanchor>establish</docanchor>
    <docanchor>receiving_data</docanchor>
    <docanchor>receiving_calls</docanchor>
    <docanchor>dcopidl</docanchor>
    <docanchor>dcop_signals</docanchor>
  </compound>
  <compound kind="class">
    <name>DCOPArg</name>
    <filename>classDCOPArg.html</filename>
    <member kind="function">
      <type></type>
      <name>DCOPArg</name>
      <anchor>a0</anchor>
      <arglist>(const T &amp;t, const char *tname_arg)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPArg</name>
      <anchor>a1</anchor>
      <arglist>(const T &amp;t)</arglist>
    </member>
    <member kind="variable">
      <type>QByteArray</type>
      <name>data</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>const char *</type>
      <name>tname</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPClient</name>
    <filename>classDCOPClient.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>applicationRegistered</name>
      <anchor>l0</anchor>
      <arglist>(const QCString &amp;appId)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>applicationRemoved</name>
      <anchor>l1</anchor>
      <arglist>(const QCString &amp;appId)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>attachFailed</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;msg)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>blockUserInput</name>
      <anchor>l3</anchor>
      <arglist>(bool block)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>callBack</name>
      <anchor>l4</anchor>
      <arglist>(int, const QCString &amp;, const QByteArray &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPClient</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DCOPClient</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>attach</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bindToApp</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>detach</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAttached</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAttachedToForeignServer</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>acceptCalls</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAcceptCalls</name>
      <anchor>a8</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>qtBridgeEnabled</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setQtBridgeEnabled</name>
      <anchor>a10</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>registerAs</name>
      <anchor>a11</anchor>
      <arglist>(const QCString &amp;appId, bool addPID=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRegistered</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>appId</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>socket</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>suspend</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resume</name>
      <anchor>a16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSuspended</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a18</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a19</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QString &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>call</name>
      <anchor>a20</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData, bool useEventLoop, int timeout)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>call</name>
      <anchor>a21</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData, bool useEventLoop=false)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>callAsync</name>
      <anchor>a22</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data, QObject *callBackObj, const char *callBackSlot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findObject</name>
      <anchor>a23</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data, QCString &amp;foundApp, QCString &amp;foundObj, bool useEventLoop, int timeout)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>findObject</name>
      <anchor>a24</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, const QCString &amp;remFun, const QByteArray &amp;data, QCString &amp;foundApp, QCString &amp;foundObj, bool useEventLoop=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitDCOPSignal</name>
      <anchor>a25</anchor>
      <arglist>(const QCString &amp;object, const QCString &amp;signal, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitDCOPSignal</name>
      <anchor>a26</anchor>
      <arglist>(const QCString &amp;signal, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>connectDCOPSignal</name>
      <anchor>a27</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;senderObj, const QCString &amp;signal, const QCString &amp;receiverObj, const QCString &amp;slot, bool Volatile)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>connectDCOPSignal</name>
      <anchor>a28</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;signal, const QCString &amp;receiverObj, const QCString &amp;slot, bool Volatile) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disconnectDCOPSignal</name>
      <anchor>a29</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;senderObj, const QCString &amp;signal, const QCString &amp;receiverObj, const QCString &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disconnectDCOPSignal</name>
      <anchor>a30</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;signal, const QCString &amp;receiverObj, const QCString &amp;slot) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>process</name>
      <anchor>a31</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function">
      <type>DCOPClientTransaction *</type>
      <name>beginTransaction</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endTransaction</name>
      <anchor>a33</anchor>
      <arglist>(DCOPClientTransaction *t, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function">
      <type>Q_INT32</type>
      <name>transactionId</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isApplicationRegistered</name>
      <anchor>a35</anchor>
      <arglist>(const QCString &amp;remApp)</arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>registeredApplications</name>
      <anchor>a36</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>remoteObjects</name>
      <anchor>a37</anchor>
      <arglist>(const QCString &amp;remApp, bool *ok=0)</arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>remoteInterfaces</name>
      <anchor>a38</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, bool *ok=0)</arglist>
    </member>
    <member kind="function">
      <type>QCStringList</type>
      <name>remoteFunctions</name>
      <anchor>a39</anchor>
      <arglist>(const QCString &amp;remApp, const QCString &amp;remObj, bool *ok=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>receive</name>
      <anchor>a40</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj, const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>find</name>
      <anchor>a41</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj, const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>senderId</name>
      <anchor>a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultObject</name>
      <anchor>a43</anchor>
      <arglist>(const QCString &amp;objId)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>defaultObject</name>
      <anchor>a44</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNotifications</name>
      <anchor>a45</anchor>
      <arglist>(bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDaemonMode</name>
      <anchor>a46</anchor>
      <arglist>(bool daemonMode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPriorityCall</name>
      <anchor>a47</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>handleAsyncReply</name>
      <anchor>a48</anchor>
      <arglist>(ReplyStruct *replyStruct)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setServerAddress</name>
      <anchor>e0</anchor>
      <arglist>(const QCString &amp;addr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>normalizeFunctionSignature</name>
      <anchor>e1</anchor>
      <arglist>(const QCString &amp;fun)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DCOPClient *</type>
      <name>mainClient</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setMainClient</name>
      <anchor>e3</anchor>
      <arglist>(DCOPClient *mainClient)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DCOPClient *</type>
      <name>findLocalClient</name>
      <anchor>e4</anchor>
      <arglist>(const QCString &amp;_appId)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>emergencyClose</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>postMortemSender</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>postMortemObject</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const char *</type>
      <name>postMortemFunction</name>
      <anchor>e8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>dcopServerFile</name>
      <anchor>e9</anchor>
      <arglist>(const QCString &amp;hostname=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>dcopServerFileOld</name>
      <anchor>e10</anchor>
      <arglist>(const QCString &amp;hostname=0) KDE_DEPRECATED</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>iceauthPath</name>
      <anchor>e11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>processSocketData</name>
      <anchor>j0</anchor>
      <arglist>(int socknum)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_attach</name>
      <anchor>ga0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>dcop_register</name>
      <anchor>ga1</anchor>
      <arglist>(const char *app_name, Bool add_pid)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_detach</name>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_register_callback</name>
      <anchor>ga3</anchor>
      <arglist>(const char *object_id, dcop_callback_t callback)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_send_signal</name>
      <anchor>ga4</anchor>
      <arglist>(const char *receiving_app, const char *object, const char *function, char *data, int data_length)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_call</name>
      <anchor>ga5</anchor>
      <arglist>(const char *app_name, const char *remote_app_name, const char *remote_object_id, const char *remote_function, const char *data, int data_length, char **reply_type, char **reply_data, int *reply_data_length)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPObject</name>
    <filename>classDCOPObject.html</filename>
    <member kind="function">
      <type></type>
      <name>DCOPObject</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPObject</name>
      <anchor>a1</anchor>
      <arglist>(QObject *obj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPObject</name>
      <anchor>a2</anchor>
      <arglist>(const QCString &amp;objId)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DCOPObject</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>objId</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setObjId</name>
      <anchor>a5</anchor>
      <arglist>(const QCString &amp;objId)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>process</name>
      <anchor>a6</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>processDynamic</name>
      <anchor>a7</anchor>
      <arglist>(const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QCStringList</type>
      <name>functionsDynamic</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QCStringList</type>
      <name>interfacesDynamic</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QCStringList</type>
      <name>interfaces</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QCStringList</type>
      <name>functions</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emitDCOPSignal</name>
      <anchor>a12</anchor>
      <arglist>(const QCString &amp;signal, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>connectDCOPSignal</name>
      <anchor>a13</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;senderObj, const QCString &amp;signal, const QCString &amp;slot, bool Volatile)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>disconnectDCOPSignal</name>
      <anchor>a14</anchor>
      <arglist>(const QCString &amp;sender, const QCString &amp;senderObj, const QCString &amp;signal, const QCString &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>DCOPClient *</type>
      <name>callingDcopClient</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCallingDcopClient</name>
      <anchor>a16</anchor>
      <arglist>(DCOPClient *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>hasObject</name>
      <anchor>e0</anchor>
      <arglist>(const QCString &amp;objId)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>DCOPObject *</type>
      <name>find</name>
      <anchor>e1</anchor>
      <arglist>(const QCString &amp;objId)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPtrList&lt; DCOPObject &gt;</type>
      <name>match</name>
      <anchor>e2</anchor>
      <arglist>(const QCString &amp;partialId)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QCString</type>
      <name>objectName</name>
      <anchor>e3</anchor>
      <arglist>(QObject *obj)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPObjectProxy</name>
    <filename>classDCOPObjectProxy.html</filename>
    <member kind="function">
      <type></type>
      <name>DCOPObjectProxy</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPObjectProxy</name>
      <anchor>a1</anchor>
      <arglist>(DCOPClient *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DCOPObjectProxy</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>process</name>
      <anchor>a3</anchor>
      <arglist>(const QCString &amp;obj, const QCString &amp;fun, const QByteArray &amp;data, QCString &amp;replyType, QByteArray &amp;replyData)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b0</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DCOPClient</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPRef</name>
    <filename>classDCOPRef.html</filename>
    <member kind="enumeration">
      <name>EventLoopFlag</name>
      <anchor>w2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPRef</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPRef</name>
      <anchor>a1</anchor>
      <arglist>(const DCOPRef &amp;ref)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPRef</name>
      <anchor>a2</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPRef</name>
      <anchor>a3</anchor>
      <arglist>(DCOPObject *object)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPRef</name>
      <anchor>a4</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj, const QCString &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>app</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>obj</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>object</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>type</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DCOPRef &amp;</type>
      <name>operator=</name>
      <anchor>a10</anchor>
      <arglist>(const DCOPRef &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRef</name>
      <anchor>a11</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj=&quot;&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRef</name>
      <anchor>a12</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj, const QCString &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DCOPClient *</type>
      <name>dcopClient</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDCOPClient</name>
      <anchor>a15</anchor>
      <arglist>(DCOPClient *client)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a16</anchor>
      <arglist>(const QCString &amp;fun)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a17</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop=NoEventLoop, int timeout=-1)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a18</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a19</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a20</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a21</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a22</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a23</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a24</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a25</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a26</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a27</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a28</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a29</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a30</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a31</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>call</name>
      <anchor>a32</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7, const T8 &amp;t8)</arglist>
    </member>
    <member kind="function">
      <type>DCOPReply</type>
      <name>callExt</name>
      <anchor>a33</anchor>
      <arglist>(const QCString &amp;fun, EventLoopFlag useEventLoop, int timeout, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7, const T8 &amp;t8)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a34</anchor>
      <arglist>(const QCString &amp;fun)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a35</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a36</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a37</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a38</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a39</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a40</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a41</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send</name>
      <anchor>a42</anchor>
      <arglist>(const QCString &amp;fun, const T1 &amp;t1, const T2 &amp;t2, const T3 &amp;t3, const T4 &amp;t4, const T5 &amp;t5, const T6 &amp;t6, const T7 &amp;t7, const T8 &amp;t8)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPReply</name>
    <filename>classDCOPReply.html</filename>
    <member kind="function">
      <type></type>
      <name>operator T</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get</name>
      <anchor>a1</anchor>
      <arglist>(T &amp;t, const char *tname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get</name>
      <anchor>a2</anchor>
      <arglist>(T &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable">
      <type>QByteArray</type>
      <name>data</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QCString</type>
      <name>type</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DCOPStub</name>
    <filename>classDCOPStub.html</filename>
    <member kind="function">
      <type></type>
      <name>DCOPStub</name>
      <anchor>a0</anchor>
      <arglist>(const QCString &amp;app, const QCString &amp;obj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPStub</name>
      <anchor>a1</anchor>
      <arglist>(DCOPClient *client, const QCString &amp;app, const QCString &amp;obj)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DCOPStub</name>
      <anchor>a2</anchor>
      <arglist>(const DCOPRef &amp;ref)</arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>app</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QCString</type>
      <name>obj</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Status</type>
      <name>status</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>ok</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setStatus</name>
      <anchor>b0</anchor>
      <arglist>(Status _status)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>callFailed</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>DCOPClient *</type>
      <name>dcopClient</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type></type>
      <name>DCOPStub</name>
      <anchor>b3</anchor>
      <arglist>(never_use_t)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Test</name>
    <filename>classTest.html</filename>
    <base virtualness="virtual">DCOPObject</base>
    <base>QValueList&lt; QString &gt;</base>
    <member kind="dcop" virtualness="virtual">
      <type>virtual QString</type>
      <name>url</name>
      <anchor>z0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual QString</type>
      <name>constTest</name>
      <anchor>z1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual DCOPRef</type>
      <name>firstView</name>
      <anchor>z2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual DCOPRef</type>
      <name>nextView</name>
      <anchor>z3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual int</type>
      <name>getNumObjects</name>
      <anchor>z4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual DCOPRef</type>
      <name>getObject</name>
      <anchor>z5</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual int</type>
      <name>getNumPages</name>
      <anchor>z6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="dcop" virtualness="virtual">
      <type>virtual DCOPRef</type>
      <name>getPage</name>
      <anchor>z7</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="dcop">
      <type>int</type>
      <name>getPageOfObj</name>
      <anchor>z8</anchor>
      <arglist>(int obj)</arglist>
    </member>
    <member kind="dcop">
      <type>void</type>
      <name>setCell</name>
      <anchor>z9</anchor>
      <arglist>(const int &amp;point=3)</arglist>
    </member>
    <member kind="dcop">
      <type>QValueList&lt; DCOPRef &gt;</type>
      <name>getWindows</name>
      <anchor>z10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getPageOfObj</name>
      <anchor>a3</anchor>
      <arglist>(int obj)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCell</name>
      <anchor>a4</anchor>
      <arglist>(KSpreadTable *table, const QPoint &amp;point)</arglist>
    </member>
    <member kind="variable">
      <type>SomeForwardFooPrivate *</type>
      <name>d</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>k_dcop_signals</type>
      <name>__pad0__</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>AUDIO_CD</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TestObject</name>
    <filename>classTestObject.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>slotTimeout</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotCallBack</name>
      <anchor>i1</anchor>
      <arglist>(int, const QCString &amp;, const QByteArray &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TestObject</name>
      <anchor>a0</anchor>
      <arglist>(const QCString &amp;app)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>dcopc</name>
    <title>C interface to DCOP</title>
    <filename>group__dcopc.html</filename>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_attach</name>
      <anchor>ga0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>char *</type>
      <name>dcop_register</name>
      <anchor>ga1</anchor>
      <arglist>(const char *app_name, Bool add_pid)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_detach</name>
      <anchor>ga2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_register_callback</name>
      <anchor>ga3</anchor>
      <arglist>(const char *object_id, dcop_callback_t callback)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_send_signal</name>
      <anchor>ga4</anchor>
      <arglist>(const char *receiving_app, const char *object, const char *function, char *data, int data_length)</arglist>
    </member>
    <member kind="function">
      <type>Bool</type>
      <name>dcop_call</name>
      <anchor>ga5</anchor>
      <arglist>(const char *app_name, const char *remote_app_name, const char *remote_object_id, const char *remote_function, const char *data, int data_length, char **reply_type, char **reply_data, int *reply_data_length)</arglist>
    </member>
  </compound>
</tagfile>
