# Function to install configuration file:
config()
{
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then
    # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# Install configuration files if not found:
config etc/security/group.conf.new
config etc/security/time.conf.new
config etc/security/pam_env.conf.new
config etc/security/limits.conf.new
config etc/security/access.conf.new
config etc/pam.d/other.new
config etc/pam.d/system-auth.new

# Check if there's already a call to rc.logoutd at /etc/rc.d/rc.M (if not, add):
(
  if [ "`grep "# Start the logoutd login time and port restrictions daemon:" etc/rc.d/rc.M`" = "" ]; then
    echo "# Start the logoutd login time and port restrictions daemon:" >> etc/rc.d/rc.M
    echo "if [ -x /etc/rc.d/rc.logoutd ]; then" >> etc/rc.d/rc.M
    echo "  . /etc/rc.d/rc.logoutd start" >> etc/rc.d/rc.M
    echo "fi" >> etc/rc.d/rc.M
  fi
)
( cd lib ; rm -rf libpam.so )
( cd lib ; ln -sf libpam.so.0 libpam.so )
( cd lib ; rm -rf libpamc.so )
( cd lib ; ln -sf libpamc.so.0 libpamc.so )
( cd lib/security ; rm -rf pam_unix_session.so )
( cd lib/security ; ln -sf pam_unix.so pam_unix_session.so )
( cd lib/security ; rm -rf pam_unix_auth.so )
( cd lib/security ; ln -sf pam_unix.so pam_unix_auth.so )
( cd lib/security ; rm -rf pam_unix_acct.so )
( cd lib/security ; ln -sf pam_unix.so pam_unix_acct.so )
( cd lib/security ; rm -rf pam_unix_passwd.so )
( cd lib/security ; ln -sf pam_unix.so pam_unix_passwd.so )
( cd lib ; rm -rf libpam_misc.so )
( cd lib ; ln -sf libpam_misc.so.0 libpam_misc.so )
