#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 6;

### use VASM::Tree
BEGIN { use_ok('VASM::Tree') }

### Ability test
can_ok('VASM::Tree', qw/new Store Retrieve Children/);

### new
# Do not confuse with my($ek, $to)!
my $tree = VASM::Tree->new;
# ...and is a member of the appropriate class?
isa_ok($tree, 'VASM::Tree', '$tree is a VASM::Tree');

### Store and Retrieve
# Store some things to test later
$tree->Store(qw/foo bar baz/, 'nonsense names');
$tree->Store(qw/foo fighters/, [ qw/UFO music/ ]);
# Not to be confused with a Chinese penis, but only a pedantic dipshit would
# suggest that anyway
$tree->Store('hanumizzle', 'Monkey God');

# Now retrieve some stuff and check it
is($tree->Retrieve(qw/foo bar baz/), 'nonsense names',
   q(Datum at qw/foo bar baz/ is string 'nonsense names'));
is_deeply($tree->Retrieve(qw/foo fighters/), [ qw/UFO music/ ],
          q(Datum at qw/foo fighters/ contains 'UFO' and 'music'));

### Children
# This is actually more of a check that Tie::Hash::Indexed is working! 
is_deeply([ $tree->Children ], [ qw/foo hanumizzle/ ],
          'Order of children preserved properly in tree');
