#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use encoding 'utf8';
use Test::More tests => 7;
use VASM::Resource;
use File::Spec::Functions;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Message + ability test
### (VASM::Resource::Catalog::Message is not a class, and can therefore not
### use can_ok)
BEGIN { use_ok('VASM::Resource::Catalog::Message', qw/findMessageCatalog
                                                      findErrorCatalog
                                                      writeMessageCatalog/) }

### findMessageCatalog
$ENV{LC_ALL} = 'hi'; # Set locale for Hindi!
my $hindiCatalog = findMessageCatalog(qw/some message/);
# Catalog is a member of the appropriate class?
isa_ok($hindiCatalog, 'VASM::Catalog::Message',
       'Hindi catalog is a VASM::Catalog::Message');
# Render some things from it and check them
is($hindiCatalog->Render('Greetings'), 'नमस्ते', 
   'Namaste valid');
is($hindiCatalog->Render('Inquiry of Welfare'), 'आप कैसे हैँ?', 
   'Ap kaise hai? valid');

### findErrorCatalog

# $ENV{LC_ALL} = ''; # Revert locale
# (Don't revert the locale; findErrorCatalog should find the correct file
# without our help)

# Load the error catalog
my $errorCatalog = findErrorCatalog(qw/some error/);
# Catalog is a member of the appropriate class?
isa_ok($errorCatalog, 'VASM::Catalog::Error',
       'Error catalog is a VASM::Catalog::Error');
# Will it render error messages properly?
is($errorCatalog->Render('HAL 9000 General Protection Fault'),
   q{I'm sorry; I can't do that, Dave.},
   q{HAL can't do that});

### writeMessageCatalog
# Write out the Hindi catalog
writeMessageCatalog($hindiCatalog, qw/some other message/);
# Is the filename correct?
is(scalar findDataResource(qw/some other message hi Message.xml/),
   "$ENV{XDG_DATA_HOME}/vasm/some/other/message/hi/Message.xml",
   'writeMessageCatalog wrote to the right place');
