#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 6;
use File::Spec::Functions;
use VASM::Resource;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Action + ability test
### (VASM::Resource::Catalog::Action is not a class, and can therefore not use
### can_ok)
BEGIN { use_ok('VASM::Resource::Catalog::Action',
               qw/findActionCatalog
                  findActionCatalogByMedium
                  mediaDirectory
                  writeActionCatalog/) }

### findActionCatalog
my $catalog = findActionCatalog(qw/File image png/);
# Catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Action',
       'Catalog is a VASM::Catalog::Action');
# Catalog contains the correct contents?
is_deeply($catalog, [ 'display %s', 'qiv %s', 'kview %s' ],
          'Catalog contents valid');

### findActionCatalogByMedium
my $catalogPNG = findActionCatalogByMedium(
  "$ENV{PWD}/.pixmaps/emacs.png");
# Does the catalog for PNG images contain the correct contents?
is_deeply($catalogPNG, $catalog, 'Contents of catalog for PNG valid');
my $catalogHTTP = findActionCatalogByMedium('http://www.seelai.com');
# Does the catalog for HTTP URIs contain the correct contents?
is_deeply($catalogHTTP, [ 'seamonkey %s', 'konqueror %s', 'dillo %s' ],
          'Contents of catalog for HTTP valid (and a good thing!)');

### writeActionCatalog
# Write out a PNG catalog somewhere else
writeActionCatalog($catalogPNG, qw/File image png-copy/);
# Is the filename correct?
is(
  scalar findConfigResource(qw/Action File image png-copy Action.xml/),
  "$ENV{XDG_CONFIG_HOME}/vasm/Action/File/image/png-copy/Action.xml",
  'writeActionCatalog wrote to the right place'
);
