#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 8;
use IO::Scalar;

# XML::Writer seems to think it is dealing with a tied handle?
BEGIN { package IO::Scalar; sub BINMODE {} } # UGLY HACK

### use VASM::Catalog::Action
BEGIN { use_ok('VASM::Catalog::Action') }

### Ability test
can_ok('VASM::Catalog::Action', qw/new Push Unshift Dump Exec Parse Write/);

### new
my $catalog = VASM::Catalog::Action->new;
# The catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Action');

### Push, Unshift, and Dump
$catalog->Push('emacs');
$catalog->Push('terminal');
$catalog->Push('seamonkey');
$catalog->Unshift('true');

# The catalog contents are preserved in the right order?
is_deeply([ $catalog->Dump ], [ qw/true emacs terminal seamonkey/ ],
          'Catalog contents valid');

### Exec
# Does simple execution of true work?
is($catalog->Exec, 0, 'Exec seems to be working');
# Unshift cat onto the catalog  
$catalog->Unshift('cat %s 2> /dev/null');
# Give cat some bullshit options; will it exit with 1?
is($catalog->Exec('-gdfdfg') >> 8, 1, 'Exec IS working');

### Parse
# Instantiate an IO::Scalar containing an XML description of a catalog and
# parse it
my $xmlParseString = q{<?xml version="1.0" encoding="utf-8"?>

<catalog>
  <!-- Generated by VASM -->
  <command>cat %s 2&gt; /dev/null</command>
  <command>true</command>
  <command>emacs</command>
  <command>terminal</command>
  <command>seamonkey</command>
</catalog>
};
my $xmlParseHandle = IO::Scalar->new(\$xmlParseString);
my $catalogParse = VASM::Catalog::Action->new($xmlParseHandle);

# Do $catalogParse and $catalog hold the same values?
is_deeply($catalogParse, $catalog, 'Parsed catalog valid');

### Write
my $xmlWriteString; my $xmlWriteHandle = IO::Scalar->new(\$xmlWriteString);
$catalog->Write($xmlWriteHandle);

# Is the wriiten XML the same as the XML parse string?
is($xmlWriteString, $xmlParseString, 'Written XML valid');
