#!/usr/bin/perl

use strict;
use warnings;
use Parse::RecDescent;

# Does ServerLayout /have to/ come up front?
# (Does it matter?)

# Section  "SectionName"
#     SectionEntry
#     ...
# EndSection

# Config file keywords are case-insensitive, and "_" characters are ignored.
# Most strings (including Option names) are also case-insensitive, and
# insensitive to white space and "_" characters.
#
# (Parsing request/writing from parsed structure should take this into
# account? At least for items such as keywords, option names, Boolean values,
# etc. In other words, should the behavior of case-insensitivity be exclusive
# or inclusive.)
# 
# Each config file entry usually takes up a single line in the file. They
# consist of a keyword, which is possibly followed by one or more arguments,
# with the number and types of the arguments depending on the keyword. The
# argument types are:
# 
#     Integer     an integer number in decimal, hex or octal
#     Real        a floating point number
#     String      a string enclosed in double quote marks (")
#
# Note:  hex  integer  values  must be prefixed with "0x", and octal values with
# "0".
#
# (Ordering for this? 0x first, then 0, then other numbers?)
# 
# A special keyword called Option may be used to provide free-form data to
# various components of the server. The Option keyword takes either one or two
# string arguments. The first is the option name, and the optional second
# argument is the option value. Some commonly used option value types include:
#
# (Option keyword preferred over others then?)
# 
#     Integer     an integer number in decimal, hex or octal
#     Real        a floating point number
#     String      a sequence of characters
#     Boolean     a boolean value (see below)
#     Frequency   a frequency value (see below)
# 
# Note that all Option values, not just strings, must be enclosed in quotes.
#
# (OK.)
# 
# Boolean options may optionally have a value specified. When no value is
# specified, the option's value is TRUE. The following boolean option values
# are recognised as TRUE:
#
# (Aw, WTF!)
# 
#     1, on, true, yes
# 
# and the following boolean option values are recognised as FALSE:
# 
#     0, off, false, no
# 
# If an option name is prefixed with "No", then the option value is negated.
#
# (This should be virtualized for sure.)
# 
# Example: the following option entries are equivalent:
# 
#     Option "Accel"   "Off"
#     Option "NoAccel"
#     Option "NoAccel" "On"
#     Option "Accel"   "false"
#     Option "Accel"   "no"
# 
# Frequency  option  values consist of a real number that is optionally followed
# by one of the following frequency units:
# 
#     Hz, k, kHz, M, MHz
# 
# When the unit name is omitted, the correct units will be determined from the
# value and the expectations of the appropriate range of the value. It is
# recommended that the units always be specified when using frequency option
# values to avoid any errors in determining the value.

my $grammar = << 'GRAMMAR';
  start: /foo\Z/
GRAMMAR

my $parser = Parse::RecDescent->new($grammar);
print "successful\n" if defined $parser->start('foo');

