#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { FALSE => 0, TRUE => 1 };
use constant { PAD => 2 };
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Super;
use VASM::Utility::Gtk2::MessageDialog;
use Gtk2 '-init';
use Expect;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Super UI Gtk2 Message/);
my $ErrorMsg = findErrorCatalog(qw/Super UI Error/);

# Localized strings from passwd will screw up my Expect patterns
$ENV{LANG} = 'C';

unless (@ARGV) {
  errorMessage($ErrorMsg->Render(id => 'Null Command',
                                 arguments => [ $0 ]));
  exit 1;
}

# Prompt for password (see vsuper-dialog.pl for commentary on empty passwords)
my $dialog = Gtk2::Dialog->new_with_buttons(
  $UIMsg->Render('Title'), undef, [],
  'gtk-cancel' => 'cancel',
  'gtk-ok' => 'ok');
$dialog->set_position('center');
# When user hits 'Enter', the OK button will be activated 
$dialog->set_default_response('ok');

# The actual password entry box
my $passwordEntry = Gtk2::Entry->new;
# Wouldn't want a sucka jockin' yo' password. Word.
$passwordEntry->set_visibility(FALSE);
# Hitting Enter will activate OK button (see above)
$passwordEntry->set_activates_default(TRUE);
$dialog->vbox->pack_start($passwordEntry, FALSE, FALSE, PAD);

# Expander with detailed description
my $shortDescription = Gtk2::Expander->new(
  $UIMsg->Render('Password Prompt Short Description'));
my $longDescription = Gtk2::Label->new(
  $UIMsg->Render('Password Prompt Long Description'));
$longDescription->set_line_wrap(TRUE);
$shortDescription->add($longDescription);
$dialog->vbox->pack_start($shortDescription, FALSE, FALSE, PAD);

$dialog->show_all;
my $response = $dialog->run;
my $password = $passwordEntry->get_text;
$dialog->destroy;

if ($response eq 'ok') {
  unless (promoteToRoot(join(' ', @ARGV), $password)) {
    errorMessage($ErrorMsg->Carp(id => 'Spawn Error',
                                 arguments => [ $! ]));
    exit 1;
  }
}

exit 0;
