#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant +{ 
  FALSE => 0, TRUE => 1, 
  PAD => 2
};
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Password;
use VASM::Utility::Gtk2::MessageDialog;
use Gtk2 '-init';
use Expect;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Passwd UI Gtk2 Message/);
my $ErrorMsg = findMessageCatalog(qw/Passwd UI Error/);

sub changePassword {
  my $passwdProcess = VASM::Utility::Expect::Password->new($ARGV[0]);
  my @promptMessages = qw/Old New Confirm/;
  my $errorMessages = [
    [ 'Incorrect Password' ],
    [ 'Too Many Tries', 'New Password Unsatisfactory' ],
    [ 'Too Many Tries', 'Passwords Do Not Match' ]
  ];
  
  unless (ref $passwdProcess) {
    if ($passwdProcess eq 'not-root') {
      errorMessage($ErrorMsg->Render('User Selection for Root Only'));
    } elsif ($passwdProcess eq 'non-existent') {
      errorMessage($ErrorMsg->Render('User Does Not Exist'));
    }

    exit 1;
  }

  my $status = $passwdProcess->Status;
  
  until ($status == SUCCESS) {
    my $lastStatus = $status;
    my $password = askPassword(
      $passwdProcess->Username, "$promptMessages[$status] Password Prompt"
    );
    $status = $passwdProcess->Submit($password);

    # Unless the new value of $status is larger than $lastStatus, an error has
    # occured; we can find this error with the values of $lastStatus and
    # $status
    errorMessage($ErrorMsg->Render($errorMessages->[$lastStatus][$status]))
      unless $status > $lastStatus;
  }

  # Confirm password installation
  infoMessage($UIMsg->Render('Password Changed'));

  exit 0;
}

sub askPassword {
  my ($username, $message) = @_;
  
  # Prompt for password of user %s
  my $dialog = Gtk2::Dialog->new_with_buttons(
    $UIMsg->Render('Title'), undef, [],
    'gtk-cancel' => 'cancel',
    'gtk-ok' => 'ok'
  );
  $dialog->set_position('center');
  # When user hits 'Enter', the OK button will be activated 
  $dialog->set_default_response('ok');

  # The actual password entry box
  my $passwordEntry = Gtk2::Entry->new;
  # Wouldn't want a sucka jockin' yo' password. Word.
  $passwordEntry->set_visibility(FALSE);
  # Hitting Enter will activate OK button (see above)
  $passwordEntry->set_activates_default(TRUE);
  $dialog->vbox->pack_start($passwordEntry, FALSE, FALSE, PAD);

  # Description of dialog
  my $description = Gtk2::Label->new(
    $UIMsg->Render(id => $message, arguments => [ $username ])
  );
  $description->set_line_wrap(TRUE);
  $dialog->vbox->pack_start($description, FALSE, FALSE, PAD);

  $dialog->show_all;
  my $response = $dialog->run;
  my $password = $passwordEntry->get_text;
  $dialog->destroy;

  $response eq 'ok' ? return $password : exit 0;
}

changePassword();
