#!/usr/bin/perl

use strict;
use warnings;
use VASM::Resource::Catalog::Menu;
use VASM::Resource::Catalog::Message;

my $ErrorMsg = findErrorCatalog(qw/Menu UI Error/);

# Dig up the catalog
my $catalog = findMenu;

# Make sure it exists
unless (defined $catalog) {
  print $ErrorMsg->Render('No Menu Catalog'), "\n";
  exit 1;
}

# If it does, produce a translation for each known window manager
for my $wm (qw/Fluxbox IceWM WindowMaker XFce4/) {
  translateMenu($catalog, $wm);
}

exit 0;
