#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 4;
use File::Spec::Functions;
use VASM::Resource;

# Set up $ENV{XDG_CONFIG_HOME} and $ENV{XDG_DATA_HOME} to the working
# directory (the same directory as the test script) in '.config' and '.data'
$ENV{XDG_CONFIG_HOME} = catdir($ENV{PWD}, '.config');
$ENV{XDG_DATA_HOME} = catdir($ENV{PWD}, '.data');

### use VASM::Resource::Catalog::Menu + ability test
### (VASM::Resource::Catalog::Menu is not a class, and can therefore not use
### can_ok)
BEGIN { use_ok('VASM::Resource::Catalog::Menu',
               qw/findMenu writeMenu translateMenu/) }

### findMenu
$ENV{LC_ALL} = 'en_US'; # Set U.S. English locale
my $catalog = findMenu;
# Catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Menu', 'Catalog is a VASM::Catalog::Menu');

### writeMenu
# Made up locale: Qzrzhczakyz language for the country of Foobaristan
$ENV{LC_ALL} = 'qz_FO';
# Write out the menu catalog
writeMenu($catalog);
# Is the filename correct?
is(scalar findConfigResource(qw/Menu File qz FO Menu.xml/),
   "$ENV{XDG_CONFIG_HOME}/vasm/Menu/File/qz/FO/Menu.xml",
   'writeMenu wrote to the right place');

### translateMenu
# Write out a translation for WindowMaker, just to make sure this works (there
# is a separate test unit for the translators)
translateMenu($catalog, 'WindowMaker');
# Is the filename correct?
is(
  scalar findConfigResource(qw/Menu Translation File WindowMaker/),
  "$ENV{XDG_CONFIG_HOME}/vasm/Menu/Translation/File/WindowMaker",
  'writeActionCatalog wrote to the right place'
);

