#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Super;
use UI::Dialog::Backend::CDialog;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Super UI CDialog Message/);
my $ErrorMsg = findErrorCatalog(qw/Super UI Error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $CommonMsg->Render('VASM Backtitle'),
  title => $UIMsg->Render('Title'),
  'ok-label' => $CommonMsg->Render('OK'),
  'cancel-label' => $CommonMsg->Render('Exit'),
  'yes-label' => $CommonMsg->Render('Yes'),
  'no-label' => $CommonMsg->Render('No'),
  width => 75,
  height => 12,
  menuheight => 10
);

unless (@ARGV) {
  $d->msgbox(text => $ErrorMsg->Render(id => 'Null Command',
                                       arguments => [ $0 ]));
  exit 1;
}

# Prompt for password...don't worry about blank entries; some people set
# up their root account like that. Their indiscretion is not taken into
# account here, though. Heh.
my $password = $d->password(text => $UIMsg->Render('Password Prompt'));

# Act on the input
if ($d->state eq 'OK') {
  unless (promoteToRoot(join(' ', @ARGV), $password)) {
    $d->msgbox(text => $ErrorMsg->Carp(id => 'Spawn Error',
                                       arguments => [ $! ]));
    exit 1;
  }
}

exit 0;
