#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use VASM::Resource::Catalog::Message;
use VASM::Utility::Expect::Password;
use UI::Dialog::Backend::CDialog;
use Expect;

# Don't show the stdout of programs; it looks sloppy.
$Expect::Log_Stdout = 0;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Passwd UI CDialog Message/);
my $ErrorMsg = findMessageCatalog(qw/Passwd UI Error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $CommonMsg->Render('VASM Backtitle'),
  title => $UIMsg->Render('Title'),
  'ok-label' => $CommonMsg->Render('OK'),
  'cancel-label' => $CommonMsg->Render('Exit'),
  'yes-label' => $CommonMsg->Render('Yes'),
  'no-label' => $CommonMsg->Render('No'),
  width => 75,
  height => 10,
  menuheight => 10
);


sub changePassword {
  my $passwdProcess = VASM::Utility::Expect::Password->new($ARGV[0]);
  my @promptMessages = qw/Old New Confirm/;
  my $errorMessages = [
    [ 'Incorrect Password' ],
    [ 'Too Many Tries', 'New Password Unsatisfactory' ],
    [ 'Too Many Tries', 'Passwords Do Not Match' ]
  ];
  
  # There was a failure
  unless (ref $passwdProcess) {
    if ($passwdProcess eq 'not-root') {
      $d->msgbox(text => $ErrorMsg->Render('User Selection for Root Only'));
    } elsif ($passwdProcess eq 'non-existent') {
      $d->msgbox(text => $ErrorMsg->Render('User Does Not Exist'));
    }

    exit 1;
  }

  my $status = $passwdProcess->Status;
  
  until ($status == SUCCESS) {
    my $lastStatus = $status;
    my $password = askPassword(
      $passwdProcess->Username, "$promptMessages[$status] Password Prompt"
    );
    $status = $passwdProcess->Submit($password);

    # Unless the new value of $status is larger than $lastStatus, an error has
    # occured; we can find this error with the values of $lastStatus and
    # $status
    $d->msgbox(
      text => $ErrorMsg->Render($errorMessages->[$lastStatus][$status])
    ) unless $status > $lastStatus;
  }

  # Confirm password installation
  $d->msgbox(text => $UIMsg->Render('Password Changed'));

  exit 0;
}

sub askPassword {
  my ($username, $message) = @_;
  
  my $password = $d->password(
    text => $UIMsg->Render(
      id => $message,
      arguments => [ $username ]
    )
  );
  
  exit 0 unless $d->state eq 'OK'; # Cancelled
  return $password;
}

changePassword(); 
