#!/usr/bin/perl

use strict;
use warnings;
use VASM::Resource::Catalog::Action;
use VASM::Resource::Catalog::Message;

my $ErrorMsg = findErrorCatalog(qw/Action UI Error/);

# Make sure a filename was given
unless (defined $ARGV[0]) {
  print $ErrorMsg->Render(
    id => 'No Filename or URI Given',
    arguments => [ $0 ]
  ), "\n";
  exit 1;
}

# Dig a catalog for the MIME type or 
my $catalog = findActionCatalogByMedium($ARGV[0]);

# Check if it found a catalog 
unless (defined $catalog) {
  print $ErrorMsg->Render(
    id => 'No Action Catalog For File',
    arguments => [ $ARGV[0] ]
  ), "\n";
  exit 1;
}

# Execute the preferred program
my $status = $catalog->Exec($ARGV[0]);
print $ErrorMsg->Render('No Matching Program'), "\n" if $status == -1;
exit $status;
