# -*- project-name: VASM -*-
package VASM::Utility::Gtk2::MessageDialog;

use strict;
use warnings;
use base qw/Exporter/;
use Gtk2;

our $VERSION = '1.0';
our @EXPORT = qw/infoMessage errorMessage confirmMessage/;

sub infoMessage {
  my ($message) = @_;
  
  my $messageDialog = Gtk2::MessageDialog->new(
    undef, [], qw/info ok/, $message
  );
  
  $messageDialog->set_position('center');
  $messageDialog->run;
  $messageDialog->destroy;
  
  return;
}

sub errorMessage {
  my ($message) = @_;

  my $messageDialog = Gtk2::MessageDialog->new(
    undef, [], qw/error ok/, $message
  );

  $messageDialog->set_position('center');
  $messageDialog->run;
  $messageDialog->destroy;

  return;
}

sub confirmMessage {
  my ($message) = @_;

  my $messageDialog = Gtk2::MessageDialog->new(
    undef, [], qw/question yes-no/, $message
  );

  $messageDialog->set_position('center');
  my $response = $messageDialog->run;
  $messageDialog->destroy;

  return $response;
}

1;

__END__
