# -*- project-name: VASM -*-
package VASM::Utility::Expect::Super;

use strict;
use warnings;
use base qw/Exporter/;
use Expect;

our $VERSION = '1.0';
our @EXPORT = qw/promoteToRoot/;

# Don't show the stdout of programs; it looks sloppy.
# $Expect::Log_Stdout = 0;
# OK, show it

sub promoteToRoot {
  my ($command, $password) = @_;

  my $expect = Expect->new;
  $expect->raw_pty(1); # Disable echoing and translation

  # If $DISPLAY is set, enable root connections to $DISPLAY (this should be
  # reasonably secure?)
  system 'xhost +si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};

  # Spawn su w/ arguments from CLI
  return unless $expect->spawn("su -c '$command'");
  
  # A minute seems to be a reasonable timeout -- the Expect pattern will
  # expect anything before a colon and a space, because a value of LANG like
  # 'de_DE' will produce 'Kennwort', etc.
  $expect->expect(60, [ qr/^.*?: /]);
  $expect->send("$password\n"); # Send the password
  $expect->expect(); # Wait until process sends EOF
  $expect->soft_close; # Terminate the Expect instance

  # Remove root from the X access control list if need be
  system 'xhost -si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};

  return 1;
}

1;
