#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use Test::More tests => 7;
use IO::Scalar;

# XML::Writer seems to think it is dealing with a tied handle?
BEGIN { package IO::Scalar; sub BINMODE {} } # UGLY HACK

### use VASM::Catalog::Menu
BEGIN { use_ok('VASM::Catalog::Menu') }

### Ability test
# Maybe test the Children method?
can_ok('VASM::Catalog::Menu', qw/new Store Retrieve Parse Write/);

### new
my $catalog = VASM::Catalog::Menu->new;
# The catalog is a member of the appropriate class?
isa_ok($catalog, 'VASM::Catalog::Menu');

### Store and Retrieve
$catalog->Store(
  qw/Editors/,
  { icon => "$ENV{PWD}/.pixmaps/kate.png" });
$catalog->Store(
  qw/Editors Emacs/, 
  { icon => "$ENV{PWD}/.pixmaps/emacs.png",
    path => '/opt/emacs/bin/emacs' });
$catalog->Store(
  qw/Editors LyX/, 
  { icon => "$ENV{PWD}/.pixmaps/lyx.png",
    path => '/usr/bin/lyx' });
# No one said this has to look pretty
$catalog->Store(
  qw/Utilities/, 
  { 
    icon => "$ENV{PWD}/.pixmaps/package_utilities.png"
  });
$catalog->Store(
  qw/Utilities WPrefs/,
  { icon => "$ENV{PWD}/.pixmaps/WPrefs.xpm",
    path => '/usr/X11/bin/WPrefs' });
$catalog->Store(
  qw/Utilities Terminal/,
  { icon => "$ENV{PWD}/.pixmaps/GNUterm.xpm",
    path => '/usr/X11/bin/terminal' });
$catalog->Store(
  qw/Internet/,
  { icon => "$ENV{PWD}/.pixmaps/browser.png" });
$catalog->Store(
  qw/Internet Seamonkey/,
  { icon => "$ENV{PWD}/.pixmaps/Mozilla.png",
    path => '/usr/bin/seamonkey' });
$catalog->Store(
  qw/Internet Dillo/,
  { icon => "$ENV{PWD}/.pixmaps/dillo.png",
    path => '/usr/X11/bin/dillo' });

# Can the menu catalog retrieve attributes properly?
is_deeply($catalog->Retrieve(qw/Internet/),
          { icon => "$ENV{PWD}/.pixmaps/browser.png" },
          'Lame-ass catalog retrieval test passed');
is_deeply($catalog->Retrieve(qw/Editors Emacs/),
          { icon => "$ENV{PWD}/.pixmaps/emacs.png",
            path => '/opt/emacs/bin/emacs' },
          'Another lame-ass catalog retrieval test slightly redeemed by ' . 
          'a tangential relation to Emacs passed');

### Parse
# Instantiate an IO::Scalar containing an XML description of a catalog and
# parse it
my $xmlParseString = qq{<?xml version="1.0" encoding="utf-8"?>

<catalog>
  <!-- Generated by VASM -->
  <folder label="Editors" icon="$ENV{PWD}/.pixmaps/kate.png">
    <item label="Emacs" icon="$ENV{PWD}/.pixmaps/emacs.png" path="/opt/emacs/bin/emacs" />
    <item label="LyX" icon="$ENV{PWD}/.pixmaps/lyx.png" path="/usr/bin/lyx" />
  </folder>
  <folder label="Utilities" icon="$ENV{PWD}/.pixmaps/package_utilities.png">
    <item label="WPrefs" icon="$ENV{PWD}/.pixmaps/WPrefs.xpm" path="/usr/X11/bin/WPrefs" />
    <item label="Terminal" icon="$ENV{PWD}/.pixmaps/GNUterm.xpm" path="/usr/X11/bin/terminal" />
  </folder>
  <folder label="Internet" icon="$ENV{PWD}/.pixmaps/browser.png">
    <item label="Seamonkey" icon="$ENV{PWD}/.pixmaps/Mozilla.png" path="/usr/bin/seamonkey" />
    <item label="Dillo" icon="$ENV{PWD}/.pixmaps/dillo.png" path="/usr/X11/bin/dillo" />
  </folder>
</catalog>
};
my $xmlParseHandle = IO::Scalar->new(\$xmlParseString);
my $catalogParse = VASM::Catalog::Menu->new($xmlParseHandle);

# Do $catalogParse and $catalog hold the same values?
is_deeply($catalogParse, $catalog, 'Parsed catalog valid');

### Write
my $xmlWriteString; my $xmlWriteHandle = IO::Scalar->new(\$xmlWriteString);
$catalog->Write($xmlWriteHandle);

# Is the wriiten XML the same as the XML parse string?
is($xmlWriteString, $xmlParseString, 'Written XML valid');
