# -*- project-name: VASM -*-
package VASM::Catalog::Error;

use strict;
use warnings;
use base qw/VASM::Catalog::Message/;
use Carp qw/shortmess/;
$Carp::CarpLevel = 1;

our $VERSION = '1.02';

sub Croak {
  my ($self, @args) = @_;

  die shortmess($self->Render(@args));
}

sub Carp {
  my ($self, @args) = @_;
  
  return shortmess($self->Render(@args));
}

1;

__END__

=head1 NAME

VASM::Catalog::Error - an object-oriented vene^H^H^H^Hwrapper for Carp

=head1 SYNOPSIS

=head1 DESCRIPTION

VASM::Catalog::Error inherits from VASM::Message, inheriting the same
facilities for i18n-ized message translation for use in error reporting with
the venerable Carp module. All methods are, therefore, essentially the same,
but Croak, and Carp, which correspond (more or less) to the traditional
procedural functions of the same name in Carp. For futher details, see
L<"METHODS"> below.

=head1 METHODS

=head1 AUTHORS

hanumizzle L<mailto:hanumizzle@gmail.com> wrote VASM::Catalog::Error. Further
considerations by cintyram.

=cut
