# -*- project-name: VASM -*-
package VASM::Catalog::Menu::Translators;

use strict;
use warnings;
use Carp;
use VASM::Resource;
use VASM::Resource::Catalog::Message;
use XML::Writer;
use Image::Magick;

my $MenuMsg = findMessageCatalog(qw/Menu Translators/);

# Write image proc in here? Sure, just read the file in and submit it to a
# closure with ImageMagick commands, and write out the results. Extract the
# file descriptor with 

sub WriteFluxbox {
  my ($self, $file) = @_;
  
  croak 'Handle argument must be given to WriteFluxBox!' unless defined $file;

  # Begin the menu
  $file->print("# Generated by VASM\n\n");
  $file->print('[begin] (' . $MenuMsg->Render('Menu Title') . ")\n");
  # Recursive method processes the menu itself
  $self->writeFluxboxHeavy($file);
  # End the menu
  $file->print("[end]\n");

  return;
}

sub writeFluxboxHeavy {
  my ($self, $file, @path) = @_;

  for my $child ($self->Children(@path)) {
    # Indent?
    my $attrs = $self->Retrieve(@path, $child);
    # If an item
    if (defined $attrs->{path}) {
      # Generate icon
      # Generate 
    }
    # If a folder
    else {
      # Recurse
      $self->writeFluxboxHeavy($file, @path, $child);
    }
  }
  
  return;
}

# WindowMaker
# IceWM
# Fluxbox

1;

__END__

=head1 NAME

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=head1 AUTHORS

hanumizzle L<mailto:hanumizzle@gmail.com> wrote VASM::Menu::Translators.

=cut

