#!/usr/bin/perl

use strict;
use warnings;
use constant { FALSE => 0, TRUE => 1 };
use constant { PAD => 2 };
use VASM::Resource::Message;
use Gtk2 '-init';
use Expect;
# Don't show the stdout of programs; it looks sloppy.
$Expect::Log_Stdout = 0;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Super UI Gtk2 Message/);
my $ErrorMsg = findErrorCatalog(qw/Super UI Error/);

unless (@ARGV) {
  my $usageMessage = Gtk2::MessageDialog->new(
    undef, qw/modal error ok/, $ErrorMsg->Render(ID => 'Null Command',
                                                 Arguments => [ $0 ]));
  $usageMessage->set_position('center');
  $usageMessage->run;
  $usageMessage->destroy;

  exit 0;
}

# Prompt for password (see vsuper-dialog.pl for commentary on empty passwords)
my $dialog = Gtk2::Dialog->new_with_buttons(
  $UIMsg->Render('Title'),
  undef,
  [ qw/modal/ ],
  'gtk-cancel' => 'cancel',
  'gtk-ok' => 'ok');
$dialog->set_position('center');
# When user hits 'Enter', the OK button will be activated 
$dialog->set_default_response('ok');

# The actual password entry box
my $entry = Gtk2::Entry->new;
# Wouldn't want a sucka jockin' yo' password. Word.
$entry->set_visibility(FALSE);
# Hitting Enter will activate OK button (see above)
$entry->set_activates_default(TRUE);
$dialog->vbox->pack_start($entry, FALSE, FALSE, PAD);

# Expander with detailed description
my $shortDescription = Gtk2::Expander->new(
  $UIMsg->Render('Password Prompt Short Description'));
my $longDescription = Gtk2::Label->new(
  $UIMsg->Render('Password Prompt Long Description'));
$longDescription->set_line_wrap(TRUE);
$shortDescription->add($longDescription);
$dialog->vbox->pack_start($shortDescription, FALSE, FALSE, PAD);

$dialog->show_all;
my $response = $dialog->run;

if ($response eq 'ok') {
  my $password = $entry->get_text;
  ## Cut and pasted from the Dialog version. Heh.
  my $expect = Expect->new;
  $expect->raw_pty(1); # Disable echoing and translation
  # If $DISPLAY is set, enable root connections to $DISPLAY (this should be
  # reasonably secure?)
  system 'xhost +si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};
  if ($expect->spawn("su -c '@ARGV'")) { # Spawn su w/ arguments from CLI
    # A minute seems to be a reasonable timeout
    $expect->expect(60, [ qr/^Password: /]);
    $expect->send("$password\n"); # Send the password
    $expect->expect(); # Wait until process sends EOF
    $expect->soft_close; # Terminate the Expect instance
    # Remove root from the X access control list if need be
    system 'xhost -si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};
  } else {
    my $errorMessage = Gtk2::MessageDialog->new(
      undef, qw/modal error ok/, $ErrorMsg->Carp(ID => 'Spawn Error',
                                                 Arguments => [ $! ]));
    $errorMessage->run;
    $errorMessage->destroy;
  }
}

$dialog->destroy;
exit 0;
