#!/usr/bin/perl

use strict;
use warnings;
use constant FALSE => 0;
use constant TRUE => 1;
use Gtk2 '-init';

my $w = Gtk2::Window->new;
$w->set_title('Eat at Joe\'s');
$w->set_border_width(5);
$w->signal_connect(delete_event => sub { return FALSE });
$w->signal_connect(destroy => sub { Gtk2->main_quit });

my @buttons =
  map
  { Gtk2::Button->new($_) }
  ('Ingsoc', 'Neo-Bolshevism', 'Obliteration of Self');
  
my $hbox = Gtk2::HBox->new(FALSE, 10);
for my $button (@buttons) {
  $button->signal_connect(clicked => sub { print $_[0]->get_label, "\n"; });
  $hbox->pack_start($button, TRUE, TRUE, 0);
}
$w->add($hbox);

$w->show_all;
Gtk2->main;
