#!/usr/bin/perl

use strict;
use warnings;
use IO::Handle;
use VASM::Menu;

my $instance = VASM::Menu->new;
print "$instance\n";

open my $fh, '<', 'Menu.xml';
my $handle = IO::Handle->new_from_fd($fh, '<');
$instance->Parse($handle);

open my $other_fh, '>', 'MenuWrite.xml';
my $otherHandle = IO::Handle->new_from_fd($other_fh, '>');
$instance->Write($otherHandle);

$handle->close;
$otherHandle->close;
