#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use VASM::Resource::Message;
use UI::Dialog::Backend::CDialog;
use Expect;
# Don't show the stdout of programs; it looks sloppy.
$Expect::Log_Stdout = 0;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Super UI CDialog Message/);
my $ErrorMsg = findErrorCatalog(qw/Super UI Error/);

# Dialog instance
my $d = UI::Dialog::Backend::CDialog->new(
  backtitle => $CommonMsg->Render('VASM Backtitle'),
  title => $UIMsg->Render('Title'),
  'ok-label' => $CommonMsg->Render('OK'),
  'cancel-label' => $CommonMsg->Render('Exit'),
  'yes-label' => $CommonMsg->Render('Yes'),
  'no-label' => $CommonMsg->Render('No'),
  width => 75,
  height => 20,
  menuheight => 10
);

unless (@ARGV) {
  $d->msgbox(text => $ErrorMsg->Render(ID => 'Null Command',
                                       Arguments => [ $0 ]),
             height => 10); # Default height looks ugly
  exit 0;
}

# Prompt for password...don't worry about blank entries; some people set
# up their root account like that. Their indiscretion is not taken into
# account here, though. Heh.
my $password = $d->password(text => $UIMsg->Render('Password Prompt'));

# Act on the input
if ($d->state eq 'OK') {
  my $expect = Expect->new;
  $expect->raw_pty(1); # Disable echoing and translation
  # If $DISPLAY is set, enable root connections to $DISPLAY (this should be
  # reasonably secure?)
  system 'xhost +si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};
  $expect->spawn("su -c '@ARGV'") # Spawn su w/ arguments from CLI
    or $d->msgbox(text => $ErrorMsg->Carp(ID => 'Spawn Error',
                                          Arguments => [ $! ]));
  # A minute seems to be a reasonable timeout
  $expect->expect(60, [ qr/^Password: /]);
  $expect->send("$password\n"); # Send the password
  $expect->expect(); # Wait until process sends EOF
  $expect->soft_close; # Terminate the Expect instance
  # Remove root from the X access control list if need be
  system 'xhost -si:localuser:root &> /dev/null' if defined $ENV{DISPLAY};
}

exit 0;
