#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { FALSE => 0, TRUE => 1 };
use constant { LABEL => 0, DATA => 1 };
use VASM::Resource::Message;
use VASM::Resource::Menu;
use Gtk2 '-init';

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Menu UI Gtk2 Message/);
#my $ErrorMsg = findErrorCatalog(qw/Menu UI Error/);

# Add 'Edit' button along with others

sub makeMenuTree {
  my ($menu) = @_;

  # Set up a tree store corresponding to the menu; the single Glib::String
  # column indicates a particular folder or item name in the menu object
  my $menuTree = Gtk2::TreeStore->new('Glib::String', 'Glib::Scalar');
  
  # makeMenuTreeHeavy needs to be factored out, as it is a /recursive/
  # function that will fill in the tree store itself
  makeMenuTreeHeavy($menu, $menuTree);

  return $menuTree;
}

sub makeMenuTreeHeavy {
  my ($menu, $menuTree, @iters) = @_;
  
  # Get the current 'stack' of folders
  my @folders = map { $menuTree->get($_, LABEL) } @iters;

  # Create more folders under it
  for my $child ($menu->Children(@folders)) {
    # Recurse if the child in question has children of its own
    if ($menu->Children(@folders, $child)) {
      push @iters, $menuTree->append($iters[-1] or undef);
      # Set the folder name at the current path
      $menuTree->set($iters[-1], LABEL, $child);
      makeMenuTreeHeavy($menu, $menuTree, @iters); # Recurse
      pop @iters; # Move back up a level
    }
  }

  # Now, introduce the items after the folders
  for my $child ($menu->Children(@folders)) {
    if ($menu->Retrieve(@folders, $child)) {
      # Advance the pointer at the current level
      my $iter = $menuTree->append($iters[-1] or undef);
      # Set the item name and properties at the current path
      $menuTree->set($iter, LABEL, $child);
      $menuTree->set($iter, DATA, $menu->Retrieve(@folders, $child));
    }
  }
}

sub makeMenuTreeView {
  my ($menu, $dialog) = @_;

  my $treeStore = makeMenuTree($menu); # The actual data
  # The rest of this is a 'cookbook' recipe to make a tree view correspond
  # one-for-one with the data in the tree store.
  my $treeView = Gtk2::TreeView->new_with_model($treeStore);
  $treeView->set_headers_visible(FALSE);
  $treeView->set_reorderable(TRUE);
  my $col = Gtk2::TreeViewColumn->new;
  my $renderer = Gtk2::CellRendererText->new;
  $col->pack_start($renderer, FALSE);
  $col->add_attribute($renderer, text => LABEL);
  $treeView->append_column($col);

  # Attach a signal handler for double clicks on row
  $treeView->signal_connect('row-activated' => \&menuTreeRowActivated,
                            $dialog);
  
  return $treeView;
}

sub menuTreeRowActivated {
  my $dialog = $_[3];
  
  # Dispatch the selection as if OK were clicked
  $dialog->response('ok');
  
  return;
}

# Add after / inside, also type -- maybe imaginary root Desktop Menu
sub addMenu {
  my $view = $_[1];
  my $store = $view->get_model;
  my $iter = $store->insert_after(scalar $view->get_selection->get_selected);
  
  return;
}

sub removeMenu {
  my $view = $_[1];
  my $store = $view->get_model;
  my $iter = $view->get_selection->get_selected;
  $store->remove($iter) if $iter;
  
  return;
}

sub upMenu {
  my $view = $_[1];
  my $store = $view->get_model;
  my $iter = $view->get_selection->get_selected;
  my $prev = eval {
    my $path = $store->get_path($iter);
    return $store->get_iter($path) if $path->prev;
  };
  $store->swap($prev, $iter) if $prev;
  
  return;
}

sub downMenu {
  my $view = $_[1];
  my $store = $view->get_model;
  my $iter = $view->get_selection->get_selected;
  my $next = eval {
    my $path = $store->get_path($iter); $path->next;
    return $store->get_iter($path);
  };
  $store->swap($iter, $next) if $next;
  
  return;
}

sub MainMenu {
  my $dialog = Gtk2::Dialog->new_with_buttons(
    $UIMsg->Render('Title'),
    undef,
    [ qw/modal/ ],
    'gtk-close' => 'close',
    'gtk-ok' => 'none');
  $dialog->set_position('center');
  $dialog->set_default_size(400, 300);

  ## Action area
  # TreeView of menu -- but, first, get the menu definition
  my $menu = findMenu();
  my $menuTree = makeMenuTreeView($menu, $dialog);
  
  # Pack the tree view into a scrolled window. The addition of scrollbars
  # will be done automatically in either direction
  my $scrolledTree = Gtk2::ScrolledWindow->new;
  $scrolledTree->set_policy('automatic', 'automatic');
  $scrolledTree->add($menuTree);
  $dialog->vbox->pack_start($scrolledTree, TRUE, TRUE, 0);
  
  # Separator
  $dialog->vbox->pack_start(Gtk2::HSeparator->new(), FALSE, FALSE, 0);
  
  # Operations
  my $operationHBox = Gtk2::HBox->new(TRUE, 0);
  #my @operations = ( [ 'gtk-add' => \&addMenu ],
  my @operations = ( [ 'gtk-remove' => \&removeMenu ],
                     [ 'gtk-go-up' => \&upMenu ],
                     [ 'gtk-go-down' => \&downMenu ] );
  # Add them, one by one
  for my $operation (@operations) {
    my $button = Gtk2::Button->new_from_stock($operation->[0]);
    $button->signal_connect(clicked => $operation->[1], $menuTree);
    $operationHBox->pack_start($button, TRUE, TRUE, 0);
  }
  $dialog->vbox->pack_start($operationHBox, FALSE, FALSE, 0);

  # Separator
  $dialog->vbox->pack_start(Gtk2::HSeparator->new(), FALSE, FALSE, 0);

  # Expander with detailed description
  my $shortDescription = Gtk2::Expander->new(
    $UIMsg->Render('Main Menu Short Description'));
  my $longDescription = Gtk2::Label->new(
    $UIMsg->Render('Main Menu Long Description'));
  $longDescription->set_line_wrap(TRUE);
  $shortDescription->add($longDescription);
  $dialog->vbox->pack_start($shortDescription, FALSE, FALSE, 0);

  while (1) {
    $dialog->show_all;
    my $response = $dialog->run; # Run has its own main loop
    # Terminate here if so desired
    last if $response eq 'close' or $response eq 'delete-event';
    $dialog->hide_all;
    # Do somethin'
  }

  # Write out menu here
  $dialog->destroy;
  exit 0;
}

MainMenu();
