#!/usr/bin/perl
# -*- project-name: VASM -*-

use strict;
use warnings;
use constant { FALSE => 0, TRUE => 1 };
use Gtk2 '-init';
use File::MimeInfo::Magic;
use VASM::Tree;
use VASM::Resource;
use VASM::Resource::Message;
use VASM::Resource::Action;
use Archive::Tar;

# Message files
my $CommonMsg = findMessageCatalog(qw/Common Message/);
my $UIMsg = findMessageCatalog(qw/Action UI Gtk2/);
my $ErrorMsg = findErrorCatalog(qw/Action UI Error/);

sub MainMenu {
  my $window = Gtk2::Window->new; # wmclass?
  $window->set_title($UIMsg->Render(ID => 'Title'));
  $window->set_border_width(5);
  $window->signal_connect(
    delete_event => sub { Gtk2->main_quit; return FALSE });

  my $vbox = Gtk2::VBox->new(FALSE, 2);
  $vbox->pack_start(makeChoiceTreeView(), TRUE, TRUE, 0);
  $vbox->pack_start(Gtk2::HSeparator->new(), FALSE, FALSE, 0);
  # Description with expander
  # Separator
  # OK
 
  $window->add($vbox);
  $window->show_all;
  Gtk2->main;
}

sub makeChoiceTree {
  # Get directories for file and URI schemata
  my $fileDirectory = mediaDirectory('File');
  my $uriDirectory = mediaDirectory('URI');

  # Convert the file directory to data more readily usable by the function
  my $fileTypeTree = VASM::Tree->new;
  for my $mime ($fileDirectory->List) {
    $fileTypeTree->Store((split m!/!, $mime), 1);
  }

  # Now, set up a tree store corresponding to them and add the 'Template'
  # top-level choice as well. The first Glib::String is the item as it appears
  # on the screen, according to translation and additional notes. The second
  # is the 'real name', usable to the program.
  my $choiceTree = Gtk2::TreeStore->new('Glib::String', 'Glib::String');
  my @iters;

  # File
  push @iters, $choiceTree->append(undef);
  $choiceTree->set($iters[-1],
                   0, $UIMsg->Render(ID => 'File'),
                   1, 'File');
  for my $class (sort $fileTypeTree->Children) {
    # Add the class under 'File'
    push @iters, $choiceTree->append($iters[-1]);
    $choiceTree->set($iters[-1],
                     0, $class,
                     1, $class);
    # Add each member of the class (e.g., File -> image -> jpeg)
    for my $member (sort $fileTypeTree->Children($class)) {
      push @iters, $choiceTree->append($iters[-1]);
      my $mime = join('/', $class, $member);
      # The type will appear with a parenthetical note describing it in
      # further detail
      $choiceTree->set(
        $iters[-1],
        0, $member . ' (' . $fileDirectory->Render(ID => $mime) . ')',
        1, $member);
    } continue { pop @iters }
  } continue { pop @iters }
  pop @iters;

  # URI
  push @iters, $choiceTree->append(undef);
  $choiceTree->set($iters[-1],
                   0, $UIMsg->Render(ID => 'URI'),
                   1, 'URI');
  for my $scheme (sort $uriDirectory->List) {
    push @iters, $choiceTree->append($iters[-1]);
    $choiceTree->set(
      $iters[-1],
      0, $scheme . ' (' . $uriDirectory->Render(ID => $scheme) . ')',
      1, $scheme);
  } continue { pop @iters }
  pop @iters;

  # Template
  push @iters, $choiceTree->append(undef);
  $choiceTree->set($iters[-1], 0, $UIMsg->Render(ID => 'Template'));
  pop @iters; # Neat freak

  return $choiceTree;
}

sub makeChoiceTreeView {
  my $treeStore = makeChoiceTree(); # The actual data
  # The rest of this is a 'cookbook' recipe to make a tree view correspond
  # one-for-one with the data in the tree store.
  my $treeView = Gtk2::TreeView->new_with_model($treeStore);
  $treeView->set_headers_visible(FALSE);
  my $col = Gtk2::TreeViewColumn->new;
  my $renderer = Gtk2::CellRendererText->new;
  $col->pack_start($renderer, FALSE);
  $col->add_attribute($renderer, "text", 0);
  $treeView->append_column($col);

  # Attach a signal handler
  $treeView->signal_connect('row-activated' => \&choiceTreeRowActivated);

  # Pack the tree view into a scrolled window. The addition of scrollbars will
  # be done automatically in either direction
  my $scrolledTree = Gtk2::ScrolledWindow->new;
  $scrolledTree->set_policy('automatic', 'automatic');
  $scrolledTree->add($treeView);

  return $scrolledTree;
}

sub choiceTreeRowActivated {
  my ($view, $path) = @_[0..1]; my $iter;
  my $store = $view->get_model;
  my @path = split /:/, $path->to_string;

  for my $index (0..$#path) {
    $iter = $store->get_iter_from_string(join(':', @path[0..$index]));
    print $store->get($iter, 1), "\n";
  }
}

sub configureMediaType {
  
}

MainMenu();
