#!/usr/bin/perl

use strict;
use warnings;
use UI::Dialog::Backend::CDialog;
use VASM::Resource::Message;
use VASM::Resource::Action;

# Message files
my $CommonMessages = findMessageCatalog(qw/Common/);
my $UIMessages = findMessageCatalog(qw/Action UI/);
my $CDialogMessages = findMessageCatalog(qw/Action UI CDialog/);
my $ErrorMessages = findErrorCatalog(qw/Action UI Error/);

# Dialog instance
my $dialog = UI::Dialog::Backend::CDialog->new(
  backtitle => $CommonMessages->Render(ID => 'VASM Title'),
  'ok-label' => $CommonMessages->Render(ID => 'OK'),
  'cancel-label' => $CommonMessages->Render(ID => 'Cancel'),
  'yes-label' => $CommonMessages->Render(ID => 'Yes'),
  'no-label' => $CommonMessages->Render(ID => 'No'),
  width => 75,
  height => 20);
my $answer;

# Main menu
my $answer = $dialog->menu(
  title => $UIMessages->Render(ID => 'Title'),
  text => $UIMessages->Render(ID => 'Description'),
  list => 
    [ map {
        $UIMessages->Render(ID => $_),
        $UIMessages->Render(ID => "$_ Description")
      }
      qw/File URI Template/ ]);

if ($answer eq 'File' or $answer eq 'URI') {
  # Get list of media types and sort
  # Offer to List, Add, Remove
} elsif ($answer eq 'Template') {
  # List templates
} else {
  print 'foo';
}
